/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

public interface NodeOptions {
    default public boolean isFlattenPackages() {
        return false;
    }

    default public boolean isAbbreviatePackageNames() {
        return false;
    }

    default public boolean isHideEmptyMiddlePackages() {
        return false;
    }

    default public boolean isCompactDirectories() {
        return false;
    }

    default public boolean isShowLibraryContents() {
        return false;
    }

    public static class Immutable
    implements NodeOptions {
        public static final NodeOptions DEFAULT = new Immutable(null);
        private final boolean myFlattenPackages;
        private final boolean myAbbreviatePackageNames;
        private final boolean myHideEmptyMiddlePackages;
        private final boolean myCompactDirectories;
        private final boolean myShowLibraryContents;

        public Immutable(NodeOptions options) {
            this.myFlattenPackages = options != null && options.isFlattenPackages();
            this.myAbbreviatePackageNames = options != null && options.isAbbreviatePackageNames();
            this.myHideEmptyMiddlePackages = options != null && options.isHideEmptyMiddlePackages();
            this.myCompactDirectories = options != null && options.isCompactDirectories();
            this.myShowLibraryContents = options != null && options.isShowLibraryContents();
        }

        @Override
        public boolean isFlattenPackages() {
            return this.myFlattenPackages;
        }

        @Override
        public boolean isAbbreviatePackageNames() {
            return this.myAbbreviatePackageNames;
        }

        @Override
        public boolean isHideEmptyMiddlePackages() {
            return this.myHideEmptyMiddlePackages;
        }

        @Override
        public boolean isCompactDirectories() {
            return this.myCompactDirectories;
        }

        @Override
        public boolean isShowLibraryContents() {
            return this.myShowLibraryContents;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || !object.getClass().equals(this.getClass())) {
                return false;
            }
            NodeOptions options = (NodeOptions)object;
            return options.isFlattenPackages() == this.isFlattenPackages() && options.isAbbreviatePackageNames() == this.isAbbreviatePackageNames() && options.isHideEmptyMiddlePackages() == this.isHideEmptyMiddlePackages() && options.isCompactDirectories() == this.isCompactDirectories() && options.isShowLibraryContents() == this.isShowLibraryContents();
        }

        public int hashCode() {
            int result2 = this.getClass().hashCode();
            result2 = 31 * result2 + Boolean.hashCode(this.isFlattenPackages());
            result2 = 31 * result2 + Boolean.hashCode(this.isAbbreviatePackageNames());
            result2 = 31 * result2 + Boolean.hashCode(this.isHideEmptyMiddlePackages());
            result2 = 31 * result2 + Boolean.hashCode(this.isCompactDirectories());
            result2 = 31 * result2 + Boolean.hashCode(this.isShowLibraryContents());
            return result2;
        }
    }
}

