/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.markdown.utils.doc.impl;

import com.intellij.markdown.utils.doc.DocMarkdownToHtmlConverter;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.HtmlGeneratorKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J=\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0016\u0010\u000b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00070\f\"\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/markdown/utils/doc/impl/DocTagRenderer;", "Lorg/intellij/markdown/html/HtmlGenerator$DefaultTagRenderer;", "wholeText", "", "<init>", "(Ljava/lang/String;)V", "openTag", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "tagName", "attributes", "", "autoClose", "", "(Lorg/intellij/markdown/ast/ASTNode;Ljava/lang/CharSequence;[Ljava/lang/CharSequence;Z)Ljava/lang/CharSequence;", "closeTag", "convertTag", "intellij.platform.markdown.utils"})
public final class DocTagRenderer
extends HtmlGenerator.DefaultTagRenderer {
    @NotNull
    private final String wholeText;

    public DocTagRenderer(@NotNull String wholeText) {
        Intrinsics.checkNotNullParameter((Object)wholeText, (String)"wholeText");
        super(HtmlGeneratorKt.getDUMMY_ATTRIBUTES_CUSTOMIZER(), false);
        this.wholeText = wholeText;
    }

    @NotNull
    public CharSequence openTag(@NotNull ASTNode node, @NotNull CharSequence tagName, @NotNull CharSequence[] attributes, boolean autoClose) {
        ASTNode first;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        if (StringsKt.contentEquals((CharSequence)tagName, (CharSequence)"p", (boolean)true) && (first = (ASTNode)CollectionsKt.firstOrNull((List)node.getChildren())) != null && first.getType() == MarkdownTokenTypes.HTML_TAG) {
            CharSequence text2 = ASTUtilKt.getTextInNode((ASTNode)first, (CharSequence)this.wholeText);
            Matcher matcher = DocMarkdownToHtmlConverter.INSTANCE.getTAG_PATTERN$intellij_platform_markdown_utils().matcher(text2);
            if (matcher.matches()) {
                String nestedTag = matcher.group(1);
                if (DocMarkdownToHtmlConverter.INSTANCE.getACCEPTABLE_BLOCK_TAGS$intellij_platform_markdown_utils().contains(nestedTag)) {
                    return "";
                }
            }
        }
        if (StringsKt.contentEquals((CharSequence)tagName, (CharSequence)"code", (boolean)true) && node.getType() == MarkdownTokenTypes.CODE_FENCE_CONTENT) {
            return "";
        }
        return super.openTag(node, this.convertTag(tagName), Arrays.copyOf(attributes, attributes.length), autoClose);
    }

    @NotNull
    public CharSequence closeTag(@NotNull CharSequence tagName) {
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        if (StringsKt.contentEquals((CharSequence)tagName, (CharSequence)"p", (boolean)true)) {
            return "";
        }
        return super.closeTag(this.convertTag(tagName));
    }

    private final CharSequence convertTag(CharSequence tagName) {
        if (StringsKt.contentEquals((CharSequence)tagName, (CharSequence)"strong", (boolean)true)) {
            return "b";
        }
        if (StringsKt.contentEquals((CharSequence)tagName, (CharSequence)"em", (boolean)true)) {
            return "i";
        }
        return tagName;
    }
}

