/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class EditorModificationUtilEx {
    public static void deleteSelectedText(@NotNull Editor editor) {
        SelectionModel selectionModel;
        if (editor == null) {
            EditorModificationUtilEx.$$$reportNull$$$0(0);
        }
        if (!(selectionModel = editor.getSelectionModel()).hasSelection()) {
            return;
        }
        int selectionStart = selectionModel.getSelectionStart();
        int selectionEnd = selectionModel.getSelectionEnd();
        CaretModel caretModel = editor.getCaretModel();
        if (editor.isColumnMode() && caretModel.supportsMultipleCarets()) {
            VisualPosition selectionStartPosition = selectionModel.getSelectionStartPosition();
            if (selectionStartPosition != null) {
                caretModel.moveToVisualPosition(selectionStartPosition);
            } else {
                caretModel.moveToOffset(selectionStart);
            }
        } else {
            caretModel.moveToOffset(selectionStart);
        }
        selectionModel.removeSelection();
        editor.getDocument().deleteString(selectionStart, selectionEnd);
        EditorModificationUtilEx.scrollToCaret(editor);
    }

    public static void insertStringAtCaret(@NotNull Editor editor, @NotNull String s) {
        if (editor == null) {
            EditorModificationUtilEx.$$$reportNull$$$0(1);
        }
        if (s == null) {
            EditorModificationUtilEx.$$$reportNull$$$0(2);
        }
        EditorModificationUtilEx.insertStringAtCaret(editor, s, false, true);
    }

    public static int insertStringAtCaret(@NotNull Editor editor, @NotNull String s, boolean toProcessOverwriteMode) {
        if (editor == null) {
            EditorModificationUtilEx.$$$reportNull$$$0(3);
        }
        if (s == null) {
            EditorModificationUtilEx.$$$reportNull$$$0(4);
        }
        return EditorModificationUtilEx.insertStringAtCaret(editor, s, toProcessOverwriteMode, s.length());
    }

    public static int insertStringAtCaret(@NotNull Editor editor, @NotNull String s, boolean toProcessOverwriteMode, boolean toMoveCaret) {
        if (editor == null) {
            EditorModificationUtilEx.$$$reportNull$$$0(5);
        }
        if (s == null) {
            EditorModificationUtilEx.$$$reportNull$$$0(6);
        }
        return EditorModificationUtilEx.insertStringAtCaret(editor, s, toProcessOverwriteMode, toMoveCaret, s.length());
    }

    public static int insertStringAtCaret(@NotNull Editor editor, @NotNull String s, boolean toProcessOverwriteMode, int caretShift) {
        if (editor == null) {
            EditorModificationUtilEx.$$$reportNull$$$0(7);
        }
        if (s == null) {
            EditorModificationUtilEx.$$$reportNull$$$0(8);
        }
        return EditorModificationUtilEx.insertStringAtCaret(editor, s, toProcessOverwriteMode, true, caretShift);
    }

    public static int insertStringAtCaret(@NotNull Editor editor, @NotNull String s, boolean toProcessOverwriteMode, boolean toMoveCaret, int caretShift) {
        if (editor == null) {
            EditorModificationUtilEx.$$$reportNull$$$0(9);
        }
        if (s == null) {
            EditorModificationUtilEx.$$$reportNull$$$0(10);
        }
        int result2 = EditorModificationUtilEx.insertStringAtCaretNoScrolling(editor, s, toProcessOverwriteMode, toMoveCaret, caretShift);
        if (toMoveCaret) {
            EditorModificationUtilEx.scrollToCaret(editor);
        }
        return result2;
    }

    protected static int insertStringAtCaretNoScrolling(@NotNull Editor editor, @NotNull String s, boolean toProcessOverwriteMode, boolean toMoveCaret, int caretShift) {
        String filler;
        if (editor == null) {
            EditorModificationUtilEx.$$$reportNull$$$0(11);
        }
        if (s == null) {
            EditorModificationUtilEx.$$$reportNull$$$0(12);
        }
        editor.getSoftWrapModel().beforeDocumentChangeAtCaret();
        int oldOffset = editor.getSelectionModel().getSelectionStart();
        String string = filler = editor.getSelectionModel().hasSelection() ? "" : EditorModificationUtilEx.calcStringToFillVirtualSpace(editor);
        if (!filler.isEmpty()) {
            s = filler + (String)s;
        }
        Document document = editor.getDocument();
        SelectionModel selectionModel = editor.getSelectionModel();
        if (editor.isInsertMode() || !toProcessOverwriteMode) {
            if (selectionModel.hasSelection()) {
                document.replaceString(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd(), (CharSequence)s);
            } else {
                document.insertString(oldOffset, (CharSequence)s);
            }
        } else {
            EditorModificationUtilEx.deleteSelectedText(editor);
            if (((String)s).length() == 1 && Character.isLowSurrogate(((String)s).charAt(0)) && oldOffset > 0 && Character.isHighSurrogate(document.getImmutableCharSequence().charAt(oldOffset - 1))) {
                document.insertString(oldOffset, (CharSequence)s);
            } else {
                int endOffset;
                int lineNumber = editor.getCaretModel().getLogicalPosition().line;
                int lineEndOffset = document.getLineEndOffset(lineNumber);
                int inputCodePointCount = ((String)s).codePointCount(0, ((String)s).length());
                try {
                    endOffset = Math.min(lineEndOffset, Character.offsetByCodePoints(document.getImmutableCharSequence(), oldOffset, inputCodePointCount));
                }
                catch (IndexOutOfBoundsException e) {
                    endOffset = lineEndOffset;
                }
                document.replaceString(oldOffset, endOffset, (CharSequence)s);
            }
        }
        int offset = oldOffset + filler.length() + caretShift;
        if (toMoveCaret) {
            editor.getCaretModel().moveToVisualPosition(editor.offsetToVisualPosition(offset, false, true));
            selectionModel.removeSelection();
        } else if (editor.getCaretModel().getOffset() != oldOffset) {
            editor.getCaretModel().moveToOffset(oldOffset);
        }
        return offset;
    }

    @NotNull
    public static String calcStringToFillVirtualSpace(@NotNull Editor editor) {
        int afterLineEnd;
        if (editor == null) {
            EditorModificationUtilEx.$$$reportNull$$$0(13);
        }
        if ((afterLineEnd = EditorModificationUtilEx.calcAfterLineEnd(editor)) > 0) {
            return EditorModificationUtilEx.calcStringToFillVirtualSpace(editor, afterLineEnd);
        }
        return "";
    }

    @NotNull
    public static String calcStringToFillVirtualSpace(@NotNull Editor editor, int afterLineEnd) {
        boolean atLineStart;
        if (editor == null) {
            EditorModificationUtilEx.$$$reportNull$$$0(14);
        }
        Project project = editor.getProject();
        StringBuilder buf = new StringBuilder();
        Document doc = editor.getDocument();
        int caretOffset = editor.getCaretModel().getOffset();
        boolean bl = atLineStart = caretOffset >= doc.getTextLength() || doc.getLineStartOffset(doc.getLineNumber(caretOffset)) == caretOffset;
        if (atLineStart && project != null) {
            String properIndent;
            int offset = editor.getCaretModel().getOffset();
            PsiDocumentManager.getInstance((Project)project).commitDocument(doc);
            String string = properIndent = offset >= doc.getTextLength() ? "" : CodeStyleFacade.getInstance(project).getLineIndent(doc, offset);
            if (properIndent != null) {
                int tabSize = editor.getSettings().getTabSize(project);
                for (int i = 0; i < properIndent.length(); ++i) {
                    if (properIndent.charAt(i) == ' ') {
                        --afterLineEnd;
                    } else if (properIndent.charAt(i) == '\t') {
                        if (afterLineEnd < tabSize) break;
                        afterLineEnd -= tabSize;
                    }
                    buf.append(properIndent.charAt(i));
                    if (afterLineEnd != 0) {
                        continue;
                    }
                    break;
                }
            } else {
                EditorSettings editorSettings = editor.getSettings();
                boolean useTab = editorSettings.isUseTabCharacter(editor.getProject());
                if (useTab) {
                    int tabSize = editorSettings.getTabSize(project);
                    while (afterLineEnd >= tabSize) {
                        buf.append('\t');
                        afterLineEnd -= tabSize;
                    }
                }
            }
        }
        buf.repeat(32, afterLineEnd);
        String string = buf.toString();
        if (string == null) {
            EditorModificationUtilEx.$$$reportNull$$$0(15);
        }
        return string;
    }

    public static void scrollToCaret(@NotNull Editor editor) {
        if (editor == null) {
            EditorModificationUtilEx.$$$reportNull$$$0(16);
        }
        if (editor.getCaretModel().getCurrentCaret() == editor.getCaretModel().getPrimaryCaret()) {
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    public static int calcAfterLineEnd(@NotNull Editor editor) {
        if (editor == null) {
            EditorModificationUtilEx.$$$reportNull$$$0(17);
        }
        CaretModel caretModel = editor.getCaretModel();
        int caretOffset = caretModel.getOffset();
        LogicalPosition logicalPosition = caretModel.getLogicalPosition();
        VisualPosition visualPosition = caretModel.getVisualPosition();
        return EditorModificationUtilEx.calcAfterLineEnd(editor, caretOffset, logicalPosition, visualPosition);
    }

    @ApiStatus.Experimental
    public static int calcAfterLineEnd(@NotNull Editor editor, int caretOffset, @NotNull LogicalPosition logicalPosition, @NotNull VisualPosition visualPosition) {
        if (editor == null) {
            EditorModificationUtilEx.$$$reportNull$$$0(18);
        }
        if (logicalPosition == null) {
            EditorModificationUtilEx.$$$reportNull$$$0(19);
        }
        if (visualPosition == null) {
            EditorModificationUtilEx.$$$reportNull$$$0(20);
        }
        Document document = editor.getDocument();
        int lineNumber = logicalPosition.line;
        int columnNumber = logicalPosition.column;
        if (lineNumber >= document.getLineCount()) {
            return columnNumber;
        }
        int anchorLineEndOffset = document.getLineEndOffset(lineNumber);
        List<? extends SoftWrap> softWraps = editor.getSoftWrapModel().getSoftWrapsForLine(logicalPosition.line);
        for (SoftWrap softWrap : softWraps) {
            boolean visuallyBeforeSoftWrap;
            if (!editor.getSoftWrapModel().isVisible(softWrap)) continue;
            int softWrapOffset = softWrap.getStart();
            if (softWrapOffset == caretOffset) {
                VisualPosition position = editor.offsetToVisualPosition(caretOffset - 1);
                if (position.line == visualPosition.line) {
                    return visualPosition.column - position.column - 1;
                }
            }
            if (softWrapOffset > caretOffset) {
                anchorLineEndOffset = softWrapOffset;
                break;
            }
            if (softWrapOffset != caretOffset || !(visuallyBeforeSoftWrap = visualPosition.line < editor.offsetToVisualPosition((int)caretOffset).line)) continue;
            anchorLineEndOffset = softWrapOffset;
            break;
        }
        int lineEndColumnNumber = editor.offsetToLogicalPosition((int)anchorLineEndOffset).column;
        return columnNumber - lineEndColumnNumber;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/EditorModificationUtilEx";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logicalPosition";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visualPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/EditorModificationUtilEx";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "calcStringToFillVirtualSpace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "deleteSelectedText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "insertStringAtCaret";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "insertStringAtCaretNoScrolling";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "calcStringToFillVirtualSpace";
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "scrollToCaret";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "calcAfterLineEnd";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15 -> new IllegalStateException(string);
        };
    }
}

