/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.downloader;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.remoteDev.connection.JetBrainsClientDownloadInfo;
import com.intellij.remoteDev.downloader.exceptions.CodeWithMeUnavailableException;
import com.intellij.util.UriUtilKt;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.system.CpuArch;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/intellij/remoteDev/downloader/ThinClientSessionInfoFetcher;", "", "<init>", "()V", "objectMapper", "Lkotlin/Lazy;", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "logger$delegate", "Lkotlin/Lazy;", "getErrorPayload", "", "connection", "Ljava/net/HttpURLConnection;", "getSessionUrl", "Lcom/intellij/remoteDev/connection/JetBrainsClientDownloadInfo;", "joinLinkUrl", "Ljava/net/URI;", "createUrl", "", "currentBuildNumber", "currentPlatform", "intellij.remoteDev.util"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nThinClientSessionInfoFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThinClientSessionInfoFetcher.kt\ncom/intellij/remoteDev/downloader/ThinClientSessionInfoFetcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,108:1\n1#2:109\n13#3:110\n*S KotlinDebug\n*F\n+ 1 ThinClientSessionInfoFetcher.kt\ncom/intellij/remoteDev/downloader/ThinClientSessionInfoFetcher\n*L\n27#1:110\n*E\n"})
public final class ThinClientSessionInfoFetcher {
    @NotNull
    public static final ThinClientSessionInfoFetcher INSTANCE = new ThinClientSessionInfoFetcher();
    @NotNull
    private static final Lazy<ObjectMapper> objectMapper = LazyKt.lazy(ThinClientSessionInfoFetcher::objectMapper$lambda$0);
    @NotNull
    private static final Lazy logger$delegate = LazyKt.lazy(ThinClientSessionInfoFetcher::logger_delegate$lambda$0);

    private ThinClientSessionInfoFetcher() {
    }

    private final Logger getLogger() {
        Lazy lazy = logger$delegate;
        return (Logger)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] getErrorPayload(HttpURLConnection connection) {
        byte[] byArray;
        InputStream inputStream = connection.getErrorStream();
        if (inputStream == null) {
            throw new IOException("Connection errorStream is null");
        }
        InputStream errorStream = inputStream;
        InputStream stream = Intrinsics.areEqual((Object)connection.getContentEncoding(), (Object)"gzip") ? (InputStream)new GZIPInputStream(errorStream) : errorStream;
        Closeable closeable = stream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            byArray = it.readAllBytes();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"use(...)");
        return byArray;
    }

    @NotNull
    public final JetBrainsClientDownloadInfo getSessionUrl(@NotNull URI joinLinkUrl) {
        ObjectNode objectNode;
        Intrinsics.checkNotNullParameter((Object)joinLinkUrl, (String)"joinLinkUrl");
        String url = this.createUrl(joinLinkUrl);
        ObjectNode $this$getSessionUrl_u24lambda_u240 = objectNode = ((ObjectMapper)objectMapper.getValue()).createObjectNode();
        boolean bl = false;
        $this$getSessionUrl_u24lambda_u240.put("clientBuildNumber", INSTANCE.currentBuildNumber());
        $this$getSessionUrl_u24lambda_u240.put("clientPlatform", INSTANCE.currentPlatform());
        String requestString = objectNode.toPrettyString();
        Object object = HttpRequests.post((String)url, (String)"application/json; charset=utf-8").throwStatusCodeException(false).productNameAsUserAgent().tuner(ThinClientSessionInfoFetcher::getSessionUrl$lambda$1).connect(arg_0 -> ThinClientSessionInfoFetcher.getSessionUrl$lambda$2(requestString, url, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"connect(...)");
        return (JetBrainsClientDownloadInfo)object;
    }

    private final String createUrl(URI joinLinkUrl) {
        String string = UriUtilKt.withFragment((URI)joinLinkUrl, null).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        char[] cArray = new char[]{'/'};
        String baseLink = StringsKt.trimEnd((String)string, (char[])cArray);
        return baseLink + "/info";
    }

    private final String currentBuildNumber() {
        String string = ApplicationInfo.getInstance().getBuild().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String currentPlatform() {
        String string;
        if (SystemInfo.isMac && CpuArch.isArm64()) {
            string = "osx-aarch64";
        } else if (SystemInfo.isMac && CpuArch.isIntel64()) {
            string = "osx-x64";
        } else if (SystemInfo.isLinux && CpuArch.isArm64()) {
            string = "linux-aarch64";
        } else if (SystemInfo.isLinux && CpuArch.isIntel64()) {
            string = "linux-x64";
        } else if (SystemInfo.isWindows && CpuArch.isIntel64()) {
            string = "windows-x64";
        } else if (SystemInfo.isWindows && CpuArch.isArm64()) {
            string = "windows-aarch64";
        } else {
            throw new IllegalStateException(("Unsupported OS type: " + SystemInfo.OS_NAME + ", CpuArch: " + CpuArch.CURRENT).toString());
        }
        return string;
    }

    private static final ObjectMapper objectMapper$lambda$0() {
        return new ObjectMapper();
    }

    private static final Logger logger_delegate$lambda$0() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ThinClientSessionInfoFetcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    private static final void getSessionUrl$lambda$1(URLConnection it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setRequestProperty("Accept", "application/json; charset=utf-8");
    }

    private static final JetBrainsClientDownloadInfo getSessionUrl$lambda$2(String $requestString, String $url, HttpRequests.Request request) {
        JsonNode sessionInfo;
        String string;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        request.write($requestString);
        URLConnection uRLConnection = request.getConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        try {
            string = request.readString();
        }
        catch (IOException ioException) {
            byte[] errorPayload = INSTANCE.getErrorPayload(connection);
            string = new String(errorPayload, Charsets.UTF_8);
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String jsonResponseString = string2;
        if (connection.getResponseCode() == 403 || connection.getResponseCode() == 451) {
            try {
                sessionInfo = ((ObjectMapper)objectMapper.getValue()).reader().readTree(jsonResponseString);
                JsonNode jsonNode = sessionInfo.get("messageId");
                if (Intrinsics.areEqual((Object)(jsonNode != null ? jsonNode.textValue() : null), (Object)"FORBIDDEN_BY_REGION_RESTRICTION")) {
                    JsonNode jsonNode2 = sessionInfo.get("learnMoreLink");
                    String learnMoreLink = jsonNode2 != null ? jsonNode2.textValue() : null;
                    Object object = sessionInfo.get("message");
                    if (object == null || (object = object.textValue()) == null) {
                        object = "Forbidden";
                    }
                    Object message = object;
                    JsonNode jsonNode3 = sessionInfo.get("forbiddenReasonText");
                    String reason = jsonNode3 != null ? jsonNode3.textValue() : null;
                    throw new CodeWithMeUnavailableException((String)message, learnMoreLink, reason, null, connection.getResponseCode());
                }
            }
            catch (JacksonException ex) {
                INSTANCE.getLogger().warn("Failed to decode response", (Throwable)ex);
            }
        }
        if (connection.getResponseCode() >= 400) {
            throw new IllegalStateException(("Request to " + $url + " failed with status code " + connection.getResponseCode()).toString());
        }
        sessionInfo = ((ObjectMapper)objectMapper.getValue()).reader().readTree(jsonResponseString);
        JsonNode jreUrlNode = sessionInfo.get("compatibleJreUrl");
        String hostBuildNumber = sessionInfo.get("hostBuildNumber").asText();
        BuildNumber buildNumber = BuildNumber.fromStringOrNull((String)hostBuildNumber);
        if (buildNumber == null) {
            throw new IllegalStateException(("Invalid host build number: " + hostBuildNumber).toString());
        }
        String string3 = sessionInfo.get("compatibleClientUrl").asText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asText(...)");
        JsonNode jsonNode = sessionInfo.get("downloadPgpPublicKeyUrl");
        return new JetBrainsClientDownloadInfo(buildNumber, null, string3, jreUrlNode.isNull() ? null : jreUrlNode.asText(), jsonNode != null ? jsonNode.asText() : null, 2, null);
    }
}

