/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.ui;

import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.wm.impl.welcomeScreen.ActionPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenUIManager;
import com.intellij.remoteDev.RemoteDevUtilBundle;
import com.intellij.remoteDev.ui.ConnectionManager;
import com.intellij.remoteDev.ui.TextComponentHint;
import com.intellij.remoteDev.util.LocalUserSettings;
import com.intellij.remoteDev.util.UrlUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.net.URI;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/remoteDev/ui/ConnectionPanel;", "Lcom/intellij/openapi/wm/impl/welcomeScreen/ActionPanel;", "manager", "Lcom/intellij/remoteDev/ui/ConnectionManager;", "<init>", "(Lcom/intellij/remoteDev/ui/ConnectionManager;)V", "defaultButtonArc", "", "titleLabel", "Lcom/intellij/ui/components/JBLabel;", "userNameTextLabel", "remoteUrlTextLabel", "userNameTextField", "Lcom/intellij/ui/components/JBTextField;", "remoteUrlTextField", "connectActionButton", "Ljavax/swing/JButton;", "connectionButtonPanel", "Ljavax/swing/JRootPane;", "layoutComponents", "", "connect", "getRemoteUrl", "", "setRemoteUrl", "url", "intellij.remoteDev.util"})
@ApiStatus.Experimental
public class ConnectionPanel
extends ActionPanel {
    @NotNull
    private final ConnectionManager manager;
    private int defaultButtonArc;
    @NotNull
    private final JBLabel titleLabel;
    @NotNull
    private final JBLabel userNameTextLabel;
    @NotNull
    private final JBLabel remoteUrlTextLabel;
    @NotNull
    private final JBTextField userNameTextField;
    @NotNull
    private final JBTextField remoteUrlTextField;
    @NotNull
    private final JButton connectActionButton;
    @NotNull
    private JRootPane connectionButtonPanel;

    /*
     * WARNING - void declaration
     */
    public ConnectionPanel(@NotNull ConnectionManager manager) {
        void $this$_init__u24lambda_u245;
        AbstractAction $this$_init__u24lambda_u242;
        JBLabel $this$_init__u24lambda_u241;
        JBLabel $this$_init__u24lambda_u240;
        JBLabel jBLabel;
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        super((LayoutManager)new MigLayout("wrap 2, ins 20 20 0 0, novisualpadding, gap 5, flowy", null));
        this.manager = manager;
        this.connectionButtonPanel = new JRootPane();
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setBackground(WelcomeScreenUIManager.getMainAssociatedComponentBackground());
        KeyAdapter connectKeyAdapter2 = new KeyAdapter(this){
            final /* synthetic */ ConnectionPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyPressed(KeyEvent e) {
                if (e != null && e.getKeyCode() == 10) {
                    ConnectionPanel.access$connect(this.this$0);
                }
            }
        };
        JBLabel jBLabel2 = jBLabel = new JBLabel(RemoteDevUtilBundle.INSTANCE.message("connection.panel.description", new Object[0]), 2);
        ConnectionPanel connectionPanel = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.setOpaque(false);
        $this$_init__u24lambda_u240.setFont($this$_init__u24lambda_u240.getFont().deriveFont((float)StartupUiUtil.getLabelFont().getSize() + (float)JBUIScale.scale((int)5)).deriveFont(1));
        connectionPanel.titleLabel = jBLabel;
        $this$_init__u24lambda_u240 = jBLabel = new JBLabel(RemoteDevUtilBundle.INSTANCE.message("connection.panel.cwm.name.label", new Object[0]));
        connectionPanel = this;
        boolean bl2 = false;
        $this$_init__u24lambda_u241.setFont(StartupUiUtil.getLabelFont().deriveFont((float)StartupUiUtil.getLabelFont().getSize() + (float)JBUIScale.scale((int)1)).deriveFont(1));
        connectionPanel.userNameTextLabel = jBLabel;
        this.userNameTextField = new JBTextField(LocalUserSettings.INSTANCE.getUserName());
        this.userNameTextField.setMinimumSize(new Dimension(JBUI.scale((int)280), this.userNameTextField.getMinimumSize().height));
        this.userNameTextField.setMaximumSize(new Dimension(JBUI.scale((int)280), this.userNameTextField.getMaximumSize().height));
        new TextComponentHint((JTextComponent)this.userNameTextField, RemoteDevUtilBundle.INSTANCE.message("connection.panel.cwm.name.textfield", new Object[0]), null, 4, null);
        $this$_init__u24lambda_u241 = jBLabel = new JBLabel(RemoteDevUtilBundle.INSTANCE.message("connection.panel.url.label", new Object[0]));
        connectionPanel = this;
        boolean bl3 = false;
        $this$_init__u24lambda_u242.setFont(StartupUiUtil.getLabelFont().deriveFont((float)StartupUiUtil.getLabelFont().getSize() + (float)JBUIScale.scale((int)1)).deriveFont(1));
        connectionPanel.remoteUrlTextLabel = jBLabel;
        this.remoteUrlTextField = new JBTextField();
        this.remoteUrlTextField.setMinimumSize(new Dimension(JBUI.scale((int)280), this.remoteUrlTextField.getMinimumSize().height));
        this.remoteUrlTextField.setMaximumSize(new Dimension(JBUI.scale((int)280), this.remoteUrlTextField.getMaximumSize().height));
        this.remoteUrlTextField.addKeyListener((KeyListener)connectKeyAdapter2);
        new TextComponentHint((JTextComponent)this.remoteUrlTextField, RemoteDevUtilBundle.INSTANCE.message("connection.panel.url.textfield", new Object[0]), null, 4, null);
        Serializable $this$_init__u24lambda_u243 = $this$_init__u24lambda_u242 = new AbstractAction(this){
            final /* synthetic */ ConnectionPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(ActionEvent e) {
                ConnectionPanel.access$connect(this.this$0);
            }
        };
        boolean bl4 = false;
        $this$_init__u24lambda_u243.putValue("DefaultAction", true);
        $this$_init__u24lambda_u243.putValue("Name", RemoteDevUtilBundle.INSTANCE.message("connection.panel.connect.link", new Object[0]));
        AbstractAction connectAction2 = $this$_init__u24lambda_u242;
        AbstractAction $this$_init__u24lambda_u244 = $this$_init__u24lambda_u243 = new AbstractAction(this){
            final /* synthetic */ ConnectionPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(ActionEvent e) {
                ConnectionPanel.access$getManager$p(this.this$0).close();
            }
        };
        boolean bl5 = false;
        $this$_init__u24lambda_u244.putValue("Name", RemoteDevUtilBundle.INSTANCE.message("connection.panel.back.link", new Object[0]));
        AbstractAction backAction2 = $this$_init__u24lambda_u243;
        $this$_init__u24lambda_u244 = $this$_init__u24lambda_u243 = new JRootPane();
        connectionPanel = this;
        boolean bl6 = false;
        $this$_init__u24lambda_u245.setLayout(new BorderLayout());
        $this$_init__u24lambda_u245.setOpaque(false);
        $this$_init__u24lambda_u245.setBorder(BorderFactory.createEmptyBorder());
        connectionPanel.connectionButtonPanel = $this$_init__u24lambda_u243;
        this.addPropertyChangeListener(arg_0 -> ConnectionPanel._init_$lambda$6(this, arg_0));
        JButton jButton = DialogWrapper.createJButtonForAction((Action)connectAction2, (JRootPane)this.connectionButtonPanel);
        Intrinsics.checkNotNullExpressionValue((Object)jButton, (String)"createJButtonForAction(...)");
        this.connectActionButton = jButton;
        this.connectActionButton.addKeyListener(connectKeyAdapter2);
        this.connectActionButton.setBackground(this.getBackground());
        this.connectionButtonPanel.add((Component)this.connectActionButton, "Center");
        if (this.manager.getCanClose()) {
            JButton jButton2 = DialogWrapper.createJButtonForAction((Action)backAction2, (JRootPane)this.connectionButtonPanel);
            Intrinsics.checkNotNullExpressionValue((Object)jButton2, (String)"createJButtonForAction(...)");
            JButton backActionButton = jButton2;
            backActionButton.setBackground(this.getBackground());
            this.connectionButtonPanel.add((Component)backActionButton, "West");
        }
        this.layoutComponents();
    }

    protected void layoutComponents() {
        this.add((Component)this.titleLabel, "span, left, gapbottom 5");
        this.add((Component)this.userNameTextLabel, "cell 0 1");
        this.add((Component)this.userNameTextField, "cell 1 1, wrap");
        this.add((Component)this.remoteUrlTextLabel, "cell 0 2");
        this.add((Component)this.remoteUrlTextField, "cell 1 2, wrap");
        this.add(this.connectionButtonPanel, "cell 0 3, gaptop 5");
    }

    private final void connect() {
        String userName = this.userNameTextField.getText();
        String string = this.remoteUrlTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String urlToConnect = ((Object)StringsKt.trim((CharSequence)string)).toString();
        Intrinsics.checkNotNull((Object)userName);
        if (StringsKt.isBlank((CharSequence)userName) || StringsKt.isBlank((CharSequence)urlToConnect)) {
            return;
        }
        Function0 onDone = () -> ConnectionPanel.connect$lambda$0(this);
        URI uRI = UrlUtil.INSTANCE.parseOrShowError(urlToConnect, this.manager.getProductName());
        if (uRI == null) {
            return;
        }
        URI uri = uRI;
        this.userNameTextField.setEnabled(false);
        this.remoteUrlTextField.setEnabled(false);
        this.connectActionButton.setEnabled(false);
        this.manager.connect(userName, uri, (Function0<Unit>)onDone);
    }

    @NotNull
    public final String getRemoteUrl() {
        String string = this.remoteUrlTextField.getText();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public final void setRemoteUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (((CharSequence)url).length() > 0) {
            this.remoteUrlTextField.setText(url);
        }
    }

    private static final void _init_$lambda$6(ConnectionPanel this$0, PropertyChangeEvent it) {
        if (Intrinsics.areEqual((Object)it.getPropertyName(), (Object)"ancestor")) {
            if (this$0.defaultButtonArc == 0) {
                this$0.defaultButtonArc = UIManager.getInt("Button.arc");
                v0 = UIManager.put("Button.arc", 8);
            } else {
                v0 = UIManager.put("Button.arc", this$0.defaultButtonArc);
            }
        }
    }

    private static final Unit connect$lambda$0(ConnectionPanel this$0) {
        this$0.userNameTextField.setEnabled(true);
        this$0.remoteUrlTextField.setEnabled(true);
        this$0.connectActionButton.setEnabled(true);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$connect(ConnectionPanel $this) {
        $this.connect();
    }

    public static final /* synthetic */ ConnectionManager access$getManager$p(ConnectionPanel $this) {
        return $this.manager;
    }
}

