/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.trace.consent.model;

import cloud.jetbrains.trace.consent.storage.client.model.CreateTraceConsentRequest;
import cloud.jetbrains.trace.consent.storage.client.model.CreateTraceConsentRequestKt;
import com.intellij.platform.trace.consent.model.ConsentState;
import com.intellij.platform.trace.consent.model.ConsentType;
import com.intellij.platform.trace.consent.storage.serialization.TraceStateEventSerializer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0006\u0010!\u001a\u00020\"J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0006H\u00c6\u0003J\t\u0010&\u001a\u00020\bH\u00c6\u0003J\t\u0010'\u001a\u00020\nH\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u0010\u0010)\u001a\u0004\u0018\u00010\nH\u00c6\u0003\u00a2\u0006\u0002\u0010\u001dJ\u000b\u0010*\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u000fH\u00c6\u0003Jn\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u00c6\u0001\u00a2\u0006\u0002\u0010-J\u0014\u0010.\u001a\u00020\u000f2\b\u0010/\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u00100\u001a\u000201H\u00d6\u0081\u0004J\n\u00102\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u0015\u0010\f\u001a\u0004\u0018\u00010\n\u00a2\u0006\n\n\u0002\u0010\u001e\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0013R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010 \u00a8\u00063"}, d2={"Lcom/intellij/platform/trace/consent/model/TraceStateEvent;", "", "ideName", "", "ideVersion", "consentType", "Lcom/intellij/platform/trace/consent/model/ConsentType;", "consentState", "Lcom/intellij/platform/trace/consent/model/ConsentState;", "timestamp", "", "previousConsentState", "previousConsentTimestamp", "projectIdHash", "isLicenseChange", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/platform/trace/consent/model/ConsentType;Lcom/intellij/platform/trace/consent/model/ConsentState;JLcom/intellij/platform/trace/consent/model/ConsentState;Ljava/lang/Long;Ljava/lang/String;Z)V", "getIdeName", "()Ljava/lang/String;", "getIdeVersion", "getConsentType", "()Lcom/intellij/platform/trace/consent/model/ConsentType;", "getConsentState", "()Lcom/intellij/platform/trace/consent/model/ConsentState;", "getTimestamp", "()J", "getPreviousConsentState", "getPreviousConsentTimestamp", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getProjectIdHash", "()Z", "toCreateTraceConsentRequest", "Lcloud/jetbrains/trace/consent/storage/client/model/CreateTraceConsentRequest;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/platform/trace/consent/model/ConsentType;Lcom/intellij/platform/trace/consent/model/ConsentState;JLcom/intellij/platform/trace/consent/model/ConsentState;Ljava/lang/Long;Ljava/lang/String;Z)Lcom/intellij/platform/trace/consent/model/TraceStateEvent;", "equals", "other", "hashCode", "", "toString", "intellij.platform.trace.consent"})
@SourceDebugExtension(value={"SMAP\nTraceStateEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TraceStateEvent.kt\ncom/intellij/platform/trace/consent/model/TraceStateEvent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1#2:71\n*E\n"})
public final class TraceStateEvent {
    @NotNull
    private final String ideName;
    @NotNull
    private final String ideVersion;
    @NotNull
    private final ConsentType consentType;
    @NotNull
    private final ConsentState consentState;
    private final long timestamp;
    @Nullable
    private final ConsentState previousConsentState;
    @Nullable
    private final Long previousConsentTimestamp;
    @Nullable
    private final String projectIdHash;
    private final boolean isLicenseChange;

    public TraceStateEvent(@NotNull String ideName, @NotNull String ideVersion, @NotNull ConsentType consentType, @NotNull ConsentState consentState, long timestamp, @Nullable ConsentState previousConsentState, @Nullable Long previousConsentTimestamp, @Nullable String projectIdHash, boolean isLicenseChange) {
        Intrinsics.checkNotNullParameter((Object)ideName, (String)"ideName");
        Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
        Intrinsics.checkNotNullParameter((Object)((Object)consentType), (String)"consentType");
        Intrinsics.checkNotNullParameter((Object)((Object)consentState), (String)"consentState");
        this.ideName = ideName;
        this.ideVersion = ideVersion;
        this.consentType = consentType;
        this.consentState = consentState;
        this.timestamp = timestamp;
        this.previousConsentState = previousConsentState;
        this.previousConsentTimestamp = previousConsentTimestamp;
        this.projectIdHash = projectIdHash;
        this.isLicenseChange = isLicenseChange;
        if (!(!StringsKt.isBlank((CharSequence)this.ideName))) {
            boolean $i$a$-require-TraceStateEvent$52 = false;
            String $i$a$-require-TraceStateEvent$52 = "IDE name should not be blank";
            throw new IllegalArgumentException($i$a$-require-TraceStateEvent$52.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)this.ideVersion))) {
            boolean $i$a$-require-TraceStateEvent$62 = false;
            String $i$a$-require-TraceStateEvent$62 = "IDE version should not be blank";
            throw new IllegalArgumentException($i$a$-require-TraceStateEvent$62.toString());
        }
        if (!(this.ideName.length() <= 64)) {
            boolean $i$a$-require-TraceStateEvent$72 = false;
            String $i$a$-require-TraceStateEvent$72 = "IDE name should be less than 64 characters";
            throw new IllegalArgumentException($i$a$-require-TraceStateEvent$72.toString());
        }
        if (!(this.ideVersion.length() <= 64)) {
            boolean bl = false;
            String string = "IDE version should be less than 64 characters";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ TraceStateEvent(String string, String string2, ConsentType consentType, ConsentState consentState, long l, ConsentState consentState2, Long l2, String string3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            consentState2 = null;
        }
        if ((n & 0x40) != 0) {
            l2 = null;
        }
        if ((n & 0x80) != 0) {
            string3 = null;
        }
        if ((n & 0x100) != 0) {
            bl = false;
        }
        this(string, string2, consentType, consentState, l, consentState2, l2, string3, bl);
    }

    @NotNull
    public final String getIdeName() {
        return this.ideName;
    }

    @NotNull
    public final String getIdeVersion() {
        return this.ideVersion;
    }

    @NotNull
    public final ConsentType getConsentType() {
        return this.consentType;
    }

    @NotNull
    public final ConsentState getConsentState() {
        return this.consentState;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public final ConsentState getPreviousConsentState() {
        return this.previousConsentState;
    }

    @Nullable
    public final Long getPreviousConsentTimestamp() {
        return this.previousConsentTimestamp;
    }

    @Nullable
    public final String getProjectIdHash() {
        return this.projectIdHash;
    }

    public final boolean isLicenseChange() {
        return this.isLicenseChange;
    }

    @NotNull
    public final CreateTraceConsentRequest toCreateTraceConsentRequest() {
        return CreateTraceConsentRequestKt.CreateTraceConsentRequest((Function1<? super CreateTraceConsentRequest.Builder, Unit>)((Function1)arg_0 -> TraceStateEvent.toCreateTraceConsentRequest$lambda$0(this, arg_0)));
    }

    @NotNull
    public final String component1() {
        return this.ideName;
    }

    @NotNull
    public final String component2() {
        return this.ideVersion;
    }

    @NotNull
    public final ConsentType component3() {
        return this.consentType;
    }

    @NotNull
    public final ConsentState component4() {
        return this.consentState;
    }

    public final long component5() {
        return this.timestamp;
    }

    @Nullable
    public final ConsentState component6() {
        return this.previousConsentState;
    }

    @Nullable
    public final Long component7() {
        return this.previousConsentTimestamp;
    }

    @Nullable
    public final String component8() {
        return this.projectIdHash;
    }

    public final boolean component9() {
        return this.isLicenseChange;
    }

    @NotNull
    public final TraceStateEvent copy(@NotNull String ideName, @NotNull String ideVersion, @NotNull ConsentType consentType, @NotNull ConsentState consentState, long timestamp, @Nullable ConsentState previousConsentState, @Nullable Long previousConsentTimestamp, @Nullable String projectIdHash, boolean isLicenseChange) {
        Intrinsics.checkNotNullParameter((Object)ideName, (String)"ideName");
        Intrinsics.checkNotNullParameter((Object)ideVersion, (String)"ideVersion");
        Intrinsics.checkNotNullParameter((Object)((Object)consentType), (String)"consentType");
        Intrinsics.checkNotNullParameter((Object)((Object)consentState), (String)"consentState");
        return new TraceStateEvent(ideName, ideVersion, consentType, consentState, timestamp, previousConsentState, previousConsentTimestamp, projectIdHash, isLicenseChange);
    }

    public static /* synthetic */ TraceStateEvent copy$default(TraceStateEvent traceStateEvent, String string, String string2, ConsentType consentType, ConsentState consentState, long l, ConsentState consentState2, Long l2, String string3, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = traceStateEvent.ideName;
        }
        if ((n & 2) != 0) {
            string2 = traceStateEvent.ideVersion;
        }
        if ((n & 4) != 0) {
            consentType = traceStateEvent.consentType;
        }
        if ((n & 8) != 0) {
            consentState = traceStateEvent.consentState;
        }
        if ((n & 0x10) != 0) {
            l = traceStateEvent.timestamp;
        }
        if ((n & 0x20) != 0) {
            consentState2 = traceStateEvent.previousConsentState;
        }
        if ((n & 0x40) != 0) {
            l2 = traceStateEvent.previousConsentTimestamp;
        }
        if ((n & 0x80) != 0) {
            string3 = traceStateEvent.projectIdHash;
        }
        if ((n & 0x100) != 0) {
            bl = traceStateEvent.isLicenseChange;
        }
        return traceStateEvent.copy(string, string2, consentType, consentState, l, consentState2, l2, string3, bl);
    }

    @NotNull
    public String toString() {
        return "TraceStateEvent(ideName=" + this.ideName + ", ideVersion=" + this.ideVersion + ", consentType=" + this.consentType + ", consentState=" + this.consentState + ", timestamp=" + this.timestamp + ", previousConsentState=" + this.previousConsentState + ", previousConsentTimestamp=" + this.previousConsentTimestamp + ", projectIdHash=" + this.projectIdHash + ", isLicenseChange=" + this.isLicenseChange + ")";
    }

    public int hashCode() {
        int result = this.ideName.hashCode();
        result = result * 31 + this.ideVersion.hashCode();
        result = result * 31 + this.consentType.hashCode();
        result = result * 31 + this.consentState.hashCode();
        result = result * 31 + Long.hashCode(this.timestamp);
        result = result * 31 + (this.previousConsentState == null ? 0 : this.previousConsentState.hashCode());
        result = result * 31 + (this.previousConsentTimestamp == null ? 0 : ((Object)this.previousConsentTimestamp).hashCode());
        result = result * 31 + (this.projectIdHash == null ? 0 : this.projectIdHash.hashCode());
        result = result * 31 + Boolean.hashCode(this.isLicenseChange);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TraceStateEvent)) {
            return false;
        }
        TraceStateEvent traceStateEvent = (TraceStateEvent)other;
        if (!Intrinsics.areEqual((Object)this.ideName, (Object)traceStateEvent.ideName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.ideVersion, (Object)traceStateEvent.ideVersion)) {
            return false;
        }
        if (this.consentType != traceStateEvent.consentType) {
            return false;
        }
        if (this.consentState != traceStateEvent.consentState) {
            return false;
        }
        if (this.timestamp != traceStateEvent.timestamp) {
            return false;
        }
        if (this.previousConsentState != traceStateEvent.previousConsentState) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.previousConsentTimestamp, (Object)traceStateEvent.previousConsentTimestamp)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.projectIdHash, (Object)traceStateEvent.projectIdHash)) {
            return false;
        }
        return this.isLicenseChange == traceStateEvent.isLicenseChange;
    }

    private static final Unit toCreateTraceConsentRequest$lambda$0(TraceStateEvent this$0, CreateTraceConsentRequest.Builder $this$CreateTraceConsentRequest) {
        Intrinsics.checkNotNullParameter((Object)$this$CreateTraceConsentRequest, (String)"$this$CreateTraceConsentRequest");
        $this$CreateTraceConsentRequest.setMachineId(String.valueOf(TraceStateEventSerializer.INSTANCE.getMachineId()));
        $this$CreateTraceConsentRequest.setIdeName(this$0.ideName);
        $this$CreateTraceConsentRequest.setIdeVersion(this$0.ideVersion);
        $this$CreateTraceConsentRequest.setConsentType(this$0.consentType.toRequestConsentType());
        $this$CreateTraceConsentRequest.setConsentState(this$0.consentState.toRequestConsentState());
        $this$CreateTraceConsentRequest.setChangedAt(this$0.timestamp);
        ConsentState consentState = this$0.previousConsentState;
        $this$CreateTraceConsentRequest.setPreviousConsentState(consentState != null ? consentState.toRequestConsentState() : null);
        $this$CreateTraceConsentRequest.setPreviousChangedAt(this$0.previousConsentTimestamp);
        $this$CreateTraceConsentRequest.setLicenseChanged(this$0.isLicenseChange);
        return Unit.INSTANCE;
    }
}

