/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.ijent.mrfs;

import com.intellij.docker.DockerMainCoroutineScopeHolder;
import com.intellij.docker.ijent.DockerEelDescriptor;
import com.intellij.docker.ijent.DockerEelPathFormat;
import com.intellij.docker.ijent.DockerEelPathFormatKt;
import com.intellij.docker.ijent.DockerMountsAwareFileSystemProvider;
import com.intellij.execution.ijent.nio.IjentEphemeralRootAwareFileSystemProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.impl.fs.telemetry.TracingFileSystemProvider;
import com.intellij.platform.eel.provider.MultiRoutingFileSystemBackend;
import com.intellij.platform.ijent.community.impl.IjentFailSafeFileSystemPosixApiKt;
import com.intellij.platform.ijent.community.impl.nio.IjentNioFileSystemProvider;
import com.intellij.platform.ijent.fs.IjentFileSystemApi;
import java.net.URI;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lcom/intellij/docker/ijent/mrfs/EelDockerMrfsBackend;", "Lcom/intellij/platform/eel/provider/MultiRoutingFileSystemBackend;", "<init>", "()V", "fileSystemRecords", "Ljava/util/concurrent/atomic/AtomicReference;", "", "Lcom/intellij/docker/ijent/mrfs/EelDockerMrfsBackend$FileSystemRecord;", "getFileSystemRecords", "()Ljava/util/concurrent/atomic/AtomicReference;", "compute", "Ljava/nio/file/FileSystem;", "localFS", "sanitizedPath", "", "computeImpl", "", "formatPath", "Lcom/intellij/docker/ijent/DockerEelPathFormat$PathRepresentation;", "record", "getCustomRoots", "", "getCustomFileStores", "Ljava/nio/file/FileStore;", "FileSystemRecord", "Companion", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nEelDockerMrfsBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EelDockerMrfsBackend.kt\ncom/intellij/docker/ijent/mrfs/EelDockerMrfsBackend\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,117:1\n629#2,12:118\n1586#2:130\n1661#2,3:131\n1391#2:134\n1480#2,5:135\n1807#2,3:140\n13#3:143\n*S KotlinDebug\n*F\n+ 1 EelDockerMrfsBackend.kt\ncom/intellij/docker/ijent/mrfs/EelDockerMrfsBackend\n*L\n45#1:118,12\n102#1:130\n102#1:131,3\n106#1:134\n106#1:135,5\n40#1:140,3\n115#1:143\n*E\n"})
public final class EelDockerMrfsBackend
implements MultiRoutingFileSystemBackend {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicReference<List<FileSystemRecord>> fileSystemRecords = new AtomicReference<List>(CollectionsKt.emptyList());
    @NotNull
    private static final Logger LOG;

    @NotNull
    public final AtomicReference<List<FileSystemRecord>> getFileSystemRecords() {
        return this.fileSystemRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public FileSystem compute(@NotNull FileSystem localFS, @NotNull String sanitizedPath) {
        void $this$single$iv;
        Intrinsics.checkNotNullParameter((Object)localFS, (String)"localFS");
        Intrinsics.checkNotNullParameter((Object)sanitizedPath, (String)"sanitizedPath");
        DockerEelPathFormat dockerEelPathFormat = DockerEelPathFormat.Companion.detect(sanitizedPath);
        if (dockerEelPathFormat == null) {
            return null;
        }
        DockerEelPathFormat format = dockerEelPathFormat;
        DockerEelPathFormat.PathRepresentation pathRepresentation = format.parse(sanitizedPath);
        if (pathRepresentation == null) {
            return null;
        }
        DockerEelPathFormat.PathRepresentation formatPath = pathRepresentation;
        String fsRoot = formatPath.getStringRoot();
        List<FileSystemRecord> list = this.fileSystemRecords.updateAndGet(arg_0 -> EelDockerMrfsBackend.compute$lambda$0(fsRoot, arg_0));
        Intrinsics.checkNotNullExpressionValue(list, (String)"updateAndGet(...)");
        Object object = list;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            FileSystemRecord record = (FileSystemRecord)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)record.getFsRoot(), (Object)fsRoot)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        FileSystemRecord record = single$iv;
        if (record.getFs() == null) {
            object = record;
            synchronized (object) {
                boolean bl = false;
                if (record.getFs() == null) {
                    this.computeImpl(localFS, formatPath, record);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        return record.getFs();
    }

    private final void computeImpl(FileSystem localFS, DockerEelPathFormat.PathRepresentation formatPath, FileSystemRecord record) {
        Path localPath = localFS.getPath(formatPath.getStringRoot(), new String[0]);
        if (Files.exists(localPath, new LinkOption[0])) {
            LOG.warn("Cannot register a file system for a path that already exists: " + localPath);
            return;
        }
        CoroutineScope scope = DockerMainCoroutineScopeHolder.Companion.getInstance().getScope();
        URI ijentUri = new URI("ijent", "docker", "/" + formatPath.getContainerIdentifier(), null, null);
        TracingFileSystemProvider ijentDefaultProvider = new TracingFileSystemProvider((FileSystemProvider)IjentNioFileSystemProvider.Companion.getInstance(), null, 2, null);
        DockerEelDescriptor descriptor2 = DockerEelPathFormatKt.toEelDescriptor(formatPath);
        try {
            IjentFileSystemApi ijentFs = IjentFailSafeFileSystemPosixApiKt.IjentFailSafeFileSystemPosixApi((CoroutineScope)scope, (EelDescriptor)((EelDescriptor)descriptor2), null);
            ijentDefaultProvider.newFileSystem(ijentUri, IjentNioFileSystemProvider.Companion.newFileSystemMap(ijentFs));
        }
        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
            // empty catch block
        }
        Intrinsics.checkNotNull((Object)localPath);
        FileSystemProvider fileSystemProvider = (FileSystemProvider)ijentDefaultProvider;
        FileSystemProvider fileSystemProvider2 = localFS.provider();
        Intrinsics.checkNotNullExpressionValue((Object)fileSystemProvider2, (String)"provider(...)");
        IjentEphemeralRootAwareFileSystemProvider ijentFsProvider = new IjentEphemeralRootAwareFileSystemProvider(localPath, fileSystemProvider, (FileSystemProvider)new TracingFileSystemProvider(fileSystemProvider2, null, 2, null), false);
        DockerMountsAwareFileSystemProvider mountsAwareFileSystemProvider = new DockerMountsAwareFileSystemProvider((FileSystemProvider)ijentFsProvider);
        record.setFs((FileSystem)mountsAwareFileSystemProvider.getFileSystem(ijentUri));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<String> getCustomRoots() {
        void $this$mapTo$iv$iv;
        List<FileSystemRecord> list = this.fileSystemRecords.get();
        Intrinsics.checkNotNullExpressionValue(list, (String)"get(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void record;
            FileSystemRecord fileSystemRecord = (FileSystemRecord)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(record.getFsRoot());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<FileStore> getCustomFileStores(@NotNull FileSystem localFS) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)localFS, (String)"localFS");
        List<FileSystemRecord> list = this.fileSystemRecords.get();
        Intrinsics.checkNotNullExpressionValue(list, (String)"get(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FileSystemRecord record = (FileSystemRecord)element$iv$iv;
            boolean bl = false;
            Object object = this.compute(localFS, record.getFsRoot());
            if (object == null || (object = ((FileSystem)object).getFileStores()) == null) {
                object = CollectionsKt.emptyList();
            }
            Object list$iv$iv = object;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final List compute$lambda$0(String $fsRoot, List fileSystemRecords) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNull((Object)fileSystemRecords);
            Iterable $this$any$iv = fileSystemRecords;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FileSystemRecord record = (FileSystemRecord)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)record.getFsRoot(), (Object)$fsRoot)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl ? fileSystemRecords : CollectionsKt.plus((Collection)fileSystemRecords, (Object)new FileSystemRecord($fsRoot, null));
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EelDockerMrfsBackend.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/docker/ijent/mrfs/EelDockerMrfsBackend$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.clouds.docker"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/docker/ijent/mrfs/EelDockerMrfsBackend$FileSystemRecord;", "", "fsRoot", "", "fs", "Ljava/nio/file/FileSystem;", "<init>", "(Ljava/lang/String;Ljava/nio/file/FileSystem;)V", "getFsRoot", "()Ljava/lang/String;", "getFs", "()Ljava/nio/file/FileSystem;", "setFs", "(Ljava/nio/file/FileSystem;)V", "intellij.clouds.docker"})
    public static final class FileSystemRecord {
        @NotNull
        private final String fsRoot;
        @Nullable
        private volatile FileSystem fs;

        public FileSystemRecord(@NotNull String fsRoot, @Nullable FileSystem fs) {
            Intrinsics.checkNotNullParameter((Object)fsRoot, (String)"fsRoot");
            this.fsRoot = fsRoot;
            this.fs = fs;
        }

        @NotNull
        public final String getFsRoot() {
            return this.fsRoot;
        }

        @Nullable
        public final FileSystem getFs() {
            return this.fs;
        }

        public final void setFs(@Nullable FileSystem fileSystem) {
            this.fs = fileSystem;
        }
    }
}

