/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.VagrantBasedCredentialsHolder;
import com.intellij.remote.VagrantSupport;
import com.intellij.remote.ext.CredentialsEditor;
import com.intellij.remote.ext.CredentialsLanguageContribution;
import com.intellij.remote.ext.PathsBrowserDialogProvider;
import com.intellij.remote.ext.RemoteCredentialsHandler;
import com.intellij.remote.ext.VagrantCredentialsHandler;
import com.intellij.remote.ui.BundleAccessor;
import com.intellij.remote.ui.CredentialsEditorProvider;
import com.intellij.remote.ui.RemoteSdkEditorForm;
import com.jetbrains.plugins.remotesdk.VagrantCredentialsLanguageContributor;
import com.jetbrains.plugins.remotesdk.VagrantRemoteCredentialsEditor;
import com.jetbrains.plugins.remotesdk.ui.SshBrowseActionListenerUtil;
import java.util.function.Supplier;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0001&B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0002H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010H\u0016J*\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J9\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\r\b\u0001\u0010\u001f\u001a\u00070\u0018\u00a2\u0006\u0002\b 2\u000e\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020#0\"H\u0016J\b\u0010$\u001a\u00020%H\u0016\u00a8\u0006'"}, d2={"Lcom/jetbrains/plugins/remotesdk/VagrantCredentialsType;", "Lcom/intellij/remote/CredentialsType;", "Lcom/intellij/remote/VagrantBasedCredentialsHolder;", "Lcom/intellij/remote/ui/CredentialsEditorProvider;", "Lcom/intellij/remote/ext/PathsBrowserDialogProvider;", "<init>", "()V", "createCredentials", "getCredentialsKey", "Lcom/intellij/openapi/util/Key;", "getHandler", "Lcom/intellij/remote/ext/RemoteCredentialsHandler;", "credentials", "isAvailable", "", "languageContribution", "Lcom/intellij/remote/ext/CredentialsLanguageContribution;", "createEditor", "Lcom/intellij/remote/ext/CredentialsEditor;", "project", "Lcom/intellij/openapi/project/Project;", "parentForm", "Lcom/intellij/remote/ui/RemoteSdkEditorForm;", "getDefaultInterpreterPath", "", "bundleAccessor", "Lcom/intellij/remote/ui/BundleAccessor;", "showPathsBrowserDialog", "", "textField", "Ljavax/swing/JTextField;", "dialogTitle", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "supplier", "Ljava/util/function/Supplier;", "Lcom/intellij/remote/RemoteSdkAdditionalData;", "getWeight", "", "Companion", "intellij.remoteRun"})
public final class VagrantCredentialsType
extends CredentialsType<VagrantBasedCredentialsHolder>
implements CredentialsEditorProvider,
PathsBrowserDialogProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NlsSafe
    @NotNull
    public static final String VAGRANT_CREDENTIALS_TYPE_NAME = "Vagrant";
    @NonNls
    @NotNull
    public static final String VAGRANT_PREFIX = "vagrant://";
    @NotNull
    private static final Key<VagrantBasedCredentialsHolder> VAGRANT_BASED_CREDENTIALS;

    public VagrantCredentialsType() {
        super(VAGRANT_CREDENTIALS_TYPE_NAME, VAGRANT_PREFIX);
    }

    @NotNull
    public VagrantBasedCredentialsHolder createCredentials() {
        return new VagrantBasedCredentialsHolder();
    }

    @NotNull
    public Key<VagrantBasedCredentialsHolder> getCredentialsKey() {
        return VAGRANT_BASED_CREDENTIALS;
    }

    @NotNull
    public RemoteCredentialsHandler getHandler(@NotNull VagrantBasedCredentialsHolder credentials) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        return (RemoteCredentialsHandler)new VagrantCredentialsHandler(credentials);
    }

    public boolean isAvailable(@Nullable CredentialsLanguageContribution<?> languageContribution) {
        return VagrantSupport.getInstance() != null && languageContribution instanceof VagrantCredentialsLanguageContributor;
    }

    @NotNull
    public CredentialsEditor<?> createEditor(@Nullable Project project, @NotNull CredentialsLanguageContribution<?> languageContribution, @NotNull RemoteSdkEditorForm parentForm) {
        Intrinsics.checkNotNullParameter(languageContribution, (String)"languageContribution");
        Intrinsics.checkNotNullParameter((Object)parentForm, (String)"parentForm");
        VagrantSupport vagrantSupport = VagrantSupport.getInstance();
        if (vagrantSupport == null) {
            throw new IllegalStateException("Vagrant support is not available");
        }
        VagrantSupport vagrantSupport2 = vagrantSupport;
        return new VagrantRemoteCredentialsEditor(vagrantSupport2, parentForm, project);
    }

    @NotNull
    public String getDefaultInterpreterPath(@NotNull BundleAccessor bundleAccessor) {
        Intrinsics.checkNotNullParameter((Object)bundleAccessor, (String)"bundleAccessor");
        String string = bundleAccessor.message("remote.interpreter.default.interpreter.path", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void showPathsBrowserDialog(@Nullable Project project, @NotNull JTextField textField, @NlsContexts.DialogTitle @NotNull String dialogTitle, @NotNull Supplier<? extends RemoteSdkAdditionalData> supplier) {
        Intrinsics.checkNotNullParameter((Object)textField, (String)"textField");
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
        SshBrowseActionListenerUtil.showBrowseDialog(project, textField, dialogTitle, false, supplier);
    }

    public int getWeight() {
        return 40;
    }

    @JvmStatic
    @NotNull
    public static final VagrantCredentialsType getInstance() {
        return Companion.getInstance();
    }

    static {
        Key key = Key.create((String)"VAGRANT_BASED_CREDENTIALS");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        VAGRANT_BASED_CREDENTIALS = key;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\u0010H\u0007R\u0015\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u0015\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/plugins/remotesdk/VagrantCredentialsType$Companion;", "", "<init>", "()V", "VAGRANT_CREDENTIALS_TYPE_NAME", "", "Lcom/intellij/openapi/util/NlsSafe;", "VAGRANT_PREFIX", "VAGRANT_BASED_CREDENTIALS", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/remote/VagrantBasedCredentialsHolder;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getVAGRANT_BASED_CREDENTIALS", "()Lcom/intellij/openapi/util/Key;", "getInstance", "Lcom/jetbrains/plugins/remotesdk/VagrantCredentialsType;", "intellij.remoteRun"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<VagrantBasedCredentialsHolder> getVAGRANT_BASED_CREDENTIALS() {
            return VAGRANT_BASED_CREDENTIALS;
        }

        @JvmStatic
        @NotNull
        public final VagrantCredentialsType getInstance() {
            return (VagrantCredentialsType)((Object)CredentialsType.EP_NAME.findExtensionOrFail(VagrantCredentialsType.class));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

