/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.dialects.base.generator.dml.DmlGenerator;
import com.intellij.database.dialects.mongo.generator.dml.MongoColumnsOrderByGenerator;
import com.intellij.database.dialects.mongo.generator.dml.MongoDeleteColumnGenerator;
import com.intellij.database.dialects.mongo.generator.dml.MongoDeleteRowsGenerator;
import com.intellij.database.dialects.mongo.generator.dml.MongoInsertRowsGenerator;
import com.intellij.database.dialects.mongo.generator.dml.MongoSelectGenerator;
import com.intellij.database.dialects.mongo.generator.dml.MongoUpdateRowGenerator;
import com.intellij.database.dialects.mongo.generator.dml.MongoWhereClauseGenerator;
import com.intellij.database.dialects.mongo.generator.dml.MongoWrapInSelectGenerator;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.script.generator.dml.ColumnsOrderByTask;
import com.intellij.database.script.generator.dml.DeleteColumnTask;
import com.intellij.database.script.generator.dml.DeleteRowsTask;
import com.intellij.database.script.generator.dml.DmlHelper;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.InsertRowsTask;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.script.generator.dml.UpdateRowTask;
import com.intellij.database.script.generator.dml.WhereClauseTask;
import com.intellij.database.script.generator.dml.WrapInSelectTask;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J!\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J0\u0010\u001a\u001a\u0016\u0012\u0004\u0012\u0002H\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00160\u0018\u0018\u00010\u001b\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018H\u0002J\u0012\u0010\u001c\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u001dH\u0016J\u001c\u0010\u001e\u001a\u00020\u00072\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J(\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0011\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0007H\u0016J \u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0011\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020(H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\t\u00a8\u0006-"}, d2={"Lcom/intellij/database/dialects/mongo/MongoDmlHelper;", "Lcom/intellij/database/script/generator/dml/DmlHelper;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "supportsInsertDefaultValues", "", "getSupportsInsertDefaultValues", "()Z", "needAliasInDeleteStatement", "getNeedAliasInDeleteStatement", "needAliasInUpdateStatement", "getNeedAliasInUpdateStatement", "hideRowId", "getHideRowId", "hasRowId", "table", "Lcom/intellij/database/model/DasTable;", "version", "Lcom/intellij/database/util/Version;", "generate", "OUT", "task", "Lcom/intellij/database/script/generator/dml/DmlTask;", "(Lcom/intellij/database/script/generator/dml/DmlTask;)Ljava/lang/Object;", "getGenerator", "Lcom/intellij/database/dialects/base/generator/dml/DmlGenerator;", "supportsOffset", "Lcom/intellij/database/model/DasObject;", "isEditableTable", "kind", "Lcom/intellij/database/model/ObjectKind;", "variant", "Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "appendPlaceholderForInsert", "", "d", "Lcom/intellij/database/datagrid/AutoValueDescriptor;", "builder", "Lcom/intellij/database/util/DdlBuilder;", "forcePlaceholderForDefaults", "appendPlaceholderForUpdate", "data", "Lcom/intellij/database/datagrid/mutating/ColumnQueryData;", "intellij.database.dialects.mongo"})
public final class MongoDmlHelper
implements DmlHelper {
    @NotNull
    private final Dbms dbms;
    private final boolean supportsInsertDefaultValues;
    private final boolean needAliasInDeleteStatement;
    private final boolean needAliasInUpdateStatement;
    private final boolean hideRowId;

    public MongoDmlHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        this.dbms = dbms;
    }

    public boolean getSupportsInsertDefaultValues() {
        return this.supportsInsertDefaultValues;
    }

    public boolean getNeedAliasInDeleteStatement() {
        return this.needAliasInDeleteStatement;
    }

    public boolean getNeedAliasInUpdateStatement() {
        return this.needAliasInUpdateStatement;
    }

    public boolean getHideRowId() {
        return this.hideRowId;
    }

    public boolean hasRowId(@NotNull DasTable table, @Nullable Version version) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        return false;
    }

    public <OUT> OUT generate(@NotNull DmlTask<? extends OUT> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        DmlGenerator<? extends OUT, DmlTask<? extends OUT>> dmlGenerator = this.getGenerator(task);
        if (dmlGenerator == null) {
            throw new UnsupportedOperationException("Task is not supported " + task);
        }
        DmlGenerator<? extends OUT, DmlTask<? extends OUT>> generator = dmlGenerator;
        return (OUT)generator.generate();
    }

    private final <OUT> DmlGenerator<OUT, DmlTask<OUT>> getGenerator(DmlTask<? extends OUT> task) {
        DmlTask<? extends OUT> dmlTask = task;
        DmlGenerator dmlGenerator = dmlTask instanceof WhereClauseTask ? (DmlGenerator)new MongoWhereClauseGenerator((WhereClauseTask)task, this.dbms) : (dmlTask instanceof ColumnsOrderByTask ? (DmlGenerator)new MongoColumnsOrderByGenerator((ColumnsOrderByTask)task, this.dbms) : (dmlTask instanceof WrapInSelectTask ? (DmlGenerator)new MongoWrapInSelectGenerator((WrapInSelectTask)task, this.dbms) : (dmlTask instanceof SelectTask ? (DmlGenerator)new MongoSelectGenerator((SelectTask)task, this.dbms) : (dmlTask instanceof InsertRowsTask ? (DmlGenerator)new MongoInsertRowsGenerator((InsertRowsTask)task, this.dbms) : (dmlTask instanceof DeleteRowsTask ? (DmlGenerator)new MongoDeleteRowsGenerator((DeleteRowsTask)task, this.dbms) : (dmlTask instanceof UpdateRowTask ? (DmlGenerator)new MongoUpdateRowGenerator((UpdateRowTask)task, this.dbms) : (dmlTask instanceof DeleteColumnTask ? (DmlGenerator)new MongoDeleteColumnGenerator((DeleteColumnTask)task, this.dbms) : null)))))));
        return dmlGenerator instanceof DmlGenerator ? dmlGenerator : null;
    }

    public boolean supportsOffset(@Nullable DasObject table) {
        return true;
    }

    public boolean isEditableTable(@Nullable ObjectKind kind, @Nullable ModelHelper.ObjectKindVariant variant) {
        return Intrinsics.areEqual((Object)kind, (Object)ObjectKind.TABLE);
    }

    public void appendPlaceholderForInsert(@NotNull AutoValueDescriptor d, @NotNull DasObject table, @NotNull DdlBuilder builder, boolean forcePlaceholderForDefaults) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
    }

    public boolean appendPlaceholderForUpdate(@NotNull ColumnQueryData data, @NotNull DasObject table, @NotNull DdlBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.plain(String.valueOf(data.getObject()));
        return false;
    }
}

