/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.plugin.freeze;

import com.intellij.diagnostic.FreezeNotifier;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.ThreadDump;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.platform.diagnostic.plugin.freeze.FreezeReason;
import com.intellij.platform.diagnostic.plugin.freeze.PluginFreezeWatcher;
import com.intellij.ui.EditorNotifications;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/platform/diagnostic/plugin/freeze/PluginFreezeNotifier;", "Lcom/intellij/diagnostic/FreezeNotifier;", "<init>", "()V", "notifyFreeze", "", "event", "Lcom/intellij/diagnostic/LogMessage;", "currentDumps", "", "Lcom/intellij/diagnostic/ThreadDump;", "reportDir", "Ljava/nio/file/Path;", "durationMs", "", "reportFreeze", "intellij.platform.diagnostic.freezes"})
public final class PluginFreezeNotifier
implements FreezeNotifier {
    public void notifyFreeze(@NotNull LogMessage event, @NotNull Collection<ThreadDump> currentDumps, @NotNull Path reportDir, long durationMs) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(currentDumps, (String)"currentDumps");
        Intrinsics.checkNotNullParameter((Object)reportDir, (String)"reportDir");
        PluginFreezeWatcher freezeWatcher = PluginFreezeWatcher.Companion.getInstance();
        FreezeReason freezeReason = freezeWatcher.getFreezeReason();
        if (freezeReason != null) {
            return;
        }
        for (ThreadDump dump : currentDumps) {
            FreezeReason reason = freezeWatcher.dumpedThreads(event, dump, durationMs);
            if (reason == null) continue;
            LifecycleUsageTriggerCollector.pluginFreezeDetected((PluginId)reason.getPluginId(), (long)durationMs, (boolean)reason.getReportToUser());
            this.reportFreeze();
            break;
        }
    }

    private final void reportFreeze() {
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        for (Project project : projectArray) {
            Intrinsics.checkNotNull((Object)project);
            Project project2 = project;
            EditorNotifications.getInstance((Project)project2).updateAllNotifications();
        }
    }
}

