/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.permissions;

import com.intellij.cwm.plugin.common.permissions.UtilKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.ide.core.permissions.impl.IdePermission;
import com.intellij.platform.ide.core.permissions.impl.IdePermissionManager;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.actions.AccessLevelMarker;
import com.jetbrains.rd.platform.codeWithMe.permissions.FileAccessLevel;
import com.jetbrains.rd.platform.codeWithMe.permissions.RunAccessLevel;
import com.jetbrains.rd.platform.codeWithMe.permissions.TerminalAccessLevel;
import com.jetbrains.rd.platform.codeWithMe.permissions.ToolWindowAccessLevel;
import com.jetbrains.rdserver.permissions.ClientPermissionManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/cwm/plugin/permissions/GuestIdePermissionManager;", "Lcom/intellij/platform/ide/core/permissions/impl/IdePermissionManager;", "<init>", "()V", "isGranted", "", "permission", "Lcom/intellij/platform/ide/core/permissions/impl/IdePermission;", "Companion", "intellij.cwm.plugin"})
@SourceDebugExtension(value={"SMAP\nGuestIdePermissionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuestIdePermissionManager.kt\ncom/intellij/cwm/plugin/permissions/GuestIdePermissionManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,34:1\n13#2:35\n*S KotlinDebug\n*F\n+ 1 GuestIdePermissionManager.kt\ncom/intellij/cwm/plugin/permissions/GuestIdePermissionManager\n*L\n32#1:35\n*E\n"})
public final class GuestIdePermissionManager
implements IdePermissionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    public boolean isGranted(@NotNull IdePermission permission) {
        boolean bl;
        AccessLevelMarker level;
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        ClientPermissionManager manager = ClientPermissionManager.Companion.getInstance(ClientSessionsUtil.getCurrentSession((Application)ApplicationKt.getApplication()));
        AccessLevelMarker accessLevelMarker = level = UtilKt.toLevel((IdePermission)permission);
        if (accessLevelMarker instanceof TerminalAccessLevel) {
            bl = manager.getTerminalAccess().compareTo((Enum)level) >= 0;
        } else if (accessLevelMarker instanceof RunAccessLevel) {
            bl = manager.getRunAccess().compareTo((Enum)level) >= 0;
        } else if (accessLevelMarker instanceof ToolWindowAccessLevel) {
            bl = manager.getToolWindowAccess().compareTo((Enum)level) >= 0;
        } else if (accessLevelMarker instanceof FileAccessLevel) {
            bl = manager.getFileAccess().compareTo((Enum)level) >= 0;
        } else {
            logger.warn("Trying to check unknown IdePermission: " + permission);
            bl = false;
        }
        return bl;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GuestIdePermissionManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        GuestIdePermissionManager.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/cwm/plugin/permissions/GuestIdePermissionManager$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.cwm.plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

