/*
 * Decompiled with CFR 0.152.
 */
package com.dmarcotte.handlebars.inspections;

import com.dmarcotte.handlebars.HbBundle;
import com.dmarcotte.handlebars.inspections.HbBlockMismatchFix;
import com.dmarcotte.handlebars.psi.HbCloseBlockMustache;
import com.dmarcotte.handlebars.psi.HbMustacheName;
import com.dmarcotte.handlebars.psi.HbOpenBlockMustache;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public final class HbBlockMismatchAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        String closeBlockName;
        String openBlockName;
        HbMustacheName closeBlockMustacheName;
        if (element == null) {
            HbBlockMismatchAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            HbBlockMismatchAnnotator.$$$reportNull$$$0(1);
        }
        if (element instanceof HbOpenBlockMustache) {
            HbOpenBlockMustache openBlockMustache = (HbOpenBlockMustache)element;
            HbMustacheName openBlockMustacheName = openBlockMustache.getBlockMustacheName();
            HbCloseBlockMustache closeBlockMustache = openBlockMustache.getPairedElement();
            if (closeBlockMustache != null) {
                closeBlockMustacheName = closeBlockMustache.getBlockMustacheName();
                if (openBlockMustacheName != null && closeBlockMustacheName != null && !(openBlockName = openBlockMustacheName.getName()).equals(closeBlockName = closeBlockMustacheName.getName())) {
                    holder.newAnnotation(HighlightSeverity.ERROR, HbBundle.message("hb.block.mismatch.inspection.open.block", openBlockName, closeBlockName)).range((PsiElement)openBlockMustacheName).withFix((IntentionAction)new HbBlockMismatchFix(closeBlockName, openBlockName, true)).withFix((IntentionAction)new HbBlockMismatchFix(openBlockName, closeBlockName, false)).create();
                }
            } else if (openBlockMustacheName != null) {
                holder.newAnnotation(HighlightSeverity.ERROR, HbBundle.message("hb.block.mismatch.inspection.missing.end.block", openBlockMustache.getName())).range((PsiElement)openBlockMustacheName).create();
            }
        }
        if (element instanceof HbCloseBlockMustache) {
            HbCloseBlockMustache closeBlockMustache = (HbCloseBlockMustache)element;
            HbOpenBlockMustache openBlockMustache = closeBlockMustache.getPairedElement();
            if (openBlockMustache == null) {
                HbMustacheName closeBlockMustacheName2 = closeBlockMustache.getBlockMustacheName();
                if (closeBlockMustacheName2 != null) {
                    holder.newAnnotation(HighlightSeverity.ERROR, HbBundle.message("hb.block.mismatch.inspection.missing.start.block", closeBlockMustache.getName())).range((PsiElement)closeBlockMustacheName2).create();
                }
            } else {
                HbMustacheName openBlockMustacheName = openBlockMustache.getBlockMustacheName();
                closeBlockMustacheName = closeBlockMustache.getBlockMustacheName();
                if (closeBlockMustacheName != null && openBlockMustacheName != null && !(openBlockName = openBlockMustacheName.getName()).equals(closeBlockName = closeBlockMustacheName.getName())) {
                    holder.newAnnotation(HighlightSeverity.ERROR, HbBundle.message("hb.block.mismatch.inspection.close.block", openBlockName, closeBlockName)).range((PsiElement)closeBlockMustacheName).withFix((IntentionAction)new HbBlockMismatchFix(openBlockName, closeBlockName, false)).withFix((IntentionAction)new HbBlockMismatchFix(closeBlockName, openBlockName, true)).create();
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/dmarcotte/handlebars/inspections/HbBlockMismatchAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

