/*
 * Decompiled with CFR 0.152.
 */
package com.dmarcotte.handlebars.inspections;

import com.dmarcotte.handlebars.HbBundle;
import com.dmarcotte.handlebars.psi.HbBlockMustache;
import com.dmarcotte.handlebars.psi.HbOpenBlockMustache;
import com.dmarcotte.handlebars.psi.HbPath;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class HbBlockMismatchFix
implements IntentionAction {
    private final boolean myUpdateOpenMustache;
    private final String myCorrectedName;
    private final String myOriginalName;

    HbBlockMismatchFix(String correctedName, String originalName, boolean updateOpenMustache) {
        this.myUpdateOpenMustache = updateOpenMustache;
        this.myCorrectedName = correctedName;
        this.myOriginalName = originalName;
    }

    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            HbBlockMismatchFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            HbBlockMismatchFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            HbBlockMismatchFix.$$$reportNull$$$0(2);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        HbBlockMustache blockMustache;
        int offset;
        PsiElement psiElement;
        if (project == null) {
            HbBlockMismatchFix.$$$reportNull$$$0(3);
        }
        if ((psiElement = psiFile.findElementAt(offset = editor.getCaretModel().getOffset())) == null) {
            return;
        }
        if (psiElement instanceof PsiWhiteSpace) {
            psiElement = PsiTreeUtil.prevLeaf((PsiElement)psiElement);
        }
        if ((blockMustache = (HbBlockMustache)PsiTreeUtil.findFirstParent((PsiElement)psiElement, (boolean)true, psiElement1 -> psiElement1 instanceof HbBlockMustache)) == null) {
            return;
        }
        HbBlockMustache targetBlockMustache = blockMustache;
        if (this.myUpdateOpenMustache != targetBlockMustache instanceof HbOpenBlockMustache) {
            targetBlockMustache = blockMustache.getPairedElement();
        }
        HbPath path = (HbPath)PsiTreeUtil.findChildOfType((PsiElement)targetBlockMustache, HbPath.class);
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        if (path != null && document != null) {
            TextRange textRange = path.getTextRange();
            document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)this.myCorrectedName);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nls
    private String getName() {
        return this.myUpdateOpenMustache ? HbBundle.message("hb.block.mismatch.intention.rename.open", this.myOriginalName, this.myCorrectedName) : HbBundle.message("hb.block.mismatch.intention.rename.close", this.myOriginalName, this.myCorrectedName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/dmarcotte/handlebars/inspections/HbBlockMismatchFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/dmarcotte/handlebars/inspections/HbBlockMismatchFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

