/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.resolve;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssCustomPropertyAtRule;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.impl.stubs.index.CssCustomPropertyAtRuleIndex;
import com.intellij.psi.css.impl.stubs.index.CssCustomPropertyIndex;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class CssCustomPropertyReference
extends PsiPolyVariantReferenceBase<PsiElement> {
    public CssCustomPropertyReference(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            CssCustomPropertyReference.$$$reportNull$$$0(0);
        }
        super(psiElement);
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        return CssCustomPropertyReference.multiResolve(this.getElement(), this.getCanonicalText());
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            CssCustomPropertyReference.$$$reportNull$$$0(1);
        }
        return super.handleElementRename((String)(newElementName.startsWith("--") ? newElementName : "--" + newElementName));
    }

    public static ResolveResult @NotNull [] multiResolve(@NotNull PsiElement element, @NotNull String propertyName) {
        if (element == null) {
            CssCustomPropertyReference.$$$reportNull$$$0(2);
        }
        if (propertyName == null) {
            CssCustomPropertyReference.$$$reportNull$$$0(3);
        }
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement(element);
        Project project = element.getProject();
        ResolveResult[] customPropertyResult = PsiElementResolveResult.createResults((Collection)StubIndex.getElements(CssCustomPropertyIndex.KEY, (Object)propertyName, (Project)project, (GlobalSearchScope)scope, CssDeclaration.class));
        ResolveResult[] customPropertyAtRuleResult = PsiElementResolveResult.createResults((Collection)StubIndex.getElements(CssCustomPropertyAtRuleIndex.Companion.getKEY(), (Object)propertyName, (Project)project, (GlobalSearchScope)scope, CssCustomPropertyAtRule.class));
        ArrayList<ResolveResult> resultList = new ArrayList<ResolveResult>(Arrays.asList(customPropertyResult));
        resultList.addAll(Arrays.asList(customPropertyAtRuleResult));
        PsiFile containingFile = element.getContainingFile();
        if (InjectedLanguageManager.getInstance((Project)project).isInjectedFragment(containingFile)) {
            for (CssDeclaration declaration : PsiTreeUtil.findChildrenOfType((PsiElement)containingFile, CssDeclaration.class)) {
                if (!declaration.isCustomProperty() || !propertyName.equals(declaration.getPropertyName())) continue;
                resultList.add((ResolveResult)new PsiElementResolveResult((PsiElement)declaration));
            }
            for (CssCustomPropertyAtRule atRule : PsiTreeUtil.findChildrenOfType((PsiElement)containingFile, CssCustomPropertyAtRule.class)) {
                if (!propertyName.equals(atRule.getName())) continue;
                resultList.add((ResolveResult)new PsiElementResolveResult((PsiElement)atRule));
            }
        }
        ResolveResult[] resolveResultArray = resultList.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            CssCustomPropertyReference.$$$reportNull$$$0(4);
        }
        return resolveResultArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/resolve/CssCustomPropertyReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/resolve/CssCustomPropertyReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "multiResolve";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

