/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.h2.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.IntrospectionQueryContext;
import com.intellij.database.dialects.base.introspector.NameCache;
import com.intellij.database.dialects.h2.introspector.H2IntroQueries;
import com.intellij.database.dialects.h2.introspector.H2IntrospectorKt;
import com.intellij.database.dialects.h2.model.H2Aggregate;
import com.intellij.database.dialects.h2.model.H2Argument;
import com.intellij.database.dialects.h2.model.H2Check;
import com.intellij.database.dialects.h2.model.H2Constant;
import com.intellij.database.dialects.h2.model.H2Constraint;
import com.intellij.database.dialects.h2.model.H2Database;
import com.intellij.database.dialects.h2.model.H2Domain;
import com.intellij.database.dialects.h2.model.H2DomainCheck;
import com.intellij.database.dialects.h2.model.H2ForeignKey;
import com.intellij.database.dialects.h2.model.H2Index;
import com.intellij.database.dialects.h2.model.H2LikeRoutine;
import com.intellij.database.dialects.h2.model.H2LikeTable;
import com.intellij.database.dialects.h2.model.H2Role;
import com.intellij.database.dialects.h2.model.H2Root;
import com.intellij.database.dialects.h2.model.H2Routine;
import com.intellij.database.dialects.h2.model.H2Schema;
import com.intellij.database.dialects.h2.model.H2Sequence;
import com.intellij.database.dialects.h2.model.H2Synonym;
import com.intellij.database.dialects.h2.model.H2Table;
import com.intellij.database.dialects.h2.model.H2TableColumn;
import com.intellij.database.dialects.h2.model.H2Trigger;
import com.intellij.database.dialects.h2.model.H2User;
import com.intellij.database.dialects.h2.model.H2View;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicColumniation;
import com.intellij.database.model.basic.BasicDataObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModMixinElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModTableOrViewColumn;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.ColumnKind;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.Level;
import com.intellij.database.model.properties.references.BasicInlineObjectReference;
import com.intellij.database.model.properties.references.BasicKeyByIndexReference;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.model.properties.references.BasicParentReference;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeSystems;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.Version;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.h2.H2Dialect;
import com.intellij.sql.dialects.h2.H2Lexer;
import com.intellij.sql.dialects.h2.psi.H2OnUpdateClause;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifierKeywordTokenType;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlColumnGeneratedClause;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.StringKt;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0004./01B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ&\u0010\u000b\u001a \u0012\u0002\b\u0003\u0012\u0002\b\u00030\fR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001H\u0014J4\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u00030\u000eR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0014J4\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u00040\u0013R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0004H\u0014J\u0014\u0010\u0016\u001a\u00020\u0017*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0014\u0010\u0019\u001a\u00020\u0017*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J*\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0017H\u0002J\u000e\u0010!\u001a\u0004\u0018\u00010\u001d*\u00020\"H\u0002J\"\u0010#\u001a\u00020\u001b2\b\u0010$\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0017H\u0002R\u0014\u0010%\u001a\u00020&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010'R\u0014\u0010(\u001a\u00020&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010'R\u0014\u0010)\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2Introspector;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/dialects/h2/model/H2Root;", "Lcom/intellij/database/dialects/h2/model/H2Database;", "Lcom/intellij/database/dialects/h2/model/H2Schema;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "<init>", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/model/ModelFactory;)V", "createDatabaseLister", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$DatabaseLister;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "createSchemaRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "schema", "maskDefaultPrecision", "", "default", "maskDefaultScale", "getIntervalDasType", "Lcom/intellij/database/types/DasType;", "primary", "Lcom/intellij/database/dialects/h2/introspector/H2Introspector$Interval;", "secondary", "precision", "scale", "toIntervalKind", "", "getDasType", "typeName", "isV2", "", "()Z", "isNewSchema", "defaultVarDataMaxLength", "getDefaultVarDataMaxLength", "()I", "typeSystem", "Lcom/intellij/database/types/DasTypeSystemBase;", "Factory", "H2DatabaseBaseDatabaseRetriever", "H2SchemaAbstractSchemaRetriever", "Interval", "intellij.database.dialects.h2"})
public final class H2Introspector
extends BaseMultiDatabaseIntrospector<H2Root, H2Database, H2Schema> {
    @NotNull
    private final DasTypeSystemBase typeSystem;

    public H2Introspector(@NotNull DBIntrospectionContext context, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        BaseIntrospector.Nature nature = (BaseIntrospector.Nature)BaseIntrospector.DefaultNature.INSTANCE;
        Dbms dbms = Dbms.H2;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"H2");
        super(context, nature, dbms, modelFactory);
        this.typeSystem = DasTypeSystems.getTypeSystem((Dbms)this.dbms);
    }

    @NotNull
    protected BaseMultiDatabaseIntrospector.DatabaseLister<?, ?> createDatabaseLister() {
        return (BaseMultiDatabaseIntrospector.DatabaseLister)new BaseMultiDatabaseIntrospector.DatabaseLister<H2IntroQueries.DbInfo, H2Database>(this){
            final /* synthetic */ H2Introspector this$0;
            {
                this.this$0 = $receiver;
                super((BaseMultiDatabaseIntrospector)$receiver);
            }

            protected List<H2IntroQueries.DbInfo> listDatabases(DBTransaction tran) {
                Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
                return H2IntroQueries.INSTANCE.retrieveDatabases(tran, H2Introspector.access$isNewSchema(this.this$0));
            }

            protected H2Database applyDatabase(ModNamingFamily<?> databases, H2IntroQueries.DbInfo db) {
                Intrinsics.checkNotNullParameter(databases, (String)"databases");
                Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                return (H2Database)this.renew(databases, db.catalog_name);
            }
        };
    }

    @NotNull
    protected BaseMultiDatabaseIntrospector.BaseDatabaseRetriever<H2Database> createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull H2Database database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new H2DatabaseBaseDatabaseRetriever(transaction, database);
    }

    @NotNull
    protected BaseNativeIntrospector.AbstractSchemaRetriever<H2Schema> createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull H2Schema schema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return new H2SchemaAbstractSchemaRetriever(transaction, schema);
    }

    private final int maskDefaultPrecision(int $this$maskDefaultPrecision, int n) {
        return $this$maskDefaultPrecision != n ? $this$maskDefaultPrecision : -1;
    }

    private final int maskDefaultScale(int $this$maskDefaultScale, int n) {
        return $this$maskDefaultScale != n ? $this$maskDefaultScale : 0;
    }

    private final DasType getIntervalDasType(Interval primary, Interval secondary, int precision, int scale) {
        StringBuilder stringBuilder;
        int actualScale = (primary == Interval.SECOND || secondary == Interval.SECOND) && scale != 6 ? scale : 0;
        int actualPrecision = precision != 2 || actualScale != 0 && secondary == null ? precision : 0;
        StringBuilder $this$getIntervalDasType_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getIntervalDasType_u24lambda_u240.append("INTERVAL " + primary.name());
        if (actualPrecision != 0) {
            $this$getIntervalDasType_u24lambda_u240.append("(" + actualPrecision);
            if (actualScale != 0 && secondary == null) {
                $this$getIntervalDasType_u24lambda_u240.append(", " + actualScale);
            }
            $this$getIntervalDasType_u24lambda_u240.append(")");
        }
        if (secondary != null) {
            $this$getIntervalDasType_u24lambda_u240.append(" TO " + secondary.name());
            if (actualScale != 0) {
                $this$getIntervalDasType_u24lambda_u240.append("(" + actualScale + ")");
            }
        }
        String spec = stringBuilder.toString();
        DataType dataType = DataTypeFactory.of((String)spec);
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
        DataType dataType2 = dataType;
        return this.typeSystem.createDasType(dataType2);
    }

    private final Interval toIntervalKind(String $this$toIntervalKind) {
        Interval interval;
        try {
            interval = Interval.valueOf($this$toIntervalKind);
        }
        catch (Exception e) {
            interval = null;
        }
        return interval;
    }

    private final DasType getDasType(String typeName, int precision, int scale) {
        CharSequence charSequence = typeName;
        if (charSequence == null || charSequence.length() == 0) {
            return (DasType)DasTypeSystemBase.UNKNOWN;
        }
        if (StringsKt.startsWith$default((String)typeName, (String)"INTERVAL", (boolean)false, (int)2, null)) {
            char[] cArray = new char[]{' '};
            List components = StringsKt.split$default((CharSequence)typeName, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            Object object = (String)CollectionsKt.getOrNull((List)components, (int)1);
            if (object == null || (object = this.toIntervalKind((String)object)) == null) {
                return (DasType)DasTypeSystemBase.UNKNOWN;
            }
            Object primaryKind = object;
            String string = (String)CollectionsKt.getOrNull((List)components, (int)3);
            Interval secondaryKind = string != null ? this.toIntervalKind(string) : null;
            return this.getIntervalDasType((Interval)((Object)primaryKind), secondaryKind, precision, scale);
        }
        int[] primaryKind = new int[]{1, 4, 197};
        int timestampDefaultPrecision = this.getServerVersion().isOrGreater(primaryKind) ? 6 : 10;
        int actualPrecision = 0;
        int actualScale = 0;
        String suffix = "";
        String actualTypeName = typeName;
        switch (typeName) {
            case "DECIMAL": 
            case "NUMBER": 
            case "NUMERIC": 
            case "DEC": {
                if (this.isV2()) {
                    actualScale = this.maskDefaultScale(scale, 0);
                    actualPrecision = actualScale != 0 ? precision : this.maskDefaultPrecision(precision, 100000);
                    break;
                }
                actualScale = this.maskDefaultScale(scale, Short.MAX_VALUE);
                actualPrecision = actualScale != 0 ? precision : this.maskDefaultPrecision(precision, 65535);
                break;
            }
            case "DECFLOAT": {
                actualPrecision = this.maskDefaultPrecision(precision, 100000);
                break;
            }
            case "TIME": {
                actualPrecision = this.maskDefaultPrecision(this.isV2() ? precision : scale, 0);
                break;
            }
            case "TIMESTAMP": 
            case "DATETIME": {
                actualPrecision = this.maskDefaultPrecision(this.isV2() ? precision : scale, timestampDefaultPrecision);
                break;
            }
            case "TIMESTAMP WITH TIME ZONE": {
                actualPrecision = this.maskDefaultPrecision(this.isV2() ? precision : scale, timestampDefaultPrecision);
                actualTypeName = "TIMESTAMP";
                suffix = "WITH TIME ZONE";
                break;
            }
            case "TIME WITH TIME ZONE": {
                actualPrecision = this.maskDefaultPrecision(this.isV2() ? precision : scale, 0);
                actualTypeName = "TIME";
                suffix = "WITH TIME ZONE";
                break;
            }
            case "DOUBLE PRECISION": 
            case "DOUBLE": 
            case "TINYINT": 
            case "INTEGER": 
            case "NULL": 
            case "BIGINT": 
            case "BOOLEAN": 
            case "DATE": 
            case "SMALLINT": 
            case "REAL": {
                actualPrecision = -1;
                break;
            }
            case "VARCHAR_IGNORECASE": 
            case "JSON": 
            case "BINARY VARYING": 
            case "JAVA_OBJECT": 
            case "CHARACTER VARYING": {
                actualPrecision = this.maskDefaultPrecision(precision, this.getDefaultVarDataMaxLength());
                break;
            }
            case "CHARACTER": {
                actualPrecision = this.maskDefaultPrecision(precision, 1);
                break;
            }
            case "BLOB": 
            case "CHAR": 
            case "BINARY LARGE OBJECT": 
            case "CLOB": 
            case "CHARACTER LARGE OBJECT": 
            case "VARCHAR": {
                actualPrecision = this.maskDefaultPrecision(precision, Integer.MAX_VALUE);
                break;
            }
            default: {
                actualPrecision = this.maskDefaultPrecision(precision, 0);
            }
        }
        DataType dataType = DataTypeFactory.of(null, (String)actualTypeName, (int)actualPrecision, (int)actualScale, null, (String)suffix, (boolean)false, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
        DataType dataType2 = dataType;
        return this.typeSystem.createDasType(dataType2);
    }

    private final boolean isV2() {
        int[] nArray = new int[]{2};
        return this.getServerVersion().isOrGreater(nArray);
    }

    private final boolean isNewSchema() {
        Object object;
        return this.isV2() && !Intrinsics.areEqual((object = this.getDbConnection()) != null && (object = object.getConnectionPoint()) != null && (object = object.getConnectionProperties()) != null ? ((Properties)object).getProperty("OLD_INFORMATION_SCHEMA") : null, (Object)"true");
    }

    private final int getDefaultVarDataMaxLength() {
        int[] nArray = new int[]{2, 2};
        return this.getServerVersion().isOrGreater(nArray) ? 1000000000 : 0x100000;
    }

    public static final /* synthetic */ int access$maskDefaultPrecision(H2Introspector $this, int $receiver, int n) {
        return $this.maskDefaultPrecision($receiver, n);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2Introspector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "<init>", "()V", "isSupported", "", "version", "Lcom/intellij/database/util/Version;", "createIntrospector", "Lcom/intellij/database/dialects/h2/introspector/H2Introspector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "e", "Lcom/intellij/database/model/basic/BasicElement;", "VERSION", "intellij.database.dialects.h2"})
    public static final class Factory
    implements DBIntrospector.Factory {
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            int[] nArray = new int[]{1, 4, 196};
            return version.isOrGreater(nArray);
        }

        @NotNull
        public H2Introspector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return new H2Introspector(context, modelFactory);
        }

        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        public boolean isOutdatedCheckSupported(@Nullable BasicElement e) {
            return false;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2Introspector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "<init>", "()V", "intellij.database.dialects.h2"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE = new VERSION();

            private VERSION() {
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0003B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2Introspector$H2DatabaseBaseDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/dialects/h2/model/H2Database;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/dialects/h2/model/H2Root;", "Lcom/intellij/database/dialects/h2/model/H2Schema;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "<init>", "(Lcom/intellij/database/dialects/h2/introspector/H2Introspector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/h2/model/H2Database;)V", "retrieveSchemas", "", "retrieveAuxiliaryObjects", "retrieveUsers", "db", "retrieveRoles", "retrieveCollations", "intellij.database.dialects.h2"})
    @SourceDebugExtension(value={"SMAP\nH2Introspector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 H2Introspector.kt\ncom/intellij/database/dialects/h2/introspector/H2Introspector$H2DatabaseBaseDatabaseRetriever\n+ 2 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 3 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ModelFun.kt\ncom/intellij/database/model/ModelFun\n*L\n1#1,1066:1\n190#2,4:1067\n194#2,3:1090\n190#2,4:1093\n194#2,3:1116\n190#2,4:1119\n194#2,3:1143\n567#3:1071\n548#3,18:1072\n567#3:1097\n548#3,18:1098\n567#3:1123\n548#3,2:1124\n551#3,15:1128\n1915#4,2:1126\n1915#4:1148\n1916#4:1151\n512#5,2:1146\n514#5,2:1149\n516#5,3:1152\n*S KotlinDebug\n*F\n+ 1 H2Introspector.kt\ncom/intellij/database/dialects/h2/introspector/H2Introspector$H2DatabaseBaseDatabaseRetriever\n*L\n141#1:1067,4\n141#1:1090,3\n155#1:1093,4\n155#1:1116,3\n168#1:1119,4\n168#1:1143,3\n142#1:1071\n142#1:1072,18\n156#1:1097\n156#1:1098,18\n169#1:1123\n169#1:1124,2\n169#1:1128,15\n170#1:1126,2\n121#1:1148\n121#1:1151\n121#1:1146,2\n121#1:1149,2\n121#1:1152,3\n*E\n"})
    private final class H2DatabaseBaseDatabaseRetriever
    extends BaseMultiDatabaseIntrospector.BaseDatabaseRetriever<H2Database> {
        public H2DatabaseBaseDatabaseRetriever(@NotNull DBTransaction transaction, H2Database database) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            super((BaseMultiDatabaseIntrospector)H2Introspector.this, transaction, (BasicModMateDatabase)database);
        }

        public void retrieveSchemas() {
            super.retrieveSchemas();
            List<H2IntroQueries.SchemaInfo> schemaInfos = H2IntroQueries.INSTANCE.retrieveSchemas(this.getTransaction(), H2Introspector.this.isNewSchema());
            this.inDatabase(arg_0 -> H2DatabaseBaseDatabaseRetriever.retrieveSchemas$lambda$0(schemaInfos, arg_0));
        }

        public void retrieveAuxiliaryObjects() {
            super.retrieveAuxiliaryObjects();
            this.inDatabase(arg_0 -> H2DatabaseBaseDatabaseRetriever.retrieveAuxiliaryObjects$lambda$0(this, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveUsers(H2Database db) {
            void $this$modifyAndCleanup_u24default$iv;
            ObjectKind objectKind = ObjectKind.USER;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"USER");
            H2Introspector.this.reportRetrieving(objectKind);
            ModFamily modFamily = (ModFamily)db.getUsers();
            H2Introspector h2Introspector = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily users = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)h2Introspector;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                H2IntroQueries.INSTANCE.processUsers(this.getTransaction(), h2Introspector.isNewSchema(), (Function1<? super H2IntroQueries.UserInfo, Unit>)((Function1)arg_0 -> H2DatabaseBaseDatabaseRetriever.retrieveUsers$lambda$0$0$0(users, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveRoles(H2Database db) {
            void $this$modifyAndCleanup_u24default$iv;
            ObjectKind objectKind = ObjectKind.ROLE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ROLE");
            H2Introspector.this.reportRetrieving(objectKind);
            ModFamily modFamily = (ModFamily)db.getRoles();
            H2Introspector h2Introspector = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily roles = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)h2Introspector;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                H2IntroQueries.INSTANCE.processRoles(this.getTransaction(), h2Introspector.isNewSchema(), (Function1<? super H2IntroQueries.RoleInfo, Unit>)((Function1)arg_0 -> H2DatabaseBaseDatabaseRetriever.retrieveRoles$lambda$0$0$0(roles, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveCollations(H2Database db) {
            void $this$modifyAndCleanup_u24default$iv;
            ObjectKind objectKind = ObjectKind.COLLATION;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLLATION");
            H2Introspector.this.reportRetrieving(objectKind);
            ModFamily modFamily = (ModFamily)db.getCollations();
            H2Introspector h2Introspector = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily collations = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)h2Introspector;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                Iterable $this$forEach$iv = H2IntroQueries.INSTANCE.retrieveCollations(this.getTransaction(), h2Introspector.isNewSchema());
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    collations.createOrGet(it);
                }
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl4 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveSchemas$lambda$0(List $schemaInfos, H2Database db) {
            void $this$applySchemasImpl$iv;
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            ModNamingFamily<? extends H2Schema> modNamingFamily = db.getSchemas();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getSchemas(...)");
            ModNamingFamily<? extends H2Schema> modNamingFamily2 = modNamingFamily;
            List scs$iv = $schemaInfos;
            boolean $i$f$applySchemasImpl = false;
            $this$applySchemasImpl$iv.markChildrenAsSyncPending();
            Iterable $this$forEach$iv$iv = scs$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                void info;
                Object element$iv$iv;
                Object sc$iv = element$iv$iv = iterator.next();
                boolean bl = false;
                H2IntroQueries.SchemaInfo schemaInfo = (H2IntroQueries.SchemaInfo)sc$iv;
                void $this$retrieveSchemas_u24lambda_u240_u240 = $this$applySchemasImpl$iv;
                boolean bl2 = false;
                BasicModNamedElement basicModNamedElement = db.getSchemas().createOrGet(info.schema_name);
                H2Schema $this$retrieveSchemas_u24lambda_u240_u240_u240 = (H2Schema)basicModNamedElement;
                boolean bl3 = false;
                $this$retrieveSchemas_u24lambda_u240_u240_u240.setComment(info.remarks);
                $this$retrieveSchemas_u24lambda_u240_u240_u240.setCurrent(info.is_default);
            }
            $this$applySchemasImpl$iv.removeSyncPendingChildren();
            $this$applySchemasImpl$iv.sort();
            return Unit.INSTANCE;
        }

        private static final Unit retrieveAuxiliaryObjects$lambda$0(H2DatabaseBaseDatabaseRetriever this$0, H2Database db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            this$0.retrieveUsers(db);
            this$0.retrieveRoles(db);
            this$0.retrieveCollations(db);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveUsers$lambda$0$0$0(ModNamingFamily $users, H2IntroQueries.UserInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            BasicModNamedElement basicModNamedElement = $users.createOrGet(info.name);
            H2User $this$retrieveUsers_u24lambda_u240_u240_u240_u240 = (H2User)basicModNamedElement;
            boolean bl = false;
            $this$retrieveUsers_u24lambda_u240_u240_u240_u240.setAdmin(info.is_admin);
            $this$retrieveUsers_u24lambda_u240_u240_u240_u240.setComment(info.remarks);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveRoles$lambda$0$0$0(ModNamingFamily $roles, H2IntroQueries.RoleInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            BasicModNamedElement basicModNamedElement = $roles.createOrGet(info.name);
            H2Role $this$retrieveRoles_u24lambda_u240_u240_u240_u240 = (H2Role)basicModNamedElement;
            boolean bl = false;
            $this$retrieveRoles_u24lambda_u240_u240_u240_u240.setComment(info.remarks);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0003B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\f\u0010\u001c\u001a\u00020\u001d*\u00020\rH\u0002J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\rH\u0002JC\u0010(\u001a\n **\u0004\u0018\u0001H)H)\"\b\b\u0000\u0010)*\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H)0-2\u0006\u0010.\u001a\u00020\r2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\r0\u000eH\u0002\u00a2\u0006\u0002\u00100J\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020\r0\u000e2\u0006\u0010'\u001a\u00020\rH\u0002J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\rH\u0002J\f\u00105\u001a\u000206*\u000207H\u0002J\u0010\u00108\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u0002H\u0002J \u00109\u001a\u00020\u001b2\b\u0010:\u001a\u0004\u0018\u00010;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=H\u0002J\u0010\u0010?\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010@\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\"\u0010A\u001a\u00020\u001b2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\b\b\u0002\u0010F\u001a\u00020\u0016H\u0002J\f\u0010G\u001a\u000206*\u00020EH\u0002J\u001a\u0010H\u001a\u0004\u0018\u00010I2\u0006\u0010J\u001a\u00020\u00162\u0006\u0010K\u001a\u000206H\u0002J\u001a\u0010L\u001a\u0004\u0018\u00010I2\u0006\u0010J\u001a\u00020\u00162\u0006\u0010K\u001a\u000206H\u0002J\u0014\u0010P\u001a\u00020Q*\u0002062\u0006\u0010R\u001a\u00020\u0016H\u0002J\u0014\u0010U\u001a\u00020Q*\u0002062\u0006\u0010R\u001a\u00020\u0016H\u0002J\u0010\u0010V\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010W\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u000e\u0010X\u001a\u0004\u0018\u00010\r*\u00020YH\u0002J\u000e\u0010Z\u001a\u0004\u0018\u00010\r*\u00020YH\u0002J\u0010\u0010[\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\\\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010]\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010^\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010_\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u0002H\u0002R6\u0010\u000b\u001a*\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u000e0\fj\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00110\fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0011`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010M\u001a\u00020I*\u0002068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bN\u0010OR\u0018\u0010S\u001a\u00020I*\u0002068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bT\u0010O\u00a8\u0006`"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2Introspector$H2SchemaAbstractSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/h2/model/H2Schema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "Lcom/intellij/database/dialects/h2/model/H2Root;", "Lcom/intellij/database/dialects/h2/model/H2Database;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "<init>", "(Lcom/intellij/database/dialects/h2/introspector/H2Introspector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/h2/model/H2Schema;)V", "enumValues", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "arrayElementTypes", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$ArrayElementInfo;", "rowFields", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$RowFieldInfo;", "isPossibleToIntrospectSchemaIncrementally", "", "tran", "level", "Lcom/intellij/database/model/properties/Level;", "retrieveMainContent", "", "toCompositeText", "Lcom/intellij/database/script/SimpleCompositeText;", "retrieveEnumValues", "retrieveArrayTypes", "retrieveRowFields", "retrieveDomains", "retrieveDomainChecks", "retrieveTables", "retrieveColumns", "retrieveConstraints", "removeParens", "s", "renewConstraint", "C", "kotlin.jvm.PlatformType", "Lcom/intellij/database/dialects/h2/model/H2Constraint;", "family", "Lcom/intellij/database/model/families/ModNamingFamily;", "constraintName", "colNames", "(Lcom/intellij/database/model/families/ModNamingFamily;Ljava/lang/String;Ljava/util/List;)Lcom/intellij/database/dialects/h2/model/H2Constraint;", "parseColumnList", "getCascadeRule", "Lcom/intellij/database/model/properties/CascadeRule;", "code", "getDasType", "Lcom/intellij/database/types/DasType;", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$TypedObjectInfo;", "retrieveIndexes", "applyIndexColumns", "index", "Lcom/intellij/database/dialects/h2/model/H2Index;", "columns", "", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$IndexColumnInfo;", "retrieveTriggers", "retrieveSequences", "processSequenceLike", "sequence", "Lcom/intellij/database/dialects/h2/model/H2Sequence;", "info", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$SequenceLikeInfo;", "isIdentity", "dasType", "sequenceUnlimitedMinimumDefault", "Ljava/math/BigInteger;", "isAsc", "type", "sequenceUnlimitedMaximumDefault", "lowerBound", "getLowerBound", "(Lcom/intellij/database/types/DasType;)Ljava/math/BigInteger;", "decimalLowerBound", "", "exclusive", "upperBound", "getUpperBound", "decimalUpperBound", "retrieveRoutines", "retrieveRoutinesV2", "javaMethodName", "Lcom/intellij/database/dialects/h2/introspector/H2IntroQueries$RoutineInfoV2;", "javaClassName", "retrieveConstants", "retrieveSynonyms", "retrieveSourcesV2", "retrieveViewSources", "retrieveTriggerSources", "intellij.database.dialects.h2"})
    @SourceDebugExtension(value={"SMAP\nH2Introspector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 H2Introspector.kt\ncom/intellij/database/dialects/h2/introspector/H2Introspector$H2SchemaAbstractSchemaRetriever\n+ 2 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 3 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/NameCache\n*L\n1#1,1066:1\n567#2:1067\n548#2,18:1068\n567#2:1086\n548#2,18:1087\n567#2:1105\n548#2,18:1106\n567#2:1128\n548#2,18:1129\n567#2:1165\n548#2,18:1166\n567#2:1197\n548#2,18:1198\n567#2:1236\n548#2,18:1237\n567#2:1278\n548#2,18:1279\n567#2:1321\n548#2,18:1322\n567#2:1371\n548#2,18:1372\n567#2:1400\n548#2,18:1401\n567#2:1432\n548#2,18:1433\n567#2:1471\n548#2,18:1472\n567#2:1503\n548#2,2:1504\n551#2,15:1510\n567#2:1545\n548#2,2:1546\n551#2,15:1550\n567#2:1575\n548#2,18:1576\n567#2:1601\n548#2,18:1602\n190#3,4:1124\n194#3,3:1147\n348#3,3:1154\n351#3:1159\n209#3,5:1160\n215#3,5:1184\n352#3:1189\n207#3,7:1190\n215#3,5:1216\n348#3,3:1225\n351#3:1230\n209#3,5:1231\n215#3,5:1255\n352#3:1260\n348#3,3:1267\n351#3:1272\n209#3,5:1273\n215#3,5:1297\n352#3:1302\n348#3,3:1310\n351#3:1315\n209#3,5:1316\n215#3,5:1340\n352#3:1345\n348#3,3:1360\n351#3:1365\n209#3,5:1366\n215#3,5:1390\n352#3:1395\n190#3,4:1396\n194#3,3:1419\n207#3,7:1425\n215#3,5:1451\n348#3,3:1460\n351#3:1465\n209#3,5:1466\n215#3,5:1490\n352#3:1495\n207#3,7:1496\n215#3,5:1525\n348#3,3:1534\n351#3:1539\n209#3,5:1540\n215#3,5:1565\n352#3:1570\n190#3,4:1571\n194#3,3:1594\n190#3,4:1597\n194#3,3:1620\n1586#4:1150\n1661#4,3:1151\n1586#4:1221\n1661#4,3:1222\n1391#4:1261\n1480#4,5:1262\n1924#4,3:1303\n1586#4:1306\n1661#4,3:1307\n1586#4:1346\n1661#4,3:1347\n1651#4:1350\n1915#4:1351\n1916#4:1354\n1652#4:1355\n1586#4:1356\n1661#4,3:1357\n1849#4,3:1422\n1586#4:1456\n1661#4,3:1457\n1915#4,2:1506\n1915#4,2:1508\n1586#4:1530\n1661#4,3:1531\n1915#4,2:1548\n296#4,2:1635\n37#5,2:1157\n37#5,2:1228\n37#5,2:1270\n37#5,2:1313\n37#5,2:1363\n37#5,2:1463\n37#5,2:1537\n1#6:1352\n1#6:1353\n453#7,6:1623\n453#7,6:1629\n453#7,6:1637\n453#7,6:1643\n453#7,6:1649\n453#7,6:1655\n453#7,6:1661\n*S KotlinDebug\n*F\n+ 1 H2Introspector.kt\ncom/intellij/database/dialects/h2/introspector/H2Introspector$H2SchemaAbstractSchemaRetriever\n*L\n228#1:1067\n228#1:1068,18\n237#1:1086\n237#1:1087,18\n246#1:1105\n246#1:1106,18\n256#1:1128\n256#1:1129,18\n273#1:1165\n273#1:1166,18\n289#1:1197\n289#1:1198,18\n309#1:1236\n309#1:1237,18\n366#1:1278\n366#1:1279,18\n573#1:1321\n573#1:1322,18\n614#1:1371\n614#1:1372,18\n632#1:1400\n632#1:1401,18\n729#1:1432\n729#1:1433,18\n761#1:1471\n761#1:1472,18\n781#1:1503\n781#1:1504,2\n781#1:1510,15\n817#1:1545\n817#1:1546,2\n817#1:1550,15\n846#1:1575\n846#1:1576,18\n864#1:1601\n864#1:1602,18\n255#1:1124,4\n255#1:1147,3\n272#1:1154,3\n272#1:1159\n272#1:1160,5\n272#1:1184,5\n272#1:1189\n288#1:1190,7\n288#1:1216,5\n308#1:1225,3\n308#1:1230\n308#1:1231,5\n308#1:1255,5\n308#1:1260\n365#1:1267,3\n365#1:1272\n365#1:1273,5\n365#1:1297,5\n365#1:1302\n572#1:1310,3\n572#1:1315\n572#1:1316,5\n572#1:1340,5\n572#1:1345\n613#1:1360,3\n613#1:1365\n613#1:1366,5\n613#1:1390,5\n613#1:1395\n631#1:1396,4\n631#1:1419,3\n728#1:1425,7\n728#1:1451,5\n760#1:1460,3\n760#1:1465\n760#1:1466,5\n760#1:1490,5\n760#1:1495\n780#1:1496,7\n780#1:1525,5\n816#1:1534,3\n816#1:1539\n816#1:1540,5\n816#1:1565,5\n816#1:1570\n845#1:1571,4\n845#1:1594,3\n863#1:1597,4\n863#1:1620,3\n272#1:1150\n272#1:1151,3\n308#1:1221\n308#1:1222,3\n364#1:1261\n364#1:1262,5\n556#1:1303,3\n572#1:1306\n572#1:1307,3\n604#1:1346\n604#1:1347,3\n605#1:1350\n605#1:1351\n605#1:1354\n605#1:1355\n613#1:1356\n613#1:1357,3\n715#1:1422,3\n760#1:1456\n760#1:1457,3\n782#1:1506,2\n783#1:1508,2\n816#1:1530\n816#1:1531,3\n826#1:1548,2\n338#1:1635,2\n272#1:1157,2\n308#1:1228,2\n365#1:1270,2\n572#1:1313,2\n613#1:1363,2\n760#1:1463,2\n816#1:1537,2\n605#1:1353\n276#1:1623,6\n312#1:1629,6\n370#1:1637,6\n576#1:1643,6\n586#1:1649,6\n591#1:1655,6\n616#1:1661,6\n*E\n"})
    private final class H2SchemaAbstractSchemaRetriever
    extends BaseNativeIntrospector.AbstractSchemaRetriever<H2Schema> {
        @NotNull
        private final HashMap<String, List<String>> enumValues;
        @NotNull
        private final HashMap<String, H2IntroQueries.ArrayElementInfo> arrayElementTypes;
        @NotNull
        private final MultiMap<String, H2IntroQueries.RowFieldInfo> rowFields;

        public H2SchemaAbstractSchemaRetriever(@NotNull DBTransaction transaction, H2Schema schema) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super((BaseNativeIntrospector)H2Introspector.this, transaction, (BasicModSchema)schema);
            this.enumValues = new HashMap();
            this.arrayElementTypes = new HashMap();
            this.rowFields = new MultiMap();
        }

        protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull H2Schema schema, @NotNull Level level) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            return true;
        }

        protected void retrieveMainContent() {
            this.inSchema(arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveMainContent$lambda$0(H2Introspector.this, this, arg_0));
        }

        private final SimpleCompositeText toCompositeText(String $this$toCompositeText) {
            return BaseIntrospectionFunctions.toCompositeText((String)((Object)StringsKt.trim((CharSequence)$this$toCompositeText)).toString(), (CompositeText.Kind)CompositeText.Kind.DECOMPILED_TEXT);
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveEnumValues(H2Schema schema) {
            H2Introspector.this.reportRetrieving("enum values", "introspection.retrieve.enums");
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)H2Introspector.this;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl = false;
                H2IntroQueries.INSTANCE.processEnumValues(this.getTransaction(), schema, (Function1<? super H2IntroQueries.EnumValueInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveEnumValues$lambda$0$0(this, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveArrayTypes(H2Schema schema) {
            void this_$iv;
            H2Introspector.this.reportRetrieving("array types", "introspection.retrieve.array.types");
            BaseNativeIntrospector baseNativeIntrospector = (BaseNativeIntrospector)H2Introspector.this;
            H2Introspector h2Introspector = H2Introspector.this;
            boolean $i$f$continueOnDbError = false;
            void var5_5 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl = false;
                H2IntroQueries.INSTANCE.processArrayElements(this.getTransaction(), schema, h2Introspector.isNewSchema(), (Function1<? super H2IntroQueries.ArrayElementInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveArrayTypes$lambda$0$0(this, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveRowFields(H2Schema schema) {
            void this_$iv;
            H2Introspector.this.reportRetrieving("row fields", "introspection.retrieve.row.fields");
            BaseNativeIntrospector baseNativeIntrospector = (BaseNativeIntrospector)H2Introspector.this;
            H2Introspector h2Introspector = H2Introspector.this;
            boolean $i$f$continueOnDbError = false;
            void var5_5 = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl = false;
                H2IntroQueries.INSTANCE.processRowFields(this.getTransaction(), schema, h2Introspector.isNewSchema(), (Function1<? super H2IntroQueries.RowFieldInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveRowFields$lambda$0$0(this, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveDomains(H2Schema schema) {
            void $this$modifyAndCleanup_u24default$iv;
            H2Introspector.this.reportRetrieving("domains", "introspection.retrieve.domains");
            ModFamily modFamily = (ModFamily)schema.getDomains();
            H2Introspector h2Introspector = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily domains = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)h2Introspector;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                H2IntroQueries.INSTANCE.processDomains(this.getTransaction(), schema, h2Introspector.isNewSchema(), (Function1<? super H2IntroQueries.DomainInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveDomains$lambda$0$0$0(domains, this, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveDomainChecks(H2Schema schema) {
            void families$iv$iv;
            void families$iv;
            void $this$mapTo$iv$iv;
            H2Introspector.this.reportRetrieving("domain checks", "introspection.retrieve.domain.checks");
            ModNamingFamily<? extends H2Domain> modNamingFamily = schema.getDomains();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getDomains(...)");
            Iterable $this$map$iv = (Iterable)modNamingFamily;
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                H2Domain h2Domain = (H2Domain)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getChecks());
            }
            $this$map$iv = (List)destination$iv$iv;
            object = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            ModFamily[] $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = (ModFamily[])thisCollection$iv$iv.toArray(new ModNamingFamily[0]);
            $this$toTypedArray$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean removeUnaffected$iv$iv = removeUnaffected$iv;
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)object;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                NameCache domainCache = new NameCache();
                H2IntroQueries.INSTANCE.processDomainChecks(this.getTransaction(), schema, (Function1<? super H2IntroQueries.DomainCheckInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveDomainChecks$lambda$1$0$0(domainCache, schema, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTables(H2Schema schema) {
            void families$iv;
            ObjectKind objectKind = ObjectKind.TABLE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TABLE");
            H2Introspector.this.reportRetrieving(objectKind);
            ModFamily[] modFamilyArray = new ModFamily[2];
            Intrinsics.checkNotNullExpressionValue(schema.getTables(), (String)"getTables(...)");
            Intrinsics.checkNotNullExpressionValue(schema.getViews(), (String)"getViews(...)");
            H2Introspector h2Introspector = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            for (void f$iv : families$iv) {
                f$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)h2Introspector;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                H2IntroQueries.INSTANCE.processTables(this.getTransaction(), schema, h2Introspector.isNewSchema(), (Function1<? super H2IntroQueries.TableInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveTables$lambda$0$0$0(schema, this, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            for (void f$iv : families$iv) {
                f$iv.removeSyncPendingChildren();
                f$iv.sort();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveColumns(H2Schema schema) {
            void families$iv$iv;
            void families$iv;
            H2View it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
            H2Introspector.this.reportRetrieving(objectKind);
            ModNamingFamily<? extends H2Table> modNamingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$map$iv = (Iterable)modNamingFamily;
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                H2Table h2Table = (H2Table)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getColumns());
            }
            Collection collection2 = (List)destination$iv$iv;
            ModNamingFamily<? extends H2View> modNamingFamily2 = schema.getViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getViews(...)");
            $this$map$iv = (Iterable)modNamingFamily2;
            collection = collection2;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (H2View)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                boolean bl = false;
                collection3.add(it.getColumns());
            }
            $this$map$iv = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
            object = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            ModFamily[] $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = (ModFamily[])thisCollection$iv$iv.toArray(new ModPositioningNamingFamily[0]);
            $this$toTypedArray$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean removeUnaffected$iv$iv = removeUnaffected$iv;
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)object;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                NameCache tableCache = new NameCache();
                H2IntroQueries.INSTANCE.processColumns(this.getTransaction(), schema, ((H2Introspector)((Object)object)).isNewSchema(), (Function1<? super H2IntroQueries.ColumnInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveColumns$lambda$2$0$0(tableCache, schema, this, (H2Introspector)((Object)object), arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveConstraints(H2Schema schema) {
            void families$iv$iv;
            void families$iv;
            void $this$flatMapTo$iv$iv;
            H2Introspector.this.reportRetrieving("constraints", "introspection.retrieve.constraints");
            ModNamingFamily<? extends H2Table> modNamingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$flatMap$iv = (Iterable)modNamingFamily;
            boolean $i$f$flatMap = false;
            Object object = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                H2Table t = (H2Table)element$iv$iv;
                boolean bl = false;
                Object[] objectArray = new ModNamingFamily[3];
                Intrinsics.checkNotNullExpressionValue(t.getKeys(), (String)"getKeys(...)");
                Intrinsics.checkNotNullExpressionValue(t.getForeignKeys(), (String)"getForeignKeys(...)");
                Intrinsics.checkNotNullExpressionValue(t.getChecks(), (String)"getChecks(...)");
                Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List involvingFamilies = (List)destination$iv$iv;
            $this$flatMap$iv = involvingFamilies;
            object = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            ModFamily[] $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = (ModFamily[])thisCollection$iv$iv.toArray(new ModNamingFamily[0]);
            $this$toTypedArray$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean removeUnaffected$iv$iv = removeUnaffected$iv;
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)object;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                NameCache tableCache = new NameCache();
                HashMap constraintMap = new HashMap();
                H2IntroQueries.INSTANCE.processConstraints(this.getTransaction(), schema, ((H2Introspector)((Object)object)).isNewSchema(), (Function1<? super H2IntroQueries.ConstraintInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveConstraints$lambda$1$0$0(tableCache, this, (H2Introspector)((Object)object), constraintMap, schema, arg_0)));
                H2IntroQueries.INSTANCE.processForeignKeys(this.getTransaction(), schema, ((H2Introspector)((Object)object)).isNewSchema(), (Function1<? super H2IntroQueries.ForeignKeyInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveConstraints$lambda$1$0$1((H2Introspector)((Object)object), constraintMap, this, arg_0)));
                if (((H2Introspector)((Object)object)).isNewSchema()) {
                    H2IntroQueries.INSTANCE.processCheckConstraints(this.getTransaction(), schema, (Function1<? super H2IntroQueries.CheckInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveConstraints$lambda$1$0$2(constraintMap, arg_0)));
                    MultiMap keyColumnNames = new MultiMap();
                    H2IntroQueries.INSTANCE.processKeyColumnsV2(this.getTransaction(), schema, (Function1<? super H2IntroQueries.ForeignKeyColumnInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveConstraints$lambda$1$0$3(constraintMap, keyColumnNames, arg_0)));
                    for (Map.Entry entry : keyColumnNames.entrySet()) {
                        Intrinsics.checkNotNull((Object)entry);
                        H2Constraint key = (H2Constraint)entry.getKey();
                        Collection names = (Collection)entry.getValue();
                        Intrinsics.checkNotNull((Object)names);
                        key.setColNames(CollectionsKt.toList((Iterable)names));
                    }
                }
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        private final String removeParens(String s) {
            String string;
            if (StringsKt.startsWith$default((CharSequence)s, (char)'(', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)s, (char)')', (boolean)false, (int)2, null)) {
                String string2 = s.substring(1, StringsKt.getLastIndex((CharSequence)s));
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = s;
            }
            return string;
        }

        private final <C extends H2Constraint> C renewConstraint(ModNamingFamily<C> family, String constraintName, List<String> colNames) {
            H2Constraint h2Constraint;
            if (((CharSequence)constraintName).length() > 0) {
                h2Constraint = (H2Constraint)family.createOrGet(constraintName);
            } else {
                H2Constraint h2Constraint2 = (H2Constraint)family.find(arg_0 -> H2SchemaAbstractSchemaRetriever.renewConstraint$lambda$1(arg_0 -> H2SchemaAbstractSchemaRetriever.renewConstraint$lambda$0(colNames, arg_0), arg_0));
                if (h2Constraint2 != null) {
                    H2Constraint h2Constraint3;
                    H2Constraint $this$renewConstraint_u24lambda_u242 = h2Constraint3 = h2Constraint2;
                    boolean bl = false;
                    ((BasicModMixinElement)$this$renewConstraint_u24lambda_u242).setSyncPending(false);
                    h2Constraint = h2Constraint3;
                } else {
                    BasicModElement basicModElement = family.createNewOne();
                    Intrinsics.checkNotNullExpressionValue((Object)basicModElement, (String)"createNewOne(...)");
                    h2Constraint = (H2Constraint)basicModElement;
                }
            }
            return (C)h2Constraint;
        }

        private final List<String> parseColumnList(String s) {
            SmartList columnNames = new SmartList();
            H2Lexer lexer = new H2Lexer();
            lexer.start(s);
            IElementType tokenType = lexer.getTokenType();
            while (tokenType != null) {
                if (Intrinsics.areEqual((Object)tokenType, (Object)SqlTokens.SQL_IDENT) || tokenType instanceof SqlIdentifierKeywordTokenType || tokenType instanceof SqlKeywordTokenType) {
                    ((Collection)columnNames).add(lexer.getTokenText());
                }
                lexer.advance();
                tokenType = lexer.getTokenType();
            }
            return (List)columnNames;
        }

        private final CascadeRule getCascadeRule(String code) {
            return switch (code) {
                case "0", "CASCADE" -> CascadeRule.cascade;
                case "1", "RESTRICT" -> CascadeRule.restrict;
                case "2", "SET NULL" -> CascadeRule.set_null;
                case "4", "SET DEFAULT" -> CascadeRule.set_default;
                default -> CascadeRule.no_action;
            };
        }

        /*
         * WARNING - void declaration
         */
        private final DasType getDasType(H2IntroQueries.TypedObjectInfo $this$getDasType) {
            int actualPrecision;
            block40: {
                if ($this$getDasType.getColumn_type() != null) {
                    String string = $this$getDasType.getColumn_type();
                    Intrinsics.checkNotNull((Object)string);
                    SqlTypeElement sqlTypeElement = SqlPsiElementFactory.createDataTypeFromText((String)string, (SqlLanguageDialect)((SqlLanguageDialect)H2Dialect.INSTANCE), (Project)H2Introspector.this.getProject(), null, (boolean)false);
                    Intrinsics.checkNotNull((Object)sqlTypeElement, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlTypeElement");
                    SqlTypeElement fragment = sqlTypeElement;
                    DasType dasType = fragment.getDasType();
                    Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
                    return dasType;
                }
                if ($this$getDasType.getDomain_name() != null) {
                    String string = $this$getDasType.getDomain_schema();
                    String string2 = $this$getDasType.getDomain_name();
                    Intrinsics.checkNotNull((Object)string2);
                    DataType dataType = DataTypeFactory.of((String)string, (String)string2, (int)-1, (int)0, null, null, (boolean)false, (boolean)true);
                    Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                    DataType dataType2 = dataType;
                    return H2Introspector.this.typeSystem.createDasType(dataType2);
                }
                actualPrecision = $this$getDasType.getPrecision() <= Integer.MAX_VALUE ? (int)$this$getDasType.getPrecision() : Integer.MAX_VALUE;
                String string = $this$getDasType.getType_name();
                if (string == null) break block40;
                int n = -1;
                switch (string.hashCode()) {
                    case 1353045189: {
                        if (string.equals("INTERVAL")) {
                            n = 1;
                        }
                        break;
                    }
                    case 2133249: {
                        if (string.equals("ENUM")) {
                            n = 2;
                        }
                        break;
                    }
                    case 62552633: {
                        if (string.equals("ARRAY")) {
                            n = 3;
                        }
                        break;
                    }
                    case 81338: {
                        if (string.equals("ROW")) {
                            n = 4;
                        }
                        break;
                    }
                    case -1666320270: {
                        if (string.equals("GEOMETRY")) {
                            n = 5;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        Object object;
                        if ($this$getDasType.getInterval_type() == null) {
                            return (DasType)DasTypeSystemBase.UNKNOWN;
                        }
                        String string3 = $this$getDasType.getInterval_type();
                        Intrinsics.checkNotNull((Object)string3);
                        char[] cArray = new char[]{' '};
                        List components = StringsKt.split$default((CharSequence)string3, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                        String string4 = (String)CollectionsKt.getOrNull((List)components, (int)0);
                        if (string4 == null || (object = H2Introspector.this.toIntervalKind(string4)) == null) {
                            return (DasType)DasTypeSystemBase.UNKNOWN;
                        }
                        Interval primaryKind = object;
                        object = (String)CollectionsKt.getOrNull((List)components, (int)2);
                        Interval secondaryKind = object != null ? H2Introspector.this.toIntervalKind((String)object) : null;
                        return H2Introspector.this.getIntervalDasType(primaryKind, secondaryKind, $this$getDasType.getInterval_precision(), actualPrecision);
                    }
                    case 5: {
                        StringBuilder primaryKind;
                        if ($this$getDasType.getGeometry_type() == null && $this$getDasType.getGeometry_srid() == null) {
                            DasTypeSystemBase dasTypeSystemBase = H2Introspector.this.typeSystem;
                            DataType dataType = DataTypeFactory.of((String)"GEOMETRY");
                            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                            return dasTypeSystemBase.createDasType(dataType);
                        }
                        StringBuilder $this$getDasType_u24lambda_u240 = primaryKind = new StringBuilder();
                        boolean bl = false;
                        String string5 = $this$getDasType.getGeometry_type();
                        if (string5 == null) {
                            string5 = "GEOMETRY";
                        }
                        $this$getDasType_u24lambda_u240.append(string5);
                        if ($this$getDasType.getGeometry_srid() != null) {
                            $this$getDasType_u24lambda_u240.append(", ").append($this$getDasType.getGeometry_srid());
                        }
                        String arg = primaryKind.toString();
                        String string6 = $this$getDasType.getType_name();
                        Intrinsics.checkNotNull((Object)string6);
                        DataType dataType = DataTypeFactory.ofArgs(null, (String)string6, (String)arg, (boolean)false);
                        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"ofArgs(...)");
                        DataType dataType3 = dataType;
                        return H2Introspector.this.typeSystem.createDasType(dataType3);
                    }
                    case 2: {
                        if ($this$getDasType.getDtd_identifier() == null) {
                            return (DasType)DasTypeSystemBase.UNKNOWN;
                        }
                        String string7 = $this$getDasType.getDtd_identifier();
                        Intrinsics.checkNotNull((Object)string7);
                        List<String> list = this.enumValues.get(string7);
                        if (list == null) {
                            return (DasType)DasTypeSystemBase.UNKNOWN;
                        }
                        List<String> enumValues = list;
                        String string8 = $this$getDasType.getType_name();
                        Intrinsics.checkNotNull((Object)string8);
                        DataType dataType = DataTypeFactory.ofValues(null, null, (String)string8, enumValues, (boolean)false);
                        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"ofValues(...)");
                        DataType dataType4 = dataType;
                        return H2Introspector.this.typeSystem.createDasType(dataType4);
                    }
                    case 3: {
                        StringBuilder bl;
                        if ($this$getDasType.getDtd_identifier() == null) {
                            DasType dasType;
                            if (H2Introspector.this.isV2()) {
                                dasType = (DasType)DasTypeSystemBase.UNKNOWN;
                            } else {
                                DasTypeSystemBase dasTypeSystemBase = H2Introspector.this.typeSystem;
                                String string9 = $this$getDasType.getType_name();
                                Intrinsics.checkNotNull((Object)string9);
                                DataType dataType = DataTypeFactory.of((String)string9);
                                Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                                dasType = dasTypeSystemBase.createDasType(dataType);
                            }
                            return dasType;
                        }
                        String string10 = $this$getDasType.getDtd_identifier();
                        Intrinsics.checkNotNull((Object)string10);
                        H2IntroQueries.ArrayElementInfo arrayElementInfo = this.arrayElementTypes.get(string10);
                        if (arrayElementInfo == null || (arrayElementInfo = this.getDasType(arrayElementInfo)) == null) {
                            return (DasType)DasTypeSystemBase.UNKNOWN;
                        }
                        H2IntroQueries.ArrayElementInfo elementType = arrayElementInfo;
                        DataType dataType = elementType.toDataType();
                        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"toDataType(...)");
                        DataType elementDataType = dataType;
                        StringBuilder $this$getDasType_u24lambda_u241 = bl = new StringBuilder();
                        boolean bl2 = false;
                        String string11 = elementDataType.suffix;
                        if (string11 == null) {
                            string11 = "";
                        }
                        $this$getDasType_u24lambda_u241.append(string11);
                        if ($this$getDasType_u24lambda_u241.length() > 0) {
                            $this$getDasType_u24lambda_u241.append(' ');
                        }
                        $this$getDasType_u24lambda_u241.append("ARRAY");
                        if ($this$getDasType.getMaximum_cardinality() != null) {
                            Integer n2 = $this$getDasType.getMaximum_cardinality();
                            int n3 = 65536;
                            if (n2 == null || n2 != n3) {
                                $this$getDasType_u24lambda_u241.append("[" + $this$getDasType.getMaximum_cardinality() + "]");
                            }
                        }
                        String suffix = bl.toString();
                        DataType dataType5 = DataTypeFactory.withSuffix((DataType)elementType.toDataType(), (String)suffix);
                        Intrinsics.checkNotNullExpressionValue((Object)dataType5, (String)"withSuffix(...)");
                        DataType dataType6 = dataType5;
                        return H2Introspector.this.typeSystem.createDasType(dataType6);
                    }
                    case 4: {
                        if ($this$getDasType.getDtd_identifier() == null) {
                            return (DasType)DasTypeSystemBase.UNKNOWN;
                        }
                        DdlBuilder ddlBuilder = new DdlBuilder().withDialect(DbImplUtilCore.getDatabaseDialect((Dbms)H2Introspector.this.dbms)).quoteIdentifiers(false);
                        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"quoteIdentifiers(...)");
                        DdlBuilder argBuilder = ddlBuilder;
                        String string12 = $this$getDasType.getDtd_identifier();
                        Intrinsics.checkNotNull((Object)string12);
                        Collection collection = this.rowFields.get((Object)string12);
                        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
                        Iterable $this$forEachIndexed$iv = collection;
                        boolean $i$f$forEachIndexed = false;
                        int index$iv = 0;
                        for (Object item$iv : $this$forEachIndexed$iv) {
                            void field;
                            int n4;
                            if ((n4 = index$iv++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            H2IntroQueries.RowFieldInfo rowFieldInfo = (H2IntroQueries.RowFieldInfo)item$iv;
                            int i = n4;
                            boolean bl = false;
                            if (i > 0) {
                                argBuilder.plain(", ");
                            }
                            argBuilder.identifier(field.field_name);
                            argBuilder.plain(" ");
                            Intrinsics.checkNotNull((Object)field);
                            argBuilder.type(this.getDasType((H2IntroQueries.TypedObjectInfo)field).toDataType());
                        }
                        String string13 = $this$getDasType.getType_name();
                        Intrinsics.checkNotNull((Object)string13);
                        DataType dataType = DataTypeFactory.ofArgs(null, (String)string13, (String)argBuilder.getStatement(), (boolean)false);
                        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"ofArgs(...)");
                        DataType dataType7 = dataType;
                        return H2Introspector.this.typeSystem.createDasType(dataType7);
                    }
                }
            }
            return H2Introspector.this.getDasType($this$getDasType.getType_name(), actualPrecision, $this$getDasType.getScale());
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveIndexes(H2Schema schema) {
            void families$iv$iv;
            void families$iv;
            void $this$mapTo$iv$iv;
            ObjectKind objectKind = ObjectKind.INDEX;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"INDEX");
            H2Introspector.this.reportRetrieving(objectKind);
            ModNamingFamily<? extends H2Table> modNamingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$map$iv = (Iterable)modNamingFamily;
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                H2Table h2Table = (H2Table)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getIndices());
            }
            $this$map$iv = (List)destination$iv$iv;
            object = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            ModFamily[] $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = (ModFamily[])thisCollection$iv$iv.toArray(new ModNamingFamily[0]);
            $this$toTypedArray$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean removeUnaffected$iv$iv = removeUnaffected$iv;
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)object;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                NameCache tableCache = new NameCache();
                H2IntroQueries.INSTANCE.processIndexes(this.getTransaction(), schema, ((H2Introspector)((Object)object)).isNewSchema(), (Function1<? super H2IntroQueries.IndexInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveIndexes$lambda$1$0$0(tableCache, schema, arg_0)));
                NameCache indexCache = new NameCache();
                ArrayList indexColumns = new ArrayList();
                H2IntroQueries.INSTANCE.processIndexColumns(this.getTransaction(), schema, ((H2Introspector)((Object)object)).isNewSchema(), (Function1<? super H2IntroQueries.IndexColumnInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveIndexes$lambda$1$0$1(tableCache, indexCache, indexColumns, this, schema, arg_0)));
                this.applyIndexColumns((H2Index)indexCache.getV(), indexColumns);
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void applyIndexColumns(H2Index index, List<H2IntroQueries.IndexColumnInfo> columns) {
            H2Index h2Index = index;
            if (h2Index != null) {
                void destination$iv;
                void $this$mapNotNullTo$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                H2Index h2Index2;
                H2Index $this$applyIndexColumns_u24lambda_u240 = h2Index2 = h2Index;
                boolean bl = false;
                Iterable iterable = columns;
                H2Index h2Index3 = $this$applyIndexColumns_u24lambda_u240;
                boolean $i$f$map22 = false;
                void var9_10 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    H2IntroQueries.IndexColumnInfo indexColumnInfo = (H2IntroQueries.IndexColumnInfo)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.column_name);
                }
                h2Index3.setColNames((List)destination$iv$iv);
                $this$map$iv = columns;
                Collection $i$f$map22 = new LinkedHashSet();
                h2Index3 = $this$applyIndexColumns_u24lambda_u240;
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String it$iv;
                    String string;
                    Object element$iv$iv;
                    Object element$iv = element$iv$iv = iterator.next();
                    boolean bl3 = false;
                    H2IntroQueries.IndexColumnInfo c = (H2IntroQueries.IndexColumnInfo)element$iv;
                    boolean bl4 = false;
                    String it = string = c.column_name;
                    boolean bl5 = false;
                    if ((c.is_desc ? string : null) == null) continue;
                    it$iv = it$iv;
                    boolean bl6 = false;
                    destination$iv.add(it$iv);
                }
                h2Index3.setReverseColNames((Set)destination$iv);
            }
            columns.clear();
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTriggers(H2Schema schema) {
            void families$iv$iv;
            void families$iv;
            void $this$mapTo$iv$iv;
            ObjectKind objectKind = ObjectKind.TRIGGER;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TRIGGER");
            H2Introspector.this.reportRetrieving(objectKind);
            NameCache tableCache = new NameCache();
            ModNamingFamily<? extends H2Table> modNamingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$map$iv = (Iterable)modNamingFamily;
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                H2Table h2Table = (H2Table)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getTriggers());
            }
            $this$map$iv = (List)destination$iv$iv;
            object = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            ModFamily[] $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = (ModFamily[])thisCollection$iv$iv.toArray(new ModNamingFamily[0]);
            $this$toTypedArray$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean removeUnaffected$iv$iv = removeUnaffected$iv;
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)object;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                H2IntroQueries.INSTANCE.processTriggers(this.getTransaction(), schema, ((H2Introspector)((Object)object)).isNewSchema(), (Function1<? super H2IntroQueries.TriggerInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveTriggers$lambda$1$0$0(tableCache, schema, this, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveSequences(H2Schema schema) {
            void $this$modifyAndCleanup_u24default$iv;
            ObjectKind objectKind = ObjectKind.SEQUENCE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"SEQUENCE");
            H2Introspector.this.reportRetrieving(objectKind);
            ModFamily modFamily = (ModFamily)schema.getSequences();
            H2Introspector h2Introspector = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily sequences = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)h2Introspector;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                Ref.IntRef order = new Ref.IntRef();
                H2IntroQueries.INSTANCE.processSequences(this.getTransaction(), schema, h2Introspector.isNewSchema(), (Function1<? super H2IntroQueries.SequenceInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveSequences$lambda$0$0$0(sequences, this, order, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        private final void processSequenceLike(H2Sequence sequence, H2IntroQueries.SequenceLikeInfo info, boolean isIdentity) {
            SequenceIdentity sequenceIdentity;
            BigInteger bigInteger;
            BigInteger bigInteger2;
            BigInteger bigInteger3;
            BigInteger bigInteger4;
            BigInteger bigInteger5;
            BigInteger bigInteger6;
            Long l = info.getStart_value();
            if (l != null) {
                BigInteger bigInteger7 = BigInteger.valueOf(l);
                bigInteger6 = bigInteger7;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"valueOf(...)");
            } else {
                bigInteger6 = null;
            }
            BigInteger start = bigInteger6;
            Long l2 = info.getLast_value();
            if (l2 != null) {
                BigInteger bigInteger8 = BigInteger.valueOf(l2);
                bigInteger5 = bigInteger8;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger8, (String)"valueOf(...)");
            } else {
                bigInteger5 = null;
            }
            BigInteger last = bigInteger5;
            Long l3 = info.getNext_value();
            if (l3 != null) {
                BigInteger bigInteger9 = BigInteger.valueOf(l3);
                bigInteger4 = bigInteger9;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger9, (String)"valueOf(...)");
            } else {
                bigInteger4 = null;
            }
            BigInteger next = bigInteger4;
            Long l4 = info.getMin_value();
            if (l4 != null) {
                BigInteger bigInteger10 = BigInteger.valueOf(l4);
                bigInteger3 = bigInteger10;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger10, (String)"valueOf(...)");
            } else {
                bigInteger3 = null;
            }
            BigInteger minimum = bigInteger3;
            Long l5 = info.getMax_value();
            if (l5 != null) {
                BigInteger bigInteger11 = BigInteger.valueOf(l5);
                bigInteger2 = bigInteger11;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger11, (String)"valueOf(...)");
            } else {
                bigInteger2 = null;
            }
            BigInteger maximum = bigInteger2;
            Long l6 = info.getIncrement();
            if (l6 != null) {
                BigInteger bigInteger12 = BigInteger.valueOf(l6);
                bigInteger = bigInteger12;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger12, (String)"valueOf(...)");
            } else {
                bigInteger = null;
            }
            BigInteger increment = bigInteger;
            boolean isAsc = BaseIntrospectionFunctions.isAscSequenceIncrement$default((BigInteger)increment, (boolean)false, (int)1, null);
            H2Sequence h2Sequence = sequence;
            H2Introspector h2Introspector = H2Introspector.this;
            H2Sequence $this$processSequenceLike_u24lambda_u240 = h2Sequence;
            boolean bl = false;
            $this$processSequenceLike_u24lambda_u240.setStoredType(this.dasType(info));
            $this$processSequenceLike_u24lambda_u240.setStartValue(start);
            if (!isIdentity) {
                sequenceIdentity = SequenceIdentity.UNKNOWN;
            } else {
                DasType dasType = $this$processSequenceLike_u24lambda_u240.getStoredType();
                Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getStoredType(...)");
                BigInteger bigInteger13 = (BigInteger)BaseIntrospectionFunctions.nullize((Object)minimum, (Object)this.sequenceUnlimitedMinimumDefault(isAsc, dasType));
                BigInteger bigInteger14 = h2Introspector.isNewSchema() ? next : BaseIntrospectionFunctions.nextByLast((BigInteger)last, (BigInteger)increment, (BigInteger)start);
                DasType dasType2 = $this$processSequenceLike_u24lambda_u240.getStoredType();
                Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"getStoredType(...)");
                sequenceIdentity = SequenceIdentity.of((BigInteger)bigInteger13, (BigInteger)bigInteger14, (BigInteger)increment, (BigInteger)((BigInteger)BaseIntrospectionFunctions.nullize((Object)maximum, (Object)this.sequenceUnlimitedMaximumDefault(isAsc, dasType2))));
            }
            $this$processSequenceLike_u24lambda_u240.setSequenceIdentity(sequenceIdentity);
            $this$processSequenceLike_u24lambda_u240.setCacheSize(info.getCache());
            $this$processSequenceLike_u24lambda_u240.setCycled(info.is_cycle());
        }

        static /* synthetic */ void processSequenceLike$default(H2SchemaAbstractSchemaRetriever h2SchemaAbstractSchemaRetriever, H2Sequence h2Sequence, H2IntroQueries.SequenceLikeInfo sequenceLikeInfo, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            h2SchemaAbstractSchemaRetriever.processSequenceLike(h2Sequence, sequenceLikeInfo, bl);
        }

        /*
         * Unable to fully structure code
         */
        private final DasType dasType(H2IntroQueries.SequenceLikeInfo $this$dasType) {
            block17: {
                block16: {
                    if (!H2Introspector.access$isV2(H2Introspector.this)) {
                        v0 = H2Introspector.access$getTypeSystem$p(H2Introspector.this);
                        v1 = DataTypeFactory.of((String)"BIGINT");
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"of(...)");
                        return v0.createDasType(v1);
                    }
                    size = -1;
                    typeName = null;
                    seq_type_name = $this$dasType.getSeq_type_name();
                    if (seq_type_name == null) break block16;
                    switch (seq_type_name.hashCode()) {
                        case -1282431251: {
                            if (seq_type_name.equals("NUMERIC")) break;
                            ** break;
                        }
                        case 176095624: {
                            if (!seq_type_name.equals("SMALLINT")) {
                                ** break;
                            }
                            ** GOTO lbl39
                        }
                        case 2511262: {
                            if (!seq_type_name.equals("REAL")) {
                                ** break;
                            }
                            ** GOTO lbl39
                        }
                        case 1959128815: {
                            if (!seq_type_name.equals("BIGINT")) {
                                ** break;
                            }
                            ** GOTO lbl39
                        }
                        case 1345372058: {
                            if (seq_type_name.equals("DECFLOAT")) break;
                            ** break;
                        }
                        case -594415409: {
                            if (!seq_type_name.equals("TINYINT")) {
                                ** break;
                            }
                            ** GOTO lbl39
                        }
                        case 1770063567: {
                            if (!seq_type_name.equals("DOUBLE PRECISION")) {
                                ** break;
                            }
                            ** GOTO lbl39
                        }
                        case -1618932450: {
                            if (!seq_type_name.equals("INTEGER")) ** break;
lbl39:
                            // 6 sources

                            typeName = seq_type_name;
                            break block17;
                        }
                    }
                    typeName = seq_type_name;
                    size = $this$dasType.getSeq_numeric_scale() == 0 ? H2Introspector.access$maskDefaultPrecision(H2Introspector.this, $this$dasType.getSeq_numeric_precision(), 19) : $this$dasType.getSeq_numeric_precision();
                    break block17;
                }
                typeName = "BIGINT";
            }
            v2 = DataTypeFactory.of(null, (String)typeName, (int)size, (int)0, null, null, (boolean)false, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"of(...)");
            dataType = v2;
            return H2Introspector.access$getTypeSystem$p(H2Introspector.this).createDasType(dataType);
        }

        private final BigInteger sequenceUnlimitedMinimumDefault(boolean isAsc, DasType type) {
            return isAsc ? null : this.getLowerBound(type);
        }

        private final BigInteger sequenceUnlimitedMaximumDefault(boolean isAsc, DasType type) {
            return isAsc ? this.getUpperBound(type) : null;
        }

        /*
         * Enabled aggressive block sorting
         */
        private final BigInteger getLowerBound(DasType $this$lowerBound) {
            BigInteger bigInteger;
            String string = StringUtil.toUpperCase((String)DasTypeUtilsKt.getTypeName((DasType)$this$lowerBound));
            if (string != null) {
                int n = -1;
                switch (string.hashCode()) {
                    case -1282431251: {
                        if (!string.equals("NUMERIC")) break;
                        n = 1;
                        break;
                    }
                    case 2511262: {
                        if (!string.equals("REAL")) break;
                        n = 2;
                        break;
                    }
                    case -2034720975: {
                        if (!string.equals("DECIMAL")) break;
                        n = 1;
                        break;
                    }
                    case 1345372058: {
                        if (!string.equals("DECFLOAT")) break;
                        n = 3;
                        break;
                    }
                    case -594415409: {
                        if (!string.equals("TINYINT")) break;
                        n = 4;
                        break;
                    }
                    case 1770063567: {
                        if (!string.equals("DOUBLE PRECISION")) break;
                        n = 5;
                        break;
                    }
                }
                switch (n) {
                    case 4: {
                        BigInteger bigInteger2 = BigInteger.valueOf(-128);
                        bigInteger = bigInteger2;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(...)");
                        return bigInteger;
                    }
                    case 2: {
                        BigInteger bigInteger3 = BigInteger.valueOf(-16777216);
                        bigInteger = bigInteger3;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"valueOf(...)");
                        return bigInteger;
                    }
                    case 5: {
                        BigInteger bigInteger4 = BigInteger.valueOf(-9007199254740992L);
                        bigInteger = bigInteger4;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"valueOf(...)");
                        return bigInteger;
                    }
                    case 1: {
                        BigInteger bigInteger5 = BigInteger.valueOf(this.decimalLowerBound($this$lowerBound, true));
                        bigInteger = bigInteger5;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"valueOf(...)");
                        return bigInteger;
                    }
                    case 3: {
                        BigInteger bigInteger6 = BigInteger.valueOf(this.decimalLowerBound($this$lowerBound, false));
                        bigInteger = bigInteger6;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"valueOf(...)");
                        return bigInteger;
                    }
                }
            }
            BigInteger bigInteger7 = DasTypeUtilsKt.getMinValue((DasType)$this$lowerBound);
            bigInteger = bigInteger7;
            if (bigInteger7 != null) return bigInteger;
            BigInteger bigInteger8 = BigInteger.valueOf(Long.MIN_VALUE);
            bigInteger = bigInteger8;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger8, (String)"valueOf(...)");
            return bigInteger;
        }

        private final long decimalLowerBound(DasType $this$decimalLowerBound, boolean exclusive) {
            long upperBound = this.decimalUpperBound($this$decimalLowerBound, exclusive);
            return upperBound == Long.MAX_VALUE ? Long.MIN_VALUE : -upperBound;
        }

        /*
         * Enabled aggressive block sorting
         */
        private final BigInteger getUpperBound(DasType $this$upperBound) {
            BigInteger bigInteger;
            String string = StringUtil.toUpperCase((String)DasTypeUtilsKt.getTypeName((DasType)$this$upperBound));
            if (string != null) {
                int n = -1;
                switch (string.hashCode()) {
                    case -1282431251: {
                        if (!string.equals("NUMERIC")) break;
                        n = 1;
                        break;
                    }
                    case 2511262: {
                        if (!string.equals("REAL")) break;
                        n = 2;
                        break;
                    }
                    case -2034720975: {
                        if (!string.equals("DECIMAL")) break;
                        n = 1;
                        break;
                    }
                    case 1345372058: {
                        if (!string.equals("DECFLOAT")) break;
                        n = 3;
                        break;
                    }
                    case -594415409: {
                        if (!string.equals("TINYINT")) break;
                        n = 4;
                        break;
                    }
                    case 1770063567: {
                        if (!string.equals("DOUBLE PRECISION")) break;
                        n = 5;
                        break;
                    }
                }
                switch (n) {
                    case 4: {
                        BigInteger bigInteger2 = BigInteger.valueOf(127);
                        bigInteger = bigInteger2;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(...)");
                        return bigInteger;
                    }
                    case 2: {
                        BigInteger bigInteger3 = BigInteger.valueOf(0x1000000);
                        bigInteger = bigInteger3;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"valueOf(...)");
                        return bigInteger;
                    }
                    case 5: {
                        BigInteger bigInteger4 = BigInteger.valueOf(0x20000000000000L);
                        bigInteger = bigInteger4;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"valueOf(...)");
                        return bigInteger;
                    }
                    case 1: {
                        BigInteger bigInteger5 = BigInteger.valueOf(this.decimalUpperBound($this$upperBound, true));
                        bigInteger = bigInteger5;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"valueOf(...)");
                        return bigInteger;
                    }
                    case 3: {
                        BigInteger bigInteger6 = BigInteger.valueOf(this.decimalUpperBound($this$upperBound, false));
                        bigInteger = bigInteger6;
                        Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"valueOf(...)");
                        return bigInteger;
                    }
                }
            }
            BigInteger bigInteger7 = DasTypeUtilsKt.getMaxValue((DasType)$this$upperBound);
            bigInteger = bigInteger7;
            if (bigInteger7 != null) return bigInteger;
            BigInteger bigInteger8 = BigInteger.valueOf(Long.MAX_VALUE);
            bigInteger = bigInteger8;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger8, (String)"valueOf(...)");
            return bigInteger;
        }

        /*
         * WARNING - void declaration
         */
        private final long decimalUpperBound(DasType $this$decimalUpperBound, boolean exclusive) {
            long l;
            DataType dataType = $this$decimalUpperBound.toDataType();
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"toDataType(...)");
            DataType dt = dataType;
            int p = dt.getPrecision() - dt.scale;
            boolean bl = 1 <= p ? p < 19 : false;
            if (bl) {
                void $this$fold$iv;
                Iterable iterable = (Iterable)new IntRange(1, p);
                long initial$iv = 1L;
                boolean $i$f$fold = false;
                long accumulator$iv = initial$iv;
                Iterator iterator = $this$fold$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv = ((IntIterator)iterator).nextInt();
                    long res = accumulator$iv;
                    boolean bl2 = false;
                    accumulator$iv = res * (long)10;
                }
                long result = accumulator$iv;
                if (exclusive) {
                    long l2 = result;
                    result = l2 + -1L;
                }
                l = result;
            } else {
                l = Long.MAX_VALUE;
            }
            return l;
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveRoutines(H2Schema schema) {
            void families$iv$iv;
            void $this$mapTo$iv$iv;
            void families$iv;
            ObjectKind objectKind = ObjectKind.ROUTINE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ROUTINE");
            H2Introspector.this.reportRetrieving(objectKind);
            HashMap aliasMap = new HashMap();
            ModNamingFamily<? extends H2Routine> modNamingFamily = schema.getRoutines();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getRoutines(...)");
            ModNamingFamily<? extends H2Routine> routines = modNamingFamily;
            ModNamingFamily<? extends H2Aggregate> modNamingFamily2 = schema.getAggregates();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getAggregates(...)");
            ModNamingFamily<? extends H2Aggregate> aggregates = modNamingFamily2;
            ModFamily[] modFamilyArray = new ModFamily[]{routines, aggregates};
            Object object = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            for (void f$iv : families$iv) {
                f$iv.markChildrenAsSyncPending();
            }
            boolean bl4 = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)object;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                H2IntroQueries.INSTANCE.processRoutines(this.getTransaction(), schema, (Function1<? super H2IntroQueries.RoutineInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveRoutines$lambda$0$0$0(aggregates, routines, aliasMap, this, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            int n = ((void)families$iv).length;
            for (int i = 0; i < n; ++i) {
                void f$iv;
                f$iv = families$iv[i];
                f$iv.removeSyncPendingChildren();
                f$iv.sort();
            }
            Iterable $this$map$iv = (Iterable)routines;
            boolean $i$f$map = false;
            object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                H2Routine bl4 = (H2Routine)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                collection.add(it.getArguments());
            }
            $this$map$iv = (List)destination$iv$iv;
            object = H2Introspector.this;
            removeUnaffected$iv = true;
            $i$f$modifyFamiliesAndCleanup = false;
            ModFamily[] $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = (ModFamily[])thisCollection$iv$iv.toArray(new ModPositioningNamingFamily[0]);
            $this$toTypedArray$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean removeUnaffected$iv$iv = removeUnaffected$iv;
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl6 = false;
            BaseNativeIntrospector this_$iv2 = (BaseNativeIntrospector)object;
            boolean $i$f$continueOnDbError3 = false;
            BaseNativeIntrospector e$iv$iv = this_$iv2;
            Object whatsDoing$iv$iv2 = null;
            boolean $i$f$continueOnDbError4 = false;
            try {
                boolean bl7 = false;
                H2IntroQueries.INSTANCE.processRoutineArguments(this.getTransaction(), schema, (Function1<? super H2IntroQueries.RoutineArgumentInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveRoutines$lambda$2$0$0(aliasMap, this, arg_0)));
            }
            catch (DBException e$iv$iv2) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv2);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl8 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv2.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv2.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv2);
            }
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveRoutinesV2(H2Schema schema) {
            void families$iv$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$forEach$iv;
            void families$iv;
            ObjectKind objectKind = ObjectKind.ROUTINE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ROUTINE");
            H2Introspector.this.reportRetrieving(objectKind);
            HashMap routineMap = new HashMap();
            ModNamingFamily<? extends H2Routine> modNamingFamily = schema.getRoutines();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getRoutines(...)");
            ModNamingFamily<? extends H2Routine> routines = modNamingFamily;
            ModNamingFamily<? extends H2Aggregate> modNamingFamily2 = schema.getAggregates();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getAggregates(...)");
            ModNamingFamily<? extends H2Aggregate> aggregates = modNamingFamily2;
            ModFamily[] modFamilyArray = new ModFamily[]{routines, aggregates};
            Object object = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            for (void f$iv : families$iv) {
                f$iv.markChildrenAsSyncPending();
            }
            boolean bl6 = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)object;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                Object object2;
                H2LikeRoutine it;
                boolean bl2 = false;
                $this$forEach$iv = (Iterable)routines;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (H2Routine)element$iv;
                    boolean bl3 = false;
                    object2 = routineMap;
                    String string = it.getSpecificName();
                    if (string == null) {
                        string = "";
                    }
                    object2.put(string, it);
                }
                $this$forEach$iv = (Iterable)aggregates;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (H2Aggregate)element$iv;
                    boolean bl4 = false;
                    object2 = routineMap;
                    String string = it.getSpecificName();
                    if (string == null) {
                        string = "";
                    }
                    object2.put(string, it);
                }
                H2IntroQueries.INSTANCE.processRoutinesV2(this.getTransaction(), schema, ((H2Introspector)object).isNewSchema(), (Function1<? super H2IntroQueries.RoutineInfoV2, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveRoutinesV2$lambda$0$0$2(aggregates, routines, routineMap, this, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl5 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            int n = ((void)families$iv).length;
            for (int i = 0; i < n; ++i) {
                void f$iv;
                f$iv = families$iv[i];
                f$iv.removeSyncPendingChildren();
                f$iv.sort();
            }
            Iterable $this$map$iv = (Iterable)routines;
            boolean $i$f$map = false;
            object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                H2Routine bl6 = (H2Routine)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl7 = false;
                collection.add(it.getArguments());
            }
            $this$map$iv = (List)destination$iv$iv;
            object = H2Introspector.this;
            removeUnaffected$iv = true;
            $i$f$modifyFamiliesAndCleanup = false;
            ModFamily[] $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = (ModFamily[])thisCollection$iv$iv.toArray(new ModPositioningNamingFamily[0]);
            $this$toTypedArray$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean removeUnaffected$iv$iv = removeUnaffected$iv;
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl8 = false;
            BaseNativeIntrospector this_$iv2 = (BaseNativeIntrospector)object;
            boolean $i$f$continueOnDbError3 = false;
            $this$forEach$iv = this_$iv2;
            Object whatsDoing$iv$iv2 = null;
            boolean $i$f$continueOnDbError4 = false;
            try {
                boolean bl9 = false;
                H2IntroQueries.INSTANCE.processRoutineArgumentsV2(this.getTransaction(), schema, ((H2Introspector)object).isNewSchema(), (Function1<? super H2IntroQueries.RoutineArgumentInfoV2, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveRoutinesV2$lambda$2$0$0(routineMap, this, arg_0)));
                Iterable $this$forEach$iv2 = (Iterable)routines;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv2) {
                    H2Routine it = (H2Routine)element$iv;
                    boolean bl10 = false;
                    BasicModArgument basicModArgument = (BasicModArgument)it.getReturnArgument();
                    if (basicModArgument == null) continue;
                    basicModArgument.resetSyncPending();
                }
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl11 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        private final String javaMethodName(H2IntroQueries.RoutineInfoV2 $this$javaMethodName) {
            String string;
            if ($this$javaMethodName.external_name == null) {
                return null;
            }
            String string2 = $this$javaMethodName.external_name;
            Intrinsics.checkNotNull((Object)string2);
            int p = StringsKt.lastIndexOf$default((CharSequence)string2, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (p >= 0) {
                String string3;
                String string4 = $this$javaMethodName.external_name;
                Intrinsics.checkNotNull((Object)string4);
                String string5 = string4.substring(p + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                String it = string3 = string5;
                boolean bl = false;
                string = !Intrinsics.areEqual((Object)it, (Object)"null") ? string3 : null;
            } else {
                string = null;
            }
            return string;
        }

        private final String javaClassName(H2IntroQueries.RoutineInfoV2 $this$javaClassName) {
            String string;
            if ($this$javaClassName.external_name == null) {
                return null;
            }
            String string2 = $this$javaClassName.external_name;
            Intrinsics.checkNotNull((Object)string2);
            int p = StringsKt.lastIndexOf$default((CharSequence)string2, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (p >= 0) {
                String string3;
                String string4 = $this$javaClassName.external_name;
                Intrinsics.checkNotNull((Object)string4);
                String string5 = string4.substring(0, p);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                String it = string3 = string5;
                boolean bl = false;
                string = !Intrinsics.areEqual((Object)it, (Object)"null") ? string3 : null;
            } else {
                string = null;
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveConstants(H2Schema schema) {
            void $this$modifyAndCleanup_u24default$iv;
            ObjectKind objectKind = ObjectKind.CONSTANT;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"CONSTANT");
            H2Introspector.this.reportRetrieving(objectKind);
            ModFamily modFamily = (ModFamily)schema.getConstants();
            H2Introspector h2Introspector = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily constants = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)h2Introspector;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                H2IntroQueries.INSTANCE.processConstants(this.getTransaction(), schema, h2Introspector.isNewSchema(), (Function1<? super H2IntroQueries.ConstantInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveConstants$lambda$0$0$0(constants, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveSynonyms(H2Schema schema) {
            void $this$modifyAndCleanup_u24default$iv;
            Object object = new int[]{1, 4, 197};
            if (!H2Introspector.this.getServerVersion().isOrGreater(object)) {
                return;
            }
            ObjectKind objectKind = ObjectKind.SYNONYM;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"SYNONYM");
            H2Introspector.this.reportRetrieving(objectKind);
            object = (ModFamily)schema.getSynonyms();
            H2Introspector h2Introspector = H2Introspector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily synonyms = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)h2Introspector;
            boolean $i$f$continueOnDbError = false;
            BaseNativeIntrospector baseNativeIntrospector = this_$iv;
            Object whatsDoing$iv$iv = null;
            boolean $i$f$continueOnDbError2 = false;
            try {
                boolean bl2 = false;
                H2IntroQueries.INSTANCE.processSynonyms(this.getTransaction(), schema, (Function1<? super H2IntroQueries.SynonymInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveSynonyms$lambda$0$0$0(synonyms, arg_0)));
            }
            catch (DBException e$iv$iv) {
                StringBuilder stringBuilder;
                void this_$iv$iv;
                boolean expected$iv$iv = BaseNativeIntrospector.access$ignoreThisDbException((BaseNativeIntrospector)this_$iv$iv, (DBException)e$iv$iv);
                StringBuilder $this$continueOnDbError_u24lambda_u240$iv$iv = stringBuilder = new StringBuilder();
                boolean bl3 = false;
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(expected$iv$iv ? "Expected" : "Unexpected");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(" DB error ").append(e$iv$iv.vendorErrorCode).append(" encountered (and ignored)");
                $this$continueOnDbError_u24lambda_u240$iv$iv.append(". Exception message: ").append(e$iv$iv.getMessage());
                String message$iv$iv = stringBuilder.toString();
                if (expected$iv$iv) {
                    this_$iv$iv.trace(message$iv$iv);
                } else {
                    IntrospectionQueryContext.logWarn$default((IntrospectionQueryContext)((IntrospectionQueryContext)this_$iv$iv), (String)message$iv$iv, null, (int)2, null);
                }
                this_$iv$iv.getErrorSink().accept(null, e$iv$iv);
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        private final void retrieveSourcesV2(H2Schema schema) {
            this.getModel().writeSources(() -> H2SchemaAbstractSchemaRetriever.retrieveSourcesV2$lambda$0(this, schema));
        }

        private final void retrieveViewSources(H2Schema schema) {
            H2Introspector.this.reportRetrieving("view sources", "introspection.retrieve.view.sources");
            H2IntroQueries.INSTANCE.processViewSources(this.getTransaction(), schema, (Function1<? super H2IntroQueries.SourceInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveViewSources$lambda$0(schema, this, arg_0)));
        }

        private final void retrieveTriggerSources(H2Schema schema) {
            H2Introspector.this.reportRetrieving("trigger sources", "introspection.retrieve.trigger.sources");
            HashMap triggerMap = new HashMap();
            for (H2Table table : schema.getTables()) {
                for (H2Trigger trigger : table.getTriggers()) {
                    ((Map)triggerMap).put(trigger.getName(), trigger);
                }
            }
            H2IntroQueries.INSTANCE.processTriggerSources(this.getTransaction(), schema, (Function1<? super H2IntroQueries.SourceInfo, Unit>)((Function1)arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveTriggerSources$lambda$0(triggerMap, this, arg_0)));
        }

        private static final void retrieveMainContent$lambda$0$0(H2SchemaAbstractSchemaRetriever this$0, H2Schema $schema, H2Introspector this$1) {
            this$0.retrieveDomains($schema);
            if (this$1.isNewSchema()) {
                this$0.retrieveDomainChecks($schema);
            }
            this$0.retrieveTables($schema);
            this$0.retrieveColumns($schema);
            this$0.retrieveIndexes($schema);
            this$0.retrieveTriggers($schema);
            this$0.retrieveConstants($schema);
            if (this$1.isNewSchema()) {
                this$0.retrieveRoutinesV2($schema);
            } else {
                this$0.retrieveRoutines($schema);
            }
        }

        private static final Unit retrieveMainContent$lambda$0(H2Introspector this$0, H2SchemaAbstractSchemaRetriever this$1, H2Schema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            if (this$0.isNewSchema()) {
                this$1.retrieveEnumValues(schema);
                this$1.retrieveArrayTypes(schema);
                this$1.retrieveRowFields(schema);
            }
            this$1.retrieveSequences(schema);
            this$1.getModel().writeSources(() -> H2SchemaAbstractSchemaRetriever.retrieveMainContent$lambda$0$0(this$1, schema, this$0));
            this$1.retrieveConstraints(schema);
            this$1.retrieveSynonyms(schema);
            if (this$0.isNewSchema()) {
                this$1.retrieveSourcesV2(schema);
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveEnumValues$lambda$0$0(H2SchemaAbstractSchemaRetriever this$0, H2IntroQueries.EnumValueInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            ((Map)this$0.enumValues).put(info.enum_identifier, ArraysKt.asList((Object[])info.enum_values));
            return Unit.INSTANCE;
        }

        private static final Unit retrieveArrayTypes$lambda$0$0(H2SchemaAbstractSchemaRetriever this$0, H2IntroQueries.ArrayElementInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            ((Map)this$0.arrayElementTypes).put(info.collection_type_identifier, info);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveRowFields$lambda$0$0(H2SchemaAbstractSchemaRetriever this$0, H2IntroQueries.RowFieldInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            this$0.rowFields.putValue((Object)info.row_identifier, (Object)info);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveDomains$lambda$0$0$0(ModNamingFamily $domains, H2SchemaAbstractSchemaRetriever this$0, H2IntroQueries.DomainInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            BasicModNamedElement basicModNamedElement = $domains.createOrGet(info.name);
            H2Domain $this$retrieveDomains_u24lambda_u240_u240_u240_u240 = (H2Domain)basicModNamedElement;
            boolean bl = false;
            $this$retrieveDomains_u24lambda_u240_u240_u240_u240.setStoredType(this$0.getDasType(info));
            $this$retrieveDomains_u24lambda_u240_u240_u240_u240.setDefaultExpression(info.domain_default);
            $this$retrieveDomains_u24lambda_u240_u240_u240_u240.setOnUpdateExpression(info.domain_on_update);
            String string = info.sql;
            $this$retrieveDomains_u24lambda_u240_u240_u240_u240.setSourceText((CompositeText)(string != null ? this$0.toCompositeText(string) : null));
            $this$retrieveDomains_u24lambda_u240_u240_u240_u240.setComment(info.remarks);
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private static final Unit retrieveDomainChecks$lambda$1$0$0(NameCache $domainCache, H2Schema $schema, H2IntroQueries.DomainCheckInfo info) {
            block3: {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                var4_3 /* !! */  = $domainCache;
                name$iv = info.domain_name;
                $i$f$get = false;
                var7_6 = this_$iv;
                var8_7 = name$iv;
                create$iv$iv = false;
                $i$f$get = false;
                if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                v0 = this_$iv$iv.getV();
                Intrinsics.checkNotNull((Object)v0);
                if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv$iv)) {
                    v1 = this_$iv$iv.getV();
                } else lbl-1000:
                // 2 sources

                {
                    var11_10 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, (String)name$iv$iv){
                        final /* synthetic */ boolean $create;
                        final /* synthetic */ String $name;
                        {
                            this.$create = $create;
                            this.$name = $name;
                        }

                        public final T invoke(ModNamingFamily<? extends T> $this$family) {
                            Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                            return (T)(this.$create ? $this$family.createOrGet(this.$name) : (BasicModNamedElement)$this$family.get(this.$name));
                        }
                    };
                    var12_11 = this_$iv$iv;
                    var14_12 = this_$iv$iv;
                    $i$a$-get-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveDomainChecks$2$1$1$domain$1 = false;
                    v2 = $schema.getDomains();
                    Intrinsics.checkNotNullExpressionValue(v2, (String)"getDomains(...)");
                    var14_12.setV((BasicModNamedElement)((H2Domain)it.invoke(v2)));
                    v1 = this_$iv$iv.getV();
                }
                v3 = (H2Domain)v1;
                if (v3 == null) {
                    return Unit.INSTANCE;
                }
                domain = v3;
                v4 = (H2DomainCheck)domain.getChecks().createOrGet(info.constraint_name);
                if (v4 == null) break block3;
                $this$retrieveDomainChecks_u24lambda_u241_u240_u240_u241 /* !! */  = var4_3 /* !! */  = v4;
                $i$a$-apply-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveDomainChecks$2$1$1$1 = false;
                $this$retrieveDomainChecks_u24lambda_u241_u240_u240_u241 /* !! */ .setPredicate(info.check_clause);
                $this$retrieveDomainChecks_u24lambda_u241_u240_u240_u241 /* !! */ .setNameSurrogate(StringsKt.startsWith$default((String)info.constraint_name, (String)"CONSTRAINT_", (boolean)false, (int)2, null));
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveTables$lambda$0$0$0(H2Schema $schema, H2SchemaAbstractSchemaRetriever this$0, H2IntroQueries.TableInfo info) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            if (info.is_view) {
                ModNamingFamily<? extends H2View> modNamingFamily = $schema.getViews();
                object = modNamingFamily;
                Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getViews(...)");
            } else {
                ModNamingFamily<? extends H2Table> modNamingFamily = $schema.getTables();
                object = modNamingFamily;
                Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            }
            Object family = object;
            BasicModNamedElement basicModNamedElement = family.createOrGet(info.table_name);
            H2LikeTable $this$retrieveTables_u24lambda_u240_u240_u240_u240 = (H2LikeTable)basicModNamedElement;
            boolean bl = false;
            if ($this$retrieveTables_u24lambda_u240_u240_u240_u240 instanceof H2Table) {
                ((H2Table)$this$retrieveTables_u24lambda_u240_u240_u240_u240).setTemporary(info.is_temp);
            }
            if ($this$retrieveTables_u24lambda_u240_u240_u240_u240 instanceof H2View) {
                String string = info.sql;
                ((H2View)$this$retrieveTables_u24lambda_u240_u240_u240_u240).setSourceText((CompositeText)(string != null ? this$0.toCompositeText(string) : null));
            }
            $this$retrieveTables_u24lambda_u240_u240_u240_u240.setComment(info.remarks);
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private static final Unit retrieveColumns$lambda$2$0$0(NameCache $tableCache, H2Schema $schema, H2SchemaAbstractSchemaRetriever this$0, H2Introspector this$1, H2IntroQueries.ColumnInfo info) {
            block16: {
                block18: {
                    block19: {
                        block15: {
                            block17: {
                                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                                var7_5 = $tableCache;
                                name$iv = info.table_name;
                                $i$f$get = false;
                                var10_11 = this_$iv;
                                var11_12 = name$iv;
                                create$iv$iv = false;
                                $i$f$get = false;
                                if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                                v0 = this_$iv$iv.getV();
                                Intrinsics.checkNotNull((Object)v0);
                                if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv$iv)) {
                                    v1 = this_$iv$iv.getV();
                                } else lbl-1000:
                                // 2 sources

                                {
                                    var14_17 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, (String)name$iv$iv){
                                        final /* synthetic */ boolean $create;
                                        final /* synthetic */ String $name;
                                        {
                                            this.$create = $create;
                                            this.$name = $name;
                                        }

                                        public final T invoke(ModNamingFamily<? extends T> $this$family) {
                                            Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                                            return (T)(this.$create ? $this$family.createOrGet(this.$name) : (BasicModNamedElement)$this$family.get(this.$name));
                                        }
                                    };
                                    var15_18 = this_$iv$iv;
                                    var20_20 = this_$iv$iv;
                                    $i$a$-get-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveColumns$3$1$1$table$1 = false;
                                    v2 = $schema.getTables();
                                    Intrinsics.checkNotNullExpressionValue(v2, (String)"getTables(...)");
                                    v3 = (H2LikeTable)it.invoke(v2);
                                    if (v3 == null) {
                                        v4 = $schema.getViews();
                                        Intrinsics.checkNotNullExpressionValue(v4, (String)"getViews(...)");
                                        v3 = (H2LikeTable)it.invoke(v4);
                                    }
                                    var20_20.setV((BasicModNamedElement)v3);
                                    v1 = this_$iv$iv.getV();
                                }
                                v5 = (H2LikeTable)v1;
                                if (v5 == null) {
                                    return Unit.INSTANCE;
                                }
                                table = v5;
                                var6_24 = table.getColumns().createOrGetAt(info.ordinal_position);
                                $this$retrieveColumns_u24lambda_u242_u240_u240_u241 = (BasicModTableOrViewColumn)var6_24;
                                $i$a$-apply-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveColumns$3$1$1$1 = false;
                                $this$retrieveColumns_u24lambda_u242_u240_u240_u241.setName(info.column_name);
                                $this$retrieveColumns_u24lambda_u242_u240_u240_u241.setStoredType(this$0.getDasType(info));
                                v6 /* !! */  = $this$retrieveColumns_u24lambda_u242_u240_u240_u241;
                                v7 = info.column_default;
                                if (v7 != null) {
                                    this_$iv$iv = $i$f$get = v7;
                                    var11_12 = v6 /* !! */ ;
                                    $i$a$-takeIf-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveColumns$3$1$1$1$1 = false;
                                    v6 /* !! */  = var11_12;
                                    v8 = Boolean.valueOf(H2Introspector.access$isNewSchema(this$1) != false || info.is_identity == false).booleanValue() ? $i$f$get : null;
                                } else {
                                    v8 = null;
                                }
                                v6 /* !! */ .setDefaultExpression(v8);
                                if (!($this$retrieveColumns_u24lambda_u242_u240_u240_u241 instanceof H2TableColumn)) break block16;
                                if (!H2Introspector.access$isNewSchema(this$1)) break block17;
                                ((H2TableColumn)$this$retrieveColumns_u24lambda_u242_u240_u240_u241).setOnUpdate(info.column_on_update);
                                if (info.is_identity) {
                                    v9 = BasicMetaUtils.getMetaObject((Family)((Family)$schema.getSequences())).newDataObject();
                                    Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"newDataObject(...)");
                                    sequence = (H2Sequence)v9;
                                    this$0.processSequenceLike(sequence, info, info.is_identity);
                                    BasicDataObject.freeze((BasicElement)((BasicElement)sequence));
                                    ((H2TableColumn)$this$retrieveColumns_u24lambda_u242_u240_u240_u241).setSequenceRef((BasicReference)BasicInlineObjectReference.create((BasicElement)((BasicElement)sequence)));
                                } else {
                                    ((H2TableColumn)$this$retrieveColumns_u24lambda_u242_u240_u240_u241).setSequenceRef(null);
                                }
                                break block18;
                            }
                            if (!H2Introspector.access$isV2(this$1)) break block19;
                            columnPsi = SqlPsiElementFactory.createColumnFromText((String)(info.column_name + " " + info.getColumn_type()), (SqlLanguageDialect)((SqlLanguageDialect)H2Dialect.INSTANCE), (Project)H2Introspector.access$getProject(this$1));
                            v10 /* !! */  = columnPsi;
                            if (v10 /* !! */  == null || (v10 /* !! */  = v10 /* !! */ .getConstraints()) == null) ** GOTO lbl-1000
                            $this$firstOrNull$iv = (Iterable)v10 /* !! */ ;
                            $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                it = (SqlConstraintDefinition)element$iv;
                                $i$a$-firstOrNull-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveColumns$3$1$1$1$defaultHolder$1 = false;
                                if (!(it.getConstraintType() == SqlConstraintDefinition.Type.DEFAULT)) continue;
                                v11 = element$iv;
                                break block15;
                            }
                            v11 = null;
                        }
                        if ((v10 /* !! */  = (SqlConstraintDefinition)v11) != null) {
                            v12 = (SqlCompositeElement)v10 /* !! */ ;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v12 = (SqlCompositeElement)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)columnPsi), SqlColumnGeneratedClause.class);
                        }
                        defaultHolder = v12;
                        onUpdateClause = (H2OnUpdateClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)columnPsi), H2OnUpdateClause.class);
                        v13 = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)defaultHolder), SqlExpression.class);
                        ((H2TableColumn)$this$retrieveColumns_u24lambda_u242_u240_u240_u241).setDefaultExpression(v13 != null ? v13.getText() : null);
                        v14 = onUpdateClause;
                        ((H2TableColumn)$this$retrieveColumns_u24lambda_u242_u240_u240_u241).setOnUpdate(v14 != null && (v14 = v14.getExpression()) != null ? v14.getText() : null);
                    }
                    ((H2TableColumn)$this$retrieveColumns_u24lambda_u242_u240_u240_u241).setSequenceRef((BasicReference)BasicNameReference.create((String)info.sequence_name));
                }
                v15 = (H2TableColumn)$this$retrieveColumns_u24lambda_u242_u240_u240_u241;
                if (info.is_generated || Intrinsics.areEqual((Object)info.identity_generation, (Object)"ALWAYS")) {
                    v16 = ColumnKind.GENERATED_VIRTUAL;
                } else if (info.is_identity) {
                    v17 = info.getColumn_type();
                    v16 = (v17 != null ? StringsKt.contains((CharSequence)v17, (CharSequence)"generated always", (boolean)true) : false) ? ColumnKind.GENERATED_VIRTUAL : ColumnKind.GENERATED_STORED;
                } else {
                    v16 = ColumnKind.NORMAL;
                }
                v15.setColumnKind(v16);
                ((H2TableColumn)$this$retrieveColumns_u24lambda_u242_u240_u240_u241).setHidden(info.is_visible == false);
            }
            $this$retrieveColumns_u24lambda_u242_u240_u240_u241.setNotNull(info.is_nullable == false);
            $this$retrieveColumns_u24lambda_u242_u240_u240_u241.setComment(info.remarks);
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private static final Unit retrieveConstraints$lambda$1$0$0(NameCache $tableCache, H2SchemaAbstractSchemaRetriever this$0, H2Introspector this$1, HashMap $constraintMap, H2Schema $schema, H2IntroQueries.ConstraintInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            var8_6 = $tableCache;
            name$iv = info.table_name;
            $i$f$get = false;
            var11_11 = this_$iv;
            var12_15 = name$iv;
            create$iv$iv = false;
            $i$f$get = false;
            if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
            v0 = this_$iv$iv.getV();
            Intrinsics.checkNotNull((Object)v0);
            if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv$iv)) {
                v1 = this_$iv$iv.getV();
            } else lbl-1000:
            // 2 sources

            {
                var15_19 /* !! */  = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, (String)name$iv$iv){
                    final /* synthetic */ boolean $create;
                    final /* synthetic */ String $name;
                    {
                        this.$create = $create;
                        this.$name = $name;
                    }

                    public final T invoke(ModNamingFamily<? extends T> $this$family) {
                        Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                        return (T)(this.$create ? $this$family.createOrGet(this.$name) : (BasicModNamedElement)$this$family.get(this.$name));
                    }
                };
                var16_20 = this_$iv$iv;
                var18_22 = this_$iv$iv;
                $i$a$-get-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveConstraints$1$1$1$table$1 = false;
                v2 = $schema.getTables();
                Intrinsics.checkNotNullExpressionValue(v2, (String)"getTables(...)");
                var18_22.setV((BasicModNamedElement)((H2Table)it.invoke(v2)));
                v1 = this_$iv$iv.getV();
            }
            v3 = (H2Table)v1;
            if (v3 == null) {
                return Unit.INSTANCE;
            }
            table = v3;
            v4 = info.unique_index_name;
            if (v4 != null) {
                it = v4;
                $i$a$-let-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveConstraints$1$1$1$index$1 = false;
                v5 = (H2Index)table.getIndices().get(it);
            } else {
                v5 = null;
            }
            if ((v6 = (index = v5)) == null || (v6 = v6.getColNames()) == null) {
                v7 = info.column_list;
                if (v7 == null) {
                    v7 = "";
                }
                v6 = this$0.parseColumnList(v7);
            }
            colNames = v6;
            it = info.constraint_type;
            tmp = -1;
            switch (it.hashCode()) {
                case 1284802305: {
                    if (it.equals("PRIMARY KEY")) {
                        tmp = 1;
                    }
                    break;
                }
                case -1787199535: {
                    if (it.equals("UNIQUE")) {
                        tmp = 2;
                    }
                    break;
                }
                case 64089320: {
                    if (it.equals("CHECK")) {
                        tmp = 3;
                    }
                    break;
                }
                case 704200915: {
                    if (it.equals("FOREIGN KEY")) {
                        tmp = 4;
                    }
                    break;
                }
                case 2137260521: {
                    if (it.equals("REFERENTIAL")) {
                        tmp = 4;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 1: {
                    v8 = table.getKeys();
                    Intrinsics.checkNotNullExpressionValue(v8, (String)"getKeys(...)");
                    $this$retrieveConstraints_u24lambda_u241_u240_u240_u242 = var11_13 = this$0.renewConstraint(v8, info.constraint_name, colNames);
                    $i$a$-apply-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveConstraints$1$1$1$constraint$1 = false;
                    $this$retrieveConstraints_u24lambda_u241_u240_u240_u242.setPrimary(true);
                    v9 /* !! */  = var11_13;
                    break;
                }
                case 2: {
                    v10 = table.getKeys();
                    Intrinsics.checkNotNullExpressionValue(v10, (String)"getKeys(...)");
                    v9 /* !! */  = this$0.renewConstraint(v10, info.constraint_name, colNames);
                    break;
                }
                case 3: {
                    v11 = table.getChecks();
                    Intrinsics.checkNotNullExpressionValue(v11, (String)"getChecks(...)");
                    $this$retrieveConstraints_u24lambda_u241_u240_u240_u243 = var11_14 = this$0.renewConstraint(v11, info.constraint_name, colNames);
                    $i$a$-apply-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveConstraints$1$1$1$constraint$2 = false;
                    v12 = $this$retrieveConstraints_u24lambda_u241_u240_u240_u243;
                    v13 = info.check_expression;
                    if (v13 != null) {
                        $i$f$get = v13;
                        var15_19 /* !! */  = v12;
                        $i$a$-let-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveConstraints$1$1$1$constraint$2$1 = false;
                        v14 = this$0.removeParens((String)it);
                        v12 = var15_19 /* !! */ ;
                    } else {
                        v14 = null;
                    }
                    v12.setPredicate(v14);
                    v9 /* !! */  = var11_14;
                    break;
                }
                case 4: {
                    v15 = table.getForeignKeys();
                    Intrinsics.checkNotNullExpressionValue(v15, (String)"getForeignKeys(...)");
                    v9 /* !! */  = this$0.renewConstraint(v15, info.constraint_name, colNames);
                    break;
                }
                default: {
                    return Unit.INSTANCE;
                }
            }
            constraint /* !! */  = v9 /* !! */ ;
            key = H2Introspector.access$isNewSchema(this$1) != false ? (Serializable)info.constraint_name : (Serializable)TuplesKt.to((Object)info.table_name, (Object)info.constraint_name);
            ((Map)$constraintMap).put(key, constraint /* !! */ );
            constraint /* !! */ .setNameSurrogate(StringsKt.startsWith$default((String)info.constraint_name, (String)"CONSTRAINT_", (boolean)false, (int)2, null));
            constraint /* !! */ .setColNames(colNames);
            constraint /* !! */ .setComment(info.remarks);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveConstraints$lambda$1$0$1(H2Introspector this$0, HashMap $constraintMap, H2SchemaAbstractSchemaRetriever this$1, H2IntroQueries.ForeignKeyInfo info) {
            BasicReference basicReference;
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            H2Constraint h2Constraint = this$0.isNewSchema() ? (H2Constraint)$constraintMap.get(info.fk_name) : (H2Constraint)$constraintMap.get(TuplesKt.to((Object)info.fktable_name, (Object)info.fk_name));
            H2ForeignKey h2ForeignKey = h2Constraint instanceof H2ForeignKey ? (H2ForeignKey)h2Constraint : null;
            if (h2ForeignKey == null) {
                return Unit.INSTANCE;
            }
            H2ForeignKey key = h2ForeignKey;
            BasicNameReference nameRef = BasicNameReference.create((String)info.pk_name);
            if (this$0.isV2()) {
                key.setRefKeyRef((BasicReference)nameRef);
            } else {
                key.setRefKeyRef((BasicReference)BasicKeyByIndexReference.create((BasicReference)((BasicReference)nameRef)));
            }
            H2ForeignKey h2ForeignKey2 = key;
            if (this$0.isNewSchema()) {
                H2Constraint h2Constraint2 = (H2Constraint)$constraintMap.get(info.pk_name);
                DasTable dasTable = h2Constraint2 != null ? h2Constraint2.getTable() : null;
                H2LikeTable h2LikeTable = dasTable instanceof H2LikeTable ? (H2LikeTable)dasTable : null;
                if (h2LikeTable != null) {
                    void it;
                    H2LikeTable h2LikeTable2 = h2LikeTable;
                    H2ForeignKey h2ForeignKey3 = h2ForeignKey2;
                    boolean bl = false;
                    basicReference = BasicParentReference.create((String)it.getSchemaName(), (BasicReference)((BasicReference)BasicNameReference.create((String)it.getName())));
                    h2ForeignKey2 = h2ForeignKey3;
                } else {
                    basicReference = null;
                }
            } else {
                String string;
                String it = string = info.pktable_name;
                H2ForeignKey h2ForeignKey4 = h2ForeignKey2;
                boolean bl = false;
                boolean bl2 = ((CharSequence)it).length() > 0;
                h2ForeignKey2 = h2ForeignKey4;
                String string2 = bl2 ? string : null;
                if (string2 != null) {
                    it = string2;
                    h2ForeignKey4 = h2ForeignKey2;
                    boolean bl3 = false;
                    basicReference = BasicParentReference.create((String)info.pktable_schema, (BasicReference)((BasicReference)BasicNameReference.create((String)info.pktable_name)));
                    h2ForeignKey2 = h2ForeignKey4;
                } else {
                    basicReference = null;
                }
            }
            h2ForeignKey2.setRefTableRef(basicReference);
            key.setOnUpdate(this$1.getCascadeRule(info.update_rule));
            key.setOnDelete(this$1.getCascadeRule(info.delete_rule));
            return Unit.INSTANCE;
        }

        private static final Unit retrieveConstraints$lambda$1$0$2(HashMap $constraintMap, H2IntroQueries.CheckInfo info) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                Object v = $constraintMap.get(info.constraint_name);
                H2Check h2Check = v instanceof H2Check ? (H2Check)v : null;
                if (h2Check == null) break block0;
                h2Check.setPredicate(info.check_clause);
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveConstraints$lambda$1$0$3(HashMap $constraintMap, MultiMap $keyColumnNames, H2IntroQueries.ForeignKeyColumnInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            H2Constraint h2Constraint = (H2Constraint)$constraintMap.get(info.constraint_name);
            if (h2Constraint == null) {
                return Unit.INSTANCE;
            }
            H2Constraint key = h2Constraint;
            if (!$keyColumnNames.get((Object)key).contains(info.column_name)) {
                $keyColumnNames.putValue((Object)key, (Object)info.column_name);
            }
            return Unit.INSTANCE;
        }

        private static final boolean renewConstraint$lambda$0(List $colNames, H2Constraint it) {
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return ((CharSequence)string).length() == 0 && ((BasicModMixinElement)it).isSyncPending() && Intrinsics.areEqual((Object)((BasicColumniation)it).getColNames(), (Object)$colNames);
        }

        private static final boolean renewConstraint$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveIndexes$lambda$1$0$0(NameCache $tableCache, H2Schema $schema, H2IntroQueries.IndexInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            var5_3 = $tableCache;
            name$iv = info.table_name;
            $i$f$get = false;
            var8_7 = this_$iv;
            var9_8 = name$iv;
            create$iv$iv = false;
            $i$f$get = false;
            if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
            v0 = this_$iv$iv.getV();
            Intrinsics.checkNotNull((Object)v0);
            if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv$iv)) {
                v1 = this_$iv$iv.getV();
            } else lbl-1000:
            // 2 sources

            {
                var12_11 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, (String)name$iv$iv){
                    final /* synthetic */ boolean $create;
                    final /* synthetic */ String $name;
                    {
                        this.$create = $create;
                        this.$name = $name;
                    }

                    public final T invoke(ModNamingFamily<? extends T> $this$family) {
                        Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                        return (T)(this.$create ? $this$family.createOrGet(this.$name) : (BasicModNamedElement)$this$family.get(this.$name));
                    }
                };
                var13_12 = this_$iv$iv;
                var15_13 = this_$iv$iv;
                $i$a$-get-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveIndexes$2$1$1$table$1 = false;
                v2 = $schema.getTables();
                Intrinsics.checkNotNullExpressionValue(v2, (String)"getTables(...)");
                var15_13.setV((BasicModNamedElement)((H2Table)it.invoke(v2)));
                v1 = this_$iv$iv.getV();
            }
            v3 = (H2Table)v1;
            if (v3 == null) {
                return Unit.INSTANCE;
            }
            table = v3;
            var4_16 = table.getIndices().createOrGet(info.index_name);
            $this$retrieveIndexes_u24lambda_u241_u240_u240_u241 = (H2Index)var4_16;
            $i$a$-apply-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveIndexes$2$1$1$1 = false;
            $this$retrieveIndexes_u24lambda_u241_u240_u240_u241.setNameSurrogate(info.is_generated);
            $this$retrieveIndexes_u24lambda_u241_u240_u240_u241.setUnique(info.non_unique == false);
            $this$retrieveIndexes_u24lambda_u241_u240_u240_u241.setComment(info.remarks);
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveIndexes$lambda$1$0$1(NameCache $tableCache, NameCache $indexCache, ArrayList $indexColumns, H2SchemaAbstractSchemaRetriever this$0, H2Schema $schema, H2IntroQueries.IndexColumnInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            var8_6 = $tableCache;
            name$iv = info.table_name;
            $i$f$get = false;
            var11_11 = this_$iv;
            var12_12 = name$iv;
            create$iv$iv = false;
            $i$f$get = false;
            if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
            v0 = this_$iv$iv.getV();
            Intrinsics.checkNotNull((Object)v0);
            if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv$iv)) {
                v1 = this_$iv$iv.getV();
            } else lbl-1000:
            // 2 sources

            {
                var15_17 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, (String)name$iv$iv){
                    final /* synthetic */ boolean $create;
                    final /* synthetic */ String $name;
                    {
                        this.$create = $create;
                        this.$name = $name;
                    }

                    public final T invoke(ModNamingFamily<? extends T> $this$family) {
                        Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                        return (T)(this.$create ? $this$family.createOrGet(this.$name) : (BasicModNamedElement)$this$family.get(this.$name));
                    }
                };
                var16_18 = this_$iv$iv;
                var18_20 = this_$iv$iv;
                $i$a$-get-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveIndexes$2$1$2$table$1 = false;
                H2SchemaAbstractSchemaRetriever.access$applyIndexColumns(this$0, (H2Index)$indexCache.getV(), $indexColumns);
                $indexCache.setV(null);
                v2 = $schema.getTables();
                Intrinsics.checkNotNullExpressionValue(v2, (String)"getTables(...)");
                var18_20.setV((BasicModNamedElement)((H2Table)it.invoke(v2)));
                v1 = this_$iv$iv.getV();
            }
            v3 = (H2Table)v1;
            if (v3 == null) {
                return Unit.INSTANCE;
            }
            table = v3;
            var7_23 = $indexCache;
            name$iv = info.index_name;
            $i$f$get = false;
            $i$f$get = this_$iv;
            this_$iv$iv = name$iv;
            create$iv$iv = false;
            $i$f$get = false;
            if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
            v4 = this_$iv$iv.getV();
            Intrinsics.checkNotNull((Object)v4);
            if (Intrinsics.areEqual((Object)v4.getName(), (Object)name$iv$iv)) {
                v5 = this_$iv$iv.getV();
            } else lbl-1000:
            // 2 sources

            {
                $i$f$get = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, (String)name$iv$iv){
                    final /* synthetic */ boolean $create;
                    final /* synthetic */ String $name;
                    {
                        this.$create = $create;
                        this.$name = $name;
                    }

                    public final T invoke(ModNamingFamily<? extends T> $this$family) {
                        Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                        return (T)(this.$create ? $this$family.createOrGet(this.$name) : (BasicModNamedElement)$this$family.get(this.$name));
                    }
                };
                it = this_$iv$iv;
                var18_20 = this_$iv$iv;
                $i$a$-get-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveIndexes$2$1$2$1 = false;
                H2SchemaAbstractSchemaRetriever.access$applyIndexColumns(this$0, (H2Index)$indexCache.getV(), $indexColumns);
                v6 = table.getIndices();
                Intrinsics.checkNotNullExpressionValue(v6, (String)"getIndices(...)");
                var18_20.setV((BasicModNamedElement)((H2Index)it.invoke(v6)));
                v5 = this_$iv$iv.getV();
            }
            ((Collection)$indexColumns).add(info);
            return Unit.INSTANCE;
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveTriggers$lambda$1$0$0(NameCache $tableCache, H2Schema $schema, H2SchemaAbstractSchemaRetriever this$0, H2IntroQueries.TriggerInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            var6_4 = $tableCache;
            name$iv = info.table_name;
            $i$f$get = false;
            var9_8 = this_$iv;
            var10_9 = name$iv;
            create$iv$iv = false;
            $i$f$get = false;
            if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
            v0 = this_$iv$iv.getV();
            Intrinsics.checkNotNull((Object)v0);
            if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv$iv)) {
                v1 = this_$iv$iv.getV();
            } else lbl-1000:
            // 2 sources

            {
                var13_12 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, (String)name$iv$iv){
                    final /* synthetic */ boolean $create;
                    final /* synthetic */ String $name;
                    {
                        this.$create = $create;
                        this.$name = $name;
                    }

                    public final T invoke(ModNamingFamily<? extends T> $this$family) {
                        Intrinsics.checkNotNullParameter($this$family, (String)"$this$family");
                        return (T)(this.$create ? $this$family.createOrGet(this.$name) : (BasicModNamedElement)$this$family.get(this.$name));
                    }
                };
                var14_13 = this_$iv$iv;
                var16_14 = this_$iv$iv;
                $i$a$-get-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveTriggers$2$1$1$table$1 = false;
                v2 = $schema.getTables();
                Intrinsics.checkNotNullExpressionValue(v2, (String)"getTables(...)");
                var16_14.setV((BasicModNamedElement)((H2Table)it.invoke(v2)));
                v1 = this_$iv$iv.getV();
            }
            v3 = (H2Table)v1;
            if (v3 == null) {
                return Unit.INSTANCE;
            }
            table = v3;
            var5_17 = table.getTriggers().createOrGet(info.trigger_name);
            $this$retrieveTriggers_u24lambda_u241_u240_u240_u241 = (H2Trigger)var5_17;
            $i$a$-apply-H2Introspector$H2SchemaAbstractSchemaRetriever$retrieveTriggers$2$1$1$1 = false;
            $this$retrieveTriggers_u24lambda_u241_u240_u240_u241.setSchemaName(info.trigger_schema);
            v4 = info.sql;
            $this$retrieveTriggers_u24lambda_u241_u240_u240_u241.setSourceText((CompositeText)(v4 != null ? this$0.toCompositeText(v4) : null));
            $this$retrieveTriggers_u24lambda_u241_u240_u240_u241.setTurn(H2IntrospectorKt.access$asTrigTurn(info));
            $this$retrieveTriggers_u24lambda_u241_u240_u240_u241.setEvents(SetsKt.setOf((Object)H2IntrospectorKt.access$asEvent(info)));
            $this$retrieveTriggers_u24lambda_u241_u240_u240_u241.setComment(info.remarks);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveSequences$lambda$0$0$0(ModNamingFamily $sequences, H2SchemaAbstractSchemaRetriever this$0, Ref.IntRef $order, H2IntroQueries.SequenceInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            H2Sequence sequence = (H2Sequence)$sequences.createOrGet(info.sequence_name);
            Intrinsics.checkNotNull((Object)sequence);
            H2SchemaAbstractSchemaRetriever.processSequenceLike$default(this$0, sequence, info, false, 4, null);
            sequence.setNameSurrogate(info.is_generated);
            Object object = StringKt.nullize$default((String)info.remarks, (boolean)false, (int)1, null);
            if (object == null) {
                if (info.is_generated) {
                    ++$order.element;
                    object = "#" + $order.element;
                } else {
                    object = null;
                }
            }
            sequence.setComment((String)object);
            return Unit.INSTANCE;
        }

        private static final boolean retrieveRoutines$lambda$0$0$0$0(String $aliasName, int $colCount, H2Routine it) {
            return Intrinsics.areEqual((Object)((H2LikeRoutine)it).getName(), (Object)$aliasName) && ((H2LikeRoutine)it).getArguments().size() == $colCount + 1;
        }

        private static final boolean retrieveRoutines$lambda$0$0$0$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final Unit retrieveRoutines$lambda$0$0$0(ModNamingFamily $aggregates, ModNamingFamily $routines, HashMap $aliasMap, H2SchemaAbstractSchemaRetriever this$0, H2IntroQueries.RoutineInfo info) {
            H2LikeRoutine h2LikeRoutine;
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            String aliasName = info.alias_name;
            int colCount = info.column_count;
            Object object = info.source;
            if ((object == null || object.length() == 0) && ((object = (CharSequence)info.java_method) == null || object.length() == 0)) {
                h2LikeRoutine = (H2LikeRoutine)$aggregates.createOrGet(aliasName);
            } else {
                Object object2;
                object = (H2Routine)$routines.find(arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveRoutines$lambda$0$0$0$1(arg_0 -> H2SchemaAbstractSchemaRetriever.retrieveRoutines$lambda$0$0$0$0(aliasName, colCount, arg_0), arg_0));
                if (object != null) {
                    Object object3;
                    Object $this$retrieveRoutines_u24lambda_u240_u240_u240_u242 = object3 = object;
                    boolean bl = false;
                    $this$retrieveRoutines_u24lambda_u240_u240_u240_u242.resetSyncPending();
                    object2 = object3;
                } else {
                    BasicModElement basicModElement = $routines.createNewOne();
                    Intrinsics.checkNotNullExpressionValue((Object)basicModElement, (String)"createNewOne(...)");
                    BasicModElement basicModElement2 = basicModElement;
                    H2Routine $this$retrieveRoutines_u24lambda_u240_u240_u240_u243 = (H2Routine)basicModElement2;
                    boolean bl = false;
                    $this$retrieveRoutines_u24lambda_u240_u240_u240_u243.setName(aliasName);
                    object2 = (H2Routine)basicModElement2;
                }
                h2LikeRoutine = (H2LikeRoutine)object2;
            }
            H2LikeRoutine routine = h2LikeRoutine;
            object = $aliasMap;
            object.put(aliasName + "/" + colCount, routine);
            H2LikeRoutine $this$retrieveRoutines_u24lambda_u240_u240_u240_u244 = routine;
            boolean bl = false;
            $this$retrieveRoutines_u24lambda_u240_u240_u240_u244.setRoutineKind(info.is_func ? DasRoutine.Kind.FUNCTION : DasRoutine.Kind.PROCEDURE);
            if ($this$retrieveRoutines_u24lambda_u240_u240_u240_u244 instanceof H2Routine) {
                ((H2Routine)$this$retrieveRoutines_u24lambda_u240_u240_u240_u244).setJavaClass(info.java_class);
                String string = info.source;
                ((H2Routine)$this$retrieveRoutines_u24lambda_u240_u240_u240_u244).setSourceText((CompositeText)(string != null && (string = StringKt.nullize$default((String)string, (boolean)false, (int)1, null)) != null ? this$0.toCompositeText(string) : null));
                ((H2Routine)$this$retrieveRoutines_u24lambda_u240_u240_u240_u244).setJavaMethod(info.java_method);
            } else {
                $this$retrieveRoutines_u24lambda_u240_u240_u240_u244.setJavaClass(info.java_class);
            }
            $this$retrieveRoutines_u24lambda_u240_u240_u240_u244.setComment(info.remarks);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveRoutines$lambda$2$0$0(HashMap $aliasMap, H2SchemaAbstractSchemaRetriever this$0, H2IntroQueries.RoutineArgumentInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            H2LikeRoutine h2LikeRoutine = (H2LikeRoutine)$aliasMap.get(info.alias_name + "/" + info.column_count);
            if (h2LikeRoutine == null) {
                return Unit.INSTANCE;
            }
            H2LikeRoutine routine = h2LikeRoutine;
            BasicModElement basicModElement = routine.getArguments().createOrGetAt(info.pos);
            H2Argument $this$retrieveRoutines_u24lambda_u242_u240_u240_u240 = (H2Argument)basicModElement;
            boolean bl = false;
            $this$retrieveRoutines_u24lambda_u242_u240_u240_u240.setName(info.column_name);
            $this$retrieveRoutines_u24lambda_u242_u240_u240_u240.setArgumentDirection(info._column_type == 5 ? ArgumentDirection.RETURN : ArgumentDirection.IN);
            $this$retrieveRoutines_u24lambda_u242_u240_u240_u240.setStoredType(this$0.getDasType(info));
            return Unit.INSTANCE;
        }

        private static final Unit retrieveRoutinesV2$lambda$0$0$2(ModNamingFamily $aggregates, ModNamingFamily $routines, HashMap $routineMap, H2SchemaAbstractSchemaRetriever this$0, H2IntroQueries.RoutineInfoV2 info) {
            H2LikeRoutine h2LikeRoutine;
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            String routineName = info.routine_name;
            String string = info.specific_name;
            if (string == null) {
                return Unit.INSTANCE;
            }
            String specificName = string;
            boolean isAggregate = Intrinsics.areEqual((Object)info.routine_type, (Object)"AGGREGATE");
            boolean isFunction = Intrinsics.areEqual((Object)info.routine_type, (Object)"FUNCTION");
            ModNamingFamily family = isAggregate ? $aggregates : $routines;
            H2LikeRoutine h2LikeRoutine2 = (H2LikeRoutine)$routineMap.get(specificName);
            if (h2LikeRoutine2 != null) {
                H2LikeRoutine $this$retrieveRoutinesV2_u24lambda_u240_u240_u242_u240 = var13_10 = h2LikeRoutine2;
                boolean bl = false;
                $this$retrieveRoutinesV2_u24lambda_u240_u240_u242_u240.resetSyncPending();
                h2LikeRoutine = var13_10;
            } else {
                BasicModElement basicModElement = family.createNewOne();
                Intrinsics.checkNotNullExpressionValue((Object)basicModElement, (String)"createNewOne(...)");
                H2LikeRoutine $this$retrieveRoutinesV2_u24lambda_u240_u240_u242_u241 = var13_10 = basicModElement;
                boolean bl = false;
                $this$retrieveRoutinesV2_u24lambda_u240_u240_u242_u241.setName(routineName);
                ((Map)$routineMap).put(specificName, $this$retrieveRoutinesV2_u24lambda_u240_u240_u242_u241);
                h2LikeRoutine = var13_10;
            }
            H2LikeRoutine routine = h2LikeRoutine;
            routine.setSpecificName(specificName);
            H2LikeRoutine $this$retrieveRoutinesV2_u24lambda_u240_u240_u242_u242 = routine;
            boolean bl = false;
            $this$retrieveRoutinesV2_u24lambda_u240_u240_u242_u242.setRoutineKind(isFunction ? DasRoutine.Kind.FUNCTION : DasRoutine.Kind.PROCEDURE);
            if ($this$retrieveRoutinesV2_u24lambda_u240_u240_u242_u242 instanceof H2Routine) {
                ((H2Routine)$this$retrieveRoutinesV2_u24lambda_u240_u240_u242_u242).setJavaClass(this$0.javaClassName(info));
                ((H2Routine)$this$retrieveRoutinesV2_u24lambda_u240_u240_u242_u242).setJavaMethod(this$0.javaMethodName(info));
                String string2 = info.routine_definition;
                ((H2Routine)$this$retrieveRoutinesV2_u24lambda_u240_u240_u242_u242).setSourceText((CompositeText)(string2 != null && (string2 = StringKt.nullize$default((String)string2, (boolean)false, (int)1, null)) != null ? this$0.toCompositeText(string2) : null));
            } else {
                $this$retrieveRoutinesV2_u24lambda_u240_u240_u242_u242.setJavaClass(info.external_name);
            }
            if (isFunction) {
                $this$retrieveRoutinesV2_u24lambda_u240_u240_u242_u242.createOrGetReturnArgument().setStoredType(this$0.getDasType(info));
            }
            $this$retrieveRoutinesV2_u24lambda_u240_u240_u242_u242.setComment(info.remarks);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveRoutinesV2$lambda$2$0$0(HashMap $routineMap, H2SchemaAbstractSchemaRetriever this$0, H2IntroQueries.RoutineArgumentInfoV2 info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            H2LikeRoutine h2LikeRoutine = (H2LikeRoutine)$routineMap.get(info.specific_name);
            if (h2LikeRoutine == null) {
                return Unit.INSTANCE;
            }
            H2LikeRoutine routine = h2LikeRoutine;
            BasicModElement basicModElement = routine.getArguments().createOrGetAt(info.ordinal_position);
            H2Argument $this$retrieveRoutinesV2_u24lambda_u242_u240_u240_u240 = (H2Argument)basicModElement;
            boolean bl = false;
            $this$retrieveRoutinesV2_u24lambda_u242_u240_u240_u240.setName(info.parameter_name);
            $this$retrieveRoutinesV2_u24lambda_u242_u240_u240_u240.setArgumentDirection(ArgumentDirection.IN);
            $this$retrieveRoutinesV2_u24lambda_u242_u240_u240_u240.setStoredType(this$0.getDasType(info));
            return Unit.INSTANCE;
        }

        private static final Unit retrieveConstants$lambda$0$0$0(ModNamingFamily $constants, H2IntroQueries.ConstantInfo info) {
            String string;
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            BasicModNamedElement basicModNamedElement = $constants.createOrGet(info.constant_name);
            H2Constant $this$retrieveConstants_u24lambda_u240_u240_u240_u240 = (H2Constant)basicModNamedElement;
            boolean bl = false;
            int num = StringUtil.parseInt((String)info.data_type, (int)Integer.MIN_VALUE);
            if (num == Integer.MIN_VALUE) {
                string = info.data_type;
            } else {
                String string2 = JdbcUtil.getJdbcTypeName((int)num);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getJdbcTypeName(...)");
            }
            String typeName = string;
            Intrinsics.checkNotNull((Object)$this$retrieveConstants_u24lambda_u240_u240_u240_u240);
            DasTypeSystemBase dasTypeSystemBase = DasTypeUtilsKt.getTypeSystem((BasicElement)((BasicElement)$this$retrieveConstants_u24lambda_u240_u240_u240_u240));
            DataType dataType = DataTypeFactory.of((String)typeName);
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
            $this$retrieveConstants_u24lambda_u240_u240_u240_u240.setStoredType(dasTypeSystemBase.createDasType(dataType));
            $this$retrieveConstants_u24lambda_u240_u240_u240_u240.setValue(info.sql);
            $this$retrieveConstants_u24lambda_u240_u240_u240_u240.setComment(info.remarks);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveSynonyms$lambda$0$0$0(ModNamingFamily $synonyms, H2IntroQueries.SynonymInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            BasicModNamedElement basicModNamedElement = $synonyms.createOrGet(info.synonym_name);
            H2Synonym $this$retrieveSynonyms_u24lambda_u240_u240_u240_u240 = (H2Synonym)basicModNamedElement;
            boolean bl = false;
            $this$retrieveSynonyms_u24lambda_u240_u240_u240_u240.setTargetObjectRef(BasicParentReference.create((String)info.synonym_for_schema, (BasicReference)((BasicReference)BasicNameReference.create((String)info.synonym_for))));
            $this$retrieveSynonyms_u24lambda_u240_u240_u240_u240.setComment(info.remarks);
            return Unit.INSTANCE;
        }

        private static final void retrieveSourcesV2$lambda$0(H2SchemaAbstractSchemaRetriever this$0, H2Schema $schema) {
            this$0.retrieveViewSources($schema);
            this$0.retrieveTriggerSources($schema);
        }

        private static final Unit retrieveViewSources$lambda$0(H2Schema $schema, H2SchemaAbstractSchemaRetriever this$0, H2IntroQueries.SourceInfo info) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                H2View h2View = (H2View)$schema.getViews().get(info.name);
                if (h2View == null) break block0;
                String string = info.sql;
                ((BasicModSourceAware)h2View).setSourceText((CompositeText)(string != null ? this$0.toCompositeText(string) : null));
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveTriggerSources$lambda$0(HashMap $triggerMap, H2SchemaAbstractSchemaRetriever this$0, H2IntroQueries.SourceInfo info) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                H2Trigger h2Trigger = (H2Trigger)$triggerMap.get(info.name);
                if (h2Trigger == null) break block0;
                String string = info.sql;
                h2Trigger.setSourceText((CompositeText)(string != null ? this$0.toCompositeText(string) : null));
            }
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ void access$applyIndexColumns(H2SchemaAbstractSchemaRetriever $this, H2Index index, List columns) {
            $this.applyIndexColumns(index, columns);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/h2/introspector/H2Introspector$Interval;", "", "<init>", "(Ljava/lang/String;I)V", "YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND", "intellij.database.dialects.h2"})
    private static final class Interval
    extends Enum<Interval> {
        public static final /* enum */ Interval YEAR = new Interval();
        public static final /* enum */ Interval MONTH = new Interval();
        public static final /* enum */ Interval DAY = new Interval();
        public static final /* enum */ Interval HOUR = new Interval();
        public static final /* enum */ Interval MINUTE = new Interval();
        public static final /* enum */ Interval SECOND = new Interval();
        private static final /* synthetic */ Interval[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Interval[] values() {
            return (Interval[])$VALUES.clone();
        }

        public static Interval valueOf(String value) {
            return Enum.valueOf(Interval.class, value);
        }

        @NotNull
        public static EnumEntries<Interval> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = intervalArray = new Interval[]{Interval.YEAR, Interval.MONTH, Interval.DAY, Interval.HOUR, Interval.MINUTE, Interval.SECOND};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

