/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.bigquery.psi;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.bigquery.psi.BigQueryPivotedQueryExpressionImpl$getSimpleFakeColumnName$;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTimeLiteralExpression;
import com.intellij.sql.psi.impl.SqlNumericLiteralExpressionImpl;
import com.intellij.sql.psi.impl.SqlPivotedQueryExpressionImpl;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u001a\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u0007H\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/sql/dialects/bigquery/psi/BigQueryPivotedQueryExpressionImpl;", "Lcom/intellij/sql/psi/impl/SqlPivotedQueryExpressionImpl;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "getSimpleFakeColumnName", "", "column", "Lcom/intellij/sql/psi/SqlExpression;", "getFullFakeColumnName", "columnName", "valueName", "intellij.database.dialects.bigquery"})
@SourceDebugExtension(value={"SMAP\nBigQueryPivotedQueryExpressionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BigQueryPivotedQueryExpressionImpl.kt\ncom/intellij/sql/dialects/bigquery/psi/BigQueryPivotedQueryExpressionImpl\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,63:1\n479#2:64\n*S KotlinDebug\n*F\n+ 1 BigQueryPivotedQueryExpressionImpl.kt\ncom/intellij/sql/dialects/bigquery/psi/BigQueryPivotedQueryExpressionImpl\n*L\n41#1:64\n*E\n"})
public class BigQueryPivotedQueryExpressionImpl
extends SqlPivotedQueryExpressionImpl {
    public BigQueryPivotedQueryExpressionImpl(@NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        super(elementType);
    }

    @Nullable
    protected String getSimpleFakeColumnName(@NotNull SqlExpression column) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        if (SqlPsiUtilKt.isNull((PsiElement)((PsiElement)column))) {
            String string = column.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = string.toUpperCase(Locale.ROOT);
            object = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        } else if (SqlPsiUtilKt.isFalse((PsiElement)((PsiElement)column)) || SqlPsiUtilKt.isTrue((PsiElement)((PsiElement)column))) {
            String string = column.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string3 = string.toLowerCase(Locale.ROOT);
            object = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        } else if (column instanceof SqlNumericLiteralExpressionImpl) {
            String string = ((SqlNumericLiteralExpressionImpl)column).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            Object text = string;
            if (StringsKt.startsWith$default((String)text, (String)"-", (boolean)false, (int)2, null)) {
                String string4 = ((String)text).substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                text = "minus_" + string4;
            } else {
                text = "_" + (String)text;
            }
            object = StringsKt.replace$default((String)text, (String)"\\.", (String)"_point_", (boolean)false, (int)4, null);
        } else if (column instanceof SqlStringLiteralExpression) {
            object = ((SqlStringLiteralExpression)column).getValue();
        } else if (column instanceof SqlTimeLiteralExpression) {
            PsiElement psiElement = ((SqlTimeLiteralExpression)column).getFirstChild();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getFirstChild(...)");
            Object $this$filterIsInstance$iv = PsiTreeUtilKt.siblings$default((PsiElement)psiElement, (boolean)false, (boolean)false, (int)3, null);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getSimpleFakeColumnName$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Object object2 = (SqlStringLiteralExpression)SequencesKt.firstOrNull((Sequence)sequence);
            if (object2 == null || (object2 = object2.getValue()) == null) {
                return null;
            }
            Object s = object2;
            $this$filterIsInstance$iv = new char[1];
            $this$filterIsInstance$iv[0] = (Sequence)45;
            List parts = StringsKt.split$default((CharSequence)((CharSequence)s), (char[])$this$filterIsInstance$iv, (boolean)false, (int)0, (int)6, null);
            if (parts.size() != 3) {
                return null;
            }
            String year = (String)parts.get(0);
            Object month = (String)parts.get(1);
            Object day = (String)parts.get(2);
            if (((String)month).length() == 1) {
                month = "0" + (String)month;
            }
            if (((String)day).length() == 1) {
                day = "0" + (String)day;
            }
            object = "_" + year + "_" + (String)month + "_" + (String)day;
        } else {
            object = super.getSimpleFakeColumnName(column);
        }
        return object;
    }

    @NotNull
    protected String getFullFakeColumnName(@NotNull String columnName, @Nullable String valueName) {
        Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
        if (valueName != null) {
            return StringsKt.startsWith$default((CharSequence)columnName, (char)'_', (boolean)false, (int)2, null) ? valueName + columnName : valueName + "_" + columnName;
        }
        if (Intrinsics.areEqual((Object)columnName, (Object)"NULL")) {
            return "`" + columnName + "`";
        }
        return columnName;
    }
}

