/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.lang.documentation.ide.impl.DocumentationManager;
import com.intellij.model.Pointer;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogApplicationSettings;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.ui.table.links.IssueLinkTag;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J \u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/vcs/log/ui/table/VcsLogGraphTableLinkPreviewSupport;", "Ljava/awt/event/MouseAdapter;", "table", "Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;", "<init>", "(Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;)V", "session", "Lcom/intellij/vcs/log/ui/table/VcsLogGraphTableLinkPreviewSupport$LinkPreviewSession;", "mouseMoved", "", "e", "Ljava/awt/event/MouseEvent;", "mouseExited", "startShowingDoc", "tag", "Lcom/intellij/vcs/log/ui/table/links/IssueLinkTag;", "row", "", "mousePosition", "Ljava/awt/Point;", "LinkPreviewSession", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogGraphTableLinkPreviewSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogGraphTableLinkPreviewSupport.kt\ncom/intellij/vcs/log/ui/table/VcsLogGraphTableLinkPreviewSupport\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,91:1\n30#2,2:92\n30#2,2:94\n*S KotlinDebug\n*F\n+ 1 VcsLogGraphTableLinkPreviewSupport.kt\ncom/intellij/vcs/log/ui/table/VcsLogGraphTableLinkPreviewSupport\n*L\n47#1:92,2\n72#1:94,2\n*E\n"})
public final class VcsLogGraphTableLinkPreviewSupport
extends MouseAdapter {
    @NotNull
    private final VcsLogGraphTable table;
    @Nullable
    private LinkPreviewSession session;

    public VcsLogGraphTableLinkPreviewSupport(@NotNull VcsLogGraphTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.table = table;
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent e) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (this.table.getRowCount() == 0) {
                    return;
                }
                if (this.table.isResizingColumns()) {
                    return;
                }
                int row = this.table.rowAtPoint(e.getPoint());
                Object tag = this.table.getTagAt(e);
                if (!(tag instanceof IssueLinkTag)) break block2;
                IssueLinkTag issueLinkTag = (IssueLinkTag)((Object)tag);
                Point point = e.getPoint();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                this.startShowingDoc(issueLinkTag, row, point);
                break block3;
            }
            LinkPreviewSession linkPreviewSession = this.session;
            if (linkPreviewSession == null || (linkPreviewSession = linkPreviewSession.getDocumentationSession()) == null) break block3;
            linkPreviewSession.mouseOutsideOfSourceArea();
        }
    }

    @Override
    public void mouseExited(@Nullable MouseEvent e) {
        block0: {
            LinkPreviewSession linkPreviewSession = this.session;
            if (linkPreviewSession == null || (linkPreviewSession = linkPreviewSession.getDocumentationSession()) == null) break block0;
            linkPreviewSession.mouseOutsideOfSourceArea();
        }
    }

    private final void startShowingDoc(IssueLinkTag tag, int row, Point mousePosition) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        ComponentManager $this$service$iv = (ComponentManager)application;
        boolean $i$f$service = false;
        Class<VcsLogApplicationSettings> serviceClass$iv = VcsLogApplicationSettings.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        VcsLogApplicationSettings settings = (VcsLogApplicationSettings)object;
        VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty = CommonUiProperties.SHOW_ISSUE_PREVIEW_ON_HOVER;
        Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty, (String)"SHOW_ISSUE_PREVIEW_ON_HOVER");
        if (!settings.get(vcsLogUiProperty).booleanValue()) {
            return;
        }
        VcsLogUiProperties.VcsLogUiProperty<Integer> vcsLogUiProperty2 = CommonUiProperties.SHOW_ISSUE_PREVIEW_ON_HOVER_DELAY;
        Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty2, (String)"SHOW_ISSUE_PREVIEW_ON_HOVER_DELAY");
        Integer delay = settings.get(vcsLogUiProperty2);
        ReadAction.nonBlocking(() -> VcsLogGraphTableLinkPreviewSupport.startShowingDoc$lambda$0(tag)).finishOnUiThread(ModalityState.any(), arg_0 -> VcsLogGraphTableLinkPreviewSupport.startShowingDoc$lambda$1(this, tag, row, mousePosition, delay, arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private static final Pointer startShowingDoc$lambda$0$0(DocumentationTarget it) {
        return it.createPointer();
    }

    private static final Pointer startShowingDoc$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Pointer)$tmp0.invoke(p0);
    }

    private static final DocumentationTarget startShowingDoc$lambda$1$0(Pointer it) {
        return (DocumentationTarget)it.dereference();
    }

    private static final DocumentationTarget startShowingDoc$lambda$1$1(Function1 $tmp0, Object p0) {
        return (DocumentationTarget)$tmp0.invoke(p0);
    }

    private static final void startShowingDoc$lambda$1$3(VcsLogGraphTableLinkPreviewSupport this$0) {
        this$0.session = null;
    }

    private static final Optional startShowingDoc$lambda$0(IssueLinkTag $tag) {
        return Optional.ofNullable($tag.getDocumentationTarget()).map(arg_0 -> VcsLogGraphTableLinkPreviewSupport.startShowingDoc$lambda$0$1(VcsLogGraphTableLinkPreviewSupport::startShowingDoc$lambda$0$0, arg_0));
    }

    private static final void startShowingDoc$lambda$1(VcsLogGraphTableLinkPreviewSupport this$0, IssueLinkTag $tag, int $row, Point $mousePosition, Integer $delay, Optional pointerOptional) {
        block6: {
            block5: {
                Project project;
                DocumentationTarget target = pointerOptional.map(arg_0 -> VcsLogGraphTableLinkPreviewSupport.startShowingDoc$lambda$1$1(VcsLogGraphTableLinkPreviewSupport::startShowingDoc$lambda$1$0, arg_0)).orElse(null);
                if (target == null) break block5;
                LinkPreviewSession linkPreviewSession = this$0.session;
                if (linkPreviewSession != null) {
                    LinkPreviewSession session = linkPreviewSession;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)$tag.getIssueId(), (Object)session.getIssueId()) && $row == session.getRow()) {
                        session.getDocumentationSession().mouseWithinSourceArea();
                        return;
                    }
                    if (!session.getDocumentationSession().tryFinishImmediately()) {
                        return;
                    }
                }
                if ((project = $tag.getProject()).isDisposed() || !this$0.table.isShowing()) {
                    return;
                }
                Rectangle rectangle = this$0.table.getCellRect($row, 0, false);
                Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getCellRect(...)");
                Rectangle cellRect = rectangle;
                cellRect.width = this$0.table.getWidth();
                cellRect.x = Math.min(Math.max($mousePosition.x, 0), cellRect.width - 1);
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<DocumentationManager> serviceClass$iv = DocumentationManager.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                DocumentationManager documentationManager = (DocumentationManager)object;
                List list = CollectionsKt.listOf((Object)target);
                Component component = (Component)((Object)this$0.table);
                Intrinsics.checkNotNull((Object)$delay);
                DocumentationManager.DocumentationOnHoverSession documentationOnHoverSession = documentationManager.showDocumentationOnHoverAround(list, project, component, cellRect, 350, $delay.intValue(), () -> VcsLogGraphTableLinkPreviewSupport.startShowingDoc$lambda$1$3(this$0));
                if (documentationOnHoverSession == null) break block6;
                DocumentationManager.DocumentationOnHoverSession it = documentationOnHoverSession;
                boolean bl = false;
                this$0.session = new LinkPreviewSession(project, $tag.getIssueId(), $row, it);
                break block6;
            }
            LinkPreviewSession linkPreviewSession = this$0.session;
            if (linkPreviewSession == null || (linkPreviewSession = linkPreviewSession.getDocumentationSession()) == null) break block6;
            linkPreviewSession.mouseOutsideOfSourceArea();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0014\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001c\u001a\u00020\u0007H\u00d6\u0081\u0004J\n\u0010\u001d\u001a\u00020\u0005H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lcom/intellij/vcs/log/ui/table/VcsLogGraphTableLinkPreviewSupport$LinkPreviewSession;", "", "project", "Lcom/intellij/openapi/project/Project;", "issueId", "", "row", "", "documentationSession", "Lcom/intellij/lang/documentation/ide/impl/DocumentationManager$DocumentationOnHoverSession;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;ILcom/intellij/lang/documentation/ide/impl/DocumentationManager$DocumentationOnHoverSession;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getIssueId", "()Ljava/lang/String;", "getRow", "()I", "getDocumentationSession", "()Lcom/intellij/lang/documentation/ide/impl/DocumentationManager$DocumentationOnHoverSession;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "intellij.platform.vcs.log.impl"})
    private static final class LinkPreviewSession {
        @NotNull
        private final Project project;
        @NotNull
        private final String issueId;
        private final int row;
        @NotNull
        private final DocumentationManager.DocumentationOnHoverSession documentationSession;

        public LinkPreviewSession(@NotNull Project project, @NotNull String issueId, int row, @NotNull DocumentationManager.DocumentationOnHoverSession documentationSession) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)issueId, (String)"issueId");
            Intrinsics.checkNotNullParameter((Object)documentationSession, (String)"documentationSession");
            this.project = project;
            this.issueId = issueId;
            this.row = row;
            this.documentationSession = documentationSession;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final String getIssueId() {
            return this.issueId;
        }

        public final int getRow() {
            return this.row;
        }

        @NotNull
        public final DocumentationManager.DocumentationOnHoverSession getDocumentationSession() {
            return this.documentationSession;
        }

        @NotNull
        public final Project component1() {
            return this.project;
        }

        @NotNull
        public final String component2() {
            return this.issueId;
        }

        public final int component3() {
            return this.row;
        }

        @NotNull
        public final DocumentationManager.DocumentationOnHoverSession component4() {
            return this.documentationSession;
        }

        @NotNull
        public final LinkPreviewSession copy(@NotNull Project project, @NotNull String issueId, int row, @NotNull DocumentationManager.DocumentationOnHoverSession documentationSession) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)issueId, (String)"issueId");
            Intrinsics.checkNotNullParameter((Object)documentationSession, (String)"documentationSession");
            return new LinkPreviewSession(project, issueId, row, documentationSession);
        }

        public static /* synthetic */ LinkPreviewSession copy$default(LinkPreviewSession linkPreviewSession, Project project, String string, int n, DocumentationManager.DocumentationOnHoverSession documentationOnHoverSession, int n2, Object object) {
            if ((n2 & 1) != 0) {
                project = linkPreviewSession.project;
            }
            if ((n2 & 2) != 0) {
                string = linkPreviewSession.issueId;
            }
            if ((n2 & 4) != 0) {
                n = linkPreviewSession.row;
            }
            if ((n2 & 8) != 0) {
                documentationOnHoverSession = linkPreviewSession.documentationSession;
            }
            return linkPreviewSession.copy(project, string, n, documentationOnHoverSession);
        }

        @NotNull
        public String toString() {
            return "LinkPreviewSession(project=" + this.project + ", issueId=" + this.issueId + ", row=" + this.row + ", documentationSession=" + this.documentationSession + ")";
        }

        public int hashCode() {
            int result = this.project.hashCode();
            result = result * 31 + this.issueId.hashCode();
            result = result * 31 + Integer.hashCode(this.row);
            result = result * 31 + this.documentationSession.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LinkPreviewSession)) {
                return false;
            }
            LinkPreviewSession linkPreviewSession = (LinkPreviewSession)other;
            if (!Intrinsics.areEqual((Object)this.project, (Object)linkPreviewSession.project)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.issueId, (Object)linkPreviewSession.issueId)) {
                return false;
            }
            if (this.row != linkPreviewSession.row) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.documentationSession, (Object)linkPreviewSession.documentationSession);
        }
    }
}

