/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible.filters;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogParentFilter;
import com.intellij.vcs.log.VcsLogRangeFilter;
import com.intellij.vcs.log.VcsLogRevisionFilter;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcs.log.visible.filters.HashSeparatorCharFilter;
import com.intellij.vcs.log.visible.filters.VcsLogBranchFilterImpl;
import com.intellij.vcs.log.visible.filters.VcsLogDateFilterImpl;
import com.intellij.vcs.log.visible.filters.VcsLogFilterCollectionImpl;
import com.intellij.vcs.log.visible.filters.VcsLogFiltersKt;
import com.intellij.vcs.log.visible.filters.VcsLogHashFilterImpl;
import com.intellij.vcs.log.visible.filters.VcsLogMultiplePatternsTextFilter;
import com.intellij.vcs.log.visible.filters.VcsLogParentFilterImpl;
import com.intellij.vcs.log.visible.filters.VcsLogRangeFilterImpl;
import com.intellij.vcs.log.visible.filters.VcsLogRegexTextFilter;
import com.intellij.vcs.log.visible.filters.VcsLogRevisionFilterImpl;
import com.intellij.vcs.log.visible.filters.VcsLogRootFilterImpl;
import com.intellij.vcs.log.visible.filters.VcsLogStructureFilterImpl;
import com.intellij.vcs.log.visible.filters.VcsLogTextFilterImpl;
import com.intellij.vcs.log.visible.filters.VcsLogUserFilterImpl;
import com.intellij.vcsUtil.VcsUtil;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\rH\u0007J \u0010\u000f\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\b\b\u0002\u0010\u000e\u001a\u00020\rH\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0007J\u0016\u0010\u0015\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0011H\u0007J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bH\u0007J\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0011H\u0007J.\u0010\u001d\u001a\u00020\u00132\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0 2\b\b\u0002\u0010!\u001a\u00020\rH\u0007J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0007J\u0016\u0010&\u001a\u00020#2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020%0\u0011H\u0007J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u000b\u001a\u00020\bH\u0007J\u0016\u0010*\u001a\u00020)2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\b0\u001eH\u0007J\u001c\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/2\b\u00100\u001a\u0004\u0018\u00010/H\u0007J\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u0002012\u0006\u00100\u001a\u000201H\u0007J\u001e\u00102\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020\b0\u001e2\u0006\u00105\u001a\u000206H\u0007J \u00107\u001a\u0002032\u0006\u00108\u001a\u0002092\u000e\b\u0002\u0010:\u001a\b\u0012\u0004\u0012\u0002090 H\u0007J8\u00102\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020\b0\u001e2\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u0002090<2\f\u0010:\u001a\b\u0012\u0004\u0012\u0002090 H\u0007J\u0016\u0010>\u001a\u00020?2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020A0\u001eH\u0007J\u0016\u0010B\u001a\u00020?2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020=0\u001eH\u0007J\u0010\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020=H\u0007J\u0016\u0010F\u001a\u00020D2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020=0\u001eH\u0007J\b\u0010H\u001a\u00020IH\u0007J%\u0010J\u001a\u00020I2\n\b\u0002\u0010K\u001a\u0004\u0018\u00010L2\n\b\u0002\u0010M\u001a\u0004\u0018\u00010LH\u0007\u00a2\u0006\u0002\u0010NJ%\u0010O\u001a\u00020P2\u0016\u0010Q\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010S0R\"\u0004\u0018\u00010SH\u0007\u00a2\u0006\u0002\u0010TR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010U\u001a\u00020P8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lcom/intellij/vcs/log/visible/filters/VcsLogFilterObject;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "ME", "", "fromPattern", "Lcom/intellij/vcs/log/VcsLogTextFilter;", "text", "isRegexpAllowed", "", "isMatchCase", "fromPatternsList", "patterns", "", "fromBranch", "Lcom/intellij/vcs/log/VcsLogBranchFilter;", "branchName", "fromBranches", "branchNames", "fromRange", "Lcom/intellij/vcs/log/VcsLogRangeFilter;", "exclusiveRef", "inclusiveRef", "ranges", "Lcom/intellij/vcs/log/VcsLogRangeFilter$RefRange;", "fromBranchPatterns", "", "existingBranches", "", "excludeNotMatched", "fromCommit", "Lcom/intellij/vcs/log/VcsLogRevisionFilter;", "commit", "Lcom/intellij/vcs/log/CommitId;", "fromCommits", "commits", "fromHash", "Lcom/intellij/vcs/log/VcsLogHashFilter;", "fromHashes", "hashes", "fromDates", "Lcom/intellij/vcs/log/VcsLogDateFilter;", "after", "Ljava/util/Date;", "before", "", "fromUserNames", "Lcom/intellij/vcs/log/VcsLogUserFilter;", "userNames", "vcsLogData", "Lcom/intellij/vcs/log/data/VcsLogData;", "fromUser", "user", "Lcom/intellij/vcs/log/VcsUser;", "allUsers", "meData", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "fromPaths", "Lcom/intellij/vcs/log/VcsLogStructureFilter;", "files", "Lcom/intellij/openapi/vcs/FilePath;", "fromVirtualFiles", "fromRoot", "Lcom/intellij/vcs/log/VcsLogRootFilter;", "root", "fromRoots", "roots", "noMerges", "Lcom/intellij/vcs/log/VcsLogParentFilter;", "fromParentCount", "minParents", "", "maxParents", "(Ljava/lang/Integer;Ljava/lang/Integer;)Lcom/intellij/vcs/log/VcsLogParentFilter;", "collection", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "filters", "", "Lcom/intellij/vcs/log/VcsLogFilter;", "([Lcom/intellij/vcs/log/VcsLogFilter;)Lcom/intellij/vcs/log/VcsLogFilterCollection;", "EMPTY_COLLECTION", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogFilters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogFilters.kt\ncom/intellij/vcs/log/visible/filters/VcsLogFilterObject\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,320:1\n1586#2:321\n1661#2,3:322\n*S KotlinDebug\n*F\n+ 1 VcsLogFilters.kt\ncom/intellij/vcs/log/visible/filters/VcsLogFilterObject\n*L\n199#1:321\n199#1:322,3\n*E\n"})
public final class VcsLogFilterObject {
    @NotNull
    public static final VcsLogFilterObject INSTANCE = new VcsLogFilterObject();
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String ME = "*";
    @JvmField
    @NotNull
    public static final VcsLogFilterCollection EMPTY_COLLECTION;

    private VcsLogFilterObject() {
    }

    @JvmStatic
    @NotNull
    public static final VcsLogTextFilter fromPattern(@NotNull String text, boolean isRegexpAllowed, boolean isMatchCase) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (isRegexpAllowed && VcsLogUtil.isRegexp(text)) {
            try {
                Pattern pattern = Pattern.compile(text, isMatchCase ? 0 : 2);
                Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
                return new VcsLogRegexTextFilter(pattern);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return new VcsLogTextFilterImpl(text, isMatchCase);
    }

    public static /* synthetic */ VcsLogTextFilter fromPattern$default(String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return VcsLogFilterObject.fromPattern(string, bl, bl2);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogTextFilter fromPatternsList(@NotNull List<String> patterns, boolean isMatchCase) {
        Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
        if (patterns.isEmpty()) {
            return VcsLogFilterObject.fromPattern("", false, isMatchCase);
        }
        if (patterns.size() == 1) {
            return VcsLogFilterObject.fromPattern((String)CollectionsKt.single(patterns), false, isMatchCase);
        }
        return new VcsLogMultiplePatternsTextFilter(patterns, isMatchCase);
    }

    public static /* synthetic */ VcsLogTextFilter fromPatternsList$default(List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return VcsLogFilterObject.fromPatternsList(list, bl);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogBranchFilter fromBranch(@NotNull String branchName) {
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        return VcsLogFilterObject.fromBranches(CollectionsKt.listOf((Object)branchName));
    }

    @JvmStatic
    @NotNull
    public static final VcsLogBranchFilter fromBranches(@NotNull List<String> branchNames) {
        Intrinsics.checkNotNullParameter(branchNames, (String)"branchNames");
        return new VcsLogBranchFilterImpl(branchNames, CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList());
    }

    @JvmStatic
    @NotNull
    public static final VcsLogRangeFilter fromRange(@NotNull String exclusiveRef, @NotNull String inclusiveRef) {
        Intrinsics.checkNotNullParameter((Object)exclusiveRef, (String)"exclusiveRef");
        Intrinsics.checkNotNullParameter((Object)inclusiveRef, (String)"inclusiveRef");
        return VcsLogFilterObject.fromRange(CollectionsKt.listOf((Object)new VcsLogRangeFilter.RefRange(exclusiveRef, inclusiveRef)));
    }

    @JvmStatic
    @NotNull
    public static final VcsLogRangeFilter fromRange(@NotNull List<VcsLogRangeFilter.RefRange> ranges) {
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        return new VcsLogRangeFilterImpl(ranges);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final VcsLogBranchFilter fromBranchPatterns(@NotNull Collection<String> patterns, @NotNull Set<String> existingBranches, boolean excludeNotMatched) {
        Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
        Intrinsics.checkNotNullParameter(existingBranches, (String)"existingBranches");
        ArrayList<String> includedBranches = new ArrayList<String>();
        ArrayList<String> excludedBranches = new ArrayList<String>();
        ArrayList<Pattern> includedPatterns = new ArrayList<Pattern>();
        ArrayList<Pattern> excludedPatterns = new ArrayList<Pattern>();
        boolean shouldExcludeNotMatched = !((Collection)existingBranches).isEmpty() && excludeNotMatched;
        for (String pattern : patterns) {
            boolean bl;
            boolean isRegexp;
            String string;
            boolean isExcluded = StringsKt.startsWith$default((String)pattern, (String)"-", (boolean)false, (int)2, null);
            if (isExcluded) {
                String string2 = pattern.substring(1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = pattern;
            }
            String string3 = string;
            boolean bl2 = isRegexp = !existingBranches.contains(string3) && VcsLogUtil.isRegexp(string3);
            if (isRegexp) {
                boolean bl3;
                try {
                    Pattern regex = Pattern.compile(string3);
                    bl3 = isExcluded ? excludedPatterns.add(regex) : includedPatterns.add(regex);
                }
                catch (PatternSyntaxException e) {
                    LOG.warn("Pattern " + string3 + " is not a proper regular expression and no branch can be found with that name.", (Throwable)e);
                    if (shouldExcludeNotMatched) continue;
                    bl3 = isExcluded ? excludedBranches.add(string3) : includedBranches.add(string3);
                }
                bl = bl3;
                continue;
            }
            if (shouldExcludeNotMatched && !existingBranches.contains(string3)) continue;
            bl = isExcluded ? excludedBranches.add(string3) : includedBranches.add(string3);
        }
        return new VcsLogBranchFilterImpl((List<String>)includedBranches, (List<Pattern>)includedPatterns, (List<String>)excludedBranches, (List<Pattern>)excludedPatterns);
    }

    public static /* synthetic */ VcsLogBranchFilter fromBranchPatterns$default(Collection collection, Set set, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return VcsLogFilterObject.fromBranchPatterns(collection, set, bl);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogRevisionFilter fromCommit(@NotNull CommitId commit) {
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        return new VcsLogRevisionFilterImpl(CollectionsKt.listOf((Object)commit));
    }

    @JvmStatic
    @NotNull
    public static final VcsLogRevisionFilter fromCommits(@NotNull List<CommitId> commits) {
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        return new VcsLogRevisionFilterImpl((Collection<CommitId>)commits);
    }

    @JvmStatic
    @Nullable
    public static final VcsLogHashFilter fromHash(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        List hashes = new ArrayList();
        for (String word : StringUtil.split((String)text, (CharFilter)HashSeparatorCharFilter.INSTANCE, (boolean)true, (boolean)true)) {
            if (!VcsLogUtil.HASH_REGEX.matcher(word).matches()) {
                return null;
            }
            Intrinsics.checkNotNull((Object)word);
            hashes.add(word);
        }
        if (hashes.isEmpty()) {
            return null;
        }
        return VcsLogFilterObject.fromHashes(hashes);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogHashFilter fromHashes(@NotNull Collection<String> hashes) {
        Intrinsics.checkNotNullParameter(hashes, (String)"hashes");
        return new VcsLogHashFilterImpl(hashes);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogDateFilter fromDates(@Nullable Date after, @Nullable Date before) {
        return new VcsLogDateFilterImpl(after, before);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogDateFilter fromDates(long after, long before) {
        return VcsLogFilterObject.fromDates(after > 0L ? new Date(after) : null, before > 0L ? new Date(before) : null);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogUserFilter fromUserNames(@NotNull Collection<String> userNames, @NotNull VcsLogData vcsLogData) {
        Intrinsics.checkNotNullParameter(userNames, (String)"userNames");
        Intrinsics.checkNotNullParameter((Object)vcsLogData, (String)"vcsLogData");
        return new VcsLogUserFilterImpl(userNames, vcsLogData.getUserNameResolver());
    }

    @JvmStatic
    @NotNull
    public static final VcsLogUserFilter fromUser(@NotNull VcsUser user2, @NotNull Set<? extends VcsUser> allUsers) {
        Intrinsics.checkNotNullParameter((Object)user2, (String)"user");
        Intrinsics.checkNotNullParameter(allUsers, (String)"allUsers");
        return VcsLogFilterObject.fromUserNames(CollectionsKt.listOf((Object)VcsUserUtil.getShortPresentation((VcsUser)user2)), MapsKt.emptyMap(), allUsers);
    }

    public static /* synthetic */ VcsLogUserFilter fromUser$default(VcsUser vcsUser, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = SetsKt.setOf((Object)vcsUser);
        }
        return VcsLogFilterObject.fromUser(vcsUser, set);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogUserFilter fromUserNames(@NotNull Collection<String> userNames, @NotNull Map<VirtualFile, ? extends VcsUser> meData, @NotNull Set<? extends VcsUser> allUsers) {
        Intrinsics.checkNotNullParameter(userNames, (String)"userNames");
        Intrinsics.checkNotNullParameter(meData, (String)"meData");
        Intrinsics.checkNotNullParameter(allUsers, (String)"allUsers");
        return new VcsLogUserFilterImpl(userNames, meData, allUsers);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogStructureFilter fromPaths(@NotNull Collection<? extends FilePath> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        return new VcsLogStructureFilterImpl(files);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final VcsLogStructureFilter fromVirtualFiles(@NotNull Collection<? extends VirtualFile> files) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Iterable $this$map$iv = files;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void file;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(VcsUtil.getFilePath((VirtualFile)file));
        }
        return VcsLogFilterObject.fromPaths((List)destination$iv$iv);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogRootFilter fromRoot(@NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return VcsLogFilterObject.fromRoots(CollectionsKt.listOf((Object)root));
    }

    @JvmStatic
    @NotNull
    public static final VcsLogRootFilter fromRoots(@NotNull Collection<? extends VirtualFile> roots) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        return new VcsLogRootFilterImpl(roots);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogParentFilter noMerges() {
        return VcsLogFilterObject.fromParentCount$default(null, 1, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogParentFilter fromParentCount(@Nullable Integer minParents, @Nullable Integer maxParents) {
        Integer n = minParents;
        Integer n2 = maxParents;
        return new VcsLogParentFilterImpl(n != null ? n : 0, n2 != null ? n2 : Integer.MAX_VALUE);
    }

    public static /* synthetic */ VcsLogParentFilter fromParentCount$default(Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = null;
        }
        if ((n3 & 2) != 0) {
            n2 = null;
        }
        return VcsLogFilterObject.fromParentCount(n, n2);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogFilterCollection collection(VcsLogFilter ... filters) {
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        ObjectOpenCustomHashSet filterSet = VcsLogFiltersKt.access$createFilterSet();
        for (VcsLogFilter f : filters) {
            if (f == null || !VcsLogFiltersKt.access$replace(filterSet, f)) continue;
            LOG.warn("Two filters with the same key " + f.getKey() + " in filter collection. Keeping only " + f + ".");
        }
        return new VcsLogFilterCollectionImpl((Collection)filterSet);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final VcsLogBranchFilter fromBranchPatterns(@NotNull Collection<String> patterns, @NotNull Set<String> existingBranches) {
        Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
        Intrinsics.checkNotNullParameter(existingBranches, (String)"existingBranches");
        return VcsLogFilterObject.fromBranchPatterns$default(patterns, existingBranches, false, 4, null);
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.intellij.vcs.log.visible.filters.VcsLogFilters");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        EMPTY_COLLECTION = VcsLogFilterObject.collection(new VcsLogFilter[0]);
    }
}

