/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.todo.HighlightedRegionProvider;
import com.intellij.ide.todo.SmartTodoItemPointer;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.nodes.BaseToDoNode;
import com.intellij.ide.todo.nodes.TodoItemNodePresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.search.TodoAttributesUtil;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.search.TodoPattern;
import com.intellij.ui.HighlightedRegion;
import com.intellij.usageView.UsageTreeColors;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class TodoItemNode
extends BaseToDoNode<SmartTodoItemPointer>
implements HighlightedRegionProvider {
    private static final Logger LOG = Logger.getInstance(TodoItem.class);

    public TodoItemNode(Project project, @NotNull SmartTodoItemPointer value, TodoTreeBuilder builder) {
        if (value == null) {
            TodoItemNode.$$$reportNull$$$0(0);
        }
        super(project, value, builder);
        RangeMarker rangeMarker = value.getRangeMarker();
        LOG.assertTrue(rangeMarker.isValid());
    }

    @NotNull
    protected PresentationData createPresentation() {
        return new TodoItemNodePresentationData();
    }

    @Override
    public boolean contains(Object element) {
        return this.canRepresent(element);
    }

    public boolean canRepresent(Object element) {
        SmartTodoItemPointer value = (SmartTodoItemPointer)this.getValue();
        TodoItem item = value != null ? value.getTodoItem() : null;
        return Comparing.equal((Object)item, (Object)element);
    }

    @Override
    public int getFileCount(SmartTodoItemPointer val) {
        return 1;
    }

    @Override
    public int getTodoItemCount(SmartTodoItemPointer val) {
        return 1;
    }

    public List<HighlightedRegion> getHighlightedRegions() {
        return Collections.unmodifiableList(((TodoItemNodePresentationData)this.getPresentation()).getHighlightedRegions());
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        List<AbstractTreeNode<?>> list = Collections.emptyList();
        if (list == null) {
            TodoItemNode.$$$reportNull$$$0(1);
        }
        return list;
    }

    public void update(@NotNull PresentationData presentation) {
        int lineStartOffset;
        if (presentation == null) {
            TodoItemNode.$$$reportNull$$$0(2);
        }
        SmartTodoItemPointer todoItemPointer = (SmartTodoItemPointer)this.getValue();
        assert (todoItemPointer != null);
        TodoItem todoItem = todoItemPointer.getTodoItem();
        RangeMarker myRangeMarker = todoItemPointer.getRangeMarker();
        if (!todoItem.getFile().isValid() || !myRangeMarker.isValid() || myRangeMarker.getStartOffset() == myRangeMarker.getEndOffset()) {
            myRangeMarker.dispose();
            this.setValue(null);
            return;
        }
        @NotNull List<HighlightedRegion> myHighlightedRegions = ((TodoItemNodePresentationData)presentation).getHighlightedRegions();
        @NotNull List<HighlightedRegionProvider> myAdditionalLines = ((TodoItemNodePresentationData)presentation).getAdditionalLines();
        myHighlightedRegions.clear();
        myAdditionalLines.clear();
        Document document = todoItemPointer.getDocument();
        CharSequence chars = document.getCharsSequence();
        int startOffset = myRangeMarker.getStartOffset();
        int endOffset = myRangeMarker.getEndOffset();
        int lineNumber = document.getLineNumber(startOffset);
        for (lineStartOffset = document.getLineStartOffset(lineNumber); lineStartOffset < document.getTextLength() && (chars.charAt(lineStartOffset) == '\t' || chars.charAt(lineStartOffset) == ' '); ++lineStartOffset) {
        }
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        String lineColumnPrefix = String.valueOf(lineNumber + 1) + " ";
        String highlightedText = chars.subSequence(lineStartOffset, Math.min(lineEndOffset, chars.length())).toString();
        String newName = lineColumnPrefix + highlightedText;
        TodoPattern pattern = todoItem.getPattern();
        Icon newIcon = pattern != null ? pattern.getAttributes().getIcon() : null;
        myHighlightedRegions.clear();
        EditorHighlighter highlighter = this.myBuilder.getHighlighter(todoItem.getFile(), document);
        TodoItemNode.collectHighlights(myHighlightedRegions, highlighter, lineStartOffset, lineEndOffset, lineColumnPrefix.length());
        TextAttributes attributes = pattern != null ? pattern.getAttributes().getTextAttributes() : TodoAttributesUtil.getDefaultColorSchemeTextAttributes();
        myHighlightedRegions.add(new HighlightedRegion(0, lineColumnPrefix.length(), UsageTreeColors.NUMBER_OF_USAGES_ATTRIBUTES.toTextAttributes()));
        myHighlightedRegions.add(new HighlightedRegion(lineColumnPrefix.length() + startOffset - lineStartOffset, lineColumnPrefix.length() + endOffset - lineStartOffset, attributes));
        presentation.setPresentableText(newName);
        presentation.setIcon(newIcon);
        for (RangeMarker additionalMarker : todoItemPointer.getAdditionalRangeMarkers()) {
            if (!additionalMarker.isValid()) break;
            ArrayList<HighlightedRegion> highlights = new ArrayList<HighlightedRegion>();
            int lineNum = document.getLineNumber(additionalMarker.getStartOffset());
            int lineStart = document.getLineStartOffset(lineNum);
            int lineEnd = document.getLineEndOffset(lineNum);
            int lineStartNonWs = CharArrayUtil.shiftForward((CharSequence)chars, (int)lineStart, (String)" \t");
            if (lineStartNonWs > additionalMarker.getStartOffset() || lineEnd < additionalMarker.getEndOffset()) break;
            TodoItemNode.collectHighlights(highlights, highlighter, lineStartNonWs, lineEnd, 0);
            highlights.add(new HighlightedRegion(additionalMarker.getStartOffset() - lineStartNonWs, additionalMarker.getEndOffset() - lineStartNonWs, attributes));
            myAdditionalLines.add(new AdditionalTodoLine(document.getText(new TextRange(lineStartNonWs, lineEnd)), highlights));
        }
    }

    private static void collectHighlights(@NotNull List<? super HighlightedRegion> highlights, @NotNull EditorHighlighter highlighter, int startOffset, int endOffset, int highlightOffsetShift) {
        if (highlights == null) {
            TodoItemNode.$$$reportNull$$$0(3);
        }
        if (highlighter == null) {
            TodoItemNode.$$$reportNull$$$0(4);
        }
        HighlighterIterator iterator = highlighter.createIterator(startOffset);
        while (!iterator.atEnd()) {
            int start = Math.max(iterator.getStart(), startOffset);
            int end = Math.min(iterator.getEnd(), endOffset);
            if (start >= endOffset) break;
            TextAttributes attributes = iterator.getTextAttributes();
            int fontType = attributes.getFontType();
            if ((fontType & 1) != 0) {
                attributes = attributes.clone();
                attributes.setFontType(fontType & 0xFFFFFFFE);
            }
            HighlightedRegion region = new HighlightedRegion(highlightOffsetShift + start - startOffset, highlightOffsetShift + end - startOffset, attributes);
            highlights.add((HighlightedRegion)region);
            iterator.advance();
        }
    }

    public String getTestPresentation() {
        return "Item: " + String.valueOf(((SmartTodoItemPointer)this.getValue()).getTodoItem().getTextRange());
    }

    public int getWeight() {
        return 5;
    }

    @NotNull
    public List<HighlightedRegionProvider> getAdditionalLines() {
        List<HighlightedRegionProvider> list = Collections.unmodifiableList(((TodoItemNodePresentationData)this.getPresentation()).getAdditionalLines());
        if (list == null) {
            TodoItemNode.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/nodes/TodoItemNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlights";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/nodes/TodoItemNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectHighlights";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5 -> new IllegalStateException(string);
        };
    }

    private static final class AdditionalTodoLine
    implements HighlightedRegionProvider {
        private final String myText;
        private final List<HighlightedRegion> myHighlights;

        private AdditionalTodoLine(String text, List<HighlightedRegion> highlights) {
            this.myText = text;
            this.myHighlights = highlights;
        }

        @Override
        public Iterable<HighlightedRegion> getHighlightedRegions() {
            return this.myHighlights;
        }

        public String toString() {
            return this.myText;
        }
    }
}

