/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebuggerViewSupportKt;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.MemberFilterWithNameMappings;
import org.jetbrains.debugger.Variable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001BC\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\t\u0012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0014R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/javascript/debugger/MyMemberFilter;", "Lorg/jetbrains/debugger/MemberFilterWithNameMappings;", "variableDeclaredAfter", "", "", "additionalVariables", "", "Lorg/jetbrains/debugger/Variable;", "rawNameToSource", "", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "<init>", "(Ljava/util/Set;Ljava/util/Collection;Ljava/util/Map;Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;)V", "getAdditionalVariables", "()Ljava/util/Collection;", "isMemberVisible", "", "variable", "normalizeMemberName", "name", "intellij.javascript.debugger.backend"})
final class MyMemberFilter
extends MemberFilterWithNameMappings {
    @NotNull
    private final Set<String> variableDeclaredAfter;
    @NotNull
    private final Collection<Variable> additionalVariables;
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;

    public MyMemberFilter(@NotNull Set<String> variableDeclaredAfter, @NotNull Collection<? extends Variable> additionalVariables, @NotNull Map<String, String> rawNameToSource, @NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkNotNullParameter(variableDeclaredAfter, (String)"variableDeclaredAfter");
        Intrinsics.checkNotNullParameter(additionalVariables, (String)"additionalVariables");
        Intrinsics.checkNotNullParameter(rawNameToSource, (String)"rawNameToSource");
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        super(rawNameToSource);
        this.variableDeclaredAfter = variableDeclaredAfter;
        this.additionalVariables = additionalVariables;
        this.debugProcess = debugProcess;
    }

    @NotNull
    public Collection<Variable> getAdditionalVariables() {
        return this.additionalVariables;
    }

    public boolean isMemberVisible(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return super.isMemberVisible(variable) && JavaScriptDebuggerViewSupportKt.isVariableVisible(variable) && !this.variableDeclaredAfter.contains(variable.getName());
    }

    @NotNull
    protected String normalizeMemberName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.debugProcess.normalizeMemberName(name);
    }
}

