/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util.common;

import com.intellij.database.util.common.IllegalDateTimeFormatException;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.util.GregorianCalendar;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0004\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0005\u001a\u0012\u0010\u0002\u001a\u00020\u0003*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\b\u001a\u0012\u0010\u0002\u001a\u00020\u0003*\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\u0002\u001a\u00020\u0003*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\t\u001a\n\u0010\n\u001a\u00020\u0003*\u00020\t\u001a\u0012\u0010\u000e\u001a\u00020\u0003*\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\n\u0010\u000f\u001a\u00020\u0007*\u00020\t\u001a\n\u0010\u000b\u001a\u00020\u0007*\u00020\t\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0011\u001a\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u000e\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u000e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0016\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0011\u001a#\u0010\u0019\u001a\u0004\u0018\u00010\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u0011H\u0007\u00a2\u0006\u0002\b\u001c\u001a\f\u0010\u001d\u001a\u00020\u0004*\u00020\tH\u0002\u001a\f\u0010\u001e\u001a\u00020\b*\u00020\tH\u0002\u001a\n\u0010'\u001a\u00020\u0011*\u00020\t\"\u0015\u0010\u000b\u001a\u00020\u0007*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u001f\u001a\u00020\u0003*\u00020 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\"\u0018\u0010#\u001a\u00020\u0003*\u00020 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"\"\u0018\u0010%\u001a\u00020\u0003*\u00020 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\"\"\u0019\u0010(\u001a\n **\u0004\u0018\u00010)0)\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u0006-"}, d2={"currentInstantTruncatedToSeconds", "Ljava/time/Instant;", "export", "", "Ljava/time/LocalDate;", "Ljava/time/LocalTime;", "withMilliseconds", "", "Ljava/time/LocalDateTime;", "Ljava/util/Date;", "exportDateOnly", "hasMilliseconds", "getHasMilliseconds", "(Ljava/time/LocalTime;)Z", "exportDateTime", "hasTime", "truncateToSeconds", "Ljava/sql/Timestamp;", "importLocalDateTime", "string", "", "importInstant", "importSqlDateTime", "formalSqlDateTimePattern", "Lkotlin/text/Regex;", "min", "timestamp1", "timestamp2", "minOrNull", "toLocalDate", "toLocalDateTime", "str2", "", "getStr2", "(I)Ljava/lang/String;", "str3", "getStr3", "str4", "getStr4", "toTimestamp", "localeDataTimeFormatterMediumStyle", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "getLocaleDataTimeFormatterMediumStyle", "()Ljava/time/format/DateTimeFormatter;", "intellij.database.util"})
@JvmName(name="CalendarFun")
public final class CalendarFun {
    @NotNull
    private static final Regex formalSqlDateTimePattern = new Regex("^\\s*(-?\\d+)-(\\d+)-(\\d+)(\\s*\\.\\s*(\\d+):(\\d+)(:(\\d+)(\\.(\\d{3}))?)?)?\\s*$");
    private static final DateTimeFormatter localeDataTimeFormatterMediumStyle = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM);

    @NotNull
    public static final Instant currentInstantTruncatedToSeconds() {
        Instant instant = Instant.now().truncatedTo(ChronoUnit.SECONDS);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"truncatedTo(...)");
        return instant;
    }

    @NotNull
    public static final String export(@NotNull LocalDate $this$export) {
        Intrinsics.checkNotNullParameter((Object)$this$export, (String)"<this>");
        return CalendarFun.getStr4($this$export.getYear()) + "-" + CalendarFun.getStr2($this$export.getMonthValue()) + "-" + CalendarFun.getStr2($this$export.getDayOfMonth());
    }

    @NotNull
    public static final String export(@NotNull LocalTime $this$export) {
        Intrinsics.checkNotNullParameter((Object)$this$export, (String)"<this>");
        return CalendarFun.export($this$export, CalendarFun.getHasMilliseconds($this$export));
    }

    @NotNull
    public static final String export(@NotNull LocalTime $this$export, boolean withMilliseconds) {
        Intrinsics.checkNotNullParameter((Object)$this$export, (String)"<this>");
        return withMilliseconds ? CalendarFun.getStr2($this$export.getHour()) + ":" + CalendarFun.getStr2($this$export.getMinute()) + ":" + CalendarFun.getStr2($this$export.getSecond()) + "." + CalendarFun.getStr3($this$export.getNano() / 1000000) : CalendarFun.getStr2($this$export.getHour()) + ":" + CalendarFun.getStr2($this$export.getMinute()) + ":" + CalendarFun.getStr2($this$export.getSecond());
    }

    @NotNull
    public static final String export(@NotNull LocalDateTime $this$export) {
        Intrinsics.checkNotNullParameter((Object)$this$export, (String)"<this>");
        LocalDate localDate = $this$export.toLocalDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"toLocalDate(...)");
        String string = CalendarFun.export(localDate);
        LocalTime localTime = $this$export.toLocalTime();
        Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"toLocalTime(...)");
        return string + "." + CalendarFun.export(localTime);
    }

    @NotNull
    public static final String export(@NotNull LocalDateTime $this$export, boolean withMilliseconds) {
        Intrinsics.checkNotNullParameter((Object)$this$export, (String)"<this>");
        LocalDate localDate = $this$export.toLocalDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"toLocalDate(...)");
        String string = CalendarFun.export(localDate);
        LocalTime localTime = $this$export.toLocalTime();
        Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"toLocalTime(...)");
        return string + "." + CalendarFun.export(localTime, withMilliseconds);
    }

    @NotNull
    public static final String export(@NotNull Instant $this$export, boolean withMilliseconds) {
        Intrinsics.checkNotNullParameter((Object)$this$export, (String)"<this>");
        LocalDateTime localDateTime = $this$export.truncatedTo(withMilliseconds ? ChronoUnit.MILLIS : ChronoUnit.SECONDS).atZone(ZoneOffset.UTC).toLocalDateTime();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"toLocalDateTime(...)");
        return CalendarFun.export(localDateTime, withMilliseconds);
    }

    @NotNull
    public static final String export(@NotNull java.util.Date $this$export) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$export, (String)"<this>");
        java.util.Date date = $this$export;
        if (date instanceof Date) {
            LocalDate localDate = ((Date)$this$export).toLocalDate();
            Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"toLocalDate(...)");
            string = CalendarFun.export(localDate);
        } else if (date instanceof Timestamp) {
            LocalDateTime localDateTime = ((Timestamp)$this$export).toLocalDateTime();
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"toLocalDateTime(...)");
            string = CalendarFun.export(localDateTime);
        } else {
            string = CalendarFun.hasTime($this$export) ? CalendarFun.export(CalendarFun.toLocalDate($this$export)) : CalendarFun.export(CalendarFun.toLocalDateTime($this$export));
        }
        return string;
    }

    @NotNull
    public static final String exportDateOnly(@NotNull java.util.Date $this$exportDateOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$exportDateOnly, (String)"<this>");
        return CalendarFun.export(CalendarFun.toLocalDate($this$exportDateOnly));
    }

    public static final boolean getHasMilliseconds(@NotNull LocalTime $this$hasMilliseconds) {
        Intrinsics.checkNotNullParameter((Object)$this$hasMilliseconds, (String)"<this>");
        return $this$hasMilliseconds.getNano() >= 1000000;
    }

    @NotNull
    public static final String exportDateTime(@NotNull java.util.Date $this$exportDateTime, boolean withMilliseconds) {
        Intrinsics.checkNotNullParameter((Object)$this$exportDateTime, (String)"<this>");
        return CalendarFun.export(CalendarFun.toLocalDateTime($this$exportDateTime), withMilliseconds);
    }

    public static final boolean hasTime(@NotNull java.util.Date $this$hasTime) {
        Intrinsics.checkNotNullParameter((Object)$this$hasTime, (String)"<this>");
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis($this$hasTime.getTime());
        return c.get(11) > 0 || c.get(12) > 0 || c.get(13) > 0 || c.get(14) > 0;
    }

    public static final boolean hasMilliseconds(@NotNull java.util.Date $this$hasMilliseconds) {
        Intrinsics.checkNotNullParameter((Object)$this$hasMilliseconds, (String)"<this>");
        return $this$hasMilliseconds.getTime() % 1000L > 0L;
    }

    @NotNull
    public static final Timestamp truncateToSeconds(@NotNull Timestamp $this$truncateToSeconds) {
        Intrinsics.checkNotNullParameter((Object)$this$truncateToSeconds, (String)"<this>");
        long t = $this$truncateToSeconds.getTime();
        t = t / 1000L * 1000L;
        return t == $this$truncateToSeconds.getTime() ? $this$truncateToSeconds : new Timestamp(t);
    }

    @NotNull
    public static final LocalDateTime importLocalDateTime(@NotNull CharSequence string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        MatchResult match = formalSqlDateTimePattern.matchEntire(string);
        if (match == null) {
            throw new IllegalDateTimeFormatException("The string \"" + string + "\" is not a valid date and time (wrong format).");
        }
        List values = match.getGroupValues();
        try {
            int y = Integer.parseInt((String)values.get(1));
            int m = Integer.parseInt((String)values.get(2));
            int d = Integer.parseInt((String)values.get(3));
            LocalDate date = LocalDate.of(y, m, d);
            if (((CharSequence)values.get(4)).length() == 0) {
                LocalDateTime localDateTime = LocalDateTime.of(date, LocalTime.MIDNIGHT);
                Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"of(...)");
                return localDateTime;
            }
            int h = Integer.parseInt((String)values.get(5));
            int n = Integer.parseInt((String)values.get(6));
            Integer n2 = StringsKt.toIntOrNull((String)((String)values.get(8)));
            int s = n2 != null ? n2 : 0;
            Integer n3 = StringsKt.toIntOrNull((String)((String)values.get(10)));
            int l = n3 != null ? n3 : 0;
            LocalTime time = LocalTime.of(h, n, s, l * 1000000);
            LocalDateTime localDateTime = LocalDateTime.of(date, time);
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"of(...)");
            return localDateTime;
        }
        catch (Exception e) {
            throw new IllegalDateTimeFormatException("The string \"" + string + "\" is not a valid date and time (wrong values).", e);
        }
    }

    @NotNull
    public static final Instant importInstant(@NotNull CharSequence string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        LocalDateTime ldt = CalendarFun.importLocalDateTime(string);
        Instant instant = ldt.toInstant(ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
        return instant;
    }

    @NotNull
    public static final java.util.Date importSqlDateTime(@NotNull CharSequence string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        LocalDateTime dt = CalendarFun.importLocalDateTime(string);
        try {
            java.util.Date date;
            if (Intrinsics.areEqual((Object)dt.toLocalTime(), (Object)LocalTime.MIDNIGHT)) {
                Date date2 = Date.valueOf(dt.toLocalDate());
                Intrinsics.checkNotNullExpressionValue((Object)date2, (String)"valueOf(...)");
                date = date2;
            } else {
                Timestamp timestamp = Timestamp.valueOf(dt);
                Intrinsics.checkNotNullExpressionValue((Object)timestamp, (String)"valueOf(...)");
                date = timestamp;
            }
            return date;
        }
        catch (Exception e) {
            throw new IllegalDateTimeFormatException("Cannot convert timestamp (" + string + ") from LocalDateTime to java.sql.Date/Timestamp.", e);
        }
    }

    @NotNull
    public static final Timestamp min(@NotNull Timestamp timestamp1, @NotNull Timestamp timestamp2) {
        Intrinsics.checkNotNullParameter((Object)timestamp1, (String)"timestamp1");
        Intrinsics.checkNotNullParameter((Object)timestamp2, (String)"timestamp2");
        return timestamp1.getTime() <= timestamp2.getTime() ? timestamp1 : timestamp2;
    }

    @JvmName(name="minOrNull")
    @Nullable
    public static final Timestamp minOrNull(@Nullable Timestamp timestamp1, @Nullable Timestamp timestamp2) {
        Timestamp timestamp;
        if (timestamp1 != null && timestamp2 != null) {
            timestamp = CalendarFun.min(timestamp1, timestamp2);
        } else {
            timestamp = timestamp1;
            if (timestamp == null) {
                timestamp = timestamp2;
            }
        }
        return timestamp;
    }

    private static final LocalDate toLocalDate(java.util.Date $this$toLocalDate) {
        LocalDate localDate = new Date($this$toLocalDate.getTime()).toLocalDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"toLocalDate(...)");
        return localDate;
    }

    private static final LocalDateTime toLocalDateTime(java.util.Date $this$toLocalDateTime) {
        LocalDateTime localDateTime = new Timestamp($this$toLocalDateTime.getTime()).toLocalDateTime();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"toLocalDateTime(...)");
        return localDateTime;
    }

    private static final String getStr2(int $this$str2) {
        int n = $this$str2;
        return (0 <= n ? n < 10 : false) ? "0" + $this$str2 : ((-9 <= n ? n < 0 : false) ? "-0" + Math.abs($this$str2) : String.valueOf($this$str2));
    }

    private static final String getStr3(int $this$str3) {
        Object object;
        block1: {
            int n;
            block2: {
                block0: {
                    n = $this$str3;
                    boolean bl = 0 <= n ? n < 10 : false;
                    if (!bl) break block0;
                    object = "00" + $this$str3;
                    break block1;
                }
                boolean bl = 10 <= n ? n < 100 : false;
                if (!bl) break block2;
                object = "0" + $this$str3;
                break block1;
            }
            object = (-9 <= n ? n < 0 : false) ? "-00" + Math.abs($this$str3) : ((-99 <= n ? n < -9 : false) ? "-0" + Math.abs($this$str3) : String.valueOf($this$str3));
        }
        return object;
    }

    private static final String getStr4(int $this$str4) {
        Object object;
        block1: {
            int n;
            block4: {
                block3: {
                    block2: {
                        block0: {
                            n = $this$str4;
                            boolean bl = 0 <= n ? n < 10 : false;
                            if (!bl) break block0;
                            object = "000" + $this$str4;
                            break block1;
                        }
                        boolean bl = 10 <= n ? n < 100 : false;
                        if (!bl) break block2;
                        object = "00" + $this$str4;
                        break block1;
                    }
                    boolean bl = 100 <= n ? n < 1000 : false;
                    if (!bl) break block3;
                    object = "0" + $this$str4;
                    break block1;
                }
                boolean bl = -9 <= n ? n < 0 : false;
                if (!bl) break block4;
                object = "-000" + Math.abs($this$str4);
                break block1;
            }
            object = (-99 <= n ? n < -9 : false) ? "-00" + Math.abs($this$str4) : ((-999 <= n ? n < -99 : false) ? "-0" + Math.abs($this$str4) : String.valueOf($this$str4));
        }
        return object;
    }

    @NotNull
    public static final Timestamp toTimestamp(@NotNull java.util.Date $this$toTimestamp) {
        Intrinsics.checkNotNullParameter((Object)$this$toTimestamp, (String)"<this>");
        return new Timestamp($this$toTimestamp.getTime());
    }

    public static final DateTimeFormatter getLocaleDataTimeFormatterMediumStyle() {
        return localeDataTimeFormatterMediumStyle;
    }
}

