/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.resultUI;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesPresentation;
import com.intellij.dupLocator.resultUI.BasicTreeNode;
import com.intellij.dupLocator.resultUI.CodeFragmentType;
import com.intellij.dupLocator.resultUI.DuplicatesModel;
import com.intellij.dupLocator.resultUI.GroupNode;
import com.intellij.dupLocator.resultUI.InvalidatedException;
import com.intellij.dupLocator.resultUI.UsagesEditSourceDescriptor;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageInfo;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeNode
extends BasicTreeNode {
    private RangeMarker myRangeMarker;
    private VirtualFile myVirtualFile;
    private final int myIndex;
    private final DuplicatesPresentation myPresentation;
    private final PsiFragment myFragment;

    public CodeNode(GroupNode parent, @NotNull PsiFragment fragment, @Nullable UsageInfo info, int index) {
        PsiElement psiElement;
        if (fragment == null) {
            CodeNode.J(0);
        }
        super(false, parent);
        this.myFragment = fragment;
        this.myPresentation = parent.getPresentation();
        this.myIndex = index;
        if (info != null && (psiElement = info.getElement()) != null) {
            PsiElement psiElement2;
            TextRange textRange = psiElement.getTextRange().cutOut((TextRange)info.getRangeInElement());
            this.myVirtualFile = psiElement.getContainingFile().getVirtualFile();
            Document document = FileDocumentManager.getInstance().getDocument(this.myVirtualFile);
            int n2 = textRange.getStartOffset();
            int n3 = document.getLineNumber(n2);
            int n4 = document.getLineStartOffset(n3);
            PsiElement psiElement3 = psiElement.getContainingFile().findElementAt(n4);
            if (psiElement3 instanceof PsiWhiteSpace && (psiElement2 = PsiTreeUtil.skipWhitespacesForward((PsiElement)psiElement3)) != null && psiElement2.getTextRange().getStartOffset() == n2) {
                n2 = n4;
            }
            this.myRangeMarker = document.createRangeMarker(n2, textRange.getEndOffset(), true);
        }
    }

    public PsiFragment getFragment() {
        return this.myFragment;
    }

    @Nullable
    public DuplicatesPresentation getPresentation() {
        return this.myPresentation;
    }

    @Override
    protected TreeNode[] getChildren() {
        return new TreeNode[0];
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public GroupNode getParent() {
        return (GroupNode)super.getParent();
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Nullable
    public DocumentContent getDiffContentIfValid() {
        try {
            RangeMarker rangeMarker = this.getRangeMarker();
            Document document = rangeMarker.getDocument();
            TextRange textRange = rangeMarker.getTextRange();
            return DiffContentFactory.getInstance().createFragment(this.getProject(), document, textRange);
        }
        catch (InvalidatedException invalidatedException) {
            return null;
        }
    }

    public CellAppearanceEx getTitle(boolean selected) {
        CompositeAppearance compositeAppearance = null;
        try {
            CodeFragmentType codeFragmentType;
            DuplicatesPresentation duplicatesPresentation = this.getPresentation();
            if (duplicatesPresentation != null && (codeFragmentType = duplicatesPresentation.getType(this)) != null) {
                compositeAppearance = codeFragmentType.getTitle(selected);
            }
        }
        catch (InvalidatedException invalidatedException) {
            // empty catch block
        }
        if (compositeAppearance == null) {
            compositeAppearance = CodeNode.invalidTitle();
        }
        compositeAppearance.getBeginning().addText("#" + this.myIndex + " ", SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
        return compositeAppearance;
    }

    public VirtualFile getVirtualFile() throws InvalidatedException {
        if (this.myVirtualFile == null || !this.myVirtualFile.isValid()) {
            throw new InvalidatedException();
        }
        return this.myVirtualFile;
    }

    public boolean isValid() {
        return this.myRangeMarker != null && this.myRangeMarker.isValid();
    }

    public boolean isRightInDiff() {
        return Comparing.equal((Object)this.getModel().getRight(), (Object)this);
    }

    public boolean isLeftInDiff() {
        return Comparing.equal((Object)this.getModel().getLeft(), (Object)this);
    }

    @Override
    public DuplicatesModel getModel() {
        return this.getParent().getModel();
    }

    @Nullable
    public OpenFileDescriptor getOpenFileDescriptorIfValid() {
        try {
            return new UsagesEditSourceDescriptor(this.getProject(), this.getVirtualFile(), this.getTextRange(), false);
        }
        catch (InvalidatedException invalidatedException) {
            return null;
        }
    }

    public RangeMarker getRangeMarker() throws InvalidatedException {
        if (this.myRangeMarker == null || !this.myRangeMarker.isValid()) {
            throw new InvalidatedException();
        }
        return this.myRangeMarker;
    }

    public TextRange getTextRange() throws InvalidatedException {
        RangeMarker rangeMarker = this.getRangeMarker();
        return rangeMarker.getTextRange();
    }

    public static CompositeAppearance invalidTitle() {
        return CompositeAppearance.single((String)DupLocatorBundle.message((String)"duplicate.location.invalid", (Object[])new Object[0]), (SimpleTextAttributes)SimpleTextAttributes.ERROR_ATTRIBUTES);
    }

    public int getIndex() {
        return this.myIndex;
    }

    private static /* synthetic */ void J(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/dupLocator/resultUI/CodeNode", "<init>"));
    }
}

