/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.renderer;

import com.intellij.openapi.graph.GraphDataKeys;
import com.intellij.openapi.graph.builder.renderer.BasicNodeCellRenderer;
import com.intellij.openapi.graph.services.GraphExportService;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractColoredNodeCellRenderer
extends BasicNodeCellRenderer {
    public static final String GRAPH_NODE_SELECTED = "GRAPH_NODE_SELECTED";

    protected AbstractColoredNodeCellRenderer(ModificationTracker modificationTracker) {
        super(modificationTracker);
    }

    @Override
    @NotNull
    protected JComponent createNodeRealizerComponent(@NotNull Graph2DView view, @NotNull NodeRealizer realizer, @Nullable Object object, boolean isSelected) {
        if (view == null) {
            AbstractColoredNodeCellRenderer.J(0);
        }
        if (realizer == null) {
            AbstractColoredNodeCellRenderer.J(1);
        }
        CellRendererPanel cellRendererPanel = new CellRendererPanel();
        cellRendererPanel.setLayout((LayoutManager)new BorderLayout());
        cellRendererPanel.setBorder(this.getBorder(realizer, object, isSelected));
        cellRendererPanel.setFocusable(false);
        cellRendererPanel.setOpaque(true);
        ClientProperty.put((JComponent)cellRendererPanel, GraphDataKeys.VIEW_GRAPH_BUILDER, GraphDataKeys.getBuilder(view));
        cellRendererPanel.putClientProperty((Object)GRAPH_NODE_SELECTED, (Object)isSelected);
        this.tuneNode(realizer, (JPanel)cellRendererPanel);
        CellRendererPanel cellRendererPanel2 = cellRendererPanel;
        if (cellRendererPanel2 == null) {
            AbstractColoredNodeCellRenderer.J(2);
        }
        return cellRendererPanel2;
    }

    public abstract void tuneNode(NodeRealizer var1, JPanel var2);

    protected int getSelectionBorderWidth() {
        return 1;
    }

    @NotNull
    protected Border getBorder(NodeRealizer realizer, Object object, boolean isSelected) {
        Color color = this.getBorderColor(realizer, object, isSelected);
        if (GraphExportService.getInstance().isPrintMode()) {
            return new LineBorder(color, 2);
        }
        return isSelected ? new LineBorder(color, this.getSelectionBorderWidth(), true) : new LineBorder(color);
    }

    @NotNull
    protected Color getBorderColor(NodeRealizer realizer, Object object, boolean isSelected) {
        if (isSelected) {
            return new JBColor((Color)JBColor.ORANGE, (Color)JBColor.blue);
        }
        if (GraphExportService.getInstance().isPrintMode()) {
            Gray gray = Gray._168;
            if (gray == null) {
                AbstractColoredNodeCellRenderer.J(3);
            }
            return gray;
        }
        if (StartupUiUtil.isUnderDarcula()) {
            Gray gray = Gray._120;
            if (gray == null) {
                AbstractColoredNodeCellRenderer.J(4);
            }
            return gray;
        }
        JBColor jBColor = JBColor.LIGHT_GRAY;
        if (jBColor == null) {
            AbstractColoredNodeCellRenderer.J(5);
        }
        return jBColor;
    }

    private static /* synthetic */ void J(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "realizer";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/builder/renderer/AbstractColoredNodeCellRenderer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/builder/renderer/AbstractColoredNodeCellRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodeRealizerComponent";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBorderColor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createNodeRealizerComponent";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

