/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.renderer;

import com.intellij.openapi.graph.services.GraphExportService;
import com.intellij.openapi.graph.services.GraphNodeRealizerService;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BasicNodeCellRenderer
implements NodeCellRenderer {
    @NotNull
    private static final Key<MyRealizerComponents> MY_COMPONENTS_KEY = Key.create((String)"com.intellij.openapi.graph.builder.renderer.BasicNodeCellRenderer.MY_COMPONENTS_KEY");
    @Nullable
    private final ModificationTracker myCacheModificationTracker;

    protected BasicNodeCellRenderer(@Nullable ModificationTracker modificationTracker) {
        this.myCacheModificationTracker = modificationTracker;
    }

    @Override
    @NotNull
    public JComponent getNodeCellRendererComponent(@NotNull Graph2DView view, @NotNull NodeRealizer nodeRealizer, @Nullable Object object, boolean isSelected) {
        if (view == null) {
            BasicNodeCellRenderer.c(0);
        }
        if (nodeRealizer == null) {
            BasicNodeCellRenderer.c(1);
        }
        if (GraphExportService.getInstance().isPrintMode()) {
            JComponent jComponent = this.createNodeRealizerComponent(view, nodeRealizer, object, isSelected);
            UIUtil.uiTraverser((Component)jComponent).forEach(component -> component.setBackground((Color)JBColor.white));
            JComponent jComponent2 = jComponent;
            if (jComponent2 == null) {
                BasicNodeCellRenderer.c(2);
            }
            return jComponent2;
        }
        MyRealizerComponents myRealizerComponents = GraphNodeRealizerService.getInstance().getUserData(nodeRealizer, MY_COMPONENTS_KEY);
        if (myRealizerComponents == null) {
            myRealizerComponents = new MyRealizerComponents();
            GraphNodeRealizerService.getInstance().putUserData(nodeRealizer, MY_COMPONENTS_KEY, myRealizerComponents);
        }
        JComponent jComponent = myRealizerComponents.getOrCompute(this.myCacheModificationTracker, view, nodeRealizer, object, isSelected);
        this.beforeShown(jComponent, view, nodeRealizer, object, isSelected);
        JComponent jComponent3 = jComponent;
        if (jComponent3 == null) {
            BasicNodeCellRenderer.c(3);
        }
        return jComponent3;
    }

    @NotNull
    protected Object createNodeRealizerComponentKey(@NotNull Graph2DView view, @NotNull NodeRealizer nodeRealizer, @Nullable Object object, boolean isSelected) {
        if (view == null) {
            BasicNodeCellRenderer.c(4);
        }
        if (nodeRealizer == null) {
            BasicNodeCellRenderer.c(5);
        }
        Boolean bl = isSelected;
        if (bl == null) {
            BasicNodeCellRenderer.c(6);
        }
        return bl;
    }

    @NotNull
    protected abstract JComponent createNodeRealizerComponent(@NotNull Graph2DView var1, @NotNull NodeRealizer var2, @Nullable Object var3, boolean var4);

    protected void beforeShown(@NotNull JComponent component, @NotNull Graph2DView view, @NotNull NodeRealizer nodeRealizer, @Nullable Object object, boolean isSelected) {
        if (component == null) {
            BasicNodeCellRenderer.c(7);
        }
        if (view == null) {
            BasicNodeCellRenderer.c(8);
        }
        if (nodeRealizer == null) {
            BasicNodeCellRenderer.c(9);
        }
    }

    private static /* synthetic */ void c(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 2, 3, 6 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeRealizer";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/builder/renderer/BasicNodeCellRenderer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/builder/renderer/BasicNodeCellRenderer";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeCellRendererComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodeRealizerComponentKey";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNodeCellRendererComponent";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createNodeRealizerComponentKey";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "beforeShown";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6 -> new IllegalStateException(string);
        };
    }

    private final class MyRealizerComponents {
        @NotNull
        private final Map<Object, JComponent> myComponents = new HashMap<Object, JComponent>(2);
        private long myModificationCount = 0L;

        private MyRealizerComponents() {
        }

        @NotNull
        public JComponent getOrCompute(@Nullable ModificationTracker modificationTracker, @NotNull Graph2DView view, @NotNull NodeRealizer nodeRealizer, @Nullable Object object, boolean isSelected) {
            long l10;
            if (view == null) {
                MyRealizerComponents.c(0);
            }
            if (nodeRealizer == null) {
                MyRealizerComponents.c(1);
            }
            long l11 = l10 = modificationTracker != null ? modificationTracker.getModificationCount() : 0L;
            if (l10 != this.myModificationCount) {
                this.myModificationCount = l10;
                this.myComponents.clear();
            }
            JComponent jComponent = this.myComponents.computeIfAbsent(BasicNodeCellRenderer.this.createNodeRealizerComponentKey(view, nodeRealizer, object, isSelected), object2 -> BasicNodeCellRenderer.this.createNodeRealizerComponent(view, nodeRealizer, object, isSelected));
            if (jComponent == null) {
                MyRealizerComponents.c(2);
            }
            return jComponent;
        }

        private static /* synthetic */ void c(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeRealizer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/graph/builder/renderer/BasicNodeCellRenderer$MyRealizerComponents";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/graph/builder/renderer/BasicNodeCellRenderer$MyRealizerComponents";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCompute";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrCompute";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

