/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.graph.base.DataProvider;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphEditModeFactory;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.util.DataProviderFactory;
import com.intellij.openapi.graph.impl.builder.BasicPopupMode;
import com.intellij.openapi.graph.impl.builder.GraphBuilderImpl;
import com.intellij.openapi.graph.services.GraphGroupingService;
import com.intellij.openapi.graph.view.CellEditorMode;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.HitInfo;
import com.intellij.openapi.graph.view.NodeCellRendererPainter;
import com.intellij.openapi.graph.view.PopupMode;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphEditModeFactoryImpl
extends GraphEditModeFactory {
    @Override
    @NotNull
    public <N, E> EditMode createEditMode(final @NotNull GraphBuilder<N, E> builder) {
        if (builder == null) {
            GraphEditModeFactoryImpl.J(0);
        }
        final GraphPresentationModel<N, E> graphPresentationModel = builder.getGraphPresentationModel();
        return new EditMode(){

            @Override
            @Nullable
            public String getNodeTip(@Nullable Node node) {
                return builder.getActionExecutor().tryComputeReadAction(null, () -> {
                    Object t2 = builder.getActionExecutor().suppressComputableReadLockAssertion(() -> builder.getNodeObject(node));
                    return t2 == null ? null : graphPresentationModel.getNodeTooltip(t2);
                });
            }

            @Override
            @Nullable
            public String getEdgeTip(@Nullable Edge edge) {
                return builder.getActionExecutor().tryComputeReadAction(null, () -> {
                    Object t2 = builder.getActionExecutor().suppressComputableReadLockAssertion(() -> builder.getEdgeObject(edge));
                    return t2 == null ? null : graphPresentationModel.getEdgeTooltip(t2);
                });
            }

            @Override
            public void mouseClicked(@NotNull MouseEvent mouseEvent) {
                if (mouseEvent == null) {
                    1.c(0);
                }
                if (mouseEvent.getClickCount() == 2) {
                    if (!(builder instanceof GraphBuilderImpl) || !((GraphBuilderImpl)builder).isUpdating()) {
                        HitInfo hitInfo = this.getHitInfo(mouseEvent);
                        Node node = hitInfo.getHitNode();
                        Edge edge = hitInfo.getHitEdge();
                        if (node != null) {
                            if (GraphGroupingService.getInstance().isGroupOrFolderNode(builder, node)) {
                                builder.getActionExecutor().runGraphActionAsync(() -> {
                                    GraphGroupingService.getInstance().toggleGroup(builder, node, graphPresentationModel.getSettings().isCollapseEdgesOnGrouping());
                                    GraphEditModeFactoryImpl.this.update(builder);
                                });
                            }
                            super.mouseClicked(mouseEvent);
                        } else if (edge != null) {
                            graphPresentationModel.editEdge(builder.getEdgeObject(edge));
                        }
                    }
                } else {
                    super.mouseClicked(mouseEvent);
                }
            }

            @Override
            public boolean editNode(@Nullable Node node, @Nullable EventObject eventObject) {
                Object t2 = builder.getActionExecutor().suppressComputableReadLockAssertion(() -> builder.getNodeObject(node));
                return graphPresentationModel.editNode(t2);
            }

            private static /* synthetic */ void c(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mouseEvent", "com/intellij/openapi/graph/impl/builder/GraphEditModeFactoryImpl$1", "mouseClicked"));
            }
        };
    }

    @Override
    @NotNull
    public <N, E> PopupMode createPopupMode(final @NotNull GraphBuilder<N, E> builder) {
        if (builder == null) {
            GraphEditModeFactoryImpl.J(1);
        }
        final GraphPresentationModel<N, E> graphPresentationModel = builder.getGraphPresentationModel();
        return new BasicPopupMode(this, graphPresentationModel){

            @Override
            @NotNull
            protected DefaultActionGroup getNodeActions(@Nullable Node node) {
                DefaultActionGroup defaultActionGroup = graphPresentationModel.getNodeActionGroup(builder.getActionExecutor().suppressComputableReadLockAssertion(() -> builder.getNodeObject(node)));
                if (defaultActionGroup == null) {
                    2.c(0);
                }
                return defaultActionGroup;
            }

            @Override
            @NotNull
            protected DefaultActionGroup getEdgeActions(@Nullable Edge edge) {
                DefaultActionGroup defaultActionGroup = graphPresentationModel.getEdgeActionGroup(builder.getActionExecutor().suppressComputableReadLockAssertion(() -> builder.getEdgeObject(edge)));
                if (defaultActionGroup == null) {
                    2.c(1);
                }
                return defaultActionGroup;
            }

            @Override
            @NotNull
            protected DefaultActionGroup getPaperPopupActions() {
                DefaultActionGroup defaultActionGroup = graphPresentationModel.getPaperActionGroup();
                if (defaultActionGroup == null) {
                    2.c(2);
                }
                return defaultActionGroup;
            }

            private static /* synthetic */ void c(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/openapi/graph/impl/builder/GraphEditModeFactoryImpl$2";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodeActions";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getEdgeActions";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPaperPopupActions";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @Override
    @NotNull
    public <N, E> CellEditorMode createCellEditorMode(@NotNull GraphBuilder<N, E> builder) {
        if (builder == null) {
            GraphEditModeFactoryImpl.J(2);
        }
        return new CellEditorMode(this, GraphEditModeFactoryImpl.c(builder), NodeCellRendererPainter.USER_DATA_MAP){};
    }

    protected <N, E> void update(@NotNull GraphBuilder<N, E> builder) {
        if (builder == null) {
            GraphEditModeFactoryImpl.J(3);
        }
        builder.queryGraphUpdate().withDataReload().withRelayout().run();
    }

    @NotNull
    private static <N, E> DataProvider c(final @NotNull GraphBuilder<N, E> graphBuilder) {
        if (graphBuilder == null) {
            GraphEditModeFactoryImpl.J(4);
        }
        return new DataProviderFactory.ProviderAdapter(){

            @Override
            @Nullable
            public Object get(@Nullable Object dataHolder) {
                return graphBuilder.getGraphPresentationModel().getCustomNodeCellEditor(graphBuilder.getNodeObject((Node)dataHolder));
            }
        };
    }

    private static /* synthetic */ void J(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "builder";
        objectArray2[1] = "com/intellij/openapi/graph/impl/builder/GraphEditModeFactoryImpl";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createEditMode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createPopupMode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createCellEditorMode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCellEditorDataProvider";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

