/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.util.NodeFactory;
import com.intellij.openapi.graph.impl.builder.GraphBuilderImpl;
import com.intellij.openapi.graph.impl.builder.GraphDataMaps;
import com.intellij.openapi.graph.impl.builder.GraphImplUtil;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import java.awt.Point;

public class NodeFactoryImpl
extends NodeFactory {
    @Override
    public <N, E> Node createNode(GraphBuilder<N, E> builder, N nodeObject, String nodeName) {
        builder.getActionExecutor().assertWriteAccess();
        Graph2D graph2D = builder.getGraph();
        GraphDataMaps graphDataMaps = ((GraphBuilderImpl)builder).getDataMaps();
        Node node = GraphImplUtil.createNode((Graph)graph2D, graphDataMaps, nodeName, nodeObject);
        GraphImplUtil.setNodeObject(graphDataMaps, node, nodeObject);
        builder.setNodeRealizer(node, builder.getGraphPresentationModel().getNodeRealizer(nodeObject));
        return node;
    }

    @Override
    public <N, E> Node createNode(GraphBuilder<N, E> builder, N nodeObject, String nodeName, Point location) {
        builder.getActionExecutor().assertWriteAccess();
        Graph2D graph2D = builder.getGraph();
        Graph2DView graph2DView = builder.getView();
        Node node = this.createNode(builder, nodeObject, nodeName);
        graph2D.setLocation(node, graph2DView.toWorldCoordX((int)location.getX()), graph2DView.toWorldCoordY((int)location.getY()));
        return node;
    }

    @Override
    public <N, E> Node createDraggedNode(GraphBuilder<N, E> builder, N nodeObject, String nodeName, Point location) {
        builder.getActionExecutor().assertWriteAccess();
        Node node = this.createNode(builder, nodeObject, nodeName, location);
        GraphBuilderImpl graphBuilderImpl = (GraphBuilderImpl)builder;
        GraphImplUtil.setNodeWasDragged(graphBuilderImpl.getDataMaps(), node);
        builder.queryGraphUpdate().withDataReload().withRelayout().run();
        return node;
    }
}

