/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.logging;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.lsp.impl.logging.LanguageServiceLoggerKt;
import com.intellij.platform.lsp.impl.logging.LanguageServiceLoggerServiceKt;
import java.io.BufferedOutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0019\u001a\u00020\u0007H\u0002J\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J,\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020#2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u000e0'H\u0002J\b\u0010(\u001a\u00020#H\u0002J\r\u0010)\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b*R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006+"}, d2={"Lcom/intellij/platform/lsp/impl/logging/LanguageServiceLogger;", "", "logPath", "Ljava/nio/file/Path;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "writeStandardLogIfLimitReached", "", "LanguageServiceLogger", "(Ljava/nio/file/Path;Lkotlinx/coroutines/CoroutineScope;Z)V", "getLogPath$intellij_platform_lsp_impl", "()Ljava/nio/file/Path;", "flushRequests", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "flushRequestJob", "Lkotlinx/coroutines/Job;", "logSizeChars", "", "writer", "Ljava/io/PrintWriter;", "c", "()Ljava/io/PrintWriter;", "writer$delegate", "Lkotlin/Lazy;", "c", "logInbound", "message", "", "logOutbound", "logError", "J", "R", "c", "c", "", "c", "channelTag", "logToIdeaLog", "Lkotlin/Function1;", "c", "close", "close$intellij_platform_lsp_impl", "intellij.platform.lsp.impl"})
public final class LanguageServiceLogger {
    @NotNull
    private final Path logPath;
    private final boolean writeStandardLogIfLimitReached;
    @NotNull
    private final MutableSharedFlow<Unit> flushRequests;
    @NotNull
    private final Job flushRequestJob;
    private int logSizeChars;
    @NotNull
    private final Lazy writer$delegate;

    public LanguageServiceLogger(@NotNull Path logPath, @NotNull CoroutineScope cs2, boolean writeStandardLogIfLimitReached) {
        Intrinsics.checkNotNullParameter((Object)logPath, (String)"logPath");
        Intrinsics.checkNotNullParameter((Object)cs2, (String)"cs");
        this.logPath = logPath;
        this.writeStandardLogIfLimitReached = writeStandardLogIfLimitReached;
        this.flushRequests = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        this.writer$delegate = LazyKt.lazy(() -> LanguageServiceLogger.c(this));
        this.flushRequestJob = BuildersKt.launch$default((CoroutineScope)cs2, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ LanguageServiceLogger this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.debounce-HG0u8IE((Flow)FlowKt.sample-HG0u8IE((Flow)((Flow)this.this$0.flushRequests), (long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS)), (long)DurationKt.toDuration((int)100, (DurationUnit)DurationUnit.MILLISECONDS)).collect(new FlowCollector(){

                            public final Object emit(Unit it, Continuation<? super Unit> $completion) {
                                this$0.c().flush();
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final Path getLogPath$intellij_platform_lsp_impl() {
        return this.logPath;
    }

    private final PrintWriter c() {
        Lazy lazy = this.writer$delegate;
        return (PrintWriter)lazy.getValue();
    }

    private final boolean c() {
        return this.logSizeChars >= 100000000;
    }

    public final void logInbound(@NotNull CharSequence message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.c("IN ", message, (Function1<? super CharSequence, Unit>)((Function1)new Function1<CharSequence, Unit>((Object)this){

            public final void invoke(CharSequence p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                LanguageServiceLogger.access$logInboundToIdeaLog((LanguageServiceLogger)this.receiver, p0);
            }
        }));
    }

    public final void logOutbound(@NotNull CharSequence message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.c("OUT", message, (Function1<? super CharSequence, Unit>)((Function1)new Function1<CharSequence, Unit>((Object)this){

            public final void invoke(CharSequence p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                LanguageServiceLogger.access$logOutboundToIdeaLog((LanguageServiceLogger)this.receiver, p0);
            }
        }));
    }

    public final void logError(@NotNull CharSequence message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.c("ERR", message, (Function1<? super CharSequence, Unit>)((Function1)new Function1<CharSequence, Unit>((Object)this){

            public final void invoke(CharSequence p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                LanguageServiceLogger.access$logErrorToIdeaLog((LanguageServiceLogger)this.receiver, p0);
            }
        }));
    }

    private final void J(CharSequence charSequence) {
        LanguageServiceLoggerKt.access$getLOG$p().debug("<-- " + this.logPath.getFileName() + ": " + this.c(charSequence));
    }

    private final void R(CharSequence charSequence) {
        LanguageServiceLoggerKt.access$getLOG$p().debug("--> " + this.logPath.getFileName() + ": " + this.c(charSequence));
    }

    private final void c(CharSequence charSequence) {
        LanguageServiceLoggerKt.access$getLOG$p().debug("<xx " + this.logPath.getFileName() + ": " + this.c(charSequence));
    }

    private final String c(CharSequence charSequence) {
        String string = StringUtil.shortenTextWithEllipsis((String)((Object)charSequence).toString(), (int)3000, (int)500);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
        return string;
    }

    private final void c(String string, CharSequence charSequence, Function1<? super CharSequence, Unit> function1) {
        if (this.c() && this.writeStandardLogIfLimitReached || Registry.Companion.is("lsp.communication.standard.log.file", false)) {
            function1.invoke((Object)charSequence);
        }
        if (this.c()) {
            return;
        }
        this.logSizeChars += charSequence.length();
        for (String string2 : StringsKt.lineSequence((CharSequence)charSequence)) {
            if (!(((CharSequence)string2).length() > 0)) continue;
            this.c().write(this.c() + " " + string + " " + string2 + "\n");
        }
        if (this.c()) {
            this.c().write("LOG SIZE LIMIT REACHED\n");
            this.close$intellij_platform_lsp_impl();
            return;
        }
        if (!this.flushRequests.tryEmit((Object)Unit.INSTANCE)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    private final String c() {
        String string = LanguageServiceLoggerKt.access$getTIMESTAMP_FORMAT$p().format(LanguageServiceLoggerServiceKt.millisToDate(System.currentTimeMillis()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    public final void close$intellij_platform_lsp_impl() {
        Job.DefaultImpls.cancel$default((Job)this.flushRequestJob, null, (int)1, null);
        this.c().close();
    }

    private static final PrintWriter c(LanguageServiceLogger languageServiceLogger) {
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE};
        return new PrintWriter(new BufferedOutputStream(Files.newOutputStream(languageServiceLogger.logPath, openOptionArray)));
    }

    public static final /* synthetic */ void access$logInboundToIdeaLog(LanguageServiceLogger $this, CharSequence message) {
        $this.J(message);
    }

    public static final /* synthetic */ void access$logOutboundToIdeaLog(LanguageServiceLogger $this, CharSequence message) {
        $this.R(message);
    }

    public static final /* synthetic */ void access$logErrorToIdeaLog(LanguageServiceLogger $this, CharSequence message) {
        $this.c(message);
    }
}

