/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.logging;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.platform.lsp.impl.logging.LanguageServiceLogger;
import com.intellij.platform.lsp.impl.logging.LanguageServiceLoggerServiceKt;
import com.intellij.platform.lsp.impl.logging.LoggerBucket;
import com.intellij.util.io.Sanitize_nameKt;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\b2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/lsp/impl/logging/LanguageServiceLoggerService;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "LanguageServiceLoggerService", "(Lkotlinx/coroutines/CoroutineScope;)V", "loggers", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/platform/lsp/impl/logging/LoggerBucket;", "connect", "Lcom/intellij/platform/lsp/impl/logging/LanguageServiceLogger;", "logFileName", "writeStandardLogIfLimitReached", "", "disconnect", "", "logger", "Companion", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLanguageServiceLoggerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageServiceLoggerService.kt\ncom/intellij/platform/lsp/impl/logging/LanguageServiceLoggerService\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n72#2,2:145\n1#3:147\n1#3:148\n*S KotlinDebug\n*F\n+ 1 LanguageServiceLoggerService.kt\ncom/intellij/platform/lsp/impl/logging/LanguageServiceLoggerService\n*L\n39#1:145,2\n39#1:147\n*E\n"})
public final class LanguageServiceLoggerService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final ConcurrentHashMap<String, LoggerBucket> loggers;

    public LanguageServiceLoggerService(@NotNull CoroutineScope cs2) {
        Intrinsics.checkNotNullParameter((Object)cs2, (String)"cs");
        this.cs = cs2;
        this.loggers = new ConcurrentHashMap();
    }

    @Nullable
    public final LanguageServiceLogger connect(@NotNull String logFileName, boolean writeStandardLogIfLimitReached) {
        Intrinsics.checkNotNullParameter((Object)logFileName, (String)"logFileName");
        String string = Sanitize_nameKt.sanitizeFileName$default((String)logFileName, null, (boolean)false, null, (int)14, null);
        ConcurrentMap concurrentMap = this.loggers;
        String string2 = string;
        boolean bl = false;
        Object object = concurrentMap.get(string2);
        if (object == null) {
            boolean bl2 = false;
            LoggerBucket loggerBucket = new LoggerBucket(string, this.cs);
            boolean bl3 = false;
            object = concurrentMap.putIfAbsent(string2, loggerBucket);
            if (object == null) {
                object = loggerBucket;
            }
        }
        LoggerBucket loggerBucket = (LoggerBucket)object;
        return loggerBucket.connect(writeStandardLogIfLimitReached);
    }

    public static /* synthetic */ LanguageServiceLogger connect$default(LanguageServiceLoggerService languageServiceLoggerService, String string, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return languageServiceLoggerService.connect(string, bl);
    }

    public final void disconnect(@NotNull LanguageServiceLogger logger) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Collection<LoggerBucket> collection = this.loggers.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable iterable = collection;
            for (Object t2 : iterable) {
                LoggerBucket loggerBucket = (LoggerBucket)t2;
                boolean bl = false;
                if (!loggerBucket.containsLogger(logger)) continue;
                v1 = t2;
                break block2;
            }
            v1 = null;
        }
        LoggerBucket loggerBucket = v1;
        if (loggerBucket == null) {
            LanguageServiceLoggerServiceKt.access$getLOG$p().error("Cannot find a bucket of " + logger.getLogPath$intellij_platform_lsp_impl().getFileName());
            return;
        }
        loggerBucket.disconnect(logger);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/lsp/impl/logging/LanguageServiceLoggerService$Companion;", "", "LanguageServiceLoggerService$Companion", "()V", "getInstance", "Lcom/intellij/platform/lsp/impl/logging/LanguageServiceLoggerService;", "isDebugLogEnabled", "", "intellij.platform.lsp.impl"})
    @SourceDebugExtension(value={"SMAP\nLanguageServiceLoggerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageServiceLoggerService.kt\ncom/intellij/platform/lsp/impl/logging/LanguageServiceLoggerService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,144:1\n42#2,3:145\n*S KotlinDebug\n*F\n+ 1 LanguageServiceLoggerService.kt\ncom/intellij/platform/lsp/impl/logging/LanguageServiceLoggerService$Companion\n*L\n31#1:145,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LanguageServiceLoggerService getInstance() {
            boolean bl = false;
            Class<LanguageServiceLoggerService> clazz = LanguageServiceLoggerService.class;
            Object object = ApplicationManager.getApplication().getService(clazz);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + clazz.getName() + " (classloader=" + clazz.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (LanguageServiceLoggerService)object;
        }

        public final boolean isDebugLogEnabled() {
            return LanguageServiceLoggerServiceKt.access$getLOG$p().isDebugEnabled();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

