/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clones.presentation;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestPanel;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.clones.structures.TextClone;
import com.jetbrains.clones.structures.TextFragment;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PreviewPanel
extends JPanel {
    private final Project myProject;
    private final DiffRequestPanel myDiffPanel;
    private TextClone myTextClone;

    public PreviewPanel(@NotNull Project project, @NotNull Disposable parent) {
        if (project == null) {
            PreviewPanel.c(0);
        }
        if (parent == null) {
            PreviewPanel.c(1);
        }
        super(new BorderLayout());
        this.myProject = project;
        this.myDiffPanel = DiffManager.getInstance().createRequestPanel(project, parent, null);
        this.myDiffPanel.putContextHints(DiffUserDataKeys.PLACE, (Object)"DuplicateInspectionPresentation");
        this.myDiffPanel.putContextHints(DiffUserDataKeys.FORCE_READ_ONLY, (Object)true);
        this.add((Component)this.myDiffPanel.getComponent(), "Center");
    }

    public void setTextClone(TextClone textClone) {
        this.myTextClone = textClone;
    }

    public void selectDuplicate(@NotNull TextFragment duplicate) {
        if (duplicate == null) {
            PreviewPanel.c(2);
        }
        SimpleDiffRequest simpleDiffRequest = this.c(this.myTextClone.getMain(), duplicate);
        this.myDiffPanel.setRequest((DiffRequest)simpleDiffRequest);
    }

    @Nullable
    private SimpleDiffRequest c(@NotNull TextFragment textFragment, @NotNull TextFragment textFragment2) {
        if (textFragment == null) {
            PreviewPanel.c(3);
        }
        if (textFragment2 == null) {
            PreviewPanel.c(4);
        }
        DocumentContent documentContent = PreviewPanel.createContent(this.myProject, textFragment);
        DocumentContent documentContent2 = PreviewPanel.createContent(this.myProject, textFragment2);
        if (documentContent == null || documentContent2 == null) {
            return null;
        }
        return new SimpleDiffRequest(null, (DiffContent)documentContent, (DiffContent)documentContent2, PreviewPanel.getFragmentTitle(textFragment), PreviewPanel.getFragmentTitle(textFragment2));
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    @NlsSafe
    static String getFragmentTitle(@Nullable TextFragment fragment) {
        if (fragment == null) {
            return null;
        }
        IntRange intRange = (IntRange)ReadAction.compute(() -> fragment.getLines());
        return fragment.getFile().getPresentableName() + " " + intRange.getStart() + "-" + intRange.getEndInclusive();
    }

    @Nullable
    public static DocumentContent createContent(@NotNull Project project, @NotNull TextFragment fragment) {
        PsiFile psiFile;
        if (project == null) {
            PreviewPanel.c(5);
        }
        if (fragment == null) {
            PreviewPanel.c(6);
        }
        if ((psiFile = PsiManager.getInstance((Project)project).findFile(fragment.getFile())) == null) {
            return null;
        }
        Document document = psiFile.getViewProvider().getDocument();
        TextRange textRange = PreviewPanel.c(document, fragment.getRange());
        return DiffContentFactory.getInstance().createFragment(project, document, textRange);
    }

    @Nullable
    public static DocumentContent createContent(@NotNull Project project, @NotNull RangeMarker rangeMarker) {
        if (project == null) {
            PreviewPanel.c(7);
        }
        if (rangeMarker == null) {
            PreviewPanel.c(8);
        }
        if (!rangeMarker.isValid()) {
            return null;
        }
        TextRange textRange = PreviewPanel.c(rangeMarker.getDocument(), rangeMarker.getTextRange());
        return DiffContentFactory.getInstance().createFragment(project, rangeMarker.getDocument(), textRange);
    }

    @NotNull
    private static TextRange c(@NotNull Document document, @NotNull TextRange textRange) {
        if (document == null) {
            PreviewPanel.c(9);
        }
        if (textRange == null) {
            PreviewPanel.c(10);
        }
        int n2 = document.getLineStartOffset(document.getLineNumber(textRange.getStartOffset()));
        int n3 = document.getLineEndOffset(document.getLineNumber(textRange.getEndOffset()));
        return new TextRange(n2, n3);
    }

    private static /* synthetic */ void c(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicate";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "main";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeMarker";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/clones/presentation/PreviewPanel";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "selectDuplicate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createDiffRequest";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createContent";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "extendRangeToWholeLines";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

