/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.completion.frontend.split;

import com.intellij.codeInsight.completion.FrontendFriendlyInsertHandler;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.platform.completion.common.protocol.RpcCompletionItem;
import com.intellij.platform.completion.common.protocol.RpcCompletionRequestId;
import com.intellij.platform.completion.common.protocol.RpcInsertHandler;
import com.intellij.platform.completion.frontend.split.FrontendCompletionLoggerKt;
import com.intellij.platform.completion.frontend.split.FrontendLookupElement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/completion/frontend/split/FrontendInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/platform/completion/frontend/split/FrontendLookupElement;", "requestId", "Lcom/intellij/platform/completion/common/protocol/RpcCompletionRequestId;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/platform/completion/common/protocol/RpcCompletionRequestId;Lcom/intellij/openapi/project/Project;)V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "lookupElement", "intellij.platform.completion.frontend.split"})
public final class FrontendInsertHandler
implements InsertHandler<FrontendLookupElement> {
    @NotNull
    private final RpcCompletionRequestId requestId;
    @NotNull
    private final Project project;

    public FrontendInsertHandler(@NotNull RpcCompletionRequestId requestId, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.requestId = requestId;
        this.project = project;
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull FrontendLookupElement lookupElement) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)lookupElement), (String)"lookupElement");
        RpcCompletionItem item = lookupElement.getItem();
        FrontendCompletionLoggerKt.getFcLogger().info("Handle insert for lookup element: " + item.getId());
        RpcInsertHandler rpcInsertHandler = item.getInsertHandler();
        if (rpcInsertHandler instanceof RpcInsertHandler.Frontend) {
            FrontendFriendlyInsertHandler insertHandler = ((RpcInsertHandler.Frontend)rpcInsertHandler).getInsertHandler();
            FrontendCompletionLoggerKt.getFcLogger().info("handle insert for " + item.getId() + ": running frontend insert handler " + insertHandler);
            insertHandler.handleInsert(context, (LookupElement)lookupElement);
        } else if (Intrinsics.areEqual((Object)rpcInsertHandler, (Object)RpcInsertHandler.Backend.INSTANCE)) {
            FrontendCompletionLoggerKt.getFcLogger().info("handle insert for " + item.getId() + ": delegating to backend");
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }
}

