/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.serviceView;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.ServiceViewToolWindowDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.platform.execution.serviceView.ServiceTreeNode;
import com.intellij.platform.execution.serviceView.ServiceViewCoroutineScopeProvider;
import com.intellij.platform.execution.serviceView.ServiceViewManagerImpl;
import com.intellij.platform.execution.serviceView.ServicesTree;
import com.intellij.platform.execution.serviceView.splitApi.ServiceViewConfigurationType;
import com.intellij.platform.execution.serviceView.splitApi.ServiceViewConfigurationTypeSettings;
import com.intellij.platform.execution.serviceView.splitApi.ServiceViewRpc;
import com.intellij.platform.project.ProjectIdKt;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tH\u0002J\b\u0010\u0014\u001a\u00020\rH\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/platform/execution/serviceView/ConfigureServicesDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/platform/execution/serviceView/splitApi/ServiceViewConfigurationTypeSettings;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/platform/execution/serviceView/splitApi/ServiceViewConfigurationTypeSettings;)V", "includedServicesTree", "Lcom/intellij/platform/execution/serviceView/ServicesTree;", "excludedServicesTree", "initiallyFocusedTree", "createCenterPanel", "Ljavax/swing/JComponent;", "moveToExcluded", "", "moveToIncluded", "move", "from", "to", "getPreferredFocusedComponent", "doOKAction", "Companion", "intellij.platform.execution.serviceView"})
public final class ConfigureServicesDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ServicesTree includedServicesTree;
    @NotNull
    private final ServicesTree excludedServicesTree;
    @NotNull
    private final ServicesTree initiallyFocusedTree;

    public ConfigureServicesDialog(@NotNull Project project, @NotNull ServiceViewConfigurationTypeSettings settings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(project);
        this.project = project;
        String string = ExecutionBundle.message((String)"service.view.configure.run.configuration.types", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.includedServicesTree = new ServicesTree(this.project, string);
        String string2 = ExecutionBundle.message((String)"service.view.configure.run.tool.windows", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this.excludedServicesTree = new ServicesTree(this.project, string2);
        String string3 = ExecutionBundle.message((String)"service.view.configure.dialog.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        String baseText = string3;
        if (this.project.isDefault()) {
            Object[] objectArray = new Object[]{baseText};
            this.setTitle(IdeUICustomization.getInstance().projectMessage("title.for.new.projects", objectArray));
        } else {
            this.setTitle(baseText);
        }
        Pair<List<ServiceViewContributor<?>>, List<ServiceViewContributor<?>>> services = Companion.collectServices$intellij_platform_execution_serviceView(this.project);
        this.includedServicesTree.initTree((Collection)services.getFirst(), (Collection<ServiceViewConfigurationType>)settings.getIncluded(), true);
        this.excludedServicesTree.initTree((Collection)services.getSecond(), (Collection<ServiceViewConfigurationType>)settings.getExcluded(), false);
        this.initiallyFocusedTree = this.includedServicesTree;
        this.init();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel buttonsPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        JButton moveToExcludedButton = new JButton(ExecutionBundle.message((String)"service.view.configure.exclude.button.text", (Object[])new Object[0]));
        JButton moveToIncludedButton = new JButton(ExecutionBundle.message((String)"service.view.configure.include.button.text", (Object[])new Object[0]));
        moveToExcludedButton.addActionListener(arg_0 -> ConfigureServicesDialog.createCenterPanel$lambda$0(this, arg_0));
        moveToIncludedButton.addActionListener(arg_0 -> ConfigureServicesDialog.createCenterPanel$lambda$1(this, arg_0));
        buttonsPanel.add(moveToExcludedButton);
        buttonsPanel.add(moveToIncludedButton);
        this.includedServicesTree.installDoubleClickListener((Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ConfigureServicesDialog.access$moveToExcluded((ConfigureServicesDialog)((Object)this.receiver));
            }
        }));
        this.excludedServicesTree.installDoubleClickListener((Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ConfigureServicesDialog.access$moveToIncluded((ConfigureServicesDialog)((Object)this.receiver));
            }
        }));
        JPanel mainPanel = new JPanel(new BorderLayout());
        GridBag gridBag = new GridBag().setDefaultWeightX(0, 0.5).setDefaultWeightX(1, 0.0).setDefaultWeightX(2, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)gridBag, (String)"setDefaultWeightX(...)");
        GridBag gridBag2 = gridBag;
        JPanel treesPanel = new JPanel(new GridBagLayout());
        treesPanel.add((Component)new JBLabel(ExecutionBundle.message((String)"service.view.configure.included.label.text", (Object[])new Object[0])), gridBag2.nextLine().next().anchor(17));
        treesPanel.add((Component)new JBLabel(ExecutionBundle.message((String)"service.view.configure.excluded.label.text", (Object[])new Object[0])), gridBag2.next().next().anchor(17));
        JBScrollPane includedPane = new JBScrollPane((Component)this.includedServicesTree.getTree());
        treesPanel.add((Component)includedPane, gridBag2.nextLine().next().weighty(1.0).fillCell());
        treesPanel.add((Component)buttonsPanel, gridBag2.next().anchor(11));
        JBScrollPane excludedPane = new JBScrollPane((Component)this.excludedServicesTree.getTree());
        excludedPane.setPreferredSize(includedPane.getPreferredSize());
        treesPanel.add((Component)excludedPane, gridBag2.next().weighty(1.0).fillCell());
        mainPanel.add((Component)treesPanel, "Center");
        JPanel statusPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)statusPanel, "South");
        JBLabel statusLabel = new JBLabel();
        statusLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)ExecutionBundle.message((String)"service.view.configure.dialog.description", (Object[])new Object[0])));
        statusLabel.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        statusPanel.add((Component)statusLabel, "North");
        if (!this.project.isDefault()) {
            String string = ExecutionBundle.message((String)"service.view.configure.dialog.new.project.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            ActionLink actionLink2 = new ActionLink(string, arg_0 -> ConfigureServicesDialog.createCenterPanel$lambda$2(this, arg_0));
            actionLink2.setBorder((Border)JBUI.Borders.emptyTop((int)10));
            actionLink2.setBackground(JBColor.background());
            statusPanel.add((Component)actionLink2, "South");
        }
        return mainPanel;
    }

    private final void moveToExcluded() {
        this.move(this.includedServicesTree, this.excludedServicesTree);
    }

    private final void moveToIncluded() {
        this.move(this.excludedServicesTree, this.includedServicesTree);
    }

    private final void move(ServicesTree from, ServicesTree to) {
        List<ServiceTreeNode> nodes = from.getSelectedNodes();
        if (nodes.isEmpty()) {
            return;
        }
        int oldSelectedRow = from.getTree().getSelectionModel().getLeadSelectionRow();
        from.removeNodes((Collection<? extends ServiceTreeNode>)nodes);
        to.addNodes((Collection<? extends ServiceTreeNode>)nodes);
        to.selectNodes((Collection<? extends ServiceTreeNode>)nodes);
        IdeFocusManager.getInstance((Project)this.project).requestFocus((Component)from.getTree(), true).doWhenDone(() -> ConfigureServicesDialog.move$lambda$0(from, oldSelectedRow));
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.initiallyFocusedTree.getTree();
    }

    protected void doOKAction() {
        ServiceViewManager serviceViewManager = ServiceViewManager.getInstance((Project)this.project);
        Intrinsics.checkNotNull((Object)serviceViewManager, (String)"null cannot be cast to non-null type com.intellij.platform.execution.serviceView.ServiceViewManagerImpl");
        ((ServiceViewManagerImpl)serviceViewManager).setExcludedContributors(this.excludedServicesTree.getServices());
        BuildersKt.launch$default((CoroutineScope)ServiceViewCoroutineScopeProvider.Companion.getInstance(this.project).getCs(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ConfigureServicesDialog this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = ServiceViewRpc.Companion.getInstance((Continuation<? super ServiceViewRpc>)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.label = 2;
                        v1 = ((ServiceViewRpc)v0).saveConfigurationTypes(ProjectIdKt.projectId((Project)ConfigureServicesDialog.access$getProject$p(this.this$0)), ConfigureServicesDialog.access$getIncludedServicesTree$p(this.this$0).getTypes(), (Continuation<? super Unit>)((Continuation)this));
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl21
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl21:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        super.doOKAction();
    }

    private static final void createCenterPanel$lambda$0(ConfigureServicesDialog this$0, ActionEvent it) {
        this$0.moveToExcluded();
    }

    private static final void createCenterPanel$lambda$1(ConfigureServicesDialog this$0, ActionEvent it) {
        this$0.moveToIncluded();
    }

    private static final Unit createCenterPanel$lambda$2(ConfigureServicesDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BuildersKt.launch$default((CoroutineScope)ServiceViewCoroutineScopeProvider.Companion.getInstance(this$0.project).getCs(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            Object L$0;
            int label;

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = ProjectManager.getInstance().getDefaultProject();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getDefaultProject(...)");
                        defaultProject = v0;
                        this.L$0 = defaultProject;
                        this.label = 1;
                        v1 = ServiceViewRpc.Companion.getInstance((Continuation<? super ServiceViewRpc>)((Continuation)this));
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        defaultProject = (Project)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl18:
                        // 2 sources

                        this.L$0 = defaultProject;
                        this.label = 2;
                        v2 = ((ServiceViewRpc)v1).loadConfigurationTypes(ProjectIdKt.projectId((Project)defaultProject), (Continuation<? super ServiceViewConfigurationTypeSettings>)((Continuation)this));
                        if (v2 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl28
                    }
                    case 2: {
                        defaultProject = (Project)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl28:
                        // 2 sources

                        v3 = (ServiceViewConfigurationTypeSettings)v2;
                        if (v3 == null) {
                            return Unit.INSTANCE;
                        }
                        defaultSettings = v3;
                        new ConfigureServicesDialog(defaultProject, defaultSettings).show();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return Unit.INSTANCE;
    }

    private static final void move$lambda$0(ServicesTree $from, int $oldSelectedRow) {
        $from.getTree().getSelectionModel().setSelectionPath($from.getTree().getPathForRow(RangesKt.coerceAtMost((int)$oldSelectedRow, (int)($from.getTree().getRowCount() - 1))));
    }

    public static final /* synthetic */ void access$moveToExcluded(ConfigureServicesDialog $this) {
        $this.moveToExcluded();
    }

    public static final /* synthetic */ void access$moveToIncluded(ConfigureServicesDialog $this) {
        $this.moveToIncluded();
    }

    public static final /* synthetic */ Project access$getProject$p(ConfigureServicesDialog $this) {
        return $this.project;
    }

    public static final /* synthetic */ ServicesTree access$getIncludedServicesTree$p(ConfigureServicesDialog $this) {
        return $this.includedServicesTree;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u0004\u001a\"\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00060\u00052\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/execution/serviceView/ConfigureServicesDialog$Companion;", "", "<init>", "()V", "collectServices", "Lkotlin/Pair;", "", "Lcom/intellij/execution/services/ServiceViewContributor;", "project", "Lcom/intellij/openapi/project/Project;", "collectServices$intellij_platform_execution_serviceView", "intellij.platform.execution.serviceView"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pair<List<ServiceViewContributor<?>>, List<ServiceViewContributor<?>>> collectServices$intellij_platform_execution_serviceView(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ArrayList<ServiceViewContributor> included = new ArrayList<ServiceViewContributor>();
            ArrayList<ServiceViewContributor> excluded = new ArrayList<ServiceViewContributor>();
            ServiceViewManager serviceViewManager = ServiceViewManager.getInstance((Project)project);
            for (ServiceViewContributor contributor : ServiceViewContributor.CONTRIBUTOR_EP_NAME.getExtensionList()) {
                String toolWindowId;
                ServiceViewDescriptor serviceViewDescriptor = contributor.getViewDescriptor(project);
                ServiceViewToolWindowDescriptor serviceViewToolWindowDescriptor = serviceViewDescriptor instanceof ServiceViewToolWindowDescriptor ? (ServiceViewToolWindowDescriptor)serviceViewDescriptor : null;
                if (serviceViewToolWindowDescriptor != null ? !serviceViewToolWindowDescriptor.isExclusionAllowed() : false) continue;
                String string = serviceViewManager.getToolWindowId(contributor.getClass());
                if (string == null) {
                    string = "Services";
                }
                boolean bl = Intrinsics.areEqual((Object)(toolWindowId = string), (Object)"Services") ? included.add(contributor) : excluded.add(contributor);
            }
            return new Pair(included, excluded);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

