/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.browse.ColorDeclarationType;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.ui.ColorPickerListener;
import com.intellij.ui.ColorPickerListenerFactory;
import com.jetbrains.liveEdit.LiveEditManager;
import com.jetbrains.liveEdit.rangeValue.RangeValueSynchronizer;
import com.jetbrains.liveEdit.rangeValue.RangeValueSynchronizerFactory;
import java.awt.Color;
import org.jetbrains.annotations.Nullable;

final class LiveEditColorPickerListenerFactory
extends ColorPickerListenerFactory {
    LiveEditColorPickerListenerFactory() {
    }

    @Nullable
    public ColorPickerListener createListener(@Nullable PsiElement element) {
        if (element == null || !element.isValid()) {
            return null;
        }
        PsiFile file = element.getContainingFile();
        if (file == null || !LiveEditManager.getInstance().isLiveOperable(file.getProject())) {
            return null;
        }
        return (ColorPickerListener)RangeValueSynchronizerFactory.applyAndGet(element, file, synchronizer -> new MyColorPickerListener((RangeValueSynchronizer)synchronizer, ColorDeclarationType.fromColorTerm((PsiElement)element)));
    }

    private static class MyColorPickerListener
    implements ColorPickerListener {
        private final RangeValueSynchronizer colorSynchronizer;
        private final ColorDeclarationType type;

        MyColorPickerListener(RangeValueSynchronizer colorSynchronizer, ColorDeclarationType type) {
            this.colorSynchronizer = colorSynchronizer;
            this.type = type;
        }

        public void colorChanged(Color color) {
            this.colorSynchronizer.sync(CssPsiColorUtil.convertTo((ColorDeclarationType)this.type, (Color)color));
        }

        public void closed(@Nullable Color color) {
            if (color != null) {
                this.colorSynchronizer.sync(CssPsiColorUtil.convertTo((ColorDeclarationType)this.type, (Color)color));
            } else {
                this.colorSynchronizer.revert();
            }
        }
    }
}

