/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.highlighting;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlTag;
import com.jetbrains.liveEdit.ApplicationInspector;
import com.jetbrains.liveEdit.CssSelectorCreator;
import com.jetbrains.liveEdit.PsiUtil;
import com.jetbrains.liveEdit.highlighting.ElementHighlightExecutor;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.Nullable;

final class LiveEditElementHighlightExecutor
extends ElementHighlightExecutor {
    LiveEditElementHighlightExecutor() {
    }

    @Override
    protected void doHighlight(Project project, XmlTag tag) {
        String selector;
        CssSelectorCreator selectorCreator = (CssSelectorCreator)ReadAction.compute(() -> PsiUtil.isTagHeadRole(tag) ? null : new CssSelectorCreator().create(tag));
        VirtualFile file = (VirtualFile)ReadAction.compute(() -> tag.getContainingFile().getViewProvider().getVirtualFile());
        String string = selector = selectorCreator == null ? null : selectorCreator.getSelector();
        if (selector == null) {
            this.hideHighlight(project, null);
        } else {
            this.lastHighlightedTagRef = new WeakReference<XmlTag>(tag);
            ApplicationInspector.getInstance().highlightElement(project, file, selector, selectorCreator.selectorSubject());
        }
    }

    @Override
    protected void doHideHighlight(Project project, @Nullable XmlTag ifElement) {
        ApplicationInspector.getInstance().hideHighlight(project);
    }
}

