/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.rangeValue;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.Function;
import com.jetbrains.liveEdit.ApplicationInspector;
import com.jetbrains.liveEdit.CssPsiUtil;
import com.jetbrains.liveEdit.rangeValue.BrowserBackedRangeValueSynchronizer;
import com.jetbrains.liveEdit.rangeValue.RangeValueSynchronizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RangeValueSynchronizerFactory<T> {
    public static final ExtensionPointName<RangeValueSynchronizerFactory<RangeValueSynchronizer>> EP_NAME = ExtensionPointName.create((String)"com.jetbrains.liveEdit.rangeValueSynchronizerFactory");

    @Nullable
    public abstract T create(@NotNull FileType var1, @NotNull PsiElement var2, @NotNull PsiFile var3);

    @Nullable
    public static <F extends RangeValueSynchronizerFactory<S>, S> S find(@NotNull PsiElement element, @NotNull PsiFile file, @NotNull ExtensionPointName<F> ep) {
        if (element == null) {
            RangeValueSynchronizerFactory.$$$reportNull$$$0(0);
        }
        if (file == null) {
            RangeValueSynchronizerFactory.$$$reportNull$$$0(1);
        }
        if (ep == null) {
            RangeValueSynchronizerFactory.$$$reportNull$$$0(2);
        }
        FileType fileType = file.getViewProvider().getFileType();
        for (RangeValueSynchronizerFactory factory : (RangeValueSynchronizerFactory[])ep.getExtensions()) {
            Object synchronizer = factory.create(fileType, element, file);
            if (synchronizer == null) continue;
            return (S)synchronizer;
        }
        return null;
    }

    @Nullable
    public static <R> R applyAndGet(PsiElement element, PsiFile file, Function<? super RangeValueSynchronizer, ? extends R> manager) {
        RangeValueSynchronizer synchronizer = (RangeValueSynchronizer)RangeValueSynchronizerFactory.find(element, file, EP_NAME);
        return (R)(synchronizer != null ? manager.fun((Object)synchronizer) : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "ep";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/liveEdit/rangeValue/RangeValueSynchronizerFactory";
        objectArray[2] = "find";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Css
    extends RangeValueSynchronizerFactory<RangeValueSynchronizer> {
        private static final Logger LOG = Logger.getInstance(Css.class);

        @Nullable
        private static CssDeclaration findCssDeclaration(PsiElement element) {
            CssDeclaration declaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, CssDeclaration.class);
            if (declaration == null && element instanceof PsiWhiteSpace && element.getPrevSibling() instanceof CssDeclaration) {
                declaration = (CssDeclaration)element.getPrevSibling();
            }
            return declaration;
        }

        @Override
        @Nullable
        public RangeValueSynchronizer create(@NotNull FileType fileType, @NotNull PsiElement element, @NotNull PsiFile file) {
            if (fileType == null) {
                Css.$$$reportNull$$$0(0);
            }
            if (element == null) {
                Css.$$$reportNull$$$0(1);
            }
            if (file == null) {
                Css.$$$reportNull$$$0(2);
            }
            if (fileType != CssFileType.INSTANCE) {
                return null;
            }
            CssDeclaration declaration = Css.findCssDeclaration(element);
            if (declaration == null) {
                return null;
            }
            CssRuleset ruleset = (CssRuleset)PsiTreeUtil.getParentOfType((PsiElement)declaration, CssRuleset.class);
            if (ruleset == null) {
                LOG.warn("cannot find css ruleset for " + declaration.getText());
                return null;
            }
            if (ruleset.getSelectorList() == null) {
                LOG.warn("invalid ruleset, cannot find selector list " + ruleset.getText());
                return null;
            }
            return Css.create(file, declaration);
        }

        @NotNull
        private static RangeValueSynchronizer create(@NotNull PsiFile file, @NotNull CssDeclaration declaration) {
            if (file == null) {
                Css.$$$reportNull$$$0(3);
            }
            if (declaration == null) {
                Css.$$$reportNull$$$0(4);
            }
            return new DeclarationValueSynchronizer(file, declaration);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "declaration";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/liveEdit/rangeValue/RangeValueSynchronizerFactory$Css";
            objectArray[2] = "create";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class DeclarationValueSynchronizer
        extends BrowserBackedRangeValueSynchronizer {
            private final VirtualFile file;
            private final CssDeclaration declaration;
            private final boolean isImportant;

            DeclarationValueSynchronizer(@NotNull PsiFile file, @NotNull CssDeclaration declaration) {
                if (file == null) {
                    DeclarationValueSynchronizer.$$$reportNull$$$0(0);
                }
                if (declaration == null) {
                    DeclarationValueSynchronizer.$$$reportNull$$$0(1);
                }
                super(file.getProject());
                this.file = file.getOriginalFile().getVirtualFile();
                this.declaration = declaration;
                this.isImportant = declaration.isImportant();
            }

            private void setProperty(@Nullable CharSequence value) {
                ApplicationInspector.getInstance().setCssProperty(this.project, this.file, this.declaration, value);
            }

            @Override
            protected void doRevert() {
                if (this.declaration.isValid()) {
                    this.setProperty(CssPsiUtil.getValue(this.declaration));
                }
            }

            @Override
            @Nullable
            protected CharSequence itemToString(@NotNull LookupElement item, @NotNull String itemLookupString, @NotNull Lookup lookup, boolean closed) {
                PsiElement nameElement;
                CssTermList value;
                if (item == null) {
                    DeclarationValueSynchronizer.$$$reportNull$$$0(2);
                }
                if (itemLookupString == null) {
                    DeclarationValueSynchronizer.$$$reportNull$$$0(3);
                }
                if (lookup == null) {
                    DeclarationValueSynchronizer.$$$reportNull$$$0(4);
                }
                if ((value = this.declaration.getValue()) == null) {
                    return itemLookupString;
                }
                if (PsiTreeUtil.hasErrorElements((PsiElement)this.declaration) && ((nameElement = this.declaration.getPropertyNameElement()) == null || nameElement.getNextSibling() instanceof PsiErrorElement)) {
                    return null;
                }
                int startOffset = value.getNode().getStartOffset();
                return DeclarationValueSynchronizer.getEffectiveText(item, itemLookupString, startOffset, startOffset + value.getTextLength(), lookup, closed);
            }

            @Override
            protected void doSync(@NotNull CharSequence item) {
                if (item == null) {
                    DeclarationValueSynchronizer.$$$reportNull$$$0(5);
                }
                this.setProperty(CssPsiUtil.prepareValueForChrome(item, this.isImportant));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "declaration";
                        break;
                    }
                    case 2: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "itemLookupString";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lookup";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/liveEdit/rangeValue/RangeValueSynchronizerFactory$Css$DeclarationValueSynchronizer";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "itemToString";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "doSync";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static abstract class Html<T>
    extends RangeValueSynchronizerFactory<T> {
        @Nullable
        protected static Pair<XmlAttribute, CssDeclaration> findAttributeAndCssDeclaration(PsiElement element) {
            if (element.getLanguage().isKindOf(JavaScriptFileType.INSTANCE.getLanguage())) {
                return null;
            }
            CssDeclaration cssDeclaration = (CssDeclaration)PsiTreeUtil.getPrevSiblingOfType((PsiElement)element, CssDeclaration.class);
            if (cssDeclaration != null) {
                XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)cssDeclaration, XmlAttribute.class);
                return attribute == null ? null : Pair.create((Object)attribute, (Object)cssDeclaration);
            }
            PsiElement parent = element;
            while (true) {
                if (parent instanceof CssDeclaration) {
                    cssDeclaration = (CssDeclaration)parent;
                } else if (cssDeclaration == null && parent instanceof CssBlock) {
                    cssDeclaration = (CssDeclaration)PsiTreeUtil.getPrevSiblingOfType((PsiElement)parent, CssDeclaration.class);
                    if (cssDeclaration == null) {
                        return null;
                    }
                } else {
                    if (parent instanceof XmlAttribute) break;
                    if (parent == null || parent instanceof XmlTag || parent instanceof XmlText) {
                        return null;
                    }
                }
                parent = parent.getParent();
            }
            XmlAttribute attribute = (XmlAttribute)parent;
            return Pair.create((Object)attribute, (Object)cssDeclaration);
        }

        @Override
        @Nullable
        public final T create(@NotNull FileType fileType, @NotNull PsiElement element, @NotNull PsiFile file) {
            if (fileType == null) {
                Html.$$$reportNull$$$0(0);
            }
            if (element == null) {
                Html.$$$reportNull$$$0(1);
            }
            if (file == null) {
                Html.$$$reportNull$$$0(2);
            }
            if (fileType != HtmlFileType.INSTANCE) {
                return null;
            }
            Pair<XmlAttribute, CssDeclaration> attributeAndCssDeclaration = Html.findAttributeAndCssDeclaration(element);
            return attributeAndCssDeclaration == null ? null : (T)this.create(file, (XmlAttribute)attributeAndCssDeclaration.first, (CssDeclaration)attributeAndCssDeclaration.second);
        }

        @Nullable
        protected abstract T create(@NotNull PsiFile var1, @NotNull XmlAttribute var2, @Nullable CssDeclaration var3);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/liveEdit/rangeValue/RangeValueSynchronizerFactory$Html";
            objectArray[2] = "create";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

