/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.update;

import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.debugger.sourcemap.SourceMap;

public abstract class FileScriptProcessor
implements Processor<Script> {
    public final JavaScriptDebugProcess<? extends VmConnection> debugProcess;
    protected VirtualFile file;
    private List<Url> fileUrls;

    public FileScriptProcessor(@NotNull JavaScriptDebugProcess<? extends VmConnection> debugProcess) {
        if (debugProcess == null) {
            FileScriptProcessor.$$$reportNull$$$0(0);
        }
        this.debugProcess = debugProcess;
    }

    public final void reset(@NotNull VirtualFile file) {
        if (file == null) {
            FileScriptProcessor.$$$reportNull$$$0(1);
        }
        this.file = file;
        this.fileUrls = null;
    }

    protected final boolean isScriptFile(@NotNull Url url) {
        if (url == null) {
            FileScriptProcessor.$$$reportNull$$$0(2);
        }
        return this.file.equals(this.debugProcess.findFile(url)) || this.checkUrl(url);
    }

    protected final boolean isSourceFile(@NotNull Script script) {
        SourceMap sourceMap;
        if (script == null) {
            FileScriptProcessor.$$$reportNull$$$0(3);
        }
        if ((sourceMap = script.getSourceMap()) != null) {
            for (Url url : sourceMap.getSources()) {
                if (!this.isScriptFile(url)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkUrl(@NotNull Url url) {
        if (url == null) {
            FileScriptProcessor.$$$reportNull$$$0(4);
        }
        if (this.fileUrls == null) {
            this.fileUrls = this.debugProcess.getFinder().getRemoteUrls(this.file);
        }
        return Urls.equalsIgnoreParameters((Url)url, this.fileUrls, (boolean)this.file.isCaseSensitive());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/liveEdit/update/FileScriptProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isScriptFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isSourceFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkUrl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

