/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.liveEdit.update;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Url;
import com.jetbrains.liveEdit.ApplicationInspectorImplKt;
import com.jetbrains.liveEdit.update.AsyncValueLoaderManager;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.protocol.css.CSSKt;
import org.jetbrains.wip.protocol.css.CSSStyleSheetHeaderValue;

public final class RemoteCssStyleSheet {
    private static final boolean NEED_TO_GET_TEXT_AFTER_CHANGE = true;
    private static final AsyncValueLoaderManager<RemoteCssStyleSheet, StylesheetFile> FILE_LOADER = new AsyncValueLoaderManager<RemoteCssStyleSheet, StylesheetFile>(RemoteCssStyleSheet.class){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void load(@NotNull RemoteCssStyleSheet styleSheet, @NotNull AsyncResult<StylesheetFile> mainResult) {
            StylesheetFile psiFile;
            ArrayList<Runnable> updates;
            if (styleSheet == null) {
                1.$$$reportNull$$$0(0);
            }
            if (mainResult == null) {
                1.$$$reportNull$$$0(1);
            }
            List<Runnable> list = styleSheet.pendingUpdates;
            synchronized (list) {
                updates = new ArrayList<Runnable>(styleSheet.pendingUpdates);
                if (!updates.isEmpty()) {
                    styleSheet.pendingUpdates.clear();
                }
            }
            if (!updates.isEmpty() && (psiFile = styleSheet.psiFile).isValid()) {
                Runnable runnable = () -> {
                    try {
                        for (Runnable update : updates) {
                            update.run();
                        }
                    }
                    catch (Exception e) {
                        mainResult.reject(e.getMessage());
                        return;
                    }
                    mainResult.setDone((Object)psiFile);
                };
                Application application = ApplicationManager.getApplication();
                if (application.isDispatchThread()) {
                    application.runWriteAction(runnable);
                } else {
                    application.invokeLater(() -> ApplicationManager.getApplication().runWriteAction(runnable), ModalityState.any());
                }
                return;
            }
            styleSheet.commandProcessor.send((Request)CSSKt.GetStyleSheetText((CharSequence)styleSheet.descriptor.styleSheetId())).onSuccess(result -> styleSheet.contentLoaded(result.text(), mainResult)).onError(error -> mainResult.reject(error.getMessage()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "styleSheet";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mainResult";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/liveEdit/update/RemoteCssStyleSheet$1";
            objectArray[2] = "load";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public volatile Document document;
    private volatile LightVirtualFile virtualFile;
    private volatile StylesheetFile psiFile;
    public final Project project;
    public final WipCommandProcessor commandProcessor;
    public final CSSStyleSheetHeaderValue descriptor;
    public final Url url;
    private volatile AsyncResult<StylesheetFile> file;
    private boolean updatesStopped;
    private int changedCount;
    private final List<Runnable> pendingUpdates;

    public RemoteCssStyleSheet(@NotNull CSSStyleSheetHeaderValue descriptor, @NotNull Url url, @NotNull WipCommandProcessor commandProcessor, @NotNull Project project) {
        if (descriptor == null) {
            RemoteCssStyleSheet.$$$reportNull$$$0(0);
        }
        if (url == null) {
            RemoteCssStyleSheet.$$$reportNull$$$0(1);
        }
        if (commandProcessor == null) {
            RemoteCssStyleSheet.$$$reportNull$$$0(2);
        }
        if (project == null) {
            RemoteCssStyleSheet.$$$reportNull$$$0(3);
        }
        this.pendingUpdates = new ArrayList<Runnable>();
        this.descriptor = descriptor;
        this.url = url;
        this.commandProcessor = commandProcessor;
        this.project = project;
    }

    public static boolean isNeedToGetTextAfterChange() {
        return true;
    }

    @NotNull
    public AsyncResult<StylesheetFile> getFile() {
        AsyncResult<StylesheetFile> asyncResult = FILE_LOADER.get(this);
        if (asyncResult == null) {
            RemoteCssStyleSheet.$$$reportNull$$$0(4);
        }
        return asyncResult;
    }

    private void contentLoaded(@NotNull String text, @NotNull AsyncResult<StylesheetFile> mainResult) {
        LightVirtualFile virtualFile;
        if (text == null) {
            RemoteCssStyleSheet.$$$reportNull$$$0(5);
        }
        if (mainResult == null) {
            RemoteCssStyleSheet.$$$reportNull$$$0(6);
        }
        if ((virtualFile = this.virtualFile) == null) {
            Document document;
            virtualFile = new LightVirtualFile(this.url.trimParameters().toDecodedForm(), (FileType)CssFileType.INSTANCE, (CharSequence)text);
            this.document = document = EditorFactory.getInstance().createDocument((CharSequence)text, true, true);
            this.virtualFile = virtualFile;
            UndoUtil.disableUndoFor((Document)document);
            UndoUtil.disableUndoFor((VirtualFile)virtualFile);
            FileDocumentManagerImpl.registerDocument((Document)document, (VirtualFile)virtualFile);
            PsiManager psiManager = PsiManager.getInstance((Project)this.project);
            PsiFile psiFile = (PsiFile)ReadAction.compute(() -> psiManager.findFile((VirtualFile)this.virtualFile));
            if (psiFile instanceof StylesheetFile) {
                this.psiFile = (StylesheetFile)psiFile;
                mainResult.setDone((Object)((StylesheetFile)psiFile));
            } else {
                String message = "cannot create css psi file from stylesheet " + virtualFile.getPath();
                ApplicationInspectorImplKt.getLOG().warn(message);
                mainResult.reject(message);
            }
        } else {
            virtualFile.setContent(null, (CharSequence)text, false);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.project.isDisposed()) {
                    mainResult.reject("project disposed");
                    return;
                }
                WriteAction.run(() -> {
                    DocumentUtil.writeInRunUndoTransparentAction(() -> this.document.setText((CharSequence)text));
                    PsiDocumentManager.getInstance((Project)this.project).commitDocument(this.document);
                });
                mainResult.setDone((Object)this.psiFile);
            }, ModalityState.any());
        }
    }

    public synchronized void onChanged() {
        if (this.updatesStopped) {
            ++this.changedCount;
        } else {
            FILE_LOADER.reset(this);
        }
    }

    public synchronized void stopUpdates() {
        this.updatesStopped = true;
    }

    public synchronized void startUpdates(boolean ignoreUpdate) {
        this.updatesStopped = false;
        if (ignoreUpdate) {
            --this.changedCount;
        }
        if (this.changedCount > 0) {
            this.changedCount = 0;
            FILE_LOADER.reset(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIncrementalUpdate(@NotNull Runnable runnable) {
        if (runnable == null) {
            RemoteCssStyleSheet.$$$reportNull$$$0(7);
        }
        List<Runnable> list = this.pendingUpdates;
        synchronized (list) {
            this.pendingUpdates.add(runnable);
        }
        this.startUpdates(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIncrementalUpdates() {
        List<Runnable> list = this.pendingUpdates;
        synchronized (list) {
            this.pendingUpdates.clear();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/liveEdit/update/RemoteCssStyleSheet";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainResult";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/liveEdit/update/RemoteCssStyleSheet";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "contentLoaded";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addIncrementalUpdate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

