/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.ui.rest.resource;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.swagger.core.SwaggerFailure;
import com.intellij.swagger.core.SwaggerResource;
import com.intellij.swagger.core.SwaggerResult;
import com.intellij.swagger.core.ui.SpecificationReferenceValidationHelperKt;
import com.intellij.swagger.core.ui.SpecificationReferencesInlineHelper;
import com.intellij.swagger.core.ui.SwPreviewType;
import com.intellij.swagger.core.ui.ValidationData;
import com.intellij.swagger.core.ui.rest.RequestHandlerHelperKt;
import com.intellij.swagger.core.ui.rest.SwSpecFileProviderKt;
import com.intellij.swagger.core.ui.rest.SwUrlBuilderKt;
import com.intellij.swagger.core.ui.rest.SwUrlParser;
import com.intellij.swagger.core.ui.rest.resource.RedocResourceProviderKt;
import com.intellij.swagger.core.ui.rest.resource.SwPreviewResourceProvider;
import com.intellij.swagger.core.ui.rest.resource.SwPreviewResourceProviderKt;
import com.intellij.swagger.core.ui.rest.resource.SwaggerResourceProviderKt;
import com.intellij.util.ui.StartupUiUtil;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/intellij/swagger/core/ui/rest/resource/RedocResourceProvider;", "Lcom/intellij/swagger/core/ui/rest/resource/SwPreviewResourceProvider;", "<init>", "()V", "getLibraryResource", "Lcom/intellij/swagger/core/SwaggerResult;", "Lcom/intellij/openapi/vfs/VirtualFile;", "resourcePath", "", "getDynamicResource", "Lcom/intellij/swagger/core/SwaggerResource;", "urlParser", "Lcom/intellij/swagger/core/ui/rest/SwUrlParser;", "getSpec", "file", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "getMainHtmlPage", "specificationId", "Lcom/intellij/swagger/core/ui/rest/SpecificationId;", "getMainHtmlPage-Y7tB9Ug", "(Ljava/util/UUID;)Lcom/intellij/swagger/core/SwaggerResult;", "htmlMainContainerId", "getHtmlMainContainerId", "()Ljava/lang/String;", "previewType", "Lcom/intellij/swagger/core/ui/SwPreviewType;", "getPreviewType", "()Lcom/intellij/swagger/core/ui/SwPreviewType;", "intellij.swagger.core"})
public final class RedocResourceProvider
implements SwPreviewResourceProvider {
    @Override
    @NotNull
    public SwaggerResult<VirtualFile> getLibraryResource(@NotNull String resourcePath) {
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        return SwPreviewResourceProviderKt.getAllowedResourceFromLibrary(RedocResourceProviderKt.access$getREDOC_RESOURCES_ALLOW_LIST$p(), "com/intellij/swagger", resourcePath);
    }

    @Override
    @NotNull
    public SwaggerResult<SwaggerResource> getDynamicResource(@NotNull SwUrlParser urlParser) {
        Intrinsics.checkNotNullParameter((Object)urlParser, (String)"urlParser");
        String resourcePath = urlParser.recognizeResourcePath();
        if (Intrinsics.areEqual((Object)resourcePath, (Object)"redoc-icon.svg")) {
            String iconName = StartupUiUtil.isUnderDarcula() ? "redocIcon_dark.svg" : "redocIcon_light.svg";
            SwaggerResult<VirtualFile> iconFile = SwaggerResourceProviderKt.getVirtualFileResult("icons/redoc/" + iconName);
            return SwPreviewResourceProviderKt.wrapVirtualFileResult(iconFile);
        }
        return SwPreviewResourceProvider.super.getDynamicResource(urlParser);
    }

    @Override
    @NotNull
    public SwaggerResult<String> getSpec(@NotNull PsiFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SwaggerResult<Pair<String, Map<String, ValidationData>>> specificationTextResult = new SpecificationReferencesInlineHelper(0, 1, null).prepareSpecificationTextWithValidation$intellij_swagger_core(file);
        if (specificationTextResult.isFailure()) {
            SwaggerFailure swaggerFailure = specificationTextResult.getSwaggerFailure();
            Intrinsics.checkNotNull((Object)swaggerFailure);
            return SwaggerResult.Companion.failure(swaggerFailure);
        }
        Pair<String, Map<String, ValidationData>> pair = specificationTextResult.getSuccess();
        Intrinsics.checkNotNull(pair);
        Pair<String, Map<String, ValidationData>> pair2 = pair;
        String specificationText = (String)pair2.component1();
        Map unresolvedReferences = (Map)pair2.component2();
        if (unresolvedReferences.isEmpty()) {
            return SwaggerResult.Companion.success(specificationText);
        }
        SwaggerFailure failure = SpecificationReferenceValidationHelperKt.swaggerValidationFailure(file, SpecificationReferenceValidationHelperKt.getValidationResult(unresolvedReferences, file));
        return SwaggerResult.Companion.failure(failure);
    }

    @Override
    @NotNull
    public SwaggerResult<String> getMainHtmlPage-Y7tB9Ug(@NotNull UUID specificationId) {
        Intrinsics.checkNotNullParameter((Object)specificationId, (String)"specificationId");
        SwaggerResult<String> html = SwaggerResourceProviderKt.getBundledResourceResult("htmlTemplates/redoc-index.html");
        if (html.isFailure()) {
            return html;
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"{STATIC_RESOURCE_BASE_URL}", (Object)SwUrlBuilderKt.buildStaticResourceAccessUrl(SwPreviewType.REDOC)), TuplesKt.to((Object)"{CUSTOM_BUNDLED_RESOURCE_BASE_URL}", (Object)SwUrlBuilderKt.buildCustomBundledResourceAccessUrl(SwPreviewType.REDOC)), TuplesKt.to((Object)"{SPEC_URL}", (Object)SwUrlBuilderKt.buildSpecificationAccessUrl-bFyn6F8(specificationId, SwPreviewType.REDOC)), TuplesKt.to((Object)"{ERROR_HANDLER_SCRIPT_URL}", (Object)SwUrlBuilderKt.buildErrorScriptAccessUrl(SwPreviewType.REDOC)), TuplesKt.to((Object)"{LICENSE_KEY}", (Object)""), TuplesKt.to((Object)"{THEME}", (Object)RedocResourceProviderKt.access$getRedocThemeSettings(StartupUiUtil.isUnderDarcula()))};
        String htmlWithFulfilledValues = SwSpecFileProviderKt.inlineVariablesIntoTemplate(html.getSuccessOrThrow(), MapsKt.mapOf((Pair[])pairArray));
        return SwaggerResult.Companion.success(RequestHandlerHelperKt.applyCss(htmlWithFulfilledValues, RedocResourceProviderKt.access$getCss(StartupUiUtil.isUnderDarcula())));
    }

    @Override
    @NotNull
    public String getHtmlMainContainerId() {
        return "redocly_container";
    }

    @Override
    @NotNull
    public SwPreviewType getPreviewType() {
        return SwPreviewType.REDOC;
    }
}

