/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.ui.utils;

import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.swagger.core.index.SwIndexUtilsKt;
import com.intellij.swagger.core.model.api.SwDefinition;
import com.intellij.swagger.core.model.api.SwHttpOperation;
import com.intellij.swagger.core.model.api.SwModelElement;
import com.intellij.swagger.core.model.api.SwUrl;
import com.intellij.swagger.core.model.specification.SwSpecificationFile;
import com.intellij.swagger.core.model.specification.SwaggerFileHelper;
import com.intellij.swagger.core.traverser.SwTreeUtil;
import com.intellij.swagger.core.ui.utils.SwCommonJsUtilsKt;
import com.intellij.swagger.core.ui.utils.SwJcefNavigationRequest;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0018\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0082@\u00a2\u0006\u0002\u0010\u0006\u001a\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0004\u001a\u00020\tH\u0082@\u00a2\u0006\u0002\u0010\n\u001a\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0003\u001a\u001a\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0015\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0016\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0017\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"AUTO_SCROLL_SUPPRESSION_TRESHOLD_MS", "", "computeMetaModelElementForNavigation", "Lcom/intellij/swagger/core/model/api/SwModelElement;", "request", "Lcom/intellij/swagger/core/ui/utils/SwJcefNavigationRequest$EditorToPreview;", "(Lcom/intellij/swagger/core/ui/utils/SwJcefNavigationRequest$EditorToPreview;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "computePreviewPageOffsetForNavigation", "", "Lcom/intellij/swagger/core/ui/utils/SwJcefNavigationRequest$PreviewToEditor;", "(Lcom/intellij/swagger/core/ui/utils/SwJcefNavigationRequest$PreviewToEditor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findEndpointPsiElement", "Lcom/intellij/psi/PsiElement;", "objectCoordinates", "", "specification", "Lcom/intellij/psi/PsiFile;", "findModelPsiElement", "endpointPattern", "Lkotlin/text/Regex;", "modelPattern", "ENDPOINT_METHOD_GROUP_INDEX", "ENDPOINT_URL_GROUP_INDEX", "MODEL_NAME_GROUP_INDEX", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwBrowserEditorNavigationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwBrowserEditorNavigationService.kt\ncom/intellij/swagger/core/ui/utils/SwBrowserEditorNavigationServiceKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,192:1\n296#2,2:193\n296#2,2:195\n296#2,2:197\n1#3:199\n*S KotlinDebug\n*F\n+ 1 SwBrowserEditorNavigationService.kt\ncom/intellij/swagger/core/ui/utils/SwBrowserEditorNavigationServiceKt\n*L\n169#1:193,2\n171#1:195,2\n183#1:197,2\n*E\n"})
public final class SwBrowserEditorNavigationServiceKt {
    private static final long AUTO_SCROLL_SUPPRESSION_TRESHOLD_MS = 1000L;
    @NotNull
    private static final Regex endpointPattern = new Regex("Endpoint#(.*)#(.*)");
    @NotNull
    private static final Regex modelPattern = new Regex("Model#(.*)");
    private static final int ENDPOINT_METHOD_GROUP_INDEX = 1;
    private static final int ENDPOINT_URL_GROUP_INDEX = 2;
    private static final int MODEL_NAME_GROUP_INDEX = 1;

    private static final Object computeMetaModelElementForNavigation(SwJcefNavigationRequest.EditorToPreview request, Continuation<? super SwModelElement> $completion) {
        return CoroutinesKt.readAction(() -> SwBrowserEditorNavigationServiceKt.computeMetaModelElementForNavigation$lambda$0(request), $completion);
    }

    private static final Object computePreviewPageOffsetForNavigation(SwJcefNavigationRequest.PreviewToEditor request, Continuation<? super Integer> $completion) {
        return CoroutinesKt.readAction(() -> SwBrowserEditorNavigationServiceKt.computePreviewPageOffsetForNavigation$lambda$0(request), $completion);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresReadLock
    private static final PsiElement findEndpointPsiElement(String objectCoordinates, PsiFile specification) {
        Object v9;
        block6: {
            void $this$firstOrNull$iv;
            Object v8;
            List<SwHttpOperation> list;
            Object method;
            block5: {
                void $this$firstOrNull$iv2;
                MatchResult matchResult = endpointPattern.matchEntire((CharSequence)objectCoordinates);
                if (matchResult == null) return null;
                if (matchResult.getGroups().size() < 2) {
                    return null;
                }
                MatchGroup matchGroup = matchResult.getGroups().get(1);
                Object object = matchGroup;
                if (matchGroup == null) return null;
                String string = object.getValue();
                object = string;
                if (string == null) return null;
                String string2 = ((String)object).toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                object = string2;
                if (string2 == null) {
                    return null;
                }
                method = object;
                MatchGroup matchGroup2 = matchResult.getGroups().get(2);
                Object object2 = matchGroup2;
                if (matchGroup2 == null) return null;
                if ((object2 = object2.getValue()) == null) {
                    return null;
                }
                Object object3 = object2;
                VirtualFile virtualFile = specification.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                Project project = specification.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                SwSpecificationFile swSpecificationFile = SwaggerFileHelper.createSpecificationFile$default(SwaggerFileHelper.INSTANCE, specification, virtualFile, project, true, false, 16, null);
                if (swSpecificationFile == null) return null;
                List<SwUrl> list2 = swSpecificationFile.getUrls();
                if (list2 == null) return null;
                list = (List<SwHttpOperation>)list2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv2) {
                    SwUrl it = (SwUrl)element$iv;
                    boolean bl = false;
                    if (!StringsKt.endsWith$default((String)it.getUrlString(), (String)object3, (boolean)false, (int)2, null)) continue;
                    v8 = element$iv;
                    break block5;
                }
                v8 = null;
            }
            SwUrl swUrl = v8;
            if (swUrl == null) return null;
            list = swUrl.getSupportedOperations();
            if (list == null) return null;
            Iterable iterable = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SwHttpOperation it = (SwHttpOperation)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getHttpMethod().getValue(), (Object)method)) continue;
                v9 = element$iv;
                break block6;
            }
            v9 = null;
        }
        SwHttpOperation swHttpOperation = v9;
        if (swHttpOperation == null) return null;
        PsiElement psiElement = swHttpOperation.getSourcePsi();
        return psiElement;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresReadLock
    private static final PsiElement findModelPsiElement(String objectCoordinates, PsiFile specification) {
        Object v4;
        block3: {
            void $this$firstOrNull$iv;
            MatchResult matchResult = modelPattern.matchEntire((CharSequence)objectCoordinates);
            if (matchResult == null) return null;
            if (matchResult.getGroups().size() < 1) {
                return null;
            }
            MatchGroup matchGroup = matchResult.getGroups().get(1);
            Object object = matchGroup;
            if (matchGroup == null) return null;
            if ((object = object.getValue()) == null) {
                return null;
            }
            Object object2 = object;
            VirtualFile virtualFile = specification.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            Project project = specification.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            SwSpecificationFile swSpecificationFile = SwaggerFileHelper.createSpecificationFile$default(SwaggerFileHelper.INSTANCE, specification, virtualFile, project, true, false, 16, null);
            if (swSpecificationFile == null) return null;
            List<SwDefinition> list = swSpecificationFile.getAllLocalObjectDefinitions();
            if (list == null) return null;
            Iterable iterable = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SwDefinition it = (SwDefinition)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName().getValue(), (Object)object2)) continue;
                v4 = element$iv;
                break block3;
            }
            v4 = null;
        }
        SwDefinition swDefinition = v4;
        if (swDefinition == null) return null;
        PsiElement psiElement = swDefinition.getSourcePsi();
        return psiElement;
    }

    private static final SwModelElement computeMetaModelElementForNavigation$lambda$0(SwJcefNavigationRequest.EditorToPreview $request) {
        Object object;
        block10: {
            block9: {
                TextEditor textEditor;
                object = (TextEditor)$request.getEditor().get();
                if (object == null) break block9;
                TextEditor it = textEditor = object;
                boolean bl = false;
                object = it.isValid() ? textEditor : null;
                if (object != null) break block10;
            }
            return null;
        }
        TextEditor editor = object;
        Project project = (Project)$request.getProject().get();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        VirtualFile virtualFile = editor.getFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile editedFile = virtualFile;
        CaretEvent caretEvent = (CaretEvent)$request.getEvent().get();
        if (caretEvent == null) {
            return null;
        }
        CaretEvent event = caretEvent;
        if (SwIndexUtilsKt.isIndexingRightNow(project2) || !Intrinsics.areEqual((Object)editor.getEditor().getCaretModel().getPrimaryCaret(), (Object)event.getCaret())) {
            return null;
        }
        Caret caret = event.getCaret();
        int offset = caret != null ? caret.getOffset() : editor.getEditor().logicalPositionToOffset(new LogicalPosition(event.getNewPosition().line, event.getNewPosition().column));
        PsiFile psiFile = SwCommonJsUtilsKt.findPsiWithLogging(editedFile, project2);
        if (psiFile == null || (psiFile = psiFile.findElementAt(offset)) == null) {
            return null;
        }
        PsiFile psiElement = psiFile;
        Class[] classArray = new Class[]{SwHttpOperation.class, SwDefinition.class, SwUrl.class};
        SwModelElement swModelElement = (SwModelElement)SequencesKt.lastOrNull(SwTreeUtil.INSTANCE.getParentsOfTypes((PsiElement)psiElement, classArray));
        if (swModelElement == null) {
            return null;
        }
        return swModelElement;
    }

    private static final Integer computePreviewPageOffsetForNavigation$lambda$0(SwJcefNavigationRequest.PreviewToEditor $request) {
        Object object;
        Project project;
        block8: {
            block7: {
                TextEditor textEditor;
                Project project2 = (Project)$request.getProject().get();
                if (project2 == null) {
                    return null;
                }
                project = project2;
                object = (TextEditor)$request.getEditor().get();
                if (object == null) break block7;
                TextEditor it = textEditor = object;
                boolean bl = false;
                object = it.isValid() ? textEditor : null;
                if (object != null) break block8;
            }
            return null;
        }
        TextEditor editor = object;
        VirtualFile virtualFile = editor.getFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        PsiFile psiFile = SwCommonJsUtilsKt.findPsiWithLogging(virtualFile2, project);
        if (psiFile == null) {
            return null;
        }
        PsiFile specification = psiFile;
        PsiElement psiElement = SwBrowserEditorNavigationServiceKt.findEndpointPsiElement($request.getParsedModelObjectCoordinates(), specification);
        if (psiElement == null && (psiElement = SwBrowserEditorNavigationServiceKt.findModelPsiElement($request.getParsedModelObjectCoordinates(), specification)) == null) {
            return null;
        }
        PsiElement psiElement2 = psiElement;
        return PsiTreeUtilKt.getStartOffset((PsiElement)psiElement2);
    }

    public static final /* synthetic */ Object access$computeMetaModelElementForNavigation(SwJcefNavigationRequest.EditorToPreview request, Continuation $completion) {
        return SwBrowserEditorNavigationServiceKt.computeMetaModelElementForNavigation(request, (Continuation<? super SwModelElement>)$completion);
    }

    public static final /* synthetic */ Object access$computePreviewPageOffsetForNavigation(SwJcefNavigationRequest.PreviewToEditor request, Continuation $completion) {
        return SwBrowserEditorNavigationServiceKt.computePreviewPageOffsetForNavigation(request, (Continuation<? super Integer>)$completion);
    }
}

