/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.visualEditing.templates;

import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.swagger.core.visualEditing.SwGenerationRelativePosition;
import com.intellij.swagger.core.visualEditing.templates.SwLanguageAwareTemplateAdapter;
import com.intellij.swagger.core.visualEditing.templates.SwTemplateInsertionStrategy;
import com.intellij.swagger.core.visualEditing.templates.SwVisualEditingTemplatesKt;
import com.intellij.swagger.core.visualEditing.templates.SwYamlTemplateLanguageAdapter;
import com.intellij.swagger.core.visualEditing.templates.SwYamlTemplateLanguageAdapterKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLPsiElement;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u00060\u0003R\u00020\u00000\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0007\u001a\b\u0018\u00010\u0003R\u00020\u00002\u0006\u0010\b\u001a\u00020\tH\u0014J\u001e\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\n\u0010\r\u001a\u00060\u0003R\u00020\u0000H\u0014J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0002H\u0002J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0004\u001a\u00020\u0002H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0002H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\u000bH\u0002J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/swagger/core/visualEditing/templates/SwYamlTemplateLanguageAdapter;", "Lcom/intellij/swagger/core/visualEditing/templates/SwLanguageAwareTemplateAdapter;", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "Lcom/intellij/swagger/core/visualEditing/templates/SwYamlTemplateLanguageAdapter$YamlStrategy;", "element", "<init>", "(Lorg/jetbrains/yaml/psi/YAMLKeyValue;)V", "chooseInsertionStrategy", "relativePosition", "Lcom/intellij/swagger/core/visualEditing/SwGenerationRelativePosition;", "formatTemplateText", "", "templateText", "insertionStrategy", "chooseNodeToInsertTo", "computeIndentForInsertedElement", "", "nodeToInsertTo", "Lorg/jetbrains/yaml/psi/YAMLPsiElement;", "offsetAfterPreviousSiblingOrParent", "offsetAfterPreviousKeyValue", "(Lorg/jetbrains/yaml/psi/YAMLKeyValue;)Ljava/lang/Integer;", "offsetAfterKeyValueAndComma", "convertJsonToYaml", "jsonTemplate", "removeEmptyYamlObjectsIfAny", "yamlTemplate", "YamlStrategy", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwYamlTemplateLanguageAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwYamlTemplateLanguageAdapter.kt\ncom/intellij/swagger/core/visualEditing/templates/SwYamlTemplateLanguageAdapter\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,114:1\n67#2:115\n23#3:116\n*S KotlinDebug\n*F\n+ 1 SwYamlTemplateLanguageAdapter.kt\ncom/intellij/swagger/core/visualEditing/templates/SwYamlTemplateLanguageAdapter\n*L\n64#1:115\n104#1:116\n*E\n"})
public final class SwYamlTemplateLanguageAdapter
extends SwLanguageAwareTemplateAdapter<YAMLKeyValue, YamlStrategy> {
    public SwYamlTemplateLanguageAdapter(@NotNull YAMLKeyValue element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element, null);
    }

    @Override
    @Nullable
    protected YamlStrategy chooseInsertionStrategy(@NotNull SwGenerationRelativePosition relativePosition) {
        Intrinsics.checkNotNullParameter((Object)((Object)relativePosition), (String)"relativePosition");
        YAMLKeyValue nodeToInsertTo = this.chooseNodeToInsertTo(relativePosition);
        int newElementIndentLength = this.computeIndentForInsertedElement((YAMLPsiElement)nodeToInsertTo);
        boolean shouldAddSequenceMark = relativePosition == SwGenerationRelativePosition.COLLECTION_CHILD;
        int templateInsertionOffset = this.offsetAfterPreviousSiblingOrParent(relativePosition, nodeToInsertTo);
        return new YamlStrategy(newElementIndentLength, shouldAddSequenceMark, true, templateInsertionOffset);
    }

    @Override
    @Nullable
    protected String formatTemplateText(@NotNull String templateText, @NotNull YamlStrategy insertionStrategy) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter((Object)templateText, (String)"templateText");
        Intrinsics.checkNotNullParameter((Object)insertionStrategy, (String)"insertionStrategy");
        String string = this.convertJsonToYaml(templateText);
        if (string == null) {
            return null;
        }
        String convertedTemplateText = string;
        StringBuilder $this$formatTemplateText_u24lambda_u240 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        if (insertionStrategy.getAddLineBefore()) {
            $this$formatTemplateText_u24lambda_u240.append("\n");
        }
        StringBuilder $this$formatTemplateText_u24lambda_u240_u240 = stringBuilder = new StringBuilder();
        boolean bl2 = false;
        $this$formatTemplateText_u24lambda_u240_u240.append(StringsKt.repeat((CharSequence)" ", (int)insertionStrategy.getIndentLength()));
        if (insertionStrategy.getAddSequenceMark()) {
            $this$formatTemplateText_u24lambda_u240_u240.append("- ");
        }
        String firstLineIndentValue = stringBuilder.toString();
        String otherLinesIndentValue = StringsKt.repeat((CharSequence)" ", (int)firstLineIndentValue.length());
        char[] cArray = new char[]{' '};
        String prettyTemplateText2 = StringsKt.trimEnd((String)SequencesKt.joinToString$default((Sequence)SequencesKt.mapIndexed((Sequence)SequencesKt.filter((Sequence)StringsKt.lineSequence((CharSequence)SwVisualEditingTemplatesKt.addTemplateVariableMarkers(convertedTemplateText)), (Function1)formatTemplateText.1.prettyTemplateText.1.INSTANCE), (arg_0, arg_1) -> SwYamlTemplateLanguageAdapter.formatTemplateText$lambda$0$1(firstLineIndentValue, otherLinesIndentValue, arg_0, arg_1)), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), (char[])cArray);
        $this$formatTemplateText_u24lambda_u240.append(prettyTemplateText2);
        return stringBuilder2.toString();
    }

    private final YAMLKeyValue chooseNodeToInsertTo(SwGenerationRelativePosition relativePosition) {
        return switch (WhenMappings.$EnumSwitchMapping$0[relativePosition.ordinal()]) {
            case 1 -> {
                void $this$parentOfType$iv;
                Object var2_2 = this.getHighlightedElement();
                boolean withSelf$iv = false;
                boolean $i$f$parentOfType = false;
                PsiElement v0 = PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, YAMLKeyValue.class, (boolean)true);
                Intrinsics.checkNotNull((Object)v0);
                yield (YAMLKeyValue)v0;
            }
            case 2, 3 -> (YAMLKeyValue)this.getHighlightedElement();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final int computeIndentForInsertedElement(YAMLPsiElement nodeToInsertTo) {
        return YAMLUtil.getIndentToThisElement((PsiElement)((PsiElement)nodeToInsertTo)) + CodeStyle.getSettings((PsiFile)nodeToInsertTo.getContainingFile()).getIndentSize((FileType)YAMLFileType.YML);
    }

    /*
     * Unable to fully structure code
     */
    private final int offsetAfterPreviousSiblingOrParent(SwGenerationRelativePosition relativePosition, YAMLKeyValue nodeToInsertTo) {
        if (relativePosition != SwGenerationRelativePosition.PREVIOUS_SIBLING) ** GOTO lbl-1000
        v0 = ((YAMLKeyValue)this.getHighlightedElement()).getParentMapping();
        v1 = v0 != null ? v0.getKeyValues() : null;
        if (v1 == null) {
            v1 = CollectionsKt.emptyList();
        }
        if (v1.size() > 1) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = isInsertBeforeExistingSibling = false;
        }
        if (isInsertBeforeExistingSibling) {
            v3 = this.offsetAfterPreviousKeyValue((YAMLKeyValue)this.getHighlightedElement());
            v4 = v3 != null ? v3.intValue() : this.offsetAfterKeyValueAndComma(nodeToInsertTo);
        } else {
            v4 = this.offsetAfterKeyValueAndComma(nodeToInsertTo);
        }
        return v4;
    }

    private final Integer offsetAfterPreviousKeyValue(YAMLKeyValue element) {
        PsiElement psiElement = PsiTreeUtil.findSiblingBackward((PsiElement)((PsiElement)element), (IElementType)((IElementType)YAMLElementTypes.KEY_VALUE_PAIR), (boolean)true, null);
        return psiElement != null ? Integer.valueOf(PsiTreeUtilKt.getEndOffset((PsiElement)psiElement)) : null;
    }

    private final int offsetAfterKeyValueAndComma(YAMLKeyValue element) {
        PsiElement psiElement = element.getKey();
        Intrinsics.checkNotNull((Object)psiElement);
        return PsiTreeUtilKt.getEndOffset((PsiElement)psiElement) + 1;
    }

    private final String convertJsonToYaml(String jsonTemplate) {
        Object object;
        block2: {
            Object object2;
            object = this;
            try {
                SwYamlTemplateLanguageAdapter $this$convertJsonToYaml_u24lambda_u240 = object;
                boolean bl = false;
                JsonNode jsonTree = SwYamlTemplateLanguageAdapterKt.access$getJsonReader$p().readTree(jsonTemplate);
                String yamlTree = SwYamlTemplateLanguageAdapterKt.access$getYamlWriter$p().writeValueAsString((Object)jsonTree);
                Intrinsics.checkNotNull((Object)yamlTree);
                object2 = Result.constructor-impl((Object)$this$convertJsonToYaml_u24lambda_u240.removeEmptyYamlObjectsIfAny(yamlTree));
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block2;
            Object throwable2 = object2 = throwable;
            boolean bl = false;
            SwYamlTemplateLanguageAdapter $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(SwYamlTemplateLanguageAdapter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Error during template conversion", (Throwable)throwable2);
        }
        return (String)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private final String removeEmptyYamlObjectsIfAny(String yamlTemplate) {
        char[] cArray = new char[]{' '};
        return StringsKt.trimEnd((String)StringsKt.replace$default((String)yamlTemplate, (String)"{}", (String)"", (boolean)false, (int)4, null), (char[])cArray);
    }

    private static final String formatTemplateText$lambda$0$1(String $firstLineIndentValue, String $otherLinesIndentValue, int index, String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return index == 0 ? $firstLineIndentValue + line : $otherLinesIndentValue + line;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SwGenerationRelativePosition.values().length];
            try {
                nArray[SwGenerationRelativePosition.PREVIOUS_SIBLING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SwGenerationRelativePosition.SIMPLE_CHILD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SwGenerationRelativePosition.COLLECTION_CHILD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u000f"}, d2={"Lcom/intellij/swagger/core/visualEditing/templates/SwYamlTemplateLanguageAdapter$YamlStrategy;", "Lcom/intellij/swagger/core/visualEditing/templates/SwTemplateInsertionStrategy;", "indentLength", "", "addSequenceMark", "", "addLineBefore", "templateStartOffset", "<init>", "(Lcom/intellij/swagger/core/visualEditing/templates/SwYamlTemplateLanguageAdapter;IZZI)V", "getIndentLength", "()I", "getAddSequenceMark", "()Z", "getAddLineBefore", "intellij.swagger.core"})
    public final class YamlStrategy
    extends SwTemplateInsertionStrategy {
        private final int indentLength;
        private final boolean addSequenceMark;
        private final boolean addLineBefore;

        public YamlStrategy(int indentLength, boolean addSequenceMark, boolean addLineBefore, int templateStartOffset) {
            super(templateStartOffset, false, null);
            this.indentLength = indentLength;
            this.addSequenceMark = addSequenceMark;
            this.addLineBefore = addLineBefore;
        }

        public final int getIndentLength() {
            return this.indentLength;
        }

        public final boolean getAddSequenceMark() {
            return this.addSequenceMark;
        }

        public final boolean getAddLineBefore() {
            return this.addLineBefore;
        }
    }
}

