/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.jsx.inspections;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/lang/javascript/frameworks/jsx/inspections/JSXElementFactory;", "", "<init>", "()V", "createJSXElementFromText", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "language", "Lcom/intellij/lang/Language;", "text", "", "intellij.javascript.codeinsight"})
final class JSXElementFactory {
    @NotNull
    public static final JSXElementFactory INSTANCE = new JSXElementFactory();

    private JSXElementFactory() {
    }

    @NotNull
    public final PsiElement createJSXElementFromText(@NotNull Project project, @NotNull Language language, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText(language, (CharSequence)("<>" + text + "</>"));
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.psi.JSFile");
        JSFile file = (JSFile)psiFile;
        JSSourceElement jSSourceElement = file.getStatements()[0];
        Intrinsics.checkNotNull((Object)jSSourceElement, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.psi.JSExpressionStatement");
        JSExpressionStatement statement = (JSExpressionStatement)jSSourceElement;
        JSExpression jSExpression = statement.getExpression();
        Intrinsics.checkNotNull((Object)jSExpression, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.psi.JSXmlLiteralExpression");
        JSXmlLiteralExpression initializer = (JSXmlLiteralExpression)jSExpression;
        PsiElement psiElement = initializer.getChildren()[1];
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"get(...)");
        return psiElement;
    }
}

