/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions.destructuring;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.macro.EnumMacro;
import com.intellij.javascript.types.TSType;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.intentions.destructuring.JSDestructuringPropagationIntentionBase;
import com.intellij.lang.javascript.intentions.destructuring.JSDestructuringVariantsEvaluator;
import com.intellij.lang.javascript.intentions.destructuring.JSGenerateDestructuringPatternIntention;
import com.intellij.lang.javascript.intentions.destructuring.JSGenerateDestructuringPatternIntentionKt;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.ES6ChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSServicePoweredTypeEngineEvaluator;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerReadActionKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J!\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0096\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0012\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0005H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/lang/javascript/intentions/destructuring/JSGenerateDestructuringPatternIntention;", "Lcom/intellij/lang/javascript/intentions/destructuring/JSDestructuringPropagationIntentionBase;", "<init>", "()V", "getDescription", "", "isAvailableOnElement", "", "element", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "invoke", "", "findVariable", "Lcom/intellij/lang/javascript/psi/JSVariable;", "runVariablesTemplate", "file", "Lcom/intellij/psi/PsiFile;", "buildTail", "variable", "doReplace", "destruct", "intellij.javascript.codeinsight"})
@SourceDebugExtension(value={"SMAP\nJSGenerateDestructuringPatternIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSGenerateDestructuringPatternIntention.kt\ncom/intellij/lang/javascript/intentions/destructuring/JSGenerateDestructuringPatternIntention\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,331:1\n1915#2,2:332\n*S KotlinDebug\n*F\n+ 1 JSGenerateDestructuringPatternIntention.kt\ncom/intellij/lang/javascript/intentions/destructuring/JSGenerateDestructuringPatternIntention\n*L\n159#1:332,2\n*E\n"})
public final class JSGenerateDestructuringPatternIntention
extends JSDestructuringPropagationIntentionBase {
    @Override
    @NotNull
    protected String getDescription() {
        String string = JavaScriptBundle.message((String)"refactoring.destructuring.vars.intention.deconstruct", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    protected boolean isAvailableOnElement(@NotNull PsiElement element, @NotNull Project project, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return (Boolean)JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)element, () -> JSGenerateDestructuringPatternIntention.isAvailableOnElement$lambda$0(this, element));
    }

    private final boolean isAvailableOnElement(PsiElement element) {
        PsiElement parent = element.getParent();
        if (!JSDestructuringPropagationIntentionBase.isAcceptableVariable(parent)) {
            return false;
        }
        if (this.findVariable(element) == null) {
            return false;
        }
        Intrinsics.checkNotNull((Object)parent, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.psi.JSVariable");
        if (((JSVariable)parent).isExported()) {
            return false;
        }
        Boolean tsTypeApplicable = (Boolean)TypeScriptCompilerReadActionKt.tscReadAction(() -> JSGenerateDestructuringPatternIntention.isAvailableOnElement$lambda$1(element));
        if (Intrinsics.areEqual((Object)tsTypeApplicable, (Object)false)) {
            return false;
        }
        if (tsTypeApplicable == null && !JSGenerateDestructuringPatternIntentionKt.isApplicableType(JSResolveUtil.getElementJSType((PsiElement)parent), false)) {
            return false;
        }
        return ReferencesSearch.search((PsiElement)parent, (SearchScope)((JSVariable)parent).getUseScope()).findFirst() == null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        JSVariable jSVariable = this.findVariable(element);
        if (jSVariable == null) {
            return;
        }
        JSVariable variable = jSVariable;
        JSType jsType = JSResolveUtil.getElementJSType((PsiElement)((PsiElement)variable));
        List<String> variants = new JSDestructuringVariantsEvaluator((PsiElement)variable).evaluateVariants(jsType);
        PsiElement parent = variable.getParent();
        if (parent instanceof JSDestructuringProperty) {
            if (parent instanceof JSDestructuringShorthandedProperty) {
                PsiElement finalParent = parent;
                parent = (PsiElement)ApplicationManager.getApplication().runWriteAction(() -> JSGenerateDestructuringPatternIntention.invoke$lambda$0(finalParent));
                PsiDocumentManager.getInstance((Project)variable.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            }
            PsiElement psiElement = parent;
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.psi.JSDestructuringProperty");
            parent = (PsiElement)((JSDestructuringProperty)psiElement).getDestructuringElement();
            if (!(parent instanceof JSVariable)) {
                return;
            }
            variable = (JSVariable)parent;
        }
        if (variants.isEmpty()) {
            return;
        }
        if (variants.size() == 1) {
            this.doReplace(variable, CollectionsKt.first(variants) + this.buildTail(variable));
        } else {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.doReplace(variable, CollectionsKt.last(variants) + this.buildTail(variable));
                return;
            }
            ArrayList<Object> itemsShown = new ArrayList<Object>(Math.min(variants.size(), 10));
            itemsShown.addAll(ContainerUtil.getFirstItems(variants, (int)9));
            if (variants.size() > 10) {
                itemsShown.add(CollectionsKt.last(variants));
            }
            PsiElement psiElement = variable.getNameIdentifier();
            if (psiElement == null) {
                return;
            }
            PsiElement identifier = psiElement;
            MacroCallNode macro = new MacroCallNode((Macro)new EnumMacro());
            Iterator iterator = itemsShown.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                String candidate = (String)e;
                macro.addParameter((Expression)new ConstantNode(candidate));
            }
            PsiFile file = identifier.getContainingFile();
            PsiElement finalParent1 = parent;
            JSVariable finalVariable = variable;
            JSDestructuringPropagationIntentionBase.runWriteAction(() -> JSGenerateDestructuringPatternIntention.invoke$lambda$1(identifier, finalParent1, finalVariable, project, editor, macro, this, file));
        }
    }

    private final JSVariable findVariable(PsiElement element) {
        JSVariable jSVariable;
        PsiElement parent = element.getParent();
        PsiElement psiElement = parent;
        if (psiElement instanceof JSVarStatement) {
            JSVariable[] jSVariableArray = ((JSVarStatement)parent).getVariables();
            Intrinsics.checkNotNullExpressionValue((Object)jSVariableArray, (String)"getVariables(...)");
            jSVariable = (JSVariable)ArraysKt.firstOrNull((Object[])jSVariableArray);
        } else {
            jSVariable = psiElement instanceof JSVariable ? (JSVariable)parent : null;
        }
        return jSVariable;
    }

    private final void runVariablesTemplate(Project project, Editor editor, PsiFile file) {
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset() - 1);
        JSDestructuringElement variable = (JSDestructuringElement)PsiTreeUtil.getParentOfType((PsiElement)element, JSDestructuringElement.class);
        while (variable != null) {
            element = (PsiElement)variable;
            variable = (JSDestructuringElement)PsiTreeUtil.getParentOfType((PsiElement)element, JSDestructuringElement.class);
        }
        if (element != null) {
            TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder(element);
            JBIterable jBIterable = SyntaxTraverser.psiTraverser((PsiElement)element).filter(JSVariable.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            Iterable $this$forEach$iv = (Iterable)jBIterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiElement nameIdentifier;
                JSVariable v = (JSVariable)element$iv;
                boolean bl = false;
                if (v.getParent() instanceof JSDestructuringShorthandedProperty || v.getNameIdentifier() == null) continue;
                builder.replaceElement(nameIdentifier, (Expression)new ConstantNode(nameIdentifier.getText()));
            }
            builder.run(editor, true);
        }
    }

    private final String buildTail(JSVariable variable) {
        StringBuilder tailBuilder = new StringBuilder();
        JSDestructuringPropagationIntentionBase.appendTypeAndInitializer(variable, tailBuilder);
        String string = tailBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void doReplace(JSVariable variable, String destruct) {
        PsiElement parent = variable.getParent();
        JSDestructuringPropagationIntentionBase.replaceWithDestructuring((PsiElement)variable, parent, JSPsiElementFactory.createParameterOrVariableItem((String)destruct, (PsiElement)parent, (boolean)(parent instanceof JSCatchBlock), (boolean)(variable instanceof JSParameter)), false);
    }

    private static final boolean isAvailableOnElement$lambda$0(JSGenerateDestructuringPatternIntention this$0, PsiElement $element) {
        return this$0.isAvailableOnElement($element);
    }

    private static final Boolean isAvailableOnElement$lambda$1(PsiElement $element) {
        TSType tsType;
        TSType tSType = tsType = JSServicePoweredTypeEngineEvaluator.INSTANCE.getTSTypeFromService($element);
        return tSType != null ? Boolean.valueOf(JSGenerateDestructuringPatternIntentionKt.access$isGenerateDestructuringPatternApplicable(tSType)) : null;
    }

    private static final PsiElement invoke$lambda$0(PsiElement $finalParent) {
        return (PsiElement)ES6ChangeUtil.expandDestructuringProperty((JSDestructuringShorthandedProperty)((JSDestructuringShorthandedProperty)$finalParent));
    }

    private static final void invoke$lambda$1(PsiElement $identifier, PsiElement $finalParent1, JSVariable $finalVariable, Project $project, Editor $editor, MacroCallNode $macro, JSGenerateDestructuringPatternIntention this$0, PsiFile $file) {
        PsiElement nameId = $identifier;
        if ($finalParent1 instanceof JSParameterList) {
            PsiElement expanded = JSDestructuringPropagationIntentionBase.expandForParameter((JSParameterList)$finalParent1, (PsiElement)$finalVariable, (PsiElement)$finalVariable);
            PsiDocumentManager.getInstance((Project)$project).doPostponedOperationsAndUnblockDocument($editor.getDocument());
            PsiElement psiElement = expanded;
            PsiElement psiElement2 = psiElement instanceof JSParameterList ? ((JSParameterList)expanded).getParameterVariables()[0].getNameIdentifier() : (nameId = psiElement instanceof JSParameter ? ((JSParameter)expanded).getNameIdentifier() : nameId);
        }
        if (nameId == null) {
            return;
        }
        TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder(nameId);
        builder.replaceElement(nameId, (Expression)$macro);
        builder.run($editor, true);
        TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)$editor);
        if (templateState == null) {
            return;
        }
        TemplateState templateState2 = templateState;
        templateState2.addTemplateStateListener((TemplateEditingListener)new TemplateEditingAdapter(this$0, $project, $editor, $file){
            final /* synthetic */ JSGenerateDestructuringPatternIntention this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ PsiFile $file;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$editor = $editor;
                this.$file = $file;
            }

            public void templateFinished(Template template, boolean brokenOff) {
                Intrinsics.checkNotNullParameter((Object)template, (String)"template");
                if (!brokenOff) {
                    JSDestructuringPropagationIntentionBase.runWriteAction(() -> invoke.2.1.templateFinished$lambda$0(this.this$0, this.$project, this.$editor, this.$file));
                }
            }

            private static final void templateFinished$lambda$0(JSGenerateDestructuringPatternIntention this$0, Project $project, Editor $editor, PsiFile $file) {
                Intrinsics.checkNotNull((Object)$file);
                JSGenerateDestructuringPatternIntention.access$runVariablesTemplate(this$0, $project, $editor, $file);
            }
        });
    }

    public static final /* synthetic */ void access$runVariablesTemplate(JSGenerateDestructuringPatternIntention $this, Project project, Editor editor, PsiFile file) {
        $this.runVariablesTemplate(project, editor, file);
    }
}

