/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptTypeGuardFixHelper;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.highlighting.TypeGuardSurroundKind;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSElvisOwner;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptInsertTypeGuardFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    private final String myName;
    private final TypeGuardSurroundKind mySurroundKind;
    private final String myDiscriminatedPropertyName;
    private final boolean myIsNegative;
    private final boolean myAllowSimplifyForNullable;
    private static final String myTypeOfTemplate = "typeof %s === %s";
    private static final String myTypeOfNegativeTemplate = "typeof %s !== %s";
    private static final String myInstanceOfTemplate = "%s instanceof %s";
    private final String myPropertyNameForInGuard;
    @NotNull
    private final ComputedInAdvanceFixKind myComputedInAdvanceFixKind;
    @NotNull
    private final TypeHintForTemplate myTypeHintForTemplate;

    public TypeScriptInsertTypeGuardFix(@Nullable PsiElement element, @NotNull JSType type, @NotNull TypeScriptTypeGuardFixHelper.JSTypeGuardFixData data) {
        if (type == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(0);
        }
        if (data == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(1);
        }
        super(element);
        this.myName = type.getTypeText(JSType.TypeTextFormat.CODE);
        this.mySurroundKind = data.getSurroundKind();
        this.myDiscriminatedPropertyName = data.getDiscriminatedPropertyName();
        this.myIsNegative = data.isNegative();
        this.myAllowSimplifyForNullable = data.isAllowSimplifyForNullable();
        this.myPropertyNameForInGuard = data.getPropertyNameForInGuard();
        this.myComputedInAdvanceFixKind = TypeScriptInsertTypeGuardFix.computeFixKindInAdvance(element, this.myName, type, data);
        this.myTypeHintForTemplate = TypeScriptInsertTypeGuardFix.getJsTypeForTemplate(type);
    }

    private static ComputedInAdvanceFixKind computeFixKindInAdvance(@Nullable PsiElement startElement, String name, JSType type, TypeScriptTypeGuardFixHelper.JSTypeGuardFixData fixData) {
        if (startElement != null && fixData.getSurroundKind().isChainingOp()) {
            PsiElement parent = TypeScriptInsertTypeGuardFix.computeParent(startElement, fixData.getSurroundKind());
            if (!(parent instanceof JSReferenceExpression)) {
                return ComputedInAdvanceFixKind.FIX_UNAVAILABLE;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof JSElvisOwner) || fixData.getSurroundKind() == TypeGuardSurroundKind.OptionalChaining && grandParent instanceof JSReferenceExpression && grandParent.getNode().findChildByType(JSTokenTypes.DOT) == null) {
                return ComputedInAdvanceFixKind.FIX_UNAVAILABLE;
            }
            return ComputedInAdvanceFixKind.CHAINING_OP;
        }
        if (!(fixData.getDiscriminatedPropertyName() != null || TypeScriptInsertTypeGuardFix.isTypeOfMember(name) || type instanceof JSNullType || type instanceof JSUndefinedType || type instanceof JSResolvableType)) {
            return ComputedInAdvanceFixKind.FIX_UNAVAILABLE;
        }
        if (fixData.getDiscriminatedPropertyName() == null && !TypeScriptInsertTypeGuardFix.isTypeOfMember(name) && type instanceof JSResolvableType) {
            JSResolvedTypeInfo info = ((JSResolvableType)type).resolveType();
            JSClass clazz = (JSClass)info.getDeclarationOfType(JSClass.class);
            if (clazz == null) {
                return ComputedInAdvanceFixKind.FIX_UNAVAILABLE;
            }
            if (clazz.isInterface() || clazz instanceof TypeScriptTypeAlias) {
                if (fixData.getPropertyNameForInGuard() != null && fixData.getSurroundKind() != TypeGuardSurroundKind.SwitchStatement) {
                    return ComputedInAdvanceFixKind.IN_GUARD;
                }
                return ComputedInAdvanceFixKind.FIX_UNAVAILABLE;
            }
        }
        return ComputedInAdvanceFixKind.CANNOT_COMPUTE_IN_ADVANCE;
    }

    private static TypeHintForTemplate getJsTypeForTemplate(JSType type) {
        if (type instanceof JSNullType || type instanceof JSUndefinedType) {
            return TypeHintForTemplate.NULLABLE;
        }
        if (type instanceof JSBooleanLiteralTypeImpl) {
            return ((JSBooleanLiteralTypeImpl)type).getLiteral() != false ? TypeHintForTemplate.BOOLEAN_LITERAL_TRUE : TypeHintForTemplate.BOOLEAN_LITERAL_FALSE;
        }
        return TypeHintForTemplate.OTHER;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        String shortestTypeName;
        if (project == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(5);
        }
        if (this.myComputedInAdvanceFixKind == ComputedInAdvanceFixKind.CHAINING_OP || this.myComputedInAdvanceFixKind == ComputedInAdvanceFixKind.IN_GUARD) {
            return true;
        }
        if (this.myComputedInAdvanceFixKind == ComputedInAdvanceFixKind.FIX_UNAVAILABLE) {
            return false;
        }
        if (this.myDiscriminatedPropertyName == null && TypeScriptUtil.hasAmbientExternalModuleInQName((String)this.myName) && TypeScriptUtil.hasAmbientExternalModuleInQName((String)(shortestTypeName = TypeScriptUtil.getShortestTypeNameInContext((String)this.myName, (PsiElement)startElement)))) {
            return false;
        }
        PsiElement qualifier = startElement;
        while (qualifier != null && !(qualifier instanceof JSThisExpression)) {
            if (!(qualifier instanceof JSReferenceExpression)) {
                return false;
            }
            qualifier = ((JSReferenceExpression)qualifier).getQualifier();
        }
        JSFieldVariable variable = TypeScriptInsertTypeGuardFix.getResolvedVariable(startElement);
        if (variable == null) {
            return false;
        }
        if (variable.getJSType() instanceof JSPrimitiveType && (!(variable instanceof JSParameter) || !((JSParameter)variable).isOptional()) && TypeScriptInsertTypeGuardFix.isTypeOfMember(this.myName)) {
            return false;
        }
        String name = variable.getName();
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        PsiElement parent = TypeScriptInsertTypeGuardFix.computeParent(startElement, this.mySurroundKind);
        if ((this.mySurroundKind == TypeGuardSurroundKind.IfStatement || this.mySurroundKind == TypeGuardSurroundKind.SwitchStatement) && (parent instanceof JSExpressionStatement || parent instanceof JSVarStatement)) {
            return true;
        }
        return (this.mySurroundKind == TypeGuardSurroundKind.Ternary || this.mySurroundKind == TypeGuardSurroundKind.And || this.mySurroundKind == TypeGuardSurroundKind.Or) && parent instanceof JSExpression;
    }

    @Nullable
    private static JSFieldVariable getResolvedVariable(@Nullable PsiElement startElement) {
        PsiElement resolve;
        if (startElement instanceof JSVariable) {
            return (JSVariable)startElement;
        }
        if (startElement instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)startElement).resolve()) instanceof JSFieldVariable) {
            return (JSFieldVariable)resolve;
        }
        return null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(6);
        }
        if (psiFile == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(7);
        }
        if (startElement == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(8);
        }
        if (endElement == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            return;
        }
        PsiElement parent = TypeScriptInsertTypeGuardFix.computeParent(startElement, this.mySurroundKind);
        if (parent == null) {
            return;
        }
        if (this.mySurroundKind == TypeGuardSurroundKind.OptionalChaining) {
            JSChangeUtil.setElvisAfter((PsiElement)startElement);
            return;
        }
        if (this.mySurroundKind == TypeGuardSurroundKind.NullishCoalescing) {
            JSExpression qualifier;
            PsiElement grandParent = startElement.getParent();
            JSExpression jSExpression = qualifier = grandParent instanceof JSReferenceExpression ? ((JSReferenceExpression)grandParent).getQualifier() : (JSExpression)startElement;
            assert (qualifier != null);
            JSParenthesizedExpression newQualifier = (JSParenthesizedExpression)qualifier.replace(JSPsiElementFactory.createJSExpression((String)("(" + qualifier.getText() + "?? x)"), (PsiElement)qualifier));
            int offset = ((JSBinaryExpression)newQualifier.getInnerExpression()).getROperand().getTextRange().getEndOffset();
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            editor.getDocument().replaceString(offset, offset + 1, (CharSequence)"");
            editor.getCaretModel().moveToOffset(offset);
            return;
        }
        JSFieldVariable variable = TypeScriptInsertTypeGuardFix.getResolvedVariable(startElement);
        if (variable == null) {
            return;
        }
        String shortenedType = TypeScriptUtil.getShortestTypeNameInContext((String)this.myName, (PsiElement)startElement);
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        boolean isTypeOf = TypeScriptInsertTypeGuardFix.isTypeOfMember(shortenedType);
        String name = startElement instanceof JSVariable ? variable.getName() : startElement.getText();
        Template template = templateManager.createTemplate("", "", String.format(this.getTemplate(shortenedType), name, isTypeOf ? TypeScriptInsertTypeGuardFix.wrapWithQuotes(shortenedType) : shortenedType));
        template.setToReformat(true);
        template.setToShortenLongNames(false);
        int offset = parent.getTextRange().getStartOffset();
        editor.getSelectionModel().setSelection(offset, offset + parent.getTextLength());
        templateManager.startTemplate(editor, parent.getText(), template);
    }

    @Nullable
    private static PsiElement computeParent(@NotNull PsiElement startElement, TypeGuardSurroundKind surroundKind) {
        if (startElement == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(10);
        }
        if (surroundKind == TypeGuardSurroundKind.IfStatement || surroundKind == TypeGuardSurroundKind.SwitchStatement) {
            return PsiTreeUtil.getNonStrictParentOfType((PsiElement)startElement, (Class[])new Class[]{JSStatement.class});
        }
        return TypeScriptInsertTypeGuardFix.getOwnerExpression(startElement, surroundKind);
    }

    @Nullable
    private static JSExpression getOwnerExpression(@Nullable PsiElement expression, TypeGuardSurroundKind surroundKind) {
        if (!(expression instanceof JSExpression)) {
            return null;
        }
        if (surroundKind.isChainingOp()) {
            return (JSExpression)ObjectUtils.tryCast((Object)expression, JSReferenceExpression.class);
        }
        PsiElement parentExpression = expression.getParent();
        if (parentExpression instanceof JSCallExpression) {
            return TypeScriptInsertTypeGuardFix.getOwnerExpression(parentExpression, surroundKind);
        }
        if (parentExpression instanceof JSReferenceExpression) {
            return TypeScriptInsertTypeGuardFix.getOwnerExpression(parentExpression, surroundKind);
        }
        if (parentExpression instanceof JSBinaryExpression) {
            if (((JSBinaryExpression)parentExpression).getROperand() == expression) {
                IElementType sign = ((JSBinaryExpression)parentExpression).getOperationSign();
                if (!(surroundKind != TypeGuardSurroundKind.And && surroundKind != TypeGuardSurroundKind.Or || sign != JSTokenTypes.ANDAND && sign != JSTokenTypes.OROR)) {
                    return (JSExpression)expression;
                }
            }
            return (JSExpression)parentExpression;
        }
        return (JSExpression)expression;
    }

    public static boolean isTypeOfMember(@NotNull String typeofWrapType) {
        if (typeofWrapType == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(11);
        }
        return ArrayUtil.contains((String)typeofWrapType, (String[])JSCommonTypeNames.TYPEOF_VALUES);
    }

    @NotNull
    private static String wrapWithQuotes(@NotNull String shortenedType) {
        if (shortenedType == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(12);
        }
        String string = "\"" + shortenedType + "\"";
        if (string == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public String getText() {
        return this.getActionText();
    }

    private boolean isSurround() {
        return switch (this.mySurroundKind) {
            default -> throw new MatchException(null, null);
            case TypeGuardSurroundKind.IfStatement, TypeGuardSurroundKind.SwitchStatement -> true;
            case TypeGuardSurroundKind.Ternary, TypeGuardSurroundKind.And, TypeGuardSurroundKind.Or, TypeGuardSurroundKind.OptionalChaining, TypeGuardSurroundKind.NullishCoalescing -> false;
        };
    }

    @NotNull
    @IntentionName
    private String getActionText() {
        String string = JavaScriptBundle.message((String)(this.mySurroundKind == TypeGuardSurroundKind.NullishCoalescing ? (this.getStartElement().getParent() instanceof JSReferenceExpression ? "typescript.insert.type.guard.nc" : "typescript.insert.type.guard.nc.self") : (this.isSurround() ? "typescript.insert.type.guard.surround" : (this.mySurroundKind == TypeGuardSurroundKind.OptionalChaining && !(this.getStartElement().getParent() instanceof JSReferenceExpression) ? "typescript.insert.type.guard.postfix" : "typescript.insert.type.guard.prefix"))), (Object[])new Object[]{this.createGuardTextDescription()});
        if (string == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private String getTemplate(String typeName) {
        String template = this.myComputedInAdvanceFixKind == ComputedInAdvanceFixKind.IN_GUARD ? this.getInGuardTemplate() : (this.myDiscriminatedPropertyName != null ? this.computeTemplateForDiscriminator() : (this.myTypeHintForTemplate == TypeHintForTemplate.NULLABLE ? this.computeTemplateForNullable() : this.computeTypeOfOrInstanceOfTemplate(typeName)));
        return switch (this.mySurroundKind) {
            default -> throw new MatchException(null, null);
            case TypeGuardSurroundKind.IfStatement -> "if (" + template + ") {$SELECTION$}";
            case TypeGuardSurroundKind.Ternary -> template + " ? $SELECTION$ : $END$";
            case TypeGuardSurroundKind.And -> template + " && $SELECTION$";
            case TypeGuardSurroundKind.Or -> template + " || $SELECTION$";
            case TypeGuardSurroundKind.SwitchStatement -> {
                if (!$assertionsDisabled && this.myDiscriminatedPropertyName == null) {
                    throw new AssertionError();
                }
                yield "switch (%s." + this.myDiscriminatedPropertyName + ") { case %s: $SELECTION$ }";
            }
            case TypeGuardSurroundKind.OptionalChaining -> "?.";
            case TypeGuardSurroundKind.NullishCoalescing -> "(%s ?? $SELECTION$)";
        };
    }

    @NotNull
    private String getInGuardTemplate() {
        String quote = JSCodeStyleSettings.getQuote((PsiElement)this.getStartElement());
        StringBuilder builder = new StringBuilder(quote);
        JSStringUtil.escapeSimpleStringChars((String)this.myPropertyNameForInGuard, (char)quote.charAt(0), (boolean)true, (boolean)false, (boolean)false, (StringBuilder)builder);
        builder.append(quote);
        String string = String.valueOf(builder) + " in %s";
        if (string == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private String computeTemplateForDiscriminator() {
        boolean shouldNegateCondition = this.shouldNegateCondition();
        if (this.myTypeHintForTemplate == TypeHintForTemplate.BOOLEAN_LITERAL_TRUE || this.myTypeHintForTemplate == TypeHintForTemplate.BOOLEAN_LITERAL_FALSE) {
            boolean literal = this.myTypeHintForTemplate == TypeHintForTemplate.BOOLEAN_LITERAL_TRUE;
            boolean negate = literal == shouldNegateCondition;
            String template = "%s." + this.myDiscriminatedPropertyName;
            String string = negate ? "!(" + template + ")" : template;
            if (string == null) {
                TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(16);
            }
            return string;
        }
        String string = "%s." + this.myDiscriminatedPropertyName + (shouldNegateCondition ? " !==" : " ===") + " %s";
        if (string == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(17);
        }
        return string;
    }

    private boolean shouldNegateCondition() {
        return this.myIsNegative && this.mySurroundKind != TypeGuardSurroundKind.Or || !this.myIsNegative && this.mySurroundKind == TypeGuardSurroundKind.Or;
    }

    @NotNull
    private String computeTemplateForNullable() {
        if (!this.myAllowSimplifyForNullable) {
            return this.shouldNegateCondition() ? "%s != null" : "%s == null";
        }
        return this.shouldNegateCondition() ? "%s" : "!(%s)";
    }

    @NotNull
    private String computeTypeOfOrInstanceOfTemplate(String typeName) {
        return this.shouldNegateCondition() ? (TypeScriptInsertTypeGuardFix.isTypeOfMember(typeName) ? myTypeOfNegativeTemplate : "!(%s instanceof %s)") : (TypeScriptInsertTypeGuardFix.isTypeOfMember(typeName) ? myTypeOfTemplate : myInstanceOfTemplate);
    }

    @NotNull
    private String createGuardTextDescription() {
        PsiElement element = this.myStartElement.getElement();
        if (element == null) {
            return "";
        }
        boolean isTypeOf = TypeScriptInsertTypeGuardFix.isTypeOfMember(this.myName);
        String string = String.format(StringUtil.replace((String)StringUtil.replace((String)this.getTemplate(this.myName), (String)"$SELECTION$", (String)"..."), (String)"$END$", (String)""), element.getText(), isTypeOf ? TypeScriptInsertTypeGuardFix.wrapWithQuotes(this.myName) : this.myName);
        if (string == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"typescript.insert.type.guard.fix.family", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptInsertTypeGuardFix.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 14, 15, 16, 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeofWrapType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortenedType";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/TypeScriptInsertTypeGuardFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/TypeScriptInsertTypeGuardFix";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithQuotes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionText";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getInGuardTemplate";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "computeTemplateForDiscriminator";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createGuardTextDescription";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computeParent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isTypeOfMember";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithQuotes";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 14, 15, 16, 17, 18, 19 -> new IllegalStateException(string);
        };
    }

    private static enum ComputedInAdvanceFixKind {
        CHAINING_OP,
        IN_GUARD,
        FIX_UNAVAILABLE,
        CANNOT_COMPUTE_IN_ADVANCE;

    }

    private static enum TypeHintForTemplate {
        NULLABLE,
        BOOLEAN_LITERAL_TRUE,
        BOOLEAN_LITERAL_FALSE,
        OTHER;

    }
}

