/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptExtendedConfig;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptAddFileToConfigFix
extends FixAndIntentionAction
implements HighPriorityAction {
    public static final Logger LOGGER = Logger.getInstance(TypeScriptAddFileToConfigFix.class);
    @NotNull
    private final String myFileName;

    public TypeScriptAddFileToConfigFix(@NotNull JSElement jsElement, @NotNull PsiElement element) {
        if (jsElement == null) {
            TypeScriptAddFileToConfigFix.$$$reportNull$$$0(0);
        }
        if (element == null) {
            TypeScriptAddFileToConfigFix.$$$reportNull$$$0(1);
        }
        this.registerElementRefForFix((PsiElement)jsElement, null);
        PsiFile file = element.getContainingFile();
        this.myFileName = file.getName();
    }

    protected boolean isAvailable(Project project, PsiElement element, Editor editor, PsiFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        TypeScriptConfig include = TypeScriptConfigService.Provider.get((Project)project).getPreferableConfig(virtualFile);
        return include != null && !include.isDirectoryBased() && !(include instanceof TypeScriptExtendedConfig);
    }

    public boolean startInWriteAction() {
        return true;
    }

    protected void applyFix(Project project, PsiElement el, @NotNull PsiFile file, @Nullable Editor editor) {
        if (file == null) {
            TypeScriptAddFileToConfigFix.$$$reportNull$$$0(2);
        }
        if (!(el instanceof PsiPolyVariantReference)) {
            return;
        }
        Object[] results = ((PsiPolyVariantReference)el).multiResolve(false);
        if (results.length == 0) {
            return;
        }
        ResolveResult item = (ResolveResult)ArrayUtil.getFirstElement((Object[])results);
        if (!(item instanceof JSResolveResult)) {
            return;
        }
        JSResolveResult jsResolveResult = (JSResolveResult)item;
        PsiElement element = jsResolveResult.getElement();
        VirtualFile virtualFile = file.getVirtualFile();
        TypeScriptConfig include = TypeScriptConfigService.Provider.get((Project)project).getPreferableConfig(virtualFile);
        if (include == null) {
            return;
        }
        assert (element != null);
        PsiFile psiFileForResolvedElement = element.getContainingFile();
        VirtualFile virtualFileToAdd = psiFileForResolvedElement.getVirtualFile();
        if (!TypeScriptConfigUtil.addVirtualFileToConfigFiles((Project)project, (VirtualFile)virtualFileToAdd, (TypeScriptConfig)include)) {
            LOGGER.error("Cannot add reference to tsconfig.json \n" + String.valueOf(include));
        }
    }

    @IntentionName
    @NotNull
    public String getName() {
        String string = TypeScriptAddFileToConfigFix.getMessageText(this.myFileName);
        if (string == null) {
            TypeScriptAddFileToConfigFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @IntentionName
    public static String getMessageText(@NlsSafe String fileName) {
        return JavaScriptBundle.message((String)"intention.name.add.file.to.tsconfig", (Object[])new Object[]{fileName});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/intentions/TypeScriptAddFileToConfigFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/intentions/TypeScriptAddFileToConfigFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

