/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.javascript;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.impl.JSCallExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.BDDFrameworkType;
import org.jetbrains.plugins.cucumber.StepDefinitionCreator;
import org.jetbrains.plugins.cucumber.javascript.CucumberJavaScriptStepDefinitionCreator;
import org.jetbrains.plugins.cucumber.javascript.CucumberJavaScriptUtil;
import org.jetbrains.plugins.cucumber.javascript.JavaScriptStepDefinition;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.steps.AbstractCucumberExtension;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;

@NotNullByDefault
public class CucumberJavaScriptExtension
extends AbstractCucumberExtension {
    public List<AbstractStepDefinition> getStepDefinitions(Module module) {
        ArrayList<AbstractStepDefinition> result = new ArrayList<AbstractStepDefinition>();
        Collection steps = JSClassResolver.getInstance().findElementsByNameIncludingImplicit("$cucumberJSSteps", ProjectScope.getAllScope((Project)module.getProject()));
        for (JSPsiElementBase step : steps) {
            JSLiteralExpression literalExpression;
            JSCallExpressionImpl callExpression = (JSCallExpressionImpl)ObjectUtils.tryCast((Object)step.getParent(), JSCallExpressionImpl.class);
            if (callExpression == null || (literalExpression = (JSLiteralExpression)ObjectUtils.tryCast((Object)CucumberJavaScriptUtil.getFirstCallArgument(callExpression, CucumberJavaScriptUtil.LITERAL_STUBS), JSLiteralExpression.class)) == null) continue;
            result.add(new JavaScriptStepDefinition((PsiElement)literalExpression, ((JSImplicitElementImpl)step).getUserStringData()));
        }
        return result;
    }

    public boolean isStepLikeFile(PsiElement child) {
        return child instanceof JSFile && !DialectDetector.isTypeScript((PsiElement)child);
    }

    public boolean isWritableStepLikeFile(PsiElement child) {
        return this.isStepLikeFile(child);
    }

    public BDDFrameworkType getStepFileType() {
        return new BDDFrameworkType((FileType)JavaScriptFileType.INSTANCE, "JavaScript");
    }

    public StepDefinitionCreator getStepDefinitionCreator() {
        return new CucumberJavaScriptStepDefinitionCreator();
    }

    public List<AbstractStepDefinition> loadStepsFor(@Nullable PsiFile featureFile, Module module) {
        if (featureFile == null) {
            return Collections.emptyList();
        }
        return this.getStepDefinitions(module);
    }

    public Collection<? extends PsiFile> getStepDefinitionContainers(GherkinFile file) {
        HashSet<PsiFile> result = new HashSet<PsiFile>();
        Collection steps = JSClassResolver.getInstance().findElementsByNameIncludingImplicit("$cucumberJSSteps", ProjectScope.getAllScope((Project)file.getProject()));
        for (JSPsiElementBase step : steps) {
            PsiFile containingFile = step.getContainingFile();
            if (!this.isStepLikeFile((PsiElement)containingFile)) continue;
            result.add(containingFile);
        }
        return result;
    }
}

