/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.javascript;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.modules.JSImportCandidateDescriptor;
import com.intellij.lang.javascript.modules.imports.JSAddRequireExecutor;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.AbstractStepDefinitionCreator;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.cucumber.javascript.CucumberJavaScriptUtil;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.i18n.JsonGherkinKeywordProvider;

public class CucumberJavaScriptStepDefinitionCreator
extends AbstractStepDefinitionCreator {
    private static final List<String> FORBIDDEN_STEP_KEYWORD = Arrays.asList("And", "But", "*");
    private static final String JAVASCRIPT_FILE_EXTENSION = ".js";
    private final GherkinKeywordProvider myProvider = JsonGherkinKeywordProvider.getKeywordProvider((boolean)true);

    @NotNull
    protected String getStepKeyword(@NotNull GherkinStep step) {
        String keyword;
        if (step == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(0);
        }
        if (FORBIDDEN_STEP_KEYWORD.contains(step.getKeyword().getText())) {
            PsiElement prevStep = step.getPrevSibling();
            while (prevStep instanceof GherkinStep && FORBIDDEN_STEP_KEYWORD.contains(((GherkinStep)prevStep).getKeyword().getText()) || prevStep instanceof PsiWhiteSpace) {
                prevStep = prevStep.getPrevSibling();
            }
            keyword = prevStep instanceof GherkinStep ? ((GherkinStep)prevStep).getKeyword().getText() : "Given";
        } else {
            String keyword2 = step.getKeyword().getText();
            if (step.getContainingFile() instanceof GherkinFile) {
                String language = ((GherkinFile)step.getContainingFile()).getLocaleLanguage();
                String string = this.myProvider.getBaseKeyword(language, keyword2);
                if (string == null) {
                    CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = keyword2;
            if (string == null) {
                CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = keyword;
        if (string == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    protected String getExtension() {
        return JAVASCRIPT_FILE_EXTENSION;
    }

    @NotNull
    public PsiFile createStepDefinitionContainer(@NotNull PsiDirectory dir, @NotNull String name) {
        if (dir == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(4);
        }
        if (name == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(5);
        }
        PsiFile psiFile = (PsiFile)WriteAction.compute(() -> dir.createFile(name + this.getExtension()));
        if (psiFile == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(6);
        }
        return psiFile;
    }

    public boolean createStepDefinition(@NotNull GherkinStep step, @NotNull PsiFile file, boolean withTemplate) {
        if (step == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(7);
        }
        if (file == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(8);
        }
        Project project = file.getProject();
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        assert (editor != null);
        this.closeActiveTemplateBuilders(file);
        this.addStepTextWithImport(step, file);
        return false;
    }

    @NotNull
    public String getDefaultStepFileName(@NotNull GherkinStep step) {
        if (step == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(9);
        }
        return "my_steps";
    }

    private void addStepTextWithImport(@NotNull GherkinStep step, @NotNull PsiFile file) {
        String keyword;
        boolean hasTopLevelName;
        if (step == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(10);
        }
        if (file == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(11);
        }
        if (!(hasTopLevelName = this.hasTopLevelName((JSFile)file, keyword = this.getStepKeyword(step)))) {
            this.addImportText(file, keyword);
        }
        String stepText = CucumberUtil.prepareStepRegexp((String)step.getName());
        CucumberJavaScriptStepDefinitionCreator.addStepText(file, keyword, stepText);
    }

    protected void addImportText(@NotNull PsiFile file, @NotNull String keyword) {
        if (file == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(12);
        }
        if (keyword == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(13);
        }
        String packageName = CucumberJavaScriptStepDefinitionCreator.resolvePackageName(file);
        JSAddRequireExecutor executor = new JSAddRequireExecutor((PsiElement)file);
        JSImportCandidateDescriptor descriptor = new JSImportCandidateDescriptor(packageName, keyword, keyword, ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT, (JSImportExportType)ES6ImportPsiUtil.ImportExportType.SPECIFIER);
        executor.createImportOrUpdateExisting((JSImportDescriptor)descriptor);
    }

    protected static String resolvePackageName(@NotNull PsiFile file) {
        if (file == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(14);
        }
        NodeJsInterpreterRef interpreterRef = NodeJsInterpreterRef.createProjectRef();
        NodeJsInterpreter interpreter = interpreterRef.resolve(file.getProject());
        NodePackage cucumberPackage = CucumberJavaScriptUtil.getCucumberPackage(file.getProject(), interpreter);
        return StringUtil.defaultIfEmpty((String)cucumberPackage.getName(), (String)"cucumber");
    }

    private static void addStepText(@NotNull PsiFile file, @NotNull String stepName, @NotNull String stepText) {
        ASTNode node;
        if (file == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(15);
        }
        if (stepName == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(16);
        }
        if (stepText == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(17);
        }
        if ((node = JSChangeUtil.createStatementFromText((Project)file.getProject(), (String)CucumberJavaScriptStepDefinitionCreator.getStepText(stepName, stepText), (JSLanguageDialect)DialectDetector.languageDialectOfElement((PsiElement)file), (boolean)false)) == null) {
            return;
        }
        file.add(node.getPsi());
    }

    protected boolean hasTopLevelName(@NotNull JSFile jsFile, @NotNull String keyword) {
        if (jsFile == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(18);
        }
        if (keyword == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(19);
        }
        return JSStubBasedPsiTreeUtil.resolveLocally((String)keyword, (PsiElement)jsFile) != null;
    }

    @NotNull
    private static String getStepText(@NotNull String stepName, @NotNull String stepText) {
        if (stepName == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(20);
        }
        if (stepText == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(21);
        }
        String string = String.format("%s(/^%s$/, function () {\n    \n});", stepName, stepText);
        if (string == null) {
            CucumberJavaScriptStepDefinitionCreator.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 6, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptStepDefinitionCreator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepName";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepText";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/javascript/CucumberJavaScriptStepDefinitionCreator";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepKeyword";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createStepDefinitionContainer";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStepKeyword";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 22: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createStepDefinitionContainer";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createStepDefinition";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultStepFileName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addStepTextWithImport";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addImportText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolvePackageName";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addStepText";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "hasTopLevelName";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getStepText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 6, 22 -> new IllegalStateException(string);
        };
    }
}

