/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.javascript.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.nodejs.debug.NodeDebugRunConfiguration;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.javascript.CucumberJavaScriptBundle;
import org.jetbrains.plugins.cucumber.javascript.run.CucumberJavaScriptRunningState;
import org.jetbrains.plugins.cucumber.javascript.run.ui.CucumberJavaScriptConfigurationEditorForm;

public class CucumberJavaScriptRunConfiguration
extends LocatableConfigurationBase<Element>
implements NodeDebugRunConfiguration {
    public String myFilePath = null;
    public String myNameFilter = null;
    public String cucumberJsArguments = "";
    public String workingDirectory = null;
    private NodeJsInterpreterRef myInterpreterRef;
    private EnvironmentVariablesData myEnvData = EnvironmentVariablesData.DEFAULT;

    protected CucumberJavaScriptRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
        this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
    }

    @Nullable
    public String getWorkingDirectory() {
        return this.workingDirectory != null ? this.workingDirectory : this.getProject().getBasePath();
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            CucumberJavaScriptRunConfiguration.$$$reportNull$$$0(0);
        }
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
        this.myEnvData = EnvironmentVariablesData.readExternal((Element)element);
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            CucumberJavaScriptRunConfiguration.$$$reportNull$$$0(1);
        }
        super.writeExternal(element);
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
        if (!EnvironmentVariablesData.DEFAULT.equals((Object)this.myEnvData)) {
            this.myEnvData.writeExternal(element);
        }
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new CucumberJavaScriptConfigurationEditorForm(this.getProject());
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            CucumberJavaScriptRunConfiguration.$$$reportNull$$$0(2);
        }
        if (env == null) {
            CucumberJavaScriptRunConfiguration.$$$reportNull$$$0(3);
        }
        Project project = env.getProject();
        String path = this.getFilePath();
        if (path == null || VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)path)) == null) {
            throw new ExecutionException(CucumberJavaScriptBundle.message("dialog.message.can.t.find.file", path));
        }
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)path));
        assert (virtualFile != null);
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        if (module == null) {
            throw new ExecutionException(CucumberJavaScriptBundle.message("dialog.message.can.t.find.module.for.file", new Object[0]));
        }
        return new CucumberJavaScriptRunningState(env, this);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (this.myFilePath == null || VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)this.myFilePath)) == null) {
            throw new RuntimeConfigurationException(CucumberJavaScriptBundle.message("dialog.message.can.t.find.file", this.myFilePath));
        }
    }

    public String getFilePath() {
        return this.myFilePath;
    }

    public void setFilePath(String filePath) {
        this.myFilePath = PathUtil.toSystemIndependentName((String)filePath);
    }

    public String getNameFilter() {
        return this.myNameFilter;
    }

    public void setNameFilter(String nameFilter) {
        this.myNameFilter = nameFilter;
    }

    public String getCucumberJsArguments() {
        return this.cucumberJsArguments;
    }

    public void setCucumberJsArguments(String cucumberJsArguments) {
        this.cucumberJsArguments = cucumberJsArguments;
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.myInterpreterRef;
        if (nodeJsInterpreterRef == null) {
            CucumberJavaScriptRunConfiguration.$$$reportNull$$$0(4);
        }
        return nodeJsInterpreterRef;
    }

    public void setInterpreterRef(@NotNull NodeJsInterpreterRef interpreterRef) {
        if (interpreterRef == null) {
            CucumberJavaScriptRunConfiguration.$$$reportNull$$$0(5);
        }
        this.myInterpreterRef = interpreterRef;
    }

    @NotNull
    public EnvironmentVariablesData getEnvData() {
        EnvironmentVariablesData environmentVariablesData = this.myEnvData;
        if (environmentVariablesData == null) {
            CucumberJavaScriptRunConfiguration.$$$reportNull$$$0(6);
        }
        return environmentVariablesData;
    }

    public void setEnvData(@NotNull EnvironmentVariablesData envData) {
        if (envData == null) {
            CucumberJavaScriptRunConfiguration.$$$reportNull$$$0(7);
        }
        this.myEnvData = envData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/javascript/run/CucumberJavaScriptRunConfiguration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterRef";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/javascript/run/CucumberJavaScriptRunConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterRef";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setInterpreterRef";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setEnvData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6 -> new IllegalStateException(string);
        };
    }
}

