/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.javascript.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.javascript.CucumberJavaScriptUtil;
import org.jetbrains.plugins.cucumber.javascript.run.CucumberJavaScriptRunConfiguration;
import org.jetbrains.plugins.cucumber.javascript.run.CucumberJavaScriptRunConfigurationType;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinScenario;
import org.jetbrains.plugins.cucumber.psi.GherkinScenarioOutline;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;

final class CucumberJavaScriptRunConfigurationProducer
extends LazyRunConfigurationProducer<CucumberJavaScriptRunConfiguration>
implements Cloneable {
    private static final String SCENARIO_OUTLINE_PARAMETER_REGEXP = "\\\\<.*?\\\\>";
    private static final String NAME_FILTER_TEMPLATE = "^%s$";
    private static final String ANY_STRING_REGEXP = ".*";
    private static final String FEATURES_FOLDER_NAME = "features";

    CucumberJavaScriptRunConfigurationProducer() {
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = CucumberJavaScriptRunConfigurationType.getInstance().getConfigurationFactories()[0];
        if (configurationFactory == null) {
            CucumberJavaScriptRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    private static boolean hasParentCalledFeatures(PsiDirectory directory) {
        while (directory != null) {
            if (directory.getName().equals(FEATURES_FOLDER_NAME)) {
                return true;
            }
            directory = directory.getParentDirectory();
        }
        return false;
    }

    @NotNull
    private static String getFileToRun(@NotNull PsiElement element) {
        if (element == null) {
            CucumberJavaScriptRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        return CucumberJavaScriptRunConfigurationProducer.getPath(CucumberJavaScriptRunConfigurationProducer.getFileOrDirectoryToRun(element));
    }

    @NotNull
    private static String getPath(@NotNull PsiFileSystemItem fileOrDirectory) {
        if (fileOrDirectory == null) {
            CucumberJavaScriptRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        String string = FileUtil.toSystemIndependentName((String)fileOrDirectory.getVirtualFile().getPath());
        if (string == null) {
            CucumberJavaScriptRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private static PsiFileSystemItem getFileOrDirectoryToRun(@NotNull PsiElement element) {
        if (element == null) {
            CucumberJavaScriptRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        PsiFileSystemItem fileOrDirectory = (PsiFileSystemItem)PsiTreeUtil.getParentOfType((PsiElement)element, PsiFileSystemItem.class, (boolean)false);
        assert (fileOrDirectory != null);
        PsiFileSystemItem psiFileSystemItem = fileOrDirectory;
        if (psiFileSystemItem == null) {
            CucumberJavaScriptRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        return psiFileSystemItem;
    }

    protected boolean setupConfigurationFromContext(@NotNull CucumberJavaScriptRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        NodeJsLocalInterpreter interpreter;
        PsiElement element;
        if (configuration == null) {
            CucumberJavaScriptRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (context == null) {
            CucumberJavaScriptRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        if (sourceElement == null) {
            CucumberJavaScriptRunConfigurationProducer.$$$reportNull$$$0(8);
        }
        if ((element = (PsiElement)sourceElement.get()) == null) {
            return false;
        }
        try {
            interpreter = configuration.getInterpreterRef().resolveAsLocal(configuration.getProject());
        }
        catch (ExecutionException e) {
            return false;
        }
        NodePackage nodePackage = CucumberJavaScriptUtil.getCucumberPackage(context.getProject(), (NodeJsInterpreter)interpreter);
        if (nodePackage.isEmptyPath()) {
            return false;
        }
        GherkinStepsHolder stepsHolder = (GherkinStepsHolder)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GherkinScenario.class, GherkinScenarioOutline.class});
        if (stepsHolder != null) {
            PsiFileSystemItem fileOrDirectory = CucumberJavaScriptRunConfigurationProducer.getFileOrDirectoryToRun(element);
            String workingDir = CucumberJavaScriptRunConfigurationProducer.guessWorkingDirectory(configuration.getProject(), fileOrDirectory);
            if (workingDir != null) {
                configuration.setWorkingDirectory(workingDir);
            }
            String configurationPrefix = stepsHolder instanceof GherkinScenarioOutline ? "Scenario Outline: " : "Scenario: ";
            configuration.setName(configurationPrefix + StringUtil.shortenTextWithEllipsis((String)stepsHolder.getScenarioName(), (int)30, (int)0));
            configuration.setFilePath(CucumberJavaScriptRunConfigurationProducer.getPath(fileOrDirectory));
            String nameFilter = String.format(NAME_FILTER_TEMPLATE, StringUtil.escapeToRegexp((String)stepsHolder.getScenarioName()));
            if (stepsHolder instanceof GherkinScenarioOutline) {
                nameFilter = nameFilter.replaceAll(SCENARIO_OUTLINE_PARAMETER_REGEXP, ANY_STRING_REGEXP);
            }
            configuration.setNameFilter(nameFilter);
            return true;
        }
        if (element.getContainingFile() instanceof GherkinFile || element instanceof PsiDirectory && CucumberJavaScriptRunConfigurationProducer.hasParentCalledFeatures((PsiDirectory)element)) {
            PsiFileSystemItem container = CucumberJavaScriptRunConfigurationProducer.getFileOrDirectoryToRun(element);
            String workingDir = CucumberJavaScriptRunConfigurationProducer.guessWorkingDirectory(configuration.getProject(), container);
            if (workingDir != null) {
                configuration.setWorkingDirectory(workingDir);
            }
            configuration.setName(container.getName());
            configuration.setFilePath(CucumberJavaScriptRunConfigurationProducer.getFileToRun(element));
            return true;
        }
        return false;
    }

    @Nullable
    private static String guessWorkingDirectory(@NotNull Project project, @NotNull PsiFileSystemItem psiFileItem) {
        VirtualFile directory;
        VirtualFile virtualFile;
        if (project == null) {
            CucumberJavaScriptRunConfigurationProducer.$$$reportNull$$$0(9);
        }
        if (psiFileItem == null) {
            CucumberJavaScriptRunConfigurationProducer.$$$reportNull$$$0(10);
        }
        if ((virtualFile = psiFileItem.getVirtualFile()) == null) {
            return null;
        }
        VirtualFile packageJson = JSProjectUtil.findFileUpToContentRoot((Project)project, (VirtualFile)virtualFile, (String[])new String[]{"package.json"});
        if (packageJson != null && (directory = packageJson.getParent()) != null) {
            return directory.getPath();
        }
        return null;
    }

    public boolean isConfigurationFromContext(@NotNull CucumberJavaScriptRunConfiguration configuration, @NotNull ConfigurationContext context) {
        PsiElement location;
        if (configuration == null) {
            CucumberJavaScriptRunConfigurationProducer.$$$reportNull$$$0(11);
        }
        if (context == null) {
            CucumberJavaScriptRunConfigurationProducer.$$$reportNull$$$0(12);
        }
        if ((location = context.getPsiLocation()) == null) {
            return false;
        }
        if (location.getContainingFile() instanceof GherkinFile || location instanceof PsiDirectory) {
            String contextFilePath;
            GherkinScenario scenario = (GherkinScenario)PsiTreeUtil.getParentOfType((PsiElement)location.getOriginalElement(), GherkinScenario.class);
            String contextNameFilter = null;
            if (scenario != null) {
                contextNameFilter = scenario.getScenarioName();
            }
            return StringUtil.equals((CharSequence)(contextFilePath = CucumberJavaScriptRunConfigurationProducer.getFileToRun(location)), (CharSequence)configuration.getFilePath()) && StringUtil.equals((CharSequence)contextNameFilter, (CharSequence)configuration.getNameFilter());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 6, 7, 8, 9, 10, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/javascript/run/CucumberJavaScriptRunConfigurationProducer";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDirectory";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFileItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/javascript/run/CucumberJavaScriptRunConfigurationProducer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileOrDirectoryToRun";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFileToRun";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFileOrDirectoryToRun";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "guessWorkingDirectory";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 6, 7, 8, 9, 10, 11, 12 -> new IllegalArgumentException(string);
        };
    }
}

