/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.registry.Registry;
import java.lang.ref.WeakReference;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class PopupState<Popup> {
    private WeakReference<Popup> reference;
    private boolean hiddenLongEnough = true;
    private long timeHiddenAt;

    @NotNull
    public static PopupState<JBPopup> forPopup() {
        return new JBPopupState();
    }

    @NotNull
    public static PopupState<JPopupMenu> forPopupMenu() {
        return new JPopupMenuState();
    }

    @NotNull
    public static PopupState<Balloon> forBalloon() {
        return new BalloonState();
    }

    public void prepareToShow(@NotNull Popup popup2) {
        if (popup2 == null) {
            PopupState.$$$reportNull$$$0(0);
        }
        this.hidePopup();
        this.addListener(popup2);
        this.reference = new WeakReference<Popup>(popup2);
    }

    public boolean isRecentlyHidden() {
        if (this.hiddenLongEnough) {
            return false;
        }
        this.hiddenLongEnough = true;
        return System.currentTimeMillis() - this.timeHiddenAt < (long)Registry.intValue((String)"ide.popup.hide.show.threshold", (int)200);
    }

    public boolean isHidden() {
        return !this.isShowing();
    }

    public boolean isShowing() {
        Popup popup2 = this.getPopup();
        return popup2 != null && this.isShowing(popup2);
    }

    public void hidePopup() {
        Popup popup2 = this.getPopup();
        if (popup2 != null) {
            this.hide(popup2);
        }
        this.reference = null;
    }

    @Nullable
    public Popup getPopup() {
        WeakReference<Popup> reference = this.reference;
        return reference == null ? null : (Popup)reference.get();
    }

    abstract void addListener(@NotNull Popup var1);

    abstract void removeListener(@NotNull Popup var1);

    abstract boolean isShowing(@NotNull Popup var1);

    abstract void hide(@NotNull Popup var1);

    void onHide() {
        Popup popup2 = this.getPopup();
        if (popup2 != null) {
            this.removeListener(popup2);
        }
        this.reference = null;
        this.hiddenLongEnough = false;
        this.timeHiddenAt = System.currentTimeMillis();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/ui/popup/PopupState", "prepareToShow"));
    }

    private static final class JBPopupState
    extends PopupState<JBPopup>
    implements JBPopupListener {
        private JBPopupState() {
        }

        @Override
        void addListener(@NotNull JBPopup popup2) {
            if (popup2 == null) {
                JBPopupState.$$$reportNull$$$0(0);
            }
            popup2.addListener((JBPopupListener)this);
        }

        @Override
        void removeListener(@NotNull JBPopup popup2) {
            if (popup2 == null) {
                JBPopupState.$$$reportNull$$$0(1);
            }
            popup2.removeListener((JBPopupListener)this);
        }

        @Override
        boolean isShowing(@NotNull JBPopup popup2) {
            if (popup2 == null) {
                JBPopupState.$$$reportNull$$$0(2);
            }
            return popup2.isVisible();
        }

        @Override
        void hide(@NotNull JBPopup popup2) {
            if (popup2 == null) {
                JBPopupState.$$$reportNull$$$0(3);
            }
            popup2.cancel();
            this.removeListener(popup2);
        }

        public void onClosed(@NotNull LightweightWindowEvent event) {
            if (event == null) {
                JBPopupState.$$$reportNull$$$0(4);
            }
            this.onHide();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "popup";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/popup/PopupState$JBPopupState";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addListener";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeListener";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isShowing";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hide";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onClosed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class JPopupMenuState
    extends PopupState<JPopupMenu>
    implements PopupMenuListener {
        private JPopupMenuState() {
        }

        @Override
        void addListener(@NotNull JPopupMenu menu) {
            if (menu == null) {
                JPopupMenuState.$$$reportNull$$$0(0);
            }
            menu.addPopupMenuListener(this);
        }

        @Override
        void removeListener(@NotNull JPopupMenu menu) {
            if (menu == null) {
                JPopupMenuState.$$$reportNull$$$0(1);
            }
            menu.removePopupMenuListener(this);
        }

        @Override
        boolean isShowing(@NotNull JPopupMenu menu) {
            if (menu == null) {
                JPopupMenuState.$$$reportNull$$$0(2);
            }
            return menu.isShowing();
        }

        @Override
        void hide(@NotNull JPopupMenu menu) {
            if (menu == null) {
                JPopupMenuState.$$$reportNull$$$0(3);
            }
            menu.setVisible(false);
            this.removeListener(menu);
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent event) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent event) {
            this.onHide();
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent event) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "menu";
            objectArray2[1] = "com/intellij/ui/popup/PopupState$JPopupMenuState";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addListener";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeListener";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isShowing";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hide";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class BalloonState
    extends PopupState<Balloon>
    implements JBPopupListener {
        private BalloonState() {
        }

        @Override
        void addListener(@NotNull Balloon balloon) {
            if (balloon == null) {
                BalloonState.$$$reportNull$$$0(0);
            }
            balloon.addListener((JBPopupListener)this);
        }

        @Override
        void removeListener(@NotNull Balloon balloon) {
            if (balloon == null) {
                BalloonState.$$$reportNull$$$0(1);
            }
        }

        @Override
        boolean isShowing(@NotNull Balloon balloon) {
            if (balloon == null) {
                BalloonState.$$$reportNull$$$0(2);
            }
            return !balloon.isDisposed();
        }

        @Override
        void hide(@NotNull Balloon balloon) {
            if (balloon == null) {
                BalloonState.$$$reportNull$$$0(3);
            }
            balloon.hide();
            this.removeListener(balloon);
        }

        public void onClosed(@NotNull LightweightWindowEvent event) {
            if (event == null) {
                BalloonState.$$$reportNull$$$0(4);
            }
            this.onHide();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "balloon";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/popup/PopupState$BalloonState";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addListener";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeListener";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isShowing";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hide";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onClosed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

