/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.speedSearch;

import com.intellij.openapi.util.Condition;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class FilteringTableModel<T>
extends AbstractTableModel {
    private final TableModel myOriginalModel;
    private final List<List<T>> myData = new ArrayList<List<T>>();
    private final Class<T> myClz;
    private Condition<? super T> myCondition = null;
    private final ArrayList<Integer> myIndex = new ArrayList();
    private final TableModelListener myListDataListener = e -> this.refilter();

    public FilteringTableModel(TableModel originalModel, Class<T> clz) {
        this.myClz = clz;
        this.myOriginalModel = originalModel;
        this.myOriginalModel.addTableModelListener(this.myListDataListener);
    }

    public void dispose() {
        this.myOriginalModel.removeTableModelListener(this.myListDataListener);
    }

    public void setFilter(Condition<? super T> condition) {
        this.myCondition = condition;
        this.refilter();
    }

    private void removeAllElements() {
        int index1 = this.myData.size() - 1;
        if (index1 >= 0) {
            this.myData.clear();
            this.fireTableRowsDeleted(0, index1);
        }
        this.myIndex.clear();
    }

    public void refilter() {
        this.removeAllElements();
        int count = 0;
        for (int i = 0; i < this.myOriginalModel.getRowCount(); ++i) {
            Object valueAt = this.myOriginalModel.getValueAt(i, 0);
            boolean include = false;
            if (valueAt != null && this.myClz.isAssignableFrom(valueAt.getClass())) {
                Object element = valueAt;
                if (this.passElement(element)) {
                    include = true;
                }
            } else {
                include = true;
            }
            if (!include) continue;
            ArrayList<Object> elements = new ArrayList<Object>(this.myOriginalModel.getColumnCount());
            for (int col = 0; col < this.myOriginalModel.getColumnCount(); ++col) {
                elements.add(this.myOriginalModel.getValueAt(i, col));
            }
            this.addToFiltered(elements);
            this.myIndex.add(i);
            ++count;
        }
        if (count > 0) {
            this.fireTableRowsInserted(0, count - 1);
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.myOriginalModel.isCellEditable(this.myIndex.get(rowIndex), columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.myOriginalModel.setValueAt(aValue, this.myIndex.get(rowIndex), columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.myOriginalModel.getColumnClass(columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        return this.myOriginalModel.getColumnName(column);
    }

    protected void addToFiltered(List<T> elt) {
        this.myData.add(elt);
    }

    public int getSize() {
        return this.myData.size();
    }

    private boolean passElement(T element) {
        return this.myCondition == null || this.myCondition.value(element);
    }

    @Override
    public int getRowCount() {
        return this.myData.size();
    }

    @Override
    public int getColumnCount() {
        return this.myOriginalModel.getColumnCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.myData.size() || rowIndex < 0 || columnIndex < 0 || columnIndex >= this.getColumnCount()) {
            return null;
        }
        return this.myData.get(rowIndex).get(columnIndex);
    }

    public TableModel getOriginalModel() {
        return this.myOriginalModel;
    }

    public int getOriginalIndex(int idx) {
        return idx < 0 ? idx : (idx >= this.myIndex.size() ? idx : this.myIndex.get(idx));
    }
}

