/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.speedSearch;

import java.awt.Rectangle;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import org.jetbrains.annotations.Nullable;

public abstract class SpeedSearchInputMethodRequests
implements InputMethodRequests {
    protected abstract InputMethodRequests getDelegate();

    protected void ensurePopupIsShown() {
    }

    @Override
    public Rectangle getTextLocation(TextHitInfo offset) {
        InputMethodRequests delegate = this.getDelegate();
        if (delegate == null) {
            return new Rectangle();
        }
        return delegate.getTextLocation(offset);
    }

    @Override
    @Nullable
    public TextHitInfo getLocationOffset(int x, int y) {
        InputMethodRequests delegate = this.getDelegate();
        if (delegate == null) {
            return null;
        }
        return delegate.getLocationOffset(x, y);
    }

    @Override
    public int getInsertPositionOffset() {
        InputMethodRequests delegate = this.getDelegate();
        if (delegate == null) {
            return 0;
        }
        return delegate.getInsertPositionOffset();
    }

    @Override
    public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
        InputMethodRequests delegate = this.getDelegate();
        if (delegate == null && beginIndex == 0 && endIndex == 0) {
            return new AttributedString("").getIterator();
        }
        this.ensurePopupIsShown();
        delegate = this.getDelegate();
        assert (delegate != null);
        return delegate.getCommittedText(beginIndex, endIndex, attributes);
    }

    @Override
    public int getCommittedTextLength() {
        InputMethodRequests delegate = this.getDelegate();
        if (delegate == null) {
            return 0;
        }
        return delegate.getCommittedTextLength();
    }

    @Override
    @Nullable
    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
        InputMethodRequests delegate = this.getDelegate();
        if (delegate == null) {
            return null;
        }
        return delegate.cancelLatestCommittedText(attributes);
    }

    @Override
    @Nullable
    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
        InputMethodRequests delegate = this.getDelegate();
        if (delegate == null) {
            return null;
        }
        return delegate.getSelectedText(attributes);
    }
}

